/*
 * Decompiled with CFR 0.152.
 */
import fr.free.palbou.infowin.InfoWin;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Selector
extends JFrame
implements ActionListener {
    public static Icon SNDicon;
    public static Icon noSNDicon;
    static Object list_access;
    static PicturesList left;
    static PicturesList center;
    static PicturesList right;
    static boolean modified;
    JButton tcb;
    JButton sb;
    private File destDir = null;
    private String ext;
    private static final String zeros = "00000";
    private static final int hwWidth = 615;
    private static final int hwHeight = 445;
    private static final String[] hwOptions;

    public static void main(String[] stringArray) {
        ImagePool.init();
        new Selector().setVisible(true);
    }

    public static void repaintList(int n) {
        if (n == 0) {
            center.repaint();
        } else if (n < 0) {
            left.repaint();
        } else {
            right.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isVisible(PicturesListElement picturesListElement) {
        Object object = list_access;
        synchronized (object) {
            return center.isVisible(picturesListElement) || left.isVisible(picturesListElement) || right.isVisible(picturesListElement);
        }
    }

    Selector() {
        super("Pictures selector");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        left = new PicturesList(-1, this);
        jPanel.add(left);
        center = new PicturesList(0, this);
        jPanel.add(center);
        right = new PicturesList(1, this);
        jPanel.add(right);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel();
        JButton jButton = new JButton("?");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.tcb = new JButton("Target collection");
        this.tcb.addActionListener(this);
        jPanel.add(this.tcb);
        this.sb = new JButton("Save and exit");
        this.sb.addActionListener(this);
        this.sb.setEnabled(false);
        jPanel.add(this.sb);
        jButton = new JButton("Exit");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        this.addWindowListener(new ClosingListener());
        this.setDefaultCloseOperation(0);
        SNDicon = new ImageIcon(this.getClass().getClassLoader().getResource("images/son.gif"));
        noSNDicon = new ImageIcon(this.getClass().getClassLoader().getResource("images/silence.gif"));
    }

    static int log10(int n) {
        int n2 = 0;
        while (n >= 10) {
            n /= 10;
            ++n2;
        }
        return n2;
    }

    void fileCopy(File file, File file2) {
        byte[] byArray = new byte[512];
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                int n;
                do {
                    if ((n = fileInputStream.read(byArray)) < 0) continue;
                    fileOutputStream.write(byArray, 0, n);
                } while (n == 512);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "I/O error while copying " + file + "\nto " + file2, "Error", 0);
            }
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Access error while copying " + file + "\nto " + file2, "Error", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = list_access;
        synchronized (object) {
            if (actionEvent.getActionCommand().startsWith("Open")) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle("Select a file of proper type in the list folder");
                if (jFileChooser.showOpenDialog(this) == 0) {
                    File file = jFileChooser.getSelectedFile();
                    File file2 = file.getParentFile();
                    String string = file.getName();
                    Object[] objectArray = string.indexOf(46) == -1 ? file2.list() : file2.list(new ExtFNFilter(string.substring(string.lastIndexOf(46))));
                    Arrays.sort(objectArray);
                    if (actionEvent.getActionCommand().equals("Open L")) {
                        left.setElements(file2.getPath() + File.separator, (String[])objectArray);
                    } else {
                        right.setElements(file2.getPath() + File.separator, (String[])objectArray);
                    }
                }
                return;
            }
            if (actionEvent.getActionCommand().equals("Target collection")) {
                if (!center.isEmpty() && JOptionPane.showConfirmDialog(this, "The target collection is not empty.\nThis operation will empty it before loading the contents of the selected folder.\nDo you really want to proceed?\n(to save the present collection to a given (empty or non empty) folder,\nuse the \"Save and exit\" command instead)", "Confirm", 0) == 1) {
                    return;
                }
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle("Select a target directory");
                jFileChooser.setFileSelectionMode(1);
                if (jFileChooser.showOpenDialog(this) == 0) {
                    this.destDir = jFileChooser.getSelectedFile();
                    Object[] objectArray = this.destDir.list();
                    Vector<String> vector = new Vector<String>();
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i].indexOf(46) == -1) continue;
                        this.ext = ((String)objectArray[i]).substring(((String)objectArray[i]).lastIndexOf(46)).toLowerCase();
                        if (vector.contains(this.ext)) continue;
                        vector.add(this.ext);
                    }
                    if (vector.size() > 0) {
                        vector.insertElementAt("no extension", 0);
                        vector.insertElementAt("all files", 0);
                        this.ext = (String)JOptionPane.showInputDialog(this, "Choose an extension for the files in the collection", "Target collection", 3, null, vector.toArray(), vector.get(0));
                        if (this.ext == null) {
                            this.destDir = null;
                            return;
                        }
                        if (!this.ext.equals("all files")) {
                            FilenameFilter filenameFilter = this.ext.equals("no extension") ? new noExtFNFilter() : new ExtFNFilter(this.ext);
                            objectArray = this.destDir.list(filenameFilter);
                        }
                    } else {
                        this.ext = "all files";
                    }
                    Arrays.sort(objectArray);
                    center.setElements(this.destDir.getPath() + File.separator, (String[])objectArray);
                    this.tcb.setEnabled(false);
                }
                return;
            }
            if (actionEvent.getActionCommand().equals(">>>")) {
                Object[] objectArray = left.transfer();
                center.addElements(objectArray);
                this.sb.setEnabled(modified |= objectArray.length > 0);
                return;
            }
            if (actionEvent.getActionCommand().equals("<<<")) {
                Object[] objectArray = right.transfer();
                center.addElements(objectArray);
                this.sb.setEnabled(modified |= objectArray.length > 0);
                return;
            }
            if (actionEvent.getActionCommand().equals("<<< + >>>")) {
                Object[] objectArray = center.transfer();
                left.addElements(objectArray);
                right.addElements(objectArray);
                this.sb.setEnabled(modified |= objectArray.length > 0);
                return;
            }
            if (actionEvent.getActionCommand().equals("Save and exit")) {
                Container container;
                if (this.destDir == null) {
                    container = new JFileChooser();
                    ((JFileChooser)container).setDialogTitle("Select a target directory");
                    ((JFileChooser)container).setFileSelectionMode(1);
                    if (((JFileChooser)container).showOpenDialog(this) != 0) {
                        return;
                    }
                    this.destDir = ((JFileChooser)container).getSelectedFile();
                    this.ext = "all files";
                }
                container = new SaveDlg((Frame)this, this.destDir.getPath(), this.ext);
                ((Dialog)container).show();
                if (((SaveDlg)container).valid) {
                    CompilingDialog compilingDialog = new CompilingDialog((Frame)this, true);
                    new CollectionCompiler((SaveDlg)container, compilingDialog).start();
                    compilingDialog.show();
                }
                return;
            }
            if (actionEvent.getActionCommand().equals("?")) {
                if (JOptionPane.showOptionDialog(this, "Pictures selector #3\nCopyright (C) Pierre Albou, 2004.\nAll rights reserved.", "About the program", 0, 1, null, hwOptions, hwOptions[0]) == 1) {
                    InfoWin infoWin = new InfoWin(this.getClass().getClassLoader().getResource("help.html"), "Pictures selector #3 - help");
                    infoWin.setSize(615, 445);
                    infoWin.setVisible(true);
                }
                return;
            }
            if (actionEvent.getActionCommand().equals("Exit") && (!modified || JOptionPane.showConfirmDialog(this, "Target collection has not been compiled.\nClose without saving?", "Confirm", 0) == 0)) {
                System.exit(modified ? 1 : 0);
            }
        }
    }

    static {
        list_access = new Object();
        modified = false;
        hwOptions = new String[]{"Ok", "Display help"};
    }

    class CollectionCompiler
    extends Thread {
        SaveDlg db;
        CompilingDialog pd;

        CollectionCompiler(SaveDlg saveDlg, CompilingDialog compilingDialog) {
            this.db = saveDlg;
            this.pd = compilingDialog;
        }

        public void run() {
            File file;
            PicturesListElement picturesListElement;
            Enumeration enumeration;
            File file2;
            Object object;
            if (!this.db.none_deleted.isSelected()) {
                int n = 0;
                object = Selector.this.destDir.list();
                block0: for (int i = 0; i < ((String[])object).length; ++i) {
                    file2 = new File(Selector.this.destDir, object[i]);
                    enumeration = center.elements();
                    while (enumeration.hasMoreElements()) {
                        picturesListElement = (PicturesListElement)enumeration.nextElement();
                        if (picturesListElement.list_id != Selector.center.list_id || !file2.equals(file = new File(picturesListElement.dir, picturesListElement.file)) && (!picturesListElement.hasSound() || !file2.equals(picturesListElement.sound()))) continue;
                        continue block0;
                    }
                    if (this.db.deleted_with_ext.isSelected() && !Selector.this.ext.equals("all files") && (Selector.this.ext.equals("no extension") ? !object[i].endsWith(".") : !object[i].toLowerCase().endsWith(Selector.this.ext.toLowerCase()))) continue;
                    SwingUtilities.invokeLater(new DialogUpdate("Delete .../" + file2.getName(), ++n * 100 / ((String[])object).length));
                    file2.delete();
                }
            }
            int n = 0;
            enumeration = center.elements();
            while (enumeration.hasMoreElements()) {
                picturesListElement = (PicturesListElement)enumeration.nextElement();
                file2 = new File(picturesListElement.dir, picturesListElement.file);
                int n2 = picturesListElement.file.lastIndexOf(46);
                String string = n2 > 0 ? picturesListElement.file.substring(n2) : "";
                object = this.db.FNprefix.getText() + Selector.zeros.substring(Selector.log10(n)) + n;
                file = new File(Selector.this.destDir, (String)object + string);
                File file3 = picturesListElement.hasSound() ? new File(Selector.this.destDir, (String)object + ".wav") : null;
                if (picturesListElement.list_id < 0 && this.db.lh_copy.isSelected() || picturesListElement.list_id > 0 && this.db.rh_copy.isSelected()) {
                    SwingUtilities.invokeLater(new DialogUpdate("Copy .../" + file2.getName(), 100 * n / center.length()));
                    Selector.this.fileCopy(file2, file);
                    if (file3 != null) {
                        Selector.this.fileCopy(picturesListElement.sound(), file3);
                    }
                } else {
                    SwingUtilities.invokeLater(new DialogUpdate("Move .../" + file2.getName(), 100 * n / center.length()));
                    file2.renameTo(file);
                    if (file3 != null) {
                        picturesListElement.sound().renameTo(file3);
                    }
                }
                ++n;
            }
            System.exit(0);
        }

        class DialogUpdate
        implements Runnable {
            String actionText;
            int progress;

            DialogUpdate(String string, int n) {
                this.actionText = string;
                this.progress = n;
            }

            public void run() {
                CollectionCompiler.this.pd.ActionText.setText(this.actionText);
                CollectionCompiler.this.pd.ProgressBar.setValue(this.progress);
            }
        }
    }

    class ClosingListener
    extends WindowAdapter {
        ClosingListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Selector.this.actionPerformed(new ActionEvent(this, 1001, "Exit"));
        }
    }
}

