/*
 * Decompiled with CFR 0.152.
 */
package impChess;

import impChess.character;
import impChess.gameBoard;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;

public class gameSquare
extends Component {
    private int row;
    private int col;
    private int pieceNumber;
    private Color pieceColor;
    private Color locationColor;
    private Color baseColor;
    private int Left;
    private int Top;
    private int Right;
    private int Bottom;
    private int xx;
    private int yy;
    private int size = 32;
    private Rectangle2D r2d;
    private character Character = null;
    private gameBoard Board;

    public gameSquare(int n, int n2, Color color, float f, gameBoard gameBoard2) {
        this.row = n + 1;
        this.col = n2 + 1;
        this.Board = gameBoard2;
        this.size = gameBoard2.getSquareSize();
        this.locationColor = color;
        this.baseColor = color;
        this.pieceNumber = -1;
        this.pieceColor = Color.white;
        this.xx = (this.row - 1) * (this.size + 1) + 1;
        this.yy = (this.Board.getBoardSize() - this.col) * (this.size + 1) + 1;
        this.r2d = new Rectangle2D.Float((float)this.xx + f, this.yy, this.size, this.size);
        this.xx += (int)f;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public void setCharacter(character character2) {
        this.Character = character2;
    }

    public void removeCharacter() {
        this.Character = null;
    }

    public character getCharacter() {
        return this.Character;
    }

    public boolean isOccupied() {
        return this.Character != null;
    }

    public boolean isEmpire(String string) {
        boolean bl = false;
        if (this.Character != null && this.Character.empireIn() == string) {
            bl = true;
        }
        return bl;
    }

    public void changeColor(Color color) {
        this.locationColor = color;
        this.repaint();
    }

    public void resetColor() {
        this.locationColor = this.baseColor;
        this.repaint();
    }

    public String getSquareName(String string) {
        String string2 = "";
        if (string == "Gold") {
            string2 = string2 + "G:" + this.row + "." + this.col;
        } else if (string == "Purple") {
            int n = this.Board.getBoardSize() + 1 - this.row;
            int n2 = this.Board.getBoardSize() + 1 - this.col;
            string2 = string2 + "P:" + n + "." + n2;
        }
        return string2;
    }

    protected Dimension calculateLocation() {
        Dimension dimension = new Dimension();
        int n = 0;
        int n2 = 0;
        String string = this.Board.getOrientation();
        int n3 = this.Board.getSquareSize();
        int n4 = this.Board.getLeft();
        int n5 = this.Board.getTop();
        int n6 = this.Board.getWidth();
        int n7 = this.Board.getHeight();
        dimension.setSize(n, n2);
        return dimension;
    }

    public boolean locatedIn(Dimension dimension) {
        boolean bl = false;
        int n = dimension.width;
        int n2 = dimension.height;
        if (n >= this.Left && n < this.Right && n2 >= this.Top && n2 < this.Bottom) {
            bl = true;
        }
        return bl;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.Board.getLocation(this.row, this.col, this.Board.getOrientation());
        graphics2D.setColor(this.locationColor);
        int n = this.Board.getSquareSize() - 1;
        this.Left = (int)dimension.getWidth();
        this.Top = (int)dimension.getHeight();
        this.Right = this.Left + n;
        this.Bottom = this.Top + n;
        graphics2D.fill3DRect((int)dimension.getWidth(), (int)dimension.getHeight(), n, n, true);
        if (this.isOccupied()) {
            this.Character.paint(graphics2D);
        }
        this.setBounds(this.Left, this.Right, n, n);
        Rectangle rectangle = this.bounds();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        System.out.println(this.row + ":" + this.col + " was clicked.");
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        System.out.println(this.row + ":" + this.col + " was entered.");
        this.locationColor = Color.BLUE;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        System.out.println(this.row + ":" + this.col + " was exited.");
        this.locationColor = this.baseColor;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        System.out.println(this.row + ":" + this.col + " was pressed.");
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        System.out.println(this.row + ":" + this.col + " was released.");
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        System.out.println(this.row + ":" + this.col + " was shown.");
    }
}

