#include "common.h"

/* Open required files */
int begin(void)
{
    /* Sort out file names */
    strcpy(filename,node);
    strcat(filename,".GRW");
    strcpy(tempfile,node);
    strcat(tempfile,".$$$");
    strcpy(bakfile,node);
    strcat(bakfile,".BAK");

    /* Access files */
    if ((infile=fopen(filename,"r"))==NULL)
    {
        printf("ERROR: unable to access node %s\n",node);
        return 2;
    }
    if ((outfile=fopen(tempfile,"w"))==NULL)
    {
        printf("ERROR: unable to create temporary file!\n");
        fclose(infile);
        return 3;
    }
    printf("\nNode name:   %s\n",node);
    printf("Data file:   %s\n",filename);
    printf("Work file:   %s\n",tempfile);
    printf("Backup file: %s\n",bakfile);
    printf("Comments will be ");
    if (comments==TRUE)
        printf("%s\n","added");
    else
        printf("%s\n","stripped");
    return 0;
}
/* Close files */
void closefiles(void)
{
    fclose(infile);
    fclose(outfile);
    return;
}
/******************************************************************************
* Load a block of data                                                        *
******************************************************************************/
int loadblock(void)
{
    nr_lines=0;
    while ((fgets(input,256,infile)!=NULL)
        && (strlen(input)>1)
        && (nr_lines<MAX_LINES))
    {
        strcpy(data[nr_lines],input);
        nr_lines++;
    }
    if (nr_lines==0)
        return 1;
    else
        return 0;
}
/******************************************************************************
* Write a block of data                                                       *
******************************************************************************/
int writeblock(int type)
{
    int count;

    if (comments==TRUE)
        switch (type)
        {
        case KEYWORDS:
            fprintf(outfile,"; Keywords\n");
            break;
        case ACTIONS:
            fprintf(outfile,"; Actions\n");
            break;
        default:
            break;
        }
    for (count=0; count<nr_lines; count++)
    {
        if (data[count][0]!=';')
        {
            if (type==ACTIONS)
                data[count][0]=toupper(data[count][0]);
            if (fprintf(outfile,"%s",data[count])==EOF)
            {
                printf("ERROR: Couldn't write data!\n");
                return 1;
            }
        }
    }
    fprintf(outfile,"\n");
    return 0;
}
