/****************************************************************************
* FIXGRW: Fixes up files with ".GRW" extension                              *
* TURBO C version                                                           *
****************************************************************************/
#include <stdio.h>
#include <stdlib.h>

#include "common.h"

/* Open required files */
int begin(void)
{
    /* Sort out file names */
    strcpy(filename,node);
    strcat(filename,".GRW");
    strcpy(tempfile,node);
    strcat(tempfile,".$$$");
    strcpy(bakfile,node);
    strcat(bakfile,".BAK");

    /* Access files */
    if ((infile=fopen(filename,"r"))==NULL)
    {
        printf("ERROR: unable to access node %s\n",node);
        return 2;
    }
    if ((outfile=fopen(tempfile,"w"))==NULL)
    {
        printf("ERROR: unable to create temporary file!\n");
        fclose(infile);
        return 3;
    }
    printf("\nNode name:   %s\n",node);
    printf("Data file:   %s\n",filename);
    printf("Work file:   %s\n",tempfile);
    printf("Backup file: %s\n",bakfile);
    printf("Comments will be ");
    if (comments==TRUE)
        printf("%s\n","added");
    else
        printf("%s\n","stripped");
    return 0;
}
/* Close files */
void closefiles(void)
{
    fclose(infile);
    fclose(outfile);
    return;
}
/******************************************************************************
* Load a block of data                                                        *
******************************************************************************/
int loadblock(void)
{
    nr_lines=0;
    while ((fgets(input,256,infile)!=NULL)
        && (strlen(input)>1)
        && (nr_lines<MAX_LINES))
    {
        strcpy(data[nr_lines],input);
        nr_lines++;
    }
    if (nr_lines==0)
        return 1;
    else
        return 0;
}
/******************************************************************************
* Write a block of data                                                       *
******************************************************************************/
int writeblock(int type)
{
    int count;

    if (comments==TRUE)
        switch (type)
        {
        case KEYWORDS:
            fprintf(outfile,"; Keywords\n");
            break;
        case ACTIONS:
            fprintf(outfile,"; Actions\n");
            break;
        default:
            break;
        }
    for (count=0; count<nr_lines; count++)
    {
        if (data[count][0]!=';')
        {
            if (type==ACTIONS)
                data[count][0]=toupper(data[count][0]);
            if (fprintf(outfile,"%s",data[count])==EOF)
            {
                printf("ERROR: Couldn't write data!\n");
                return 1;
            }
        }
    }
    fprintf(outfile,"\n");
    return 0;
}
/******************************************************************************
* Main program                                                                *
******************************************************************************/
main(argc, argv)
int argc;
char *argv[];
{

    int i,j;

    /* Parse command line */
    if (argc<2)
    {
        printf("USAGE:\n     FIXGRW <nodename> [/c]\n");
        printf("(where <nodename> is the node you wish to fix and /C adds comments)\n");
        exit(1);
    }
    for (i=0; i<strlen(argv[1]) && argv[1][i]!='.'; i++)
        node[i]=toupper(argv[1][i]);
    node[i]='\0';

    comments=FALSE;
    if (argc>2)
        if (argv[2][0]=='/')
            if (toupper(argv[2][1])=='C')
                comments=TRUE;

    /* Process file */
    if ((i=begin())!=0) /* open files if we can */
        exit(i);
    if ((i=loadblock())!=0) /* load up description if we can */
        exit(i);
    if ((i=writeblock(0))!=0) /* Write out description if we can */
        exit(i);
    j=KEYWORDS; /* Initial type of block we're considering */
    while ((i=loadblock())==0) /* Process as many blocks as we can */
    {
        if (nr_lines==0)
            printf("WARNING: Empty block of data!\n");
        if ((i=writeblock(j))!=0) /* put it out there */
            exit(i);
        switch (j)
        {
        case KEYWORDS:
            j=ACTIONS; 
            break;
        case ACTIONS:
            j=KEYWORDS; 
            break;
        default:
            {
                printf("ERROR: someone has been meddling with my logic!\n");
                closefiles();
                abort();
            }
        }
    }
    if (j==ACTIONS)
    {
        printf("ERROR: Unexpected end of file!\n");
        closefiles();
        abort();
    }
    /* End of processing */
    closefiles();

    unlink(bakfile);
    if (rename(filename,bakfile)==0)
        printf("\n%s renamed to %s",filename,bakfile);
    if (rename(tempfile,filename)==0)
        printf("\n%s renamed to %s",tempfile,filename);
    else
        {
        printf("\nERROR: Unable to rename %s as %s\n",tempfile,filename);
        abort();
    }
    printf("\nProcessing of node %s complete!\n",node);
    return 0;
}
