/*
 * Decompiled with CFR 0.152.
 */
package WizSolitaire.Games;

import WizSolitaire.Card;
import WizSolitaire.CardGame;
import WizSolitaire.CardWrapper;
import WizSolitaire.Deck;
import WizSolitaire.GameTable;
import WizSolitaire.Games.SpiderLevelWin;
import WizSolitaire.Settings;
import WizSolitaire.TableCell;
import WizSolitaire.UndoStep;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JFrame;

public class Spider
extends CardGame {
    public static final int SPIDER_EASY;
    public static final int SPIDER_MEDIUM = 1;
    public static final int SPIDER_HARD = 2;
    private int d = 0;
    private int e;

    public Spider(Deck deck, GameTable gameTable, int n2, int n3) {
        super("Spider", deck, gameTable, n2, n3);
    }

    public void LoadSettings(Settings settings, String string) {
        super.LoadSettings(settings, string);
        this.d = settings.getInt(string + ".Level", this.d);
    }

    public void SaveSettings(Settings settings, String string) {
        super.SaveSettings(settings, string);
        settings.setInt(string + ".Level", this.d);
    }

    public void Start() {
        SpiderLevelWin spiderLevelWin = new SpiderLevelWin((Frame)((JFrame)this.Table.getTopLevelAncestor()), true);
        spiderLevelWin.SetLevel(this.d);
        spiderLevelWin.setVisible(true);
        this.d = spiderLevelWin.GetLevel();
        super.Start();
    }

    protected void SetupCells() {
        for (int i2 = 0; i2 < 12; ++i2) {
            this.Table.AddCell(new TableCell());
        }
    }

    protected void Layout() {
        TableCell tableCell;
        this.Table.Resize(12 + (6 + this.CardWidth) * 10, this.CardHeight * 5);
        float f2 = (float)((double)this.CardWidth / 88.0);
        int n2 = (int)(18.0 * (double)f2);
        int n3 = (int)(14.0f * f2);
        int n4 = this.Table.getSize().height - this.CardHeight - 5;
        for (int i2 = 0; i2 < 10; ++i2) {
            tableCell = this.Table.GetCell(i2);
            tableCell.SetPos(6 + i2 * (6 + this.CardWidth), 5);
            tableCell.SetCardSpacing(0, n3);
        }
        this.Table.GetCell(10).SetPos(6, n4);
        tableCell = this.Table.GetCell(11);
        tableCell.SetPos(6 + 3 * this.CardWidth, n4);
        tableCell.SetCardSpacing(n2, 0);
    }

    protected void PlaceCards() {
        TableCell tableCell;
        int n2 = 52;
        for (int i2 = 0; i2 < 6; ++i2) {
            for (int i3 = 0; i3 < 10; ++i3) {
                Card card;
                while (!this.h(card = this.MyDeck.Pick())) {
                }
                tableCell = this.Table.GetCell(i3);
                CardWrapper cardWrapper = this.Table.WrapCard(card);
                tableCell.AddCard(cardWrapper);
                cardWrapper.SetFrontUp(i2 == 5);
                if (--n2 > 0) continue;
                n2 = 52;
            }
        }
        tableCell = this.Table.GetCell(10);
        while (n2-- > 0) {
            Card card;
            while (!this.h(card = this.MyDeck.Pick())) {
            }
            CardWrapper cardWrapper = this.Table.WrapCard(card);
            tableCell.AddCard(cardWrapper);
            cardWrapper.SetFrontUp(false);
        }
        this.e = 0;
    }

    private boolean h(Card card) {
        boolean bl = false;
        int n2 = card.GetSuit();
        switch (this.d) {
            case 0: {
                bl = n2 == 3;
                break;
            }
            case 1: {
                bl = n2 == 3 || n2 == 2;
                break;
            }
            case 2: {
                bl = true;
            }
        }
        return bl;
    }

    private boolean i(Card card, int n2) {
        Card card2 = this.Table.GetCell(n2).GetCard(-1);
        int n3 = card.GetValue();
        return card2 == null || n3 + 1 == card2.GetValue();
    }

    public void CardClick(CardWrapper cardWrapper, int n2, int n3) {
        if (n2 == 10) {
            boolean bl = true;
            for (int i2 = 0; bl && i2 < 10; ++i2) {
                if (this.Table.GetCell(i2).GetCard(0) != null) continue;
                bl = false;
            }
            if (bl) {
                TableCell tableCell = this.Table.GetCell(10);
                UndoStep undoStep = this.NewMove(true);
                for (int i3 = 0; i3 < 10; ++i3) {
                    CardWrapper cardWrapper2 = tableCell.PopCard();
                    TableCell tableCell2 = this.Table.GetCell(i3);
                    if (cardWrapper2 == null) continue;
                    undoStep.AddMove(cardWrapper2, tableCell);
                    cardWrapper2.SetFrontUp(true);
                    tableCell2.AddCard(cardWrapper2);
                    this.m(tableCell2, undoStep);
                }
                this.AddUndo(undoStep);
                this.Table.repaint();
                return;
            }
            this.Table.StatusMsg("There must be a card in every column to add new cards!");
            this.Beep();
        }
    }

    public void CardMouseDown(CardWrapper cardWrapper, int n2, int n3, int n4, int n5) {
        TableCell tableCell = this.Table.GetCell(n2);
        if (n2 < 10) {
            if (cardWrapper == tableCell.GetWrapper(-1)) {
                cardWrapper.SetMoving(true);
                return;
            }
            int n6 = tableCell.GetCardsCount();
            Card card = null;
            boolean bl = false;
            int n7 = 0;
            while (!bl && --n6 >= 0) {
                CardWrapper cardWrapper2 = tableCell.GetWrapper(n6);
                Card card2 = cardWrapper2.GetCard();
                if (!cardWrapper2.GetFrontUp() || card != null && (card2.GetSuit() != card.GetSuit() || card2.GetValue() - 1 != card.GetValue())) break;
                card = cardWrapper2.GetCard();
                bl = cardWrapper == cardWrapper2;
                n7 = n6;
            }
            if (bl) {
                do {
                    cardWrapper.SetMoving(true);
                } while ((cardWrapper = tableCell.GetWrapper(++n7)) != null);
            }
        }
    }

    public void CardMouseUp(int n2, int n3) {
        Vector vector = new Vector();
        this.GetMovingCards(vector);
        if (vector.size() > 0) {
            int n4;
            Object object;
            Rectangle rectangle = new Rectangle();
            Object object2 = null;
            int n5 = 0;
            int n6 = 0;
            this.GetCardsRect(vector, rectangle);
            CardWrapper cardWrapper = (CardWrapper)vector.get(0);
            for (int i2 = 0; i2 < 10; ++i2) {
                object = this.Table.GetCell(i2);
                if (object == cardWrapper.GetCell() || (n4 = ((TableCell)object).CoverArea(rectangle)) <= n5) continue;
                object2 = object;
                n5 = n4;
                n6 = i2;
            }
            if (n5 > 25 && this.i(cardWrapper.GetCard(), n6)) {
                TableCell tableCell = cardWrapper.GetCell();
                object = this.NewMove();
                for (n4 = 0; n4 < vector.size(); ++n4) {
                    cardWrapper = (CardWrapper)vector.get(n4);
                    ((UndoStep)object).AddMove(cardWrapper);
                    ((TableCell)object2).AddCard(cardWrapper);
                }
                cardWrapper = tableCell.GetWrapper(-1);
                if (cardWrapper != null) {
                    ((UndoStep)object).AddCard(cardWrapper);
                    cardWrapper.SetFrontUp(true);
                }
                this.m((TableCell)object2, (UndoStep)object);
                this.AddUndo((UndoStep)object);
            }
        }
        super.CardMouseUp(n2, n3);
    }

    private void m(TableCell tableCell, UndoStep undoStep) {
        Card card;
        boolean bl = false;
        int n2 = tableCell.GetCard(-1).GetSuit();
        int n3 = 1;
        for (int i2 = tableCell.GetCardsCount() - 1; !false && i2 >= 0 && (card = tableCell.GetCard(i2)).GetSuit() == n2 && card.GetValue() == n3++; --i2) {
            if (n3 <= 13) continue;
            bl = true;
        }
        if (bl) {
            CardWrapper cardWrapper;
            TableCell tableCell2 = this.Table.GetCell(11);
            undoStep.BeginStep(true);
            for (int i3 = 0; i3 < 12; ++i3) {
                cardWrapper = tableCell.GetWrapper(-1);
                undoStep.AddMove(cardWrapper, tableCell);
                cardWrapper.AddFlags(1);
                tableCell2.AddCard(cardWrapper);
            }
            tableCell2.AddCard(tableCell.GetWrapper(-1));
            cardWrapper = tableCell.GetWrapper(-1);
            if (cardWrapper != null) {
                undoStep.AddCard(cardWrapper);
                cardWrapper.SetFrontUp(true);
            }
            undoStep.EndStep();
            if (++this.e == 8) {
                this.GameOver(true);
            }
        }
    }

    public void Undo() {
        super.Undo();
        this.e = 0;
        for (int i2 = 0; i2 < 10; ++i2) {
            if (this.Table.GetCell(i2).GetCardsCount() > 0) continue;
            ++this.e;
        }
    }
}

