/*
 * Decompiled with CFR 0.152.
 */
package WizSolitaire.Games;

import WizSolitaire.Card;
import WizSolitaire.CardGame;
import WizSolitaire.CardWrapper;
import WizSolitaire.Deck;
import WizSolitaire.GameTable;
import WizSolitaire.TableCell;
import WizSolitaire.UndoStep;
import java.awt.Rectangle;
import java.util.Vector;

public class FortyThieves
extends CardGame {
    protected static final int TC_PILE1;
    protected static final int TC_PILE10 = 9;
    protected static final int TC_FOUND1 = 10;
    protected static final int TC_FOUND8 = 17;
    protected static final int TC_DECK = 18;
    protected static final int TC_WASTE = 19;
    private int g;

    public FortyThieves(Deck deck, GameTable gameTable, int n2, int n3) {
        super("Forty Thieves", deck, gameTable, n2, n3);
    }

    protected void SetupCells() {
        for (int i2 = 0; i2 < 20; ++i2) {
            this.Table.AddCell(new TableCell());
        }
    }

    protected void Layout() {
        int n2;
        this.Table.Resize(12 + (6 + this.CardWidth) * 10, this.CardHeight * 5);
        float f2 = (float)((double)this.CardWidth / 88.0);
        int n3 = (int)(14.0f * f2);
        int n4 = this.Table.getSize().height - this.CardHeight - 5;
        for (n2 = 0; n2 < 10; ++n2) {
            TableCell tableCell = this.Table.GetCell(n2 + 0);
            tableCell.SetPos(6 + n2 * (6 + this.CardWidth), 9 + this.CardHeight);
            tableCell.SetCardSpacing(0, n3);
        }
        for (n2 = 0; n2 < 8; ++n2) {
            this.Table.GetCell(n2 + 10).SetPos(6 + n2 * (6 + this.CardWidth), 5);
        }
        this.Table.GetCell(18).SetPos(6, n4);
        this.Table.GetCell(19).SetPos(12 + this.CardWidth, n4);
    }

    protected void PlaceCards() {
        TableCell tableCell;
        int n2 = 104;
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 10; ++i3) {
                Card card = this.MyDeck.Pick();
                tableCell = this.Table.GetCell(i3);
                CardWrapper cardWrapper = this.Table.WrapCard(card);
                tableCell.AddCard(cardWrapper);
                cardWrapper.SetFrontUp(true);
                if (--n2 > 0) continue;
                n2 = 52;
            }
        }
        tableCell = this.Table.GetCell(18);
        while (n2-- > 0) {
            Card card = this.MyDeck.Pick();
            CardWrapper cardWrapper = this.Table.WrapCard(card);
            tableCell.AddCard(cardWrapper);
            cardWrapper.SetFrontUp(false);
        }
        this.g = 0;
    }

    protected boolean CanMove(Card card, int n2) {
        Card card2 = this.Table.GetCell(n2).GetCard(-1);
        int n3 = card.GetValue();
        boolean bl = false;
        if (n2 >= 10 && n2 <= 17) {
            bl = card2 == null && n3 == 1 || card2 != null && n3 == card2.GetValue() + 1 && card.GetSuit() == card2.GetSuit();
        } else if (n2 >= 0 && n2 <= 9) {
            bl = card2 == null || n3 == card2.GetValue() - 1 && card.GetSuit() == card2.GetSuit();
        }
        return bl;
    }

    public void CardClick(CardWrapper cardWrapper, int n2, int n3) {
        if (n2 == 18) {
            TableCell tableCell = this.Table.GetCell(18);
            TableCell tableCell2 = this.Table.GetCell(19);
            CardWrapper cardWrapper2 = tableCell.PopCard();
            UndoStep undoStep = this.NewMove(true);
            if (cardWrapper2 == null) {
                while ((cardWrapper2 = tableCell2.PopCard()) != null) {
                    undoStep.AddMove(cardWrapper2, tableCell2);
                    cardWrapper2.SetFrontUp(false);
                    tableCell.AddCard(cardWrapper2);
                }
                cardWrapper2 = tableCell.PopCard();
            }
            if (cardWrapper2 != null) {
                undoStep.AddMove(cardWrapper2, tableCell);
                cardWrapper2.SetFrontUp(true);
                tableCell2.AddCard(cardWrapper2);
                this.Table.repaint();
            }
            this.AddUndo(undoStep);
        }
    }

    public void CardMouseDown(CardWrapper cardWrapper, int n2, int n3, int n4, int n5) {
        TableCell tableCell = this.Table.GetCell(n2);
        if (cardWrapper == tableCell.GetWrapper(-1) && (n2 == 19 || n2 >= 0 && n2 <= 9)) {
            cardWrapper.SetMoving(true);
        }
    }

    public void CardMouseUp(int n2, int n3) {
        Vector vector = new Vector();
        this.GetMovingCards(vector);
        if (vector.size() > 0) {
            Rectangle rectangle = new Rectangle();
            TableCell tableCell = null;
            int n4 = 0;
            int n5 = 0;
            this.GetCardsRect(vector, rectangle);
            CardWrapper cardWrapper = (CardWrapper)vector.get(0);
            for (int i2 = 0; i2 <= 17; ++i2) {
                int n6;
                TableCell tableCell2 = this.Table.GetCell(i2);
                if (tableCell2 == cardWrapper.GetCell() || (n6 = tableCell2.CoverArea(rectangle)) <= n4) continue;
                tableCell = tableCell2;
                n4 = n6;
                n5 = i2;
            }
            if (n4 > 25 && this.CanMove(cardWrapper.GetCard(), n5)) {
                UndoStep undoStep = this.NewMove();
                for (int i3 = 0; i3 < vector.size(); ++i3) {
                    cardWrapper = (CardWrapper)vector.get(i3);
                    undoStep.AddMove(cardWrapper);
                    tableCell.AddCard(cardWrapper);
                }
                this.AddUndo(undoStep);
                if (tableCell.GetCardsCount() >= 13 && ++this.g == 8) {
                    this.GameOver(true);
                }
            }
        }
        super.CardMouseUp(n2, n3);
    }

    public void Undo() {
        super.Undo();
        this.g = 0;
        for (int i2 = 10; i2 <= 17; ++i2) {
            if (this.Table.GetCell(i2).GetCardsCount() < 13) continue;
            ++this.g;
        }
    }
}

