/*
 * Decompiled with CFR 0.152.
 */
package WizSolitaire;

import WizSolitaire.Card;
import WizSolitaire.DisplayException;
import WizSolitaire.MyDataInputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Random;

public class Deck {
    public static final int CARDS_NUM = 52;
    public static final int PLACEHOLDERS_NUM = 4;
    private static byte[] c = new byte[]{87, 105, 122, 83, 111, 108, 105, 116, 97, 105, 114, 101, 68, 101, 99, 107};
    private int d = 176;
    private int e = 260;
    private Card[] f;
    private Card[] g;
    private Card h = new Card();
    private int i;
    private Random j;

    public Deck() {
        int n2;
        this.f = new Card[52];
        this.g = new Card[4];
        this.j = new Random(System.currentTimeMillis());
        for (n2 = 0; n2 < 52; ++n2) {
            this.f[n2] = new Card();
        }
        for (n2 = 0; n2 < 4; ++n2) {
            this.g[n2] = new Card();
        }
    }

    public Card GetCard(int n2) {
        Card card = null;
        if (n2 < 52) {
            card = this.f[n2];
        }
        return card;
    }

    public Card GetPlaceholder(int n2) {
        Card card = null;
        if (n2 < 4) {
            card = this.g[n2];
        }
        return card;
    }

    public Card GetBack() {
        return this.h;
    }

    public void Shuffle() {
        for (int i2 = 0; i2 < 52; ++i2) {
            this.f[i2].SetUsed(false);
        }
        this.i = 52;
    }

    public Card Pick() {
        int n2;
        int n3 = 0;
        if (this.i <= 0) {
            this.Shuffle();
        }
        if ((n2 = (int)(this.j.nextLong() % (long)this.i--)) < 0) {
            n2 = -n2;
        }
        while (n2 >= 0) {
            while (this.f[n3].HasBeenUsed()) {
                ++n3;
            }
            if (n2-- <= 0) continue;
            ++n3;
        }
        this.f[n3].SetUsed(true);
        return this.f[n3];
    }

    public void Load(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            MyDataInputStream myDataInputStream = new MyDataInputStream(new BufferedInputStream(fileInputStream));
            myDataInputStream.mark(1024);
            if (this.h(myDataInputStream)) {
                this.j(myDataInputStream);
            } else if (this.i(myDataInputStream)) {
                this.k(myDataInputStream);
            }
            fileInputStream.close();
            return;
        }
        catch (DisplayException displayException) {
            throw displayException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new DisplayException("Unable to load \"" + string + "\"!");
        }
    }

    private boolean h(DataInputStream dataInputStream) {
        byte[] byArray = new byte[c.length];
        dataInputStream.reset();
        dataInputStream.readFully(byArray);
        return Arrays.equals(c, byArray);
    }

    private boolean i(DataInputStream dataInputStream) {
        byte[] byArray = new byte[]{80, 67, 82, 69, 75, 79};
        byte[] byArray2 = new byte[byArray.length];
        dataInputStream.reset();
        dataInputStream.readFully(byArray2);
        return Arrays.equals(byArray, byArray2);
    }

    private void j(MyDataInputStream myDataInputStream) {
        int n2;
        if (myDataInputStream.readInt2() > 0) {
            throw new DisplayException("Unsupported deck version (probably it has been created\nwith a newer version of Wiz Solitaire's Deck Editor)");
        }
        this.h.Load(myDataInputStream);
        this.d = 176;
        this.e = 260;
        for (n2 = 0; n2 < 52; ++n2) {
            this.f[n2].Load(myDataInputStream);
        }
        int n3 = myDataInputStream.readInt2();
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                this.g[n2].Load(myDataInputStream);
            }
            return;
        }
        catch (EOFException eOFException) {
            return;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    private void k(MyDataInputStream myDataInputStream) {
        int n2;
        int[] nArray = new int[]{0, 1, 2, 3};
        int n3 = 1;
        int n4 = 0;
        myDataInputStream.skip(2L);
        myDataInputStream.readInt2();
        myDataInputStream.readInt2();
        this.d = myDataInputStream.readShort2();
        this.e = myDataInputStream.readShort2();
        int n5 = myDataInputStream.read();
        int n6 = myDataInputStream.read();
        this.h.LoadFromReko(myDataInputStream, this.d, this.e, n5);
        for (n2 = 0; n2 < 52; ++n2) {
            this.f[n2].LoadFromReko(myDataInputStream, this.d, this.e, n5);
            this.f[n2].SetValue(n3, nArray[n4++]);
            if (n4 <= 3) continue;
            n4 = 0;
            n3 = (char)(n3 + 1);
        }
        if (n6 > 52) {
            for (n2 = 0; n2 < 4; ++n2) {
                this.g[n2].LoadFromReko(myDataInputStream, this.d, this.e, n5);
            }
        }
    }

    public void Resize(int n2, int n3) {
        if (n2 != this.d || n3 != this.e) {
            int n4;
            this.d = n2;
            this.e = n3;
            this.h.ScaleImage(n2, n3);
            for (n4 = 0; n4 < 52; ++n4) {
                this.f[n4].ScaleImage(n2, n3);
            }
            for (n4 = 0; n4 < 4; ++n4) {
                this.g[n4].ScaleImage(n2, n3);
            }
        }
    }
}

