/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.engine.basic;

import com.quizzam.engine.Flashcard;
import com.quizzam.engine.QuizStrategy;
import com.quizzam.engine.basic.BasicAggregateStrategy;
import com.quizzam.engine.basic.BasicFlashcard;
import com.quizzam.engine.basic.BasicQuizStrategy;
import com.quizzam.engine.basic.CustomStrategy;
import com.quizzam.engine.basic.LeastRecentNextStrategy;
import com.quizzam.engine.basic.RandomCardStrategy;
import com.quizzam.engine.basic.RelativeScoreStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserFactory;

public class FlashcardFileLoader
implements DocumentHandler {
    public static final String CUSTOM_STRATEGY_LABEL = "Aggregator";
    public static final String LEAST_RECENT_NEXT_STRATEGY_LABEL = "LeastRecentNext";
    public static final String RELATIVE_SCORE_STRATEGY_LABEL = "LowestScoreNext";
    public static final String RANDOM_CARD_STRATEGY_LABEL = "RandomCard";
    public static final String UNKNOWN_LABEL = "UNKNOWN";
    public static final String STRATEGY_TAG = "STRATEGY";
    public static final String CARD_TAG = "CARD";
    public static final String DECK_TAG = "DECK";
    public static final String FRONT_TAG = "FRONT";
    public static final String BACK_TAG = "BACK";
    BasicFlashcard[] flashcards;
    BasicQuizStrategy strategy;
    int startingIndex = -1;
    private Hashtable cardPositions;
    Locator locator;
    Stack elementStack = new Stack();
    Hashtable extraStrategyInfo = new Hashtable();
    Vector cardsVector = new Vector();

    public FlashcardFileLoader() {
        this.initialize();
    }

    public FlashcardFileLoader(File file) throws IOException {
        this.initialize();
        this.loadFromDisk(file);
    }

    public FlashcardFileLoader(int n, BasicFlashcard[] basicFlashcardArray, BasicQuizStrategy basicQuizStrategy) {
        this.startingIndex = n;
        this.flashcards = basicFlashcardArray;
        this.strategy = basicQuizStrategy;
        this.initialize();
    }

    private void initialize() {
        this.cardPositions = new Hashtable();
        if (this.flashcards != null) {
            int n = 0;
            while (n < this.flashcards.length) {
                this.cardPositions.put(this.flashcards[n], new Integer(n));
                ++n;
            }
        }
    }

    public void clearData() {
        this.flashcards = null;
        this.strategy = null;
        this.startingIndex = -1;
    }

    public int getNumCards() {
        return this.flashcards.length;
    }

    public BasicFlashcard[] getFlashcards() {
        return this.flashcards;
    }

    public void setFlashcards(BasicFlashcard[] basicFlashcardArray) {
        this.flashcards = basicFlashcardArray;
    }

    public BasicQuizStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(BasicQuizStrategy basicQuizStrategy) {
        this.strategy = basicQuizStrategy;
    }

    public int getStartingIndex() {
        return this.startingIndex;
    }

    public void setStartingIndex(int n) {
        this.startingIndex = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void saveToDisk(File file) throws IOException {
        IOException iOException;
        block9: {
            FileWriter fileWriter = null;
            iOException = null;
            fileWriter = new FileWriter(file);
            fileWriter.write("<DECK index=\"" + this.startingIndex + "\">" + this.writeStrategyXML(this.strategy) + this.writeCards(this.flashcards) + "</DECK>");
            Object var6_4 = null;
            try {
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException2) {}
            break block9;
            {
                catch (IOException iOException3) {
                    iOException = iOException3;
                    Object var6_5 = null;
                    try {
                        fileWriter.flush();
                        fileWriter.close();
                    }
                    catch (IOException iOException4) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (IOException iOException5) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public static void saveToDisk(File file, int n, BasicFlashcard[] basicFlashcardArray, BasicQuizStrategy basicQuizStrategy) throws IOException {
        FlashcardFileLoader flashcardFileLoader = new FlashcardFileLoader(n, basicFlashcardArray, basicQuizStrategy);
        flashcardFileLoader.saveToDisk(file);
    }

    private String writeCards(Flashcard[] flashcardArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < flashcardArray.length) {
            Flashcard flashcard = flashcardArray[n];
            Calendar calendar = flashcard.getDateAndTimeOfLastReset();
            int n2 = calendar.get(1);
            String string = String.valueOf(n2);
            if (n2 < 10) {
                string = "000" + string;
            } else if (n2 < 100) {
                string = "00" + string;
            } else if (n2 < 1000) {
                string = "0" + string;
            }
            int n3 = calendar.get(2);
            String string2 = String.valueOf(n3);
            if (n3 < 10) {
                string2 = "0" + string2;
            }
            int n4 = calendar.get(5);
            String string3 = String.valueOf(n4);
            if (n4 < 10) {
                string3 = "0" + string3;
            }
            int n5 = calendar.get(11);
            String string4 = String.valueOf(n5);
            if (n5 < 10) {
                string4 = "0" + string4;
            }
            int n6 = calendar.get(12);
            String string5 = String.valueOf(n6);
            if (n6 < 10) {
                string5 = "0" + string5;
            }
            stringBuffer.append("<CARD lastResetDate=\"" + String.valueOf(string + string2 + string3 + string4 + string5) + "\"><" + FRONT_TAG + " numRight=\"" + flashcard.getFrontNumTimesRight() + "\" numWrong=\"" + flashcard.getFrontNumTimesWrong() + "\">" + this.substituteEscapeChars(flashcard.getFront()) + "</" + FRONT_TAG + "><" + BACK_TAG + " numRight=\"" + flashcard.getBackNumTimesRight() + "\" numWrong=\"" + flashcard.getBackNumTimesWrong() + "\">" + this.substituteEscapeChars(flashcard.getBack()) + "</" + BACK_TAG + "></" + CARD_TAG + ">");
            ++n;
        }
        return stringBuffer.toString();
    }

    private String substituteEscapeChars(String string) {
        string = FlashcardFileLoader.searchAndReplace(string, '&', "&amp;");
        string = FlashcardFileLoader.searchAndReplace(string, '<', "&lt;");
        string = FlashcardFileLoader.searchAndReplace(string, '>', "&gt;");
        string = FlashcardFileLoader.searchAndReplace(string, '\'', "&apos;");
        string = FlashcardFileLoader.searchAndReplace(string, '\"', "&quot;");
        return string;
    }

    private static String searchAndReplace(String string, char c, String string2) {
        String string3 = string;
        StringBuffer stringBuffer = new StringBuffer(string3);
        int n = string3.indexOf(c, 0);
        while (n != -1) {
            stringBuffer.replace(n, n + 1, string2);
            string3 = stringBuffer.toString();
            n = string3.indexOf(c, n + string2.length());
        }
        return string3;
    }

    private String writeStrategyXML(QuizStrategy quizStrategy) {
        return this.writeStrategyXML(quizStrategy, -1);
    }

    private String writeGenericStrategyXML(String string, int n, Hashtable hashtable, String string2) {
        String string3 = null;
        string3 = n == -1 ? "" : " weight=\"" + String.valueOf(n) + "\"";
        if (string2 == null) {
            string2 = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                try {
                    String string4 = (String)enumeration.nextElement();
                    String string5 = (String)hashtable.get(string4);
                    stringBuffer.append(" " + string4 + "=\"" + string5 + "\"");
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return "<STRATEGY type=\"" + string + "\"" + string3 + stringBuffer + ">" + string2 + "</" + STRATEGY_TAG + ">";
    }

    private String writeStrategyXML(QuizStrategy quizStrategy, int n) {
        if (quizStrategy instanceof CustomStrategy) {
            StringBuffer stringBuffer = new StringBuffer();
            CustomStrategy customStrategy = (CustomStrategy)quizStrategy;
            QuizStrategy[] quizStrategyArray = customStrategy.getStrategies();
            int n2 = 0;
            while (n2 < quizStrategyArray.length) {
                QuizStrategy quizStrategy2 = quizStrategyArray[n2];
                stringBuffer.append(this.writeStrategyXML(quizStrategy2, customStrategy.getWeight(quizStrategy2)));
                ++n2;
            }
            return this.writeGenericStrategyXML(CUSTOM_STRATEGY_LABEL, n, null, stringBuffer.toString());
        }
        if (quizStrategy instanceof RandomCardStrategy) {
            RandomCardStrategy randomCardStrategy = (RandomCardStrategy)quizStrategy;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("minSpacing", randomCardStrategy.getParameter("Spacing"));
            return this.writeGenericStrategyXML(RANDOM_CARD_STRATEGY_LABEL, n, hashtable, null);
        }
        if (quizStrategy instanceof LeastRecentNextStrategy) {
            LeastRecentNextStrategy leastRecentNextStrategy = (LeastRecentNextStrategy)quizStrategy;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("minSpacing", leastRecentNextStrategy.getParameter("Spacing"));
            hashtable.put("blockSize", leastRecentNextStrategy.getParameter("Range"));
            StringBuffer stringBuffer = new StringBuffer();
            Flashcard[] flashcardArray = leastRecentNextStrategy.getOrder();
            int n3 = 0;
            while (n3 < flashcardArray.length - 1) {
                stringBuffer.append(((Integer)this.cardPositions.get(flashcardArray[n3])).toString() + ",");
                ++n3;
            }
            if (flashcardArray.length > 0) {
                stringBuffer.append(((Integer)this.cardPositions.get(flashcardArray[flashcardArray.length - 1])).toString());
            }
            hashtable.put("order", stringBuffer.toString());
            return this.writeGenericStrategyXML(LEAST_RECENT_NEXT_STRATEGY_LABEL, n, hashtable, null);
        }
        if (quizStrategy instanceof RelativeScoreStrategy) {
            RelativeScoreStrategy relativeScoreStrategy = (RelativeScoreStrategy)quizStrategy;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("minSpacing", relativeScoreStrategy.getParameter("Spacing"));
            hashtable.put("blockSize", relativeScoreStrategy.getParameter("Range"));
            hashtable.put("maxDeviation", relativeScoreStrategy.getParameter("MaxDeviation"));
            StringBuffer stringBuffer = new StringBuffer();
            Flashcard[] flashcardArray = relativeScoreStrategy.getOrderFrontFirst();
            if (flashcardArray.length > 0) {
                stringBuffer.append(((Integer)this.cardPositions.get(flashcardArray[0])).toString() + "^" + relativeScoreStrategy.getScoreOfFront(flashcardArray[0]) + "^" + relativeScoreStrategy.getScoreOfBack(flashcardArray[0]));
            }
            int n4 = 1;
            while (n4 < flashcardArray.length - 1) {
                stringBuffer.append("," + ((Integer)this.cardPositions.get(flashcardArray[n4])).toString() + "^" + relativeScoreStrategy.getScoreOfFront(flashcardArray[n4]) + "^" + relativeScoreStrategy.getScoreOfBack(flashcardArray[n4]));
                ++n4;
            }
            hashtable.put("scores", stringBuffer.toString());
            return this.writeGenericStrategyXML(RELATIVE_SCORE_STRATEGY_LABEL, n, hashtable, null);
        }
        return this.writeGenericStrategyXML(UNKNOWN_LABEL, n, null, null);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.addCharacterData(cArray, n, n2);
    }

    public void characters(char[] cArray, int n, int n2) {
        this.addCharacterData(cArray, n, n2);
    }

    public void loadFromDisk(File file) throws IOException {
        Parser parser;
        this.startingIndex = 0;
        this.flashcards = null;
        this.strategy = null;
        this.strategy = null;
        this.cardsVector.clear();
        String string = "com.microstar.xml.SAXDriver";
        try {
            parser = ParserFactory.makeParser(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Could not find class: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Access violation on : " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Could not instantiate " + string);
        }
        catch (ClassCastException classCastException) {
            throw new IOException(string + " does not implement the SAX Parser interface.");
        }
        parser.setDocumentHandler(this);
        try {
            parser.parse(new InputSource(new FileReader(file)));
            this.flashcards = new BasicFlashcard[this.cardsVector.size()];
            int n = 0;
            while (n < this.flashcards.length) {
                this.flashcards[n] = (BasicFlashcard)this.cardsVector.get(n);
                ++n;
            }
            this.addCardsToStrategies(this.flashcards, this.extraStrategyInfo);
        }
        catch (SAXException sAXException) {
            throw new IOException("Error: " + sAXException.getMessage() + " --> line " + this.locator.getLineNumber() + ", column " + this.locator.getColumnNumber());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File not found");
        }
    }

    public void addCardsToStrategies(Flashcard[] flashcardArray, Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            BasicQuizStrategy basicQuizStrategy;
            BasicQuizStrategy basicQuizStrategy2 = (BasicQuizStrategy)enumeration.nextElement();
            if (basicQuizStrategy2 instanceof BasicAggregateStrategy) {
                basicQuizStrategy = (BasicAggregateStrategy)basicQuizStrategy2;
                int n = 0;
                while (n < flashcardArray.length) {
                    basicQuizStrategy.addCardWithoutNotifyingStrategies(flashcardArray[n]);
                    ++n;
                }
                continue;
            }
            if (basicQuizStrategy2 instanceof LeastRecentNextStrategy) {
                basicQuizStrategy = (LeastRecentNextStrategy)basicQuizStrategy2;
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)hashtable.get(basicQuizStrategy2), ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        ((LeastRecentNextStrategy)basicQuizStrategy).addCard(flashcardArray[Integer.parseInt(stringTokenizer.nextToken())]);
                    }
                }
                catch (ClassCastException classCastException) {
                    basicQuizStrategy2.removeAllCards();
                    this.addCardsInDefaultOrder(basicQuizStrategy2, flashcardArray);
                }
                catch (NumberFormatException numberFormatException) {
                    basicQuizStrategy2.removeAllCards();
                    this.addCardsInDefaultOrder(basicQuizStrategy2, flashcardArray);
                }
                continue;
            }
            if (basicQuizStrategy2 instanceof RelativeScoreStrategy) {
                basicQuizStrategy = (RelativeScoreStrategy)basicQuizStrategy2;
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)hashtable.get(basicQuizStrategy2), ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "^");
                        String string = stringTokenizer2.nextToken();
                        String string2 = stringTokenizer2.nextToken();
                        String string3 = stringTokenizer2.nextToken();
                        ((RelativeScoreStrategy)basicQuizStrategy).addCard(flashcardArray[Integer.parseInt(string)], Integer.parseInt(string2), Integer.parseInt(string3));
                    }
                }
                catch (ClassCastException classCastException) {
                    basicQuizStrategy2.removeAllCards();
                    this.addCardsInDefaultOrder(basicQuizStrategy, flashcardArray);
                }
                continue;
            }
            if (!(basicQuizStrategy2 instanceof RandomCardStrategy)) continue;
            basicQuizStrategy = (RandomCardStrategy)basicQuizStrategy2;
            basicQuizStrategy2.removeAllCards();
            this.addCardsInDefaultOrder(basicQuizStrategy, flashcardArray);
        }
    }

    private void addCardsInDefaultOrder(BasicQuizStrategy basicQuizStrategy, Flashcard[] flashcardArray) {
        int n = 0;
        while (n < flashcardArray.length) {
            basicQuizStrategy.addCard(flashcardArray[n]);
            ++n;
        }
    }

    public void startElement(String string, AttributeList attributeList) {
        Object object = null;
        String string2 = null;
        String string3 = string.trim();
        if (string3.equals(STRATEGY_TAG)) {
            String string4 = attributeList.getValue("type");
            if (string4 != null) {
                if ((string4 = string4.trim()).equals(CUSTOM_STRATEGY_LABEL)) {
                    object = new CustomStrategy();
                    string2 = null;
                } else if (string4.equals(LEAST_RECENT_NEXT_STRATEGY_LABEL)) {
                    LeastRecentNextStrategy leastRecentNextStrategy = new LeastRecentNextStrategy();
                    try {
                        leastRecentNextStrategy.setParameter("Range", attributeList.getValue("blockSize"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    try {
                        leastRecentNextStrategy.setParameter("Spacing", attributeList.getValue("minSpacing"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    object = leastRecentNextStrategy;
                    string2 = attributeList.getValue("order");
                } else if (string4.equals(RANDOM_CARD_STRATEGY_LABEL)) {
                    RandomCardStrategy randomCardStrategy = new RandomCardStrategy();
                    try {
                        randomCardStrategy.setParameter("Spacing", attributeList.getValue("minSpacing"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    object = randomCardStrategy;
                    string2 = null;
                } else if (string4.equals(RELATIVE_SCORE_STRATEGY_LABEL)) {
                    RelativeScoreStrategy relativeScoreStrategy = new RelativeScoreStrategy();
                    try {
                        relativeScoreStrategy.setParameter("Range", attributeList.getValue("blockSize"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    try {
                        relativeScoreStrategy.setParameter("Spacing", attributeList.getValue("minSpacing"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    try {
                        relativeScoreStrategy.setParameter("MaxDeviation", attributeList.getValue("maxDeviation"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    object = relativeScoreStrategy;
                    string2 = attributeList.getValue("scores");
                } else {
                    object = string;
                }
                if (object != null) {
                    this.addToAggregatorOrStrategiesList((BasicQuizStrategy)object, this.elementStack, attributeList);
                    if (string2 == null) {
                        string2 = "";
                    }
                    this.extraStrategyInfo.put(object, string2);
                }
            }
        } else if (string3.equals(DECK_TAG)) {
            try {
                this.startingIndex = Integer.parseInt(attributeList.getValue("index"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            object = DECK_TAG;
        } else if (string3.equals(CARD_TAG)) {
            object = new BasicFlashcard();
            try {
                String string5 = attributeList.getValue("lastResetDate");
                if (string5 != null && string5.length() == 12) {
                    GregorianCalendar gregorianCalendar = new GregorianCalendar(Integer.parseInt(string5.substring(0, 4)), Integer.parseInt(string5.substring(4, 6)), Integer.parseInt(string5.substring(6, 8)), Integer.parseInt(string5.substring(8, 10)), Integer.parseInt(string5.substring(10, 12)));
                    ((BasicFlashcard)object).setDateAndTimeOfLastReset(gregorianCalendar);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.cardsVector.add(object);
        } else if (string3.equals(FRONT_TAG)) {
            try {
                Flashcard flashcard = (Flashcard)this.elementStack.peek();
                try {
                    ((BasicFlashcard)flashcard).setFrontNumTimesRight(Integer.parseInt(attributeList.getValue("numRight")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    ((BasicFlashcard)flashcard).setFrontNumTimesWrong(Integer.parseInt(attributeList.getValue("numWrong")));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (EmptyStackException emptyStackException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            object = FRONT_TAG;
        } else if (string3.equals(BACK_TAG)) {
            try {
                Flashcard flashcard = (Flashcard)this.elementStack.peek();
                try {
                    ((BasicFlashcard)flashcard).setBackNumTimesRight(Integer.parseInt(attributeList.getValue("numRight")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    ((BasicFlashcard)flashcard).setBackNumTimesWrong(Integer.parseInt(attributeList.getValue("numWrong")));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (EmptyStackException emptyStackException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            object = BACK_TAG;
        } else {
            object = string3;
        }
        this.elementStack.push(object);
    }

    private void addToAggregatorOrStrategiesList(BasicQuizStrategy basicQuizStrategy, Stack stack, AttributeList attributeList) {
        block5: {
            try {
                Object e = stack.peek();
                if (e instanceof BasicAggregateStrategy) {
                    int n = 1;
                    try {
                        n = Integer.parseInt(attributeList.getValue("weight"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ((BasicAggregateStrategy)e).addStrategy(basicQuizStrategy, n);
                    break block5;
                }
                this.strategy = basicQuizStrategy;
            }
            catch (EmptyStackException emptyStackException) {
                this.strategy = basicQuizStrategy;
            }
        }
    }

    public void endElement(String string) {
        try {
            Object e = this.elementStack.peek();
            if (e instanceof QuizStrategy && string.equals(STRATEGY_TAG) || e instanceof Flashcard && string.equals(CARD_TAG) || e.equals(string)) {
                this.elementStack.pop();
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public void addCharacterData(char[] cArray, int n, int n2) {
        try {
            Object e = this.elementStack.pop();
            if (e.equals(FRONT_TAG)) {
                try {
                    Object e2 = this.elementStack.peek();
                    if (e2 instanceof Flashcard) {
                        Flashcard flashcard = (Flashcard)e2;
                        flashcard.setFront(flashcard.getFront() + new String(cArray, n, n2));
                    }
                }
                catch (EmptyStackException emptyStackException) {}
            } else if (e.equals(BACK_TAG)) {
                try {
                    Object e3 = this.elementStack.peek();
                    if (e3 instanceof Flashcard) {
                        Flashcard flashcard = (Flashcard)e3;
                        flashcard.setBack(flashcard.getBack() + new String(cArray, n, n2));
                    }
                }
                catch (EmptyStackException emptyStackException) {
                    // empty catch block
                }
            }
            this.elementStack.push(e);
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }
}

