/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.engine.basic;

import com.quizzam.engine.Flashcard;
import com.quizzam.engine.basic.FlashcardListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;

public class BasicFlashcard
implements Flashcard {
    protected String front = "";
    protected String back = "";
    protected int frontNumTimesRight = 0;
    protected int frontNumTimesWrong = 0;
    protected int backNumTimesRight = 0;
    protected int backNumTimesWrong = 0;
    Calendar dateTimeOfLastReset = new GregorianCalendar();
    HashSet flashcardListeners = new HashSet();

    public void setFrontNumTimesRight(int n) {
        this.frontNumTimesRight = n;
    }

    public void setFrontNumTimesWrong(int n) {
        this.frontNumTimesWrong = n;
    }

    public void setBackNumTimesRight(int n) {
        this.backNumTimesRight = n;
    }

    public void setBackNumTimesWrong(int n) {
        this.backNumTimesWrong = n;
    }

    public void setDateAndTimeOfLastReset(Calendar calendar) throws IllegalArgumentException {
        if (calendar == null) {
            throw new IllegalArgumentException("This method cannot accept NULL as a parameter");
        }
        this.dateTimeOfLastReset = (Calendar)calendar.clone();
    }

    public boolean addListener(FlashcardListener flashcardListener) {
        return this.flashcardListeners.add(flashcardListener);
    }

    public boolean removeListener(FlashcardListener flashcardListener) {
        return this.flashcardListeners.remove(flashcardListener);
    }

    public String getFront() {
        return this.front;
    }

    public String getBack() {
        return this.back;
    }

    public void setFront(String string) {
        this.front = string == null ? "" : string;
    }

    public void setBack(String string) {
        this.back = string == null ? "" : string;
    }

    public void markRight(boolean bl) {
        if (bl) {
            ++this.frontNumTimesRight;
        } else {
            ++this.backNumTimesRight;
        }
        Iterator iterator = this.flashcardListeners.iterator();
        while (iterator.hasNext()) {
            FlashcardListener flashcardListener = (FlashcardListener)iterator.next();
            flashcardListener.cardWasScored(this, true, bl);
        }
    }

    public void markWrong(boolean bl) {
        if (bl) {
            ++this.frontNumTimesWrong;
        } else {
            ++this.backNumTimesWrong;
        }
        Iterator iterator = this.flashcardListeners.iterator();
        while (iterator.hasNext()) {
            FlashcardListener flashcardListener = (FlashcardListener)iterator.next();
            flashcardListener.cardWasScored(this, false, bl);
        }
    }

    public int getFrontNumTimesRight() {
        return this.frontNumTimesRight;
    }

    public int getFrontNumTimesWrong() {
        return this.frontNumTimesWrong;
    }

    public int getBackNumTimesRight() {
        return this.backNumTimesRight;
    }

    public int getBackNumTimesWrong() {
        return this.backNumTimesWrong;
    }

    public void resetStats() {
        this.frontNumTimesRight = 0;
        this.frontNumTimesWrong = 0;
        this.backNumTimesRight = 0;
        this.backNumTimesWrong = 0;
        this.dateTimeOfLastReset.setTime(new Date());
    }

    public Calendar getDateAndTimeOfLastReset() {
        return this.dateTimeOfLastReset;
    }
}

