/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.SelfPositioningDialog;
import com.quizzam.engine.QuizStrategy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RelativeScoreStrategyDialog
extends SelfPositioningDialog
implements ActionListener {
    QuizStrategy strategy;
    Box box;
    JTextField rangeParamField;
    JTextField spacingParamField;
    JTextField maxDeviationParamField;
    protected static final int WIDTH = 350;
    protected static final int HEIGHT = 400;
    private Color textColor;
    private Cursor actionCursor;

    public RelativeScoreStrategyDialog(Frame frame, String string, boolean bl, Color color, Cursor cursor) throws IllegalArgumentException {
        super(frame, string, bl);
        if (frame == null || string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(color, cursor);
    }

    public RelativeScoreStrategyDialog(Dialog dialog, String string, boolean bl, Color color, Cursor cursor) throws IllegalArgumentException {
        super(dialog, string, bl);
        if (dialog == null || string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(color, cursor);
    }

    private void initialize(Color color, Cursor cursor) {
        this.textColor = color;
        this.actionCursor = cursor;
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(350, 400);
        this.setResizable(false);
    }

    public void setRelativeScoreStrategy(QuizStrategy quizStrategy) {
        this.strategy = quizStrategy;
        this.getContentPane().add((Component)this.getContentPanel(), "North");
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Apply");
        jButton.setActionCommand("apply");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Cancel");
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("apply")) {
            try {
                String string2 = this.rangeParamField.getText();
                String string3 = this.spacingParamField.getText();
                String string4 = this.maxDeviationParamField.getText();
                this.strategy.setParameter("Range", string2);
                this.strategy.setParameter("Spacing", string3);
                this.strategy.setParameter("MaxDeviation", string4);
                this.dispose();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this, "All parameters must be numeric, The first two parameters must be greater than zero.  The third must be between zero and 100.", "Invalid Parameters", 0);
            }
        } else if (string.equals("cancel")) {
            this.dispose();
        }
    }

    private JPanel getContentPanel() {
        JPanel jPanel = new JPanel(new GridLayout(16, 1, 0, 0));
        JPanel jPanel2 = null;
        JLabel jLabel = null;
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("Initially, all cards start with the same score.  When");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("new cards are added/created, they start out with the");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("lowest score amongst all existing cards.  Whenever");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("a card is marked as correct, its score increases");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("by 1 relative to the other cards.  Every time a card");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("is marked as incorrect, its score decreases by 1 relative");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("to the other cards.");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel.add(new JLabel(" "));
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("The next card shown should be one of the");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        this.rangeParamField = new JTextField(this.strategy.getParameter("Range"), 3);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jPanel2.add(this.rangeParamField);
        jLabel = new JLabel(" lowest scoring cards.");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel.add(new JLabel(" "));
        this.spacingParamField = new JTextField(this.strategy.getParameter("Spacing"), 3);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("Show at least ");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel2.add(this.spacingParamField);
        jLabel = new JLabel(" different cards before");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("repeating any specific card.");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel.add(new JLabel(" "));
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("The maximum difference allowed between the scores");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        this.maxDeviationParamField = new JTextField(this.strategy.getParameter("MaxDeviation"), 3);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("of the highest and lowest scoring cards is ");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel2.add(this.maxDeviationParamField);
        jLabel = new JLabel(".");
        jLabel.setAlignmentY(1.0f);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        return jPanel;
    }
}

