/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.AggregateStrategyDialog;
import com.quizzam.application.basic.CardIndexFieldDocument;
import com.quizzam.application.basic.CardPropertiesScreen;
import com.quizzam.application.basic.ColorIcon;
import com.quizzam.application.basic.CommonFunctions;
import com.quizzam.application.basic.CustomJToolBar;
import com.quizzam.application.basic.DeckHistory;
import com.quizzam.application.basic.DeckHistoryListener;
import com.quizzam.application.basic.FindCardDialog;
import com.quizzam.application.basic.FindCardDialogListener;
import com.quizzam.application.basic.GenericInformationScreen;
import com.quizzam.application.basic.ImportDialog;
import com.quizzam.application.basic.MultimediaCoordinator;
import com.quizzam.application.basic.PreferencesManager;
import com.quizzam.application.basic.RefreshInterface;
import com.quizzam.application.basic.RolloverLabelHandler;
import com.quizzam.application.basic.SimpleFileFilter;
import com.quizzam.application.basic.SimpleTimer;
import com.quizzam.application.basic.StringPointer;
import com.quizzam.application.basic.TextFormatCoordinator;
import com.quizzam.application.basic.TimerListener;
import com.quizzam.application.basic.ToolBarCoordinator;
import com.quizzam.application.basic.TopLevelAggregateStrategyDialog;
import com.quizzam.engine.AggregateStrategy;
import com.quizzam.engine.Flashcard;
import com.quizzam.engine.FlashcardDeck;
import com.quizzam.engine.FlashcardEngine;
import com.quizzam.engine.QuizStrategy;
import com.quizzam.engine.basic.BasicFlashcardEngine;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class Quizzam
extends JFrame
implements ActionListener,
TimerListener,
DocumentListener,
KeyListener,
WindowListener,
FindCardDialogListener,
DeckHistoryListener,
RefreshInterface {
    private static final String APP_NAME = "Quizzam";
    private static final String VERSION = "3.1";
    private static final String RELEASE = "1";
    private static final String WEB_SITE = "http://www.quizzam.com";
    private static final String EMAIL = "contact@quizzam.com";
    private static final String TITLE = "Quizzam 3.1";
    private static final String START_QUIZ_BUTTON_ROLLOVER = "Quiz Yourself";
    private static final String STOP_QUIZ_BUTTON_ROLLOVER = "Stop the quiz";
    private static final int TEMPORARY_MESSAGE_TIME = 3000;
    private static final int INIT_WIDTH = 350;
    private static final int INIT_HEIGHT = 359;
    private static final String PREFERENCES_FILENAME = "quizzam.ini";
    private static final Color LABEL_COLOR = new Color(102, 102, 153);
    private static final Cursor ACTION_CURSOR = new Cursor(12);
    private static final int FRONT = 0;
    private static final int BACK = 1;
    private static final int RANDOM = 2;
    private static final String VIEW_NORMAL = "Normal";
    private static final String VIEW_PREVIEW = "Links & Sound Test";
    private static final String VIEW_SOURCE = "HTML Source";
    private String currentView = "Normal";
    private Random randomNumberGenerator = new Random();
    private boolean inQuizMode = false;
    private boolean deckHasChanged = false;
    private int showWhichSideFirst = 0;
    private int showFrontSideFirstPercentWhenRandom = 50;
    private boolean frontShownFirstOnCurrentCardInQuiz;
    private JCheckBoxMenuItem showFrontFirstMenuItem;
    private JCheckBoxMenuItem showBackFirstMenuItem;
    private JCheckBoxMenuItem showRandomFirstMenuItem;
    private FlashcardEngine flashcardEngine = new BasicFlashcardEngine();
    private FlashcardDeck deck;
    private Flashcard currentCard;
    private boolean frontShowing;
    String currentFileName = "";
    private int outstandingTimers = 0;
    private int currentCardIndex;
    private JFileChooser fileChooser = new JFileChooser();
    private StringPointer defaultStatusBarMessage = new StringPointer("Edit Mode");
    private StringPointer frontBackStatusBarMessage = new StringPointer("The FRONT side of the card is currently being shown");
    private JLabel statusBarLabel = new JLabel(this.defaultStatusBarMessage.getString());
    private JComboBox viewSelector;
    private RolloverLabelHandler rolloverLabelHandler = new RolloverLabelHandler(this.statusBarLabel);
    private ColorIcon colorIcon = new ColorIcon(Color.BLACK, 34, 13);
    private JButton colorButton = new JButton(this.colorIcon);
    private JLabel colorLabel = new JLabel("Color:  ");
    private JLabel viewSpacerLabel = new JLabel("      ");
    private StyleSheet styleSheet = this.createStyleSheet();
    private HTMLEditorKit normalEditorKit = this.createHTMLEditorKit(this.styleSheet);
    private StyledEditorKit htmlSourceEditorKit = new StyledEditorKit();
    private JTextPane textPane = this.createTextPane(this.normalEditorKit);
    private String[] availableFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private String[] availableFontSizes = this.getAvailableFontSizes();
    private TextFormatCoordinator textFormatCoordinator = new TextFormatCoordinator(this.textPane, new JComboBox<String>(this.availableFonts), new JComboBox<String>(this.availableFontSizes), this.colorButton, this.colorIcon);
    private ToolBarCoordinator toolBarCoordinator = new ToolBarCoordinator(new CustomJToolBar("Toolbar", 0), new CustomJToolBar("Toolbar", 0), new CustomJToolBar("Flashcard", 1), 16, 27);
    private PreferencesManager preferencesManager = new PreferencesManager(this, "Preferences", true, LABEL_COLOR, ACTION_CURSOR, this.fileChooser, "Quizzam", "3.1", "1", this.availableFonts, this.availableFontSizes);
    private MultimediaCoordinator multimediaCoordinator = new MultimediaCoordinator(this, this, this.textPane, false, new JButton(new ImageIcon(CommonFunctions.getImage("/images/insertimage.gif"))), new JButton(new ImageIcon(CommonFunctions.getImage("/images/insertlink.gif"))), new JButton(new ImageIcon(CommonFunctions.getImage("/images/insertsound.gif"))), LABEL_COLOR, ACTION_CURSOR, this.fileChooser, this.preferencesManager, "quizzam.ini", this.rolloverLabelHandler);
    private GenericInformationScreen aboutInfoScreen = new GenericInformationScreen(this, "About Quizzam 3.1", "Quizzam 3.1    (release 1)<br>author: JASON YUEN<br><a href=\"http://www.quizzam.com\">http://www.quizzam.com</a><br><br>Visit the web site to report bugs, suggest changes, download cards, and read the latest news on Quizzam.", false, LABEL_COLOR, ACTION_CURSOR, 190, 245, this.multimediaCoordinator);
    private GenericInformationScreen licenseInfoScreen = new GenericInformationScreen(this, "About the Free License", "Quizzam 3.1 comes with a free license.&nbsp; To view the actual terms of the license, please visit our website.&nbsp; But in summary:<br><br>This product may be used or distributed free of charge.&nbsp; This product may NOT be distributed if it has been modified from its original form.&nbsp; This product may NOT be distributed unless all files are included and are in their unmodified entirety.&nbsp; This product may NOT be sold.<br><br>********************************************************<br>If you paid money for this product, or know of anyone who has, please contact us via our\twebsite.<br>********************************************************<br><br><a href=\"http://www.quizzam.com\">http://www.quizzam.com</a>", false, LABEL_COLOR, ACTION_CURSOR, 370, 310, this.multimediaCoordinator);
    private CardPropertiesScreen cardPropertiesScreen = new CardPropertiesScreen(this, "Card Stats", false, LABEL_COLOR, ACTION_CURSOR);
    private ImportDialog importScreen = new ImportDialog(this, "Import From file", true, LABEL_COLOR, ACTION_CURSOR);
    private AggregateStrategyDialog strategyConfigScreen = new TopLevelAggregateStrategyDialog(this.flashcardEngine, this, "Quiz Strategies", false, LABEL_COLOR, ACTION_CURSOR);
    private FindCardDialog findCardDialog = new FindCardDialog(this, (FindCardDialogListener)this, "Find a Specific Flashcard", false, new Color(0, 0, 0), ACTION_CURSOR);
    private CardLayout cardIndexPanelLayout = new CardLayout();
    private JPanel cardIndexPanel;
    private CardLayout buttonPanelLayout = new CardLayout();
    private JPanel buttonPanel;
    private JButton newCardButton;
    private JButton insertHyperlinkButton;
    private JButton insertImageButton;
    private JButton insertSoundButton;
    private JToolBar formatToolBar1;
    private JToolBar formatToolBar2;
    private JMenuItem quizMenuItem;
    private JMenuItem createMenuItem;
    private JMenuItem deckHistoryMenuItem1;
    private JMenuItem deckHistoryMenuItem2;
    private JMenuItem deckHistoryMenuItem3;
    private JMenuItem deckHistoryMenuItem4;
    DeckHistory deckHistory = new DeckHistory();
    private JLabel frontOrBackLabel;
    private Box.Filler frontOrBackBoxFiller;
    private JTextField currentCardIndexField;
    private JLabel totalCardsLabel;
    protected String APP_FILE_EXTENSION = ".qzm";
    protected String APP_FILE_EXTENSION_DESCRIPTION = "Quizzam Flashcard Decks (*.qzm)";
    SimpleFileFilter fileFilter = new SimpleFileFilter(this.APP_FILE_EXTENSION, this.APP_FILE_EXTENSION_DESCRIPTION, false);

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Quizzam quizzam = stringArray.length > 0 ? new Quizzam(stringArray[0]) : new Quizzam();
        quizzam.setDefaultCloseOperation(3);
    }

    public Quizzam() {
        this.init();
    }

    public Quizzam(String string) {
        this.init();
        this.open(string);
    }

    private String[] getAvailableFontSizes() {
        String[] stringArray = new String[15];
        int n = 0;
        int n2 = 8;
        while (n2 <= 36) {
            stringArray[n] = String.valueOf(n2);
            ++n;
            n2 += 2;
        }
        return stringArray;
    }

    private JTextPane createTextPane(HTMLEditorKit hTMLEditorKit) {
        JTextPane jTextPane = new JTextPane(new HTMLDocument());
        jTextPane.setEditorKit(hTMLEditorKit);
        return jTextPane;
    }

    private StyleSheet createStyleSheet() {
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.addRule("BODY{ margin : 0; color:#000000}");
        styleSheet.addRule("A { text-decoration: underline; color:0000FF; font-weight:bold }");
        return styleSheet;
    }

    private HTMLEditorKit createHTMLEditorKit(StyleSheet styleSheet) {
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        hTMLEditorKit.setStyleSheet(styleSheet);
        return hTMLEditorKit;
    }

    private void init() {
        super.setTitle(TITLE);
        this.addWindowListener(this);
        try {
            this.preferencesManager.load(PREFERENCES_FILENAME);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Properties properties = this.preferencesManager.getProperties();
        if (properties.getProperty(PreferencesManager.PARAM_START_WITH_DEFAULT_WINDOW_SIZE_AND_POSITION).trim().toUpperCase().equals("Y")) {
            this.setSize(350, 359);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(((int)dimension.getWidth() - this.getWidth()) / 2, ((int)dimension.getHeight() - this.getHeight()) / 2);
        } else {
            int n = 359;
            int n2 = 350;
            int n3 = 0;
            int n4 = 0;
            try {
                n = Integer.parseInt(properties.getProperty(PreferencesManager.PARAM_WINDOW_HEIGHT));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n2 = Integer.parseInt(properties.getProperty(PreferencesManager.PARAM_WINDOW_WIDTH));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n3 = Integer.parseInt(properties.getProperty(PreferencesManager.PARAM_WINDOW_X));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n4 = Integer.parseInt(properties.getProperty(PreferencesManager.PARAM_WINDOW_Y));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.setSize(n2, n);
            this.setLocation(n3, n4);
        }
        try {
            this.deckHistory.addDeck(properties.getProperty(PreferencesManager.PARAM_DECK_HISTORY_4));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.deckHistory.addDeck(properties.getProperty(PreferencesManager.PARAM_DECK_HISTORY_3));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.deckHistory.addDeck(properties.getProperty(PreferencesManager.PARAM_DECK_HISTORY_2));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.deckHistory.addDeck(properties.getProperty(PreferencesManager.PARAM_DECK_HISTORY_1));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.deckHistory.addListener(this);
        JLabel jLabel = this.statusBarLabel;
        jLabel.setForeground(LABEL_COLOR);
        this.statusBarLabel = jLabel;
        this.setupMenus(this.deckHistory);
        this.getContentPane().addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)this.getContentPane(), this.defaultStatusBarMessage);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.rolloverLabelHandler.getRolloverLabel(), "South");
        this.getContentPane().add((Component)this.createOutsideInteractivePanel(), "Center");
        this.toolBarCoordinator.refreshLayout();
        this.textFormatCoordinator.refresh();
        this.textPane.requestFocus();
        this.setVisible(true);
        this.newDeck();
    }

    private JPanel createOutsideInteractivePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createInteractivePanel(), "Center");
        JPanel jPanel2 = this.cardIndexPanel = this.createTopPanel();
        jPanel.add((Component)jPanel2, "North");
        this.buttonPanel = this.createButtonPanel();
        jPanel.add((Component)this.buttonPanel, "South");
        return jPanel;
    }

    private JToolBar createOtherTextToolBar() {
        JComboBox<String> jComboBox;
        CustomJToolBar customJToolBar = this.toolBarCoordinator.getMiddleToolBar();
        customJToolBar.setCanBeVertical(false);
        customJToolBar.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)customJToolBar, this.defaultStatusBarMessage);
        JLabel jLabel = this.colorLabel;
        Color color = new Color(0, 0, 102);
        Font font = new Font(null, 0, 10);
        jLabel.setForeground(color);
        jLabel.setFont(font);
        customJToolBar.add(jLabel);
        JButton jButton = this.colorButton;
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Select the TEXT color");
        customJToolBar.add(jButton);
        jLabel = this.viewSpacerLabel;
        jLabel.setFont(font);
        customJToolBar.add(jLabel);
        jLabel = new JLabel("View:  ");
        jLabel.setForeground(color);
        jLabel.setFont(font);
        customJToolBar.add(jLabel);
        String[] stringArray = new String[]{VIEW_NORMAL, VIEW_SOURCE, VIEW_PREVIEW};
        this.viewSelector = jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setCursor(ACTION_CURSOR);
        jComboBox.addActionListener(this);
        jComboBox.setActionCommand("switchView");
        jComboBox.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register(jComboBox, "Change your view of the flashcard");
        jComboBox.setFont(font);
        jComboBox.setMaximumSize(jComboBox.getMinimumSize());
        customJToolBar.add(jComboBox);
        return customJToolBar;
    }

    private JToolBar createTextToolBar() {
        CustomJToolBar customJToolBar = this.toolBarCoordinator.getOuterToolBar();
        customJToolBar.setCanBeVertical(false);
        customJToolBar.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)customJToolBar, this.defaultStatusBarMessage);
        Font font = new Font(null, 0, 10);
        JComboBox jComboBox = this.textFormatCoordinator.getFontObject();
        jComboBox.setCursor(ACTION_CURSOR);
        jComboBox.setFont(font);
        jComboBox.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jComboBox, "Select font");
        jComboBox.setMaximumSize(jComboBox.getMinimumSize());
        customJToolBar.add(jComboBox);
        jComboBox = this.textFormatCoordinator.getSizeObject();
        jComboBox.setCursor(ACTION_CURSOR);
        jComboBox.setFont(font);
        jComboBox.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jComboBox, "Select font size");
        jComboBox.setMaximumSize(jComboBox.getMinimumSize());
        customJToolBar.add(jComboBox);
        JLabel jLabel = new JLabel("       ");
        font = new Font(null, 0, 8);
        jLabel.setFont(font);
        customJToolBar.add(jLabel);
        JButton jButton = new JButton(new ImageIcon(CommonFunctions.getImage("/images/bold.gif")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.setActionCommand("applyBold");
        jButton.addActionListener(this.textFormatCoordinator);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Toggle BOLD text");
        customJToolBar.add(jButton);
        jButton = new JButton(new ImageIcon(CommonFunctions.getImage("/images/italic.gif")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.setActionCommand("applyItalic");
        jButton.addActionListener(this.textFormatCoordinator);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Toggle ITALICIZED text");
        customJToolBar.add(jButton);
        jButton = new JButton(new ImageIcon(CommonFunctions.getImage("/images/underline.gif")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.setActionCommand("applyUnderline");
        jButton.addActionListener(this.textFormatCoordinator);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Toggle UNDERLINED text");
        customJToolBar.add(jButton);
        return customJToolBar;
    }

    private JPanel createInteractivePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = this.createFlashcardAreaPanel();
        jPanel2.add((Component)jPanel3, "Center");
        this.formatToolBar1 = this.createOtherTextToolBar();
        jPanel2.add((Component)this.formatToolBar1, "North");
        jPanel.add((Component)jPanel2, "Center");
        this.formatToolBar2 = this.createTextToolBar();
        jPanel.add((Component)this.formatToolBar2, "North");
        return jPanel;
    }

    private JPanel createFlashcardAreaPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextPane jTextPane = this.textPane;
        jTextPane.setContentType("text/html");
        jTextPane.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jTextPane, this.defaultStatusBarMessage);
        jTextPane.addKeyListener(this);
        jPanel.add((Component)new JScrollPane(jTextPane), "Center");
        JToolBar jToolBar = this.createCardButtonsToolBar();
        jPanel.add((Component)jToolBar, "West");
        return jPanel;
    }

    private JPanel createTopPanel() {
        JPanel jPanel = new JPanel(this.cardIndexPanelLayout);
        jPanel.add((Component)this.createCardIndexPanel(), "Card Index");
        JPanel jPanel2 = new JPanel();
        JTextPane jTextPane = new JTextPane();
        JLabel jLabel = new JLabel("    Quiz Mode");
        jLabel.setFont(new Font(null, 1, 16));
        jLabel.setForeground(LABEL_COLOR);
        jPanel2.add(jLabel);
        jPanel.add((Component)jPanel2, "Quiz Message");
        return jPanel;
    }

    private JPanel createCardIndexPanel() {
        this.frontOrBackLabel = new JLabel("FRONT");
        this.frontOrBackLabel.setForeground(LABEL_COLOR);
        this.frontOrBackBoxFiller = new Box.Filler(this.frontOrBackLabel.getMinimumSize(), this.frontOrBackLabel.getPreferredSize(), this.frontOrBackLabel.getMaximumSize());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.frontOrBackBoxFiller);
        JLabel jLabel = new JLabel("   Card:");
        jLabel.setForeground(LABEL_COLOR);
        jLabel.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jLabel, this.defaultStatusBarMessage);
        jPanel2.add(jLabel);
        this.currentCardIndexField = new JTextField(RELEASE, 3);
        this.currentCardIndexField.addMouseMotionListener(this.rolloverLabelHandler);
        this.currentCardIndexField.setActionCommand("indexFieldSubmitted");
        this.currentCardIndexField.addActionListener(this);
        this.rolloverLabelHandler.register((Object)this.currentCardIndexField, "Jump to a specific card");
        this.currentCardIndexField.getDocument().addDocumentListener(this);
        jPanel2.add(this.currentCardIndexField);
        jLabel = new JLabel("/ ");
        jLabel.setForeground(LABEL_COLOR);
        jLabel.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jLabel, this.defaultStatusBarMessage);
        jPanel2.add(jLabel);
        this.totalCardsLabel = jLabel = new JLabel("xxx");
        jLabel.setForeground(LABEL_COLOR);
        jLabel.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jLabel, "The total number of cards in the deck");
        jPanel2.add(jLabel);
        jLabel = new JLabel("   ");
        jLabel.setForeground(LABEL_COLOR);
        jLabel.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jLabel, this.defaultStatusBarMessage);
        jPanel2.add(jLabel);
        jLabel = this.frontOrBackLabel;
        jLabel.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jLabel, this.frontBackStatusBarMessage);
        jPanel2.add(jLabel);
        jPanel2.add(new Box.Filler(new Dimension(38, 0), new Dimension(38, 0), new Dimension(38, 0)));
        jPanel2.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jPanel2, this.defaultStatusBarMessage);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JToolBar createCardButtonsToolBar() {
        CustomJToolBar customJToolBar = this.toolBarCoordinator.getInnerToolBar();
        customJToolBar.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)customJToolBar, this.defaultStatusBarMessage);
        JButton jButton = null;
        jButton = new JButton(new ImageIcon(CommonFunctions.getImage("/images/newcard.gif")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.setActionCommand("newCard");
        jButton.addActionListener(this);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Create a new card");
        this.newCardButton = jButton;
        customJToolBar.add(jButton);
        jButton = new JButton(new ImageIcon(CommonFunctions.getImage("/images/deletecard.gif")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.setActionCommand("removeCard");
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Delete this card");
        jButton.addActionListener(this);
        customJToolBar.add(jButton);
        jButton = new JButton(new ImageIcon(CommonFunctions.getImage("/images/carddetails.gif")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.setActionCommand("showCardDetails");
        jButton.addActionListener(this);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Show statistics on this card");
        customJToolBar.add(jButton);
        this.insertHyperlinkButton = jButton = this.multimediaCoordinator.getInsertHyperlinkButton();
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Insert a hyperlink");
        customJToolBar.add(jButton);
        this.insertImageButton = jButton = this.multimediaCoordinator.getInsertImageButton();
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Insert an image (picture)");
        customJToolBar.add(jButton);
        this.insertSoundButton = jButton = this.multimediaCoordinator.getInsertSoundButton();
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Insert sound/audio");
        customJToolBar.add(jButton);
        return customJToolBar;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(this.buttonPanelLayout);
        jPanel.add((Component)this.createEditButtonPanel(), "Edit Buttons");
        jPanel.add((Component)this.createQuizButtonPanel(), "Quiz Buttons");
        return jPanel;
    }

    private JPanel createQuizButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JPanel());
        JButton jButton = new JButton(new ImageIcon(CommonFunctions.getImage("/images/correct.gif")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.setActionCommand("markAsCorrect");
        jButton.addActionListener(this);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Score yourself as RIGHT");
        jPanel2.add(jButton);
        jButton = new JButton("Flip");
        jButton.setMargin(new Insets(5, 10, 5, 10));
        jButton.setCursor(ACTION_CURSOR);
        jButton.setActionCommand("flipCard");
        jButton.addActionListener(this);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Flip to the other side of the card");
        jPanel2.add(jButton);
        jButton = new JButton(new ImageIcon(CommonFunctions.getImage("/images/incorrect.gif")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.setActionCommand("markAsIncorrect");
        jButton.addActionListener(this);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Score yourself as WRONG");
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "Center");
        jPanel2 = new JPanel();
        jButton = new JButton(new ImageIcon(CommonFunctions.getImage("/images/stop.gif")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.setActionCommand("stopQuiz");
        jButton.addActionListener(this);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, STOP_QUIZ_BUTTON_ROLLOVER);
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "East");
        jPanel2 = new JPanel();
        Box.Filler filler = new Box.Filler(jButton.getMinimumSize(), jButton.getPreferredSize(), jButton.getMaximumSize());
        jPanel2.add(filler);
        jPanel.add((Component)jPanel2, "West");
        return jPanel;
    }

    private JPanel createEditButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JPanel());
        JButton jButton = new JButton(new ImageIcon(CommonFunctions.getImage("/images/previous.gif")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.setActionCommand("previousCard");
        jButton.addActionListener(this);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Look at the previous card");
        jPanel2.add(jButton);
        jButton = new JButton("Flip");
        jButton.setMargin(new Insets(5, 10, 5, 10));
        jButton.setCursor(ACTION_CURSOR);
        jButton.setActionCommand("flipCard");
        jButton.addActionListener(this);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Flip to the other side of the card");
        jPanel2.add(jButton);
        jPanel2.add(jButton);
        jButton = new JButton(new ImageIcon(CommonFunctions.getImage("/images/next.gif")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(ACTION_CURSOR);
        jButton.setActionCommand("nextCard");
        jButton.addActionListener(this);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Look at the next card");
        jPanel2.add(jButton);
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "Center");
        jPanel2 = new JPanel();
        jButton = new JButton(new ImageIcon(CommonFunctions.getImage("/images/start.gif")));
        jButton.setCursor(ACTION_CURSOR);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setActionCommand("startQuiz");
        jButton.addActionListener(this);
        jButton.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jButton, "Quiz yourself");
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "East");
        jPanel2 = new JPanel();
        Box.Filler filler = new Box.Filler(jButton.getMinimumSize(), jButton.getPreferredSize(), jButton.getMaximumSize());
        jPanel2.add(filler);
        jPanel.add((Component)jPanel2, "West");
        return jPanel;
    }

    private void setupMenus(DeckHistory deckHistory) {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuBar, this.defaultStatusBarMessage);
        JMenu jMenu = new JMenu("File");
        jMenu.setCursor(ACTION_CURSOR);
        jMenu.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenu, this.defaultStatusBarMessage);
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("New", 78);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("newDeck");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Start a new deck of cards");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Open", 79);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("loadDeck");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Use an existing deck of cards");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Import", 73);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("importDeck");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Add (to this deck) cards or strategies from an existing deck");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Save", 83);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("saveDeck");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Save this deck of cards");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save As...", 65);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("saveDeckAs");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Save this deck of cards with a new filename");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Preferences", 80);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("setPreferences");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Customize QUIZZAM to fit your needs");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("1 ", 49);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("deckHistory1");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Open this flashcard deck");
        Font font = jMenuItem.getFont();
        font = new Font(font.getFontName(), 2, font.getSize());
        jMenuItem.setFont(font);
        jMenu.add(jMenuItem);
        this.deckHistoryMenuItem1 = jMenuItem;
        jMenuItem = new JMenuItem("2 ", 50);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("deckHistory2");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Open this flashcard deck");
        jMenuItem.setFont(font);
        jMenu.add(jMenuItem);
        this.deckHistoryMenuItem2 = jMenuItem;
        jMenuItem = new JMenuItem("3 ", 51);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("deckHistory3");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Open this flashcard deck");
        jMenuItem.setFont(font);
        jMenu.add(jMenuItem);
        this.deckHistoryMenuItem3 = jMenuItem;
        jMenuItem = new JMenuItem("4 ", 52);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("deckHistory4");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Open this flashcard deck");
        jMenuItem.setFont(font);
        jMenu.add(jMenuItem);
        this.deckHistoryMenuItem4 = jMenuItem;
        this.deckHistoryWasUpdated(deckHistory);
        jMenuItem = new JMenuItem("Exit", 88);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("quitProgram");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Quit this program");
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Card");
        jMenu.setCursor(ACTION_CURSOR);
        jMenu.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenu, this.defaultStatusBarMessage);
        jMenu.setMnemonic(67);
        jMenuItem = new JMenuItem("Create", 67);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("newCard");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Create a new flashcard");
        this.createMenuItem = jMenuItem;
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete", 68);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("removeCard");
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Delete the current flashcard");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Find", 70);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("findCard");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Find a specific card");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Stats", 83);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("showCardDetails");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Show statistics on this card");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Reset current card", 82);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("resetCurrentCard");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Reset statistics on the current card");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Reset entire deck", 69);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("resetEntireDeck");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Reset statistics on ALL cards in this deck");
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Quiz");
        jMenu.setCursor(ACTION_CURSOR);
        jMenu.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenu, this.defaultStatusBarMessage);
        jMenu.setMnemonic(81);
        jMenuItem = new JMenuItem("Start", 83);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("startQuiz");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Quiz yourself");
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.quizMenuItem = jMenuItem;
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Strategies", 84);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("showQuizOptions");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Customize your quiz strategies");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JCheckBoxMenuItem("Show Front Side First", true);
        this.showFrontFirstMenuItem = (JCheckBoxMenuItem)jMenuItem;
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setMnemonic(70);
        jMenuItem.setActionCommand("showFrontSideFirst");
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "During Quiz Mode, show the FRONT side of the card first");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Show Back Side First", false);
        this.showBackFirstMenuItem = (JCheckBoxMenuItem)jMenuItem;
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setMnemonic(66);
        jMenuItem.setActionCommand("showBackSideFirst");
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "During Quiz Mode, show the BACK side of the card first");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Custom", false);
        this.showRandomFirstMenuItem = (JCheckBoxMenuItem)jMenuItem;
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setMnemonic(66);
        jMenuItem.setActionCommand("showRandomSideFirst");
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "During Quiz Mode, decide randomly which side to show first");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Help");
        jMenu.setCursor(ACTION_CURSOR);
        jMenu.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenu, this.defaultStatusBarMessage);
        jMenu.setMnemonic(72);
        jMenuItem = new JMenuItem("About Quizzam", 65);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("about");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Show more information about this program");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Free License", 70);
        jMenuItem.setCursor(ACTION_CURSOR);
        jMenuItem.setActionCommand("licenseInfo");
        jMenuItem.addActionListener(this);
        jMenuItem.addMouseMotionListener(this.rolloverLabelHandler);
        this.rolloverLabelHandler.register((Object)jMenuItem, "Learn about the Free License");
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
    }

    public void deckHistoryWasUpdated(DeckHistory deckHistory) {
        if (this.preferencesManager.getProperties().getProperty(PreferencesManager.PARAM_STORE_DECK_HISTORY).trim().toUpperCase().equals("Y")) {
            boolean bl;
            String string = deckHistory.getDeck(1);
            String string2 = deckHistory.getDeck(2);
            String string3 = deckHistory.getDeck(3);
            String string4 = deckHistory.getDeck(4);
            boolean bl2 = bl = string == null || string.trim().length() == 0;
            if (!bl) {
                this.deckHistoryMenuItem1.setVisible(true);
                this.deckHistoryMenuItem1.setText("1 " + string);
                bl = string2 == null || string2.trim().length() == 0;
            } else {
                this.deckHistoryMenuItem1.setVisible(false);
            }
            if (!bl) {
                this.deckHistoryMenuItem2.setVisible(true);
                this.deckHistoryMenuItem2.setText("2 " + string2);
                bl = string3 == null || string3.trim().length() == 0;
            } else {
                this.deckHistoryMenuItem2.setVisible(false);
            }
            if (!bl) {
                this.deckHistoryMenuItem3.setVisible(true);
                this.deckHistoryMenuItem3.setText("3 " + string3);
                bl = string4 == null || string4.trim().length() == 0;
            } else {
                this.deckHistoryMenuItem3.setVisible(false);
            }
            if (!bl) {
                this.deckHistoryMenuItem4.setVisible(true);
                this.deckHistoryMenuItem4.setText("4 " + string4);
            } else {
                this.deckHistoryMenuItem4.setVisible(false);
            }
            String string5 = CommonFunctions.getFullPathName(PREFERENCES_FILENAME);
            if (this.preferencesManager.getProperties().getProperty(PreferencesManager.PARAM_STORE_DECK_HISTORY).trim().toUpperCase().equals("Y")) {
                try {
                    this.preferencesManager.storeDeckHistory(string5, deckHistory.getDeck(1), deckHistory.getDeck(2), deckHistory.getDeck(3), deckHistory.getDeck(4));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getClass().getName() + ": " + fileNotFoundException.getMessage());
                    JOptionPane.showMessageDialog(this, "The user preferences file, \"" + string5 + "\", does not exist and could not be created.", "Could not save Quizzam's window settings", 0);
                }
                catch (SecurityException securityException) {
                    System.err.println(securityException.getClass().getName() + ": " + securityException.getMessage());
                    JOptionPane.showMessageDialog(this, "The security manager has denied read/write access to the user preferences file \"" + string5 + "\".", "Could not save Quizzam's window settings", 0);
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getClass().getName() + ": " + iOException.getMessage());
                    JOptionPane.showMessageDialog(this, "An I/0 error has occurred while reading or writing the user preferences file \"" + string5 + "\".", "Could not save Quizzam's window settings", 0);
                }
            }
        } else {
            this.deckHistoryMenuItem1.setVisible(false);
            this.deckHistoryMenuItem2.setVisible(false);
            this.deckHistoryMenuItem3.setVisible(false);
            this.deckHistoryMenuItem4.setVisible(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.saveToCurrentCard();
        String string = actionEvent.getActionCommand();
        if (string.equals("about")) {
            this.aboutInfoScreen.show();
        } else if (string.equals("setPreferences")) {
            String string2;
            this.preferencesManager.show();
            int n = this.preferencesManager.getResult();
            boolean bl = false;
            if (n == PreferencesManager.RESULT_APPLY_ONLY) {
                JOptionPane.showMessageDialog(this, "Your new settings will NOT be used the next time you start QUIZZAM.", "Your changes have been applied, but not saved to disk.", 1);
                bl = this.preferencesManager.getProperties().getProperty(PreferencesManager.PARAM_STORE_DECK_HISTORY).trim().toUpperCase().equals("N");
            } else if (n == PreferencesManager.RESULT_APPLY_AND_SAVE) {
                string2 = CommonFunctions.getFullPathName(PREFERENCES_FILENAME);
                try {
                    bl = this.preferencesManager.getProperties().getProperty(PreferencesManager.PARAM_STORE_DECK_HISTORY).trim().toUpperCase().equals("N");
                    this.preferencesManager.store(string2);
                    JOptionPane.showMessageDialog(this, "Your new settings will be used the next time you start QUIZZAM.", "Your changes have been applied, and also saved to disk.", 1);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getClass().getName() + ": " + fileNotFoundException.getMessage());
                    JOptionPane.showMessageDialog(this, "The user preferences file, \"" + string2 + "\", does not exist and could not be created.", "Could not save preferences to disk", 1);
                }
                catch (SecurityException securityException) {
                    System.err.println(securityException.getClass().getName() + ": " + securityException.getMessage());
                    JOptionPane.showMessageDialog(this, "The security manager has denied \"write\" access to the user preferences file \"" + string2 + "\".", "Could not save preferences to disk", 1);
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getClass().getName() + ": " + iOException.getMessage());
                    JOptionPane.showMessageDialog(this, "An I/0 error has occurred while writing the user preferences file \"" + string2 + "\".", "Could not save preferences to disk", 1);
                }
            }
            if (bl) {
                this.deckHistory.clear();
                this.deckHistoryWasUpdated(this.deckHistory);
                string2 = CommonFunctions.getFullPathName(PREFERENCES_FILENAME);
                try {
                    this.preferencesManager.storeDeckHistory(string2, "", "", "", "");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getClass().getName() + ": " + fileNotFoundException.getMessage());
                    JOptionPane.showMessageDialog(this, "The user preferences file, \"" + string2 + "\", does not exist and could not be created.", "Could not save Quizzam's window settings", 0);
                }
                catch (SecurityException securityException) {
                    System.err.println(securityException.getClass().getName() + ": " + securityException.getMessage());
                    JOptionPane.showMessageDialog(this, "The security manager has denied read/write access to the user preferences file \"" + string2 + "\".", "Could not save Quizzam's window settings", 0);
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getClass().getName() + ": " + iOException.getMessage());
                    JOptionPane.showMessageDialog(this, "An I/0 error has occurred while reading or writing the user preferences file \"" + string2 + "\".", "Could not save Quizzam's window settings", 0);
                }
            }
        } else if (string.equals("licenseInfo")) {
            this.licenseInfoScreen.show();
        } else if (string.equals("showCardDetails")) {
            this.cardPropertiesScreen.show();
        } else if (string.equals("resetEntireDeck")) {
            JOptionPane.showMessageDialog(this, "Resetting statistics will NOT affect the order cards are shown to you during a quiz.", "Confirm Reset", 2);
            int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to reset statistics for EVERY card in the deck?", "Confirm Reset", 0, 3);
            if (n == 0) {
                int n2 = 0;
                while (n2 < this.deck.size()) {
                    this.deck.getCard(n2).resetStats();
                    ++n2;
                }
                JOptionPane.showMessageDialog(this, "Statistics have been reset for all cards in this deck.", "Reset Completed!", 1);
            }
        } else if (string.equals("resetCurrentCard")) {
            JOptionPane.showMessageDialog(this, "Resetting statistics will NOT affect the order cards are shown to you during a quiz.", "Confirm Reset", 2);
            int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to reset statistics on the currently displayed card?", "Confirm Reset", 0, 3);
            if (n == 0) {
                this.currentCard.resetStats();
                JOptionPane.showMessageDialog(this, "Statistics have been reset for the currently displayed card.", "Reset Completed!", 1);
            }
        } else if (string.equals("startQuiz")) {
            this.enterQuizMode();
            this.deckHasChanged = true;
        } else if (string.equals("stopQuiz")) {
            this.enterEditMode();
        } else if (string.equals("markAsCorrect")) {
            this.scoreCard(true);
            this.deckHasChanged = true;
        } else if (string.equals("markAsIncorrect")) {
            this.scoreCard(false);
            this.deckHasChanged = true;
        } else if (string.equals("nextCard")) {
            this.nextCard();
        } else if (string.equals("previousCard")) {
            this.previousCard();
        } else if (string.equals("flipCard")) {
            this.flipCard();
        } else if (string.equals("removeCard")) {
            this.removeCard();
            this.deckHasChanged = true;
        } else if (string.equals("saveDeck")) {
            this.saveDeck();
            this.deckHasChanged = false;
        } else if (string.equals("saveDeckAs")) {
            this.saveDeckAs();
            this.deckHasChanged = false;
        } else if (string.equals("showQuizOptions")) {
            this.strategyConfigScreen.setAggregateStrategy(this.deck.getStrategy());
            this.strategyConfigScreen.show();
            this.deckHasChanged = true;
        } else if (string.equals("importDeck")) {
            this.importDeck();
            this.deckHasChanged = true;
        } else if (string.equals("loadDeck")) {
            int n = 1;
            if (this.deckHasChanged) {
                n = JOptionPane.showConfirmDialog(this, "Would you like to save your current flashcards first?", "Load Deck", 1);
            }
            if (n == 0) {
                this.saveDeckAs();
                this.loadDeck();
                this.deckHasChanged = false;
            } else if (n == 1) {
                this.loadDeck();
                this.deckHasChanged = false;
            }
        } else if (string.equals("indexFieldSubmitted")) {
            this.updateCardIndexOnScreen(this.currentCardIndex, this.deck.size());
        } else if (string.equals("showFrontSideFirst")) {
            this.showWhichSideFirst = 0;
            this.showFrontFirstMenuItem.setState(true);
            this.showBackFirstMenuItem.setState(false);
            this.showRandomFirstMenuItem.setState(false);
            this.showRandomFirstMenuItem.setText("Custom");
        } else if (string.equals("showBackSideFirst")) {
            this.showWhichSideFirst = 1;
            this.showBackFirstMenuItem.setState(true);
            this.showFrontFirstMenuItem.setState(false);
            this.showRandomFirstMenuItem.setState(false);
            this.showRandomFirstMenuItem.setText("Custom");
        } else if (string.equals("showRandomSideFirst")) {
            boolean bl = false;
            boolean bl2 = false;
            while (!bl) {
                try {
                    String string3 = JOptionPane.showInputDialog(this, "What percentage of time should the Front side be shown first?", String.valueOf(this.showFrontSideFirstPercentWhenRandom).trim());
                    if (string3 == null) {
                        bl = true;
                        bl2 = true;
                        continue;
                    }
                    if (string3.endsWith("%")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    this.showFrontSideFirstPercentWhenRandom = Integer.parseInt(string3);
                    if (this.showFrontSideFirstPercentWhenRandom > 100) {
                        this.showFrontSideFirstPercentWhenRandom = 100;
                        JOptionPane.showMessageDialog(this, "Please enter a number less than 100", "Invalid entry", 0);
                        continue;
                    }
                    if (this.showFrontSideFirstPercentWhenRandom < 0) {
                        this.showFrontSideFirstPercentWhenRandom = 0;
                        JOptionPane.showMessageDialog(this, "Please enter a number greater than 0", "Invalid entry", 0);
                        continue;
                    }
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Please enter a number", "Invalid entry", 0);
                }
            }
            if (!bl2) {
                this.showWhichSideFirst = 2;
                this.showRandomFirstMenuItem.setText("Custom (" + this.showFrontSideFirstPercentWhenRandom + "% front)");
                this.showBackFirstMenuItem.setState(false);
                this.showFrontFirstMenuItem.setState(false);
                this.showRandomFirstMenuItem.setState(true);
            } else {
                this.showRandomFirstMenuItem.setState(false);
            }
        } else if (string.equals("newCard")) {
            this.newCard();
            this.deckHasChanged = true;
        } else if (string.equals("newDeck")) {
            int n = 1;
            if (this.deckHasChanged) {
                n = JOptionPane.showConfirmDialog(this, "Would you like to save your current flashcards first?", "New Deck", 1);
            }
            if (n == 0) {
                this.saveDeckAs();
                this.newDeck();
                this.deckHasChanged = false;
            } else if (n == 1) {
                this.newDeck();
                this.deckHasChanged = false;
            }
        } else if (string.equals("switchView")) {
            String string4;
            this.currentView = string4 = (String)this.viewSelector.getSelectedItem();
            if (string4.equals(VIEW_NORMAL)) {
                this.toggleViewSpecificButtons(true);
                this.setToHTMLMode();
                this.textPane.setEditable(true);
            } else if (string4.equals(VIEW_SOURCE)) {
                this.toggleViewSpecificButtons(false);
                this.textPane.setEditorKit(this.htmlSourceEditorKit);
                try {
                    this.refreshCardDisplay();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                this.textPane.setEditable(true);
            } else if (string4.equals(VIEW_PREVIEW)) {
                this.toggleViewSpecificButtons(true);
                this.setToHTMLMode();
                JOptionPane.showMessageDialog(this, "You are now using the \"Links & Sound Test\" view, which is useful for testing out hyperlinks.  However, you cannot add or erase text when using it.", "The \"Links & Sound Test\" view", 2);
                try {
                    this.refreshCardDisplay();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                this.textPane.setEditable(false);
            }
        } else if (string.equals("findCard")) {
            this.findCardDialog.show();
        } else if (string.equals("deckHistory1")) {
            String string5 = this.deckHistory.getDeck(1);
            if (string5 != null && string5.trim().length() > 0) {
                this.deckHistoryLoad(string5);
            }
        } else if (string.equals("deckHistory2")) {
            String string6 = this.deckHistory.getDeck(2);
            if (string6 != null && string6.trim().length() > 0) {
                this.deckHistoryLoad(string6);
            }
        } else if (string.equals("deckHistory3")) {
            String string7 = this.deckHistory.getDeck(3);
            if (string7 != null && string7.trim().length() > 0) {
                this.deckHistoryLoad(string7);
            }
        } else if (string.equals("deckHistory4")) {
            String string8 = this.deckHistory.getDeck(4);
            if (string8 != null && string8.trim().length() > 0) {
                this.deckHistoryLoad(string8);
            }
        } else if (string.equals("quitProgram")) {
            this.endProgram();
        }
        if (this.currentCard != null) {
            this.cardPropertiesScreen.setFlashcard(this.currentCard);
        }
    }

    public void refreshHTMLView() {
        this.saveToCurrentCard();
        this.setToHTMLMode();
    }

    private void setToHTMLMode() {
        this.normalEditorKit.setStyleSheet(this.styleSheet);
        this.textPane.setEditorKit(this.normalEditorKit);
        try {
            this.refreshCardDisplay();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void deckHistoryLoad(String string) {
        int n = 1;
        if (this.deckHasChanged) {
            n = JOptionPane.showConfirmDialog(this, "Would you like to save your current flashcards first?", "Load Deck", 1);
        }
        if (n == 0) {
            this.saveDeckAs();
            this.open(string);
            this.deckHasChanged = false;
        } else if (n == 1) {
            this.open(string);
            this.deckHasChanged = false;
        }
    }

    private void toggleViewSpecificButtons(boolean bl) {
        this.formatToolBar2.setVisible(bl);
        this.colorButton.setVisible(bl);
        this.colorLabel.setVisible(bl);
        this.insertHyperlinkButton.setVisible(bl);
        this.insertImageButton.setVisible(bl);
        this.insertSoundButton.setVisible(bl);
        this.viewSpacerLabel.setVisible(bl);
    }

    private void switchToNormalView() {
        this.viewSelector.setSelectedItem(VIEW_NORMAL);
    }

    private void removeCard() {
        if (0 == JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this card?", "Delete Card", 0)) {
            int n = this.currentCardIndex;
            int n2 = this.deck.size();
            if (n2 > 1) {
                if (this.inQuizMode) {
                    this.deck.removeCard(n);
                    this.showNextCardInQuiz();
                } else {
                    this.deck.removeCard(n);
                    if (this.currentCardIndex == n2 - 1) {
                        this.previousCard();
                    } else {
                        this.currentCard = this.deck.getCard(this.currentCardIndex);
                        this.updateCardIndexOnScreen(this.currentCardIndex, this.deck.size());
                        try {
                            this.displayCard(this.currentCard, true);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            JOptionPane.showMessageDialog(this, "An error occurred while trying to display the current card on the screen.", "Error", 0);
                        }
                    }
                    this.updateCardIndexOnScreen(this.currentCardIndex, this.deck.size());
                }
            } else {
                this.deck.removeCard(0);
                this.newCard();
            }
        }
        this.deckHasChanged = true;
    }

    private void setTemporaryStatusBarMessage(String string, int n) {
        this.statusBarLabel.setText(string);
        this.rolloverLabelHandler.setEnabled(false);
        ++this.outstandingTimers;
        new SimpleTimer(this, n).start();
    }

    private void enterQuizMode() {
        if (this.currentView.equals(VIEW_SOURCE)) {
            this.switchToNormalView();
        }
        this.multimediaCoordinator.hideAllDialogs();
        this.inQuizMode = true;
        this.buttonPanelLayout.show(this.buttonPanel, "Quiz Buttons");
        this.cardIndexPanelLayout.show(this.cardIndexPanel, "Quiz Message");
        this.newCardButton.setVisible(false);
        this.insertImageButton.setVisible(false);
        this.insertHyperlinkButton.setVisible(false);
        this.insertSoundButton.setVisible(false);
        this.formatToolBar1.setVisible(false);
        this.formatToolBar2.setVisible(false);
        this.defaultStatusBarMessage.setString("Quiz Mode");
        this.textPane.setEditable(false);
        this.quizMenuItem.setText("Stop Quiz");
        this.quizMenuItem.setActionCommand("stopQuiz");
        this.rolloverLabelHandler.register((Object)this.quizMenuItem, STOP_QUIZ_BUTTON_ROLLOVER);
        this.createMenuItem.setEnabled(false);
        this.deckHasChanged = true;
        this.statusBarLabel.setText(STOP_QUIZ_BUTTON_ROLLOVER);
        this.showNextCardInQuiz();
    }

    private void enterEditMode() {
        this.inQuizMode = false;
        this.buttonPanelLayout.show(this.buttonPanel, "Edit Buttons");
        this.cardIndexPanelLayout.show(this.cardIndexPanel, "Card Index");
        this.newCardButton.setVisible(true);
        this.insertImageButton.setVisible(true);
        this.insertHyperlinkButton.setVisible(true);
        this.insertSoundButton.setVisible(true);
        this.formatToolBar1.setVisible(true);
        this.formatToolBar2.setVisible(true);
        this.defaultStatusBarMessage.setString("Edit Mode");
        if (this.currentView.equals(VIEW_PREVIEW)) {
            JOptionPane.showMessageDialog(this, "Reminder:  your view is currently set to \"Links & Sound Test\".  You cannot add or erase text when using this view.", "The \"Links & Sound Test\" view", 2);
        } else {
            this.textPane.setEditable(true);
        }
        this.quizMenuItem.setText("Start Quiz");
        this.quizMenuItem.setActionCommand("startQuiz");
        this.rolloverLabelHandler.register((Object)this.quizMenuItem, START_QUIZ_BUTTON_ROLLOVER);
        this.createMenuItem.setEnabled(true);
        this.statusBarLabel.setText(START_QUIZ_BUTTON_ROLLOVER);
    }

    private String getFileOperationSuccessMessage(String string, int n, int n2) {
        String string2 = null;
        string2 = n == 1 ? "card" : "cards";
        String string3 = null;
        string3 = n2 == 1 ? "strategy" : "strategies";
        return string + " " + n + " " + string2 + " and " + n2 + " " + string3 + ".";
    }

    public void timeExpired() {
        --this.outstandingTimers;
        if (this.outstandingTimers == 0) {
            this.rolloverLabelHandler.setEnabled(true);
        }
    }

    private void nextCard() {
        this.currentCardIndex = this.currentCardIndex >= this.deck.size() - 1 ? 0 : ++this.currentCardIndex;
        this.currentCard = this.deck.getCard(this.currentCardIndex);
        this.updateCardIndexOnScreen(this.currentCardIndex, this.deck.size());
        try {
            this.displayCard(this.currentCard, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, "An error occurred while trying to display the current card on the screen.", "Error", 0);
        }
    }

    private void previousCard() {
        this.currentCardIndex = this.currentCardIndex <= 0 ? this.deck.size() - 1 : --this.currentCardIndex;
        this.currentCard = this.deck.getCard(this.currentCardIndex);
        this.updateCardIndexOnScreen(this.currentCardIndex, this.deck.size());
        try {
            this.displayCard(this.currentCard, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, "An error occurred while trying to display the current card on the screen.", "Error", 0);
        }
    }

    private void loadDeck() {
        this.fileChooser.resetChoosableFileFilters();
        this.fileChooser.setFileFilter(this.fileFilter);
        int n = this.fileChooser.showOpenDialog(this);
        if (n != 1) {
            if (n == 0) {
                String string = this.fileChooser.getSelectedFile().getAbsolutePath();
                this.open(string);
            } else if (n == -1) {
                // empty if block
            }
        }
    }

    private String addDeckToHistory(String string) {
        if (this.preferencesManager.getProperties().getProperty(PreferencesManager.PARAM_STORE_DECK_HISTORY).trim().toUpperCase().equals("Y")) {
            try {
                return this.deckHistory.addDeck(string);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), "Could not add deck to the history log", 0);
                return null;
            }
        }
        return null;
    }

    public void open(String string) {
        try {
            this.deck = this.flashcardEngine.loadDeck(string);
            string = this.addDeckToHistory(string);
            CardIndexFieldDocument cardIndexFieldDocument = new CardIndexFieldDocument(this.deck);
            cardIndexFieldDocument.addDocumentListener(this);
            this.currentCardIndexField.setDocument(cardIndexFieldDocument);
            this.fileChooser.setCurrentDirectory(new File(string));
            this.currentFileName = string;
            this.currentCardIndex = this.deck.getStartingIndex();
            this.currentCard = this.deck.getCard(this.currentCardIndex);
            try {
                this.displayCard(this.currentCard, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this, "An error occurred while trying to display the current card on the screen.", "Error", 0);
            }
            this.updateCardIndexOnScreen(this.currentCardIndex, this.deck.size());
            AggregateStrategy aggregateStrategy = this.deck.getStrategy();
            this.enterEditMode();
            this.setTemporaryStatusBarMessage(this.getFileOperationSuccessMessage("Loaded", this.deck.size(), aggregateStrategy.getNumStrategies()), 3000);
            this.deckHasChanged = false;
            this.setTitle("Quizzam 3.1 (" + string + ")");
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException.getMessage(), "Could not load file", 0);
        }
    }

    private void importDeck() {
        this.fileChooser.resetChoosableFileFilters();
        this.fileChooser.setFileFilter(this.fileFilter);
        int n = this.fileChooser.showDialog(this, "Import");
        if (n != 1) {
            if (n == 0) {
                try {
                    String string = this.fileChooser.getSelectedFile().getAbsolutePath();
                    FlashcardDeck flashcardDeck = this.flashcardEngine.loadDeck(string);
                    boolean bl = false;
                    boolean bl2 = false;
                    int n2 = flashcardDeck.size();
                    int n3 = flashcardDeck.getStrategy().getNumStrategies();
                    this.importScreen.setNumCards(n2);
                    this.importScreen.setNumStrategies(n3);
                    this.importScreen.show();
                    int n4 = this.importScreen.getResult();
                    if (n4 == 1) {
                        bl = true;
                        n3 = 0;
                    } else if (n4 == 2) {
                        bl2 = true;
                        n2 = 0;
                    } else if (n4 == 3) {
                        bl2 = true;
                        bl = true;
                    } else if (n4 == 4) {
                        n2 = 0;
                        n3 = 0;
                    }
                    if (bl2 || bl) {
                        Object object;
                        if (bl2) {
                            object = this.deck.getStrategy();
                            AggregateStrategy aggregateStrategy = flashcardDeck.getStrategy();
                            QuizStrategy[] quizStrategyArray = aggregateStrategy.getStrategies();
                            int n5 = 0;
                            while (n5 < quizStrategyArray.length) {
                                int n6 = aggregateStrategy.getWeight(quizStrategyArray[n5]);
                                aggregateStrategy.removeStrategy(quizStrategyArray[n5]);
                                object.addStrategy(quizStrategyArray[n5], n6);
                                ++n5;
                            }
                        }
                        if (bl) {
                            while (flashcardDeck.size() > 0) {
                                object = flashcardDeck.removeCard(0);
                                object.resetStats();
                                this.deck.addCard((Flashcard)object);
                            }
                        }
                        this.updateCardIndexOnScreen(this.currentCardIndex, this.deck.size());
                        this.setTemporaryStatusBarMessage(this.getFileOperationSuccessMessage("Imported", n2, n3), 3000);
                        this.deckHasChanged = true;
                    }
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, iOException.getMessage(), "Could not import", 0);
                }
            } else if (n == -1) {
                // empty if block
            }
        }
    }

    private void newDeck() {
        this.enterEditMode();
        this.currentFileName = "";
        this.setTitle(TITLE);
        this.deck = this.flashcardEngine.createDeck();
        CardIndexFieldDocument cardIndexFieldDocument = new CardIndexFieldDocument(this.deck);
        cardIndexFieldDocument.addDocumentListener(this);
        this.currentCardIndexField.setDocument(cardIndexFieldDocument);
        this.newCard();
        AggregateStrategy aggregateStrategy = this.deck.getStrategy();
        this.setTemporaryStatusBarMessage(this.getFileOperationSuccessMessage("New deck created with", this.deck.size(), aggregateStrategy.getNumStrategies()), 3000);
        this.deckHasChanged = false;
    }

    private void newCard() {
        this.switchToNormalView();
        this.currentCard = this.flashcardEngine.createCard();
        this.deck.addCard(this.currentCard);
        try {
            this.displayCard(this.currentCard, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, "An error occurred while trying to display the current card on the screen.", "Error", 0);
        }
        this.currentCardIndex = this.deck.getIndex(this.currentCard);
        this.updateCardIndexOnScreen(this.currentCardIndex, this.deck.size());
        String string = "Enter your flashcard text here.";
        String string2 = new String(string + "&nbsp;");
        this.textPane.setText(string2);
        Properties properties = this.preferencesManager.getProperties();
        boolean bl = properties.getProperty(PreferencesManager.PARAM_APPLY_DEFAULT_FONT).trim().toUpperCase().equals("Y");
        this.saveToCurrentCard();
        this.requestFocus();
        this.textPane.grabFocus();
        this.textPane.setCaretPosition(0);
        this.textPane.moveCaretPosition(33);
        if (bl) {
            JComboBox jComboBox = this.textFormatCoordinator.getFontObject();
            JComboBox jComboBox2 = this.textFormatCoordinator.getSizeObject();
            String string3 = properties.getProperty(PreferencesManager.PARAM_DEFAULT_FONT);
            String string4 = properties.getProperty(PreferencesManager.PARAM_DEFAULT_FONT_SIZE);
            String string5 = properties.getProperty(PreferencesManager.PARAM_DEFAULT_FONT_COLOR);
            jComboBox.setSelectedItem(string3);
            jComboBox2.setSelectedItem(string4);
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
                this.textFormatCoordinator.setTextColor(new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken())));
                this.colorButton.repaint();
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.saveToCurrentCard();
            this.textPane.setCaretPosition(0);
            this.textPane.moveCaretPosition(32);
            this.currentCard.setBack(Pattern.compile(string, 32).matcher(this.currentCard.getFront()).replaceAll("&nbsp;&nbsp;"));
        }
        this.deckHasChanged = true;
    }

    private void saveToCurrentCard() {
        if (this.currentCard != null) {
            String string = this.textPane.getText();
            if (!this.currentView.equals(VIEW_SOURCE)) {
                string = CommonFunctions.compressHTML(string, true);
            }
            if (this.frontShowing) {
                this.currentCard.setFront(string);
            } else {
                this.currentCard.setBack(string);
            }
        }
    }

    private void updateCardIndexOnScreen(int n, int n2) {
        this.currentCardIndexField.setText(String.valueOf(n + 1));
        this.totalCardsLabel.setText(String.valueOf(n2));
    }

    private void displayCard(Flashcard flashcard, boolean bl) throws IllegalArgumentException {
        this.displayCard(flashcard, bl, false);
    }

    private void displayCard(Flashcard flashcard, boolean bl, boolean bl2) throws IllegalArgumentException {
        if (flashcard == null) {
            throw new IllegalArgumentException("Cannot accept NULL as a parameter");
        }
        this.frontShowing = bl;
        if (this.frontShowing) {
            if (!this.currentView.equals(VIEW_SOURCE)) {
                flashcard.setFront(CommonFunctions.compressHTML(flashcard.getFront(), false));
            }
            this.frontOrBackLabel.setText("FRONT");
            this.textPane.setText(flashcard.getFront());
            this.frontBackStatusBarMessage.setString("The FRONT side of the card is currently being shown");
        } else {
            if (!this.currentView.equals(VIEW_SOURCE)) {
                flashcard.setBack(CommonFunctions.compressHTML(flashcard.getBack(), false));
            }
            this.frontOrBackLabel.setText("BACK");
            this.textPane.setText(flashcard.getBack());
            this.frontBackStatusBarMessage.setString("The BACK side of the card is currently being shown");
        }
        this.frontOrBackBoxFiller.changeShape(this.frontOrBackLabel.getMinimumSize(), this.frontOrBackLabel.getPreferredSize(), this.frontOrBackLabel.getMaximumSize());
        if (bl2) {
            this.textPane.grabFocus();
        }
        this.textPane.setCaretPosition(1);
    }

    private void flipCard() throws IllegalArgumentException {
        try {
            this.displayCard(this.currentCard, !this.frontShowing, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, "An error occurred while trying to display the current card on the screen.", "Error", 0);
        }
    }

    private void refreshCardDisplay() throws IllegalArgumentException {
        this.displayCard(this.currentCard, this.frontShowing);
    }

    private void showNextCardInQuiz() {
        boolean bl = this.showWhichSideFirst == 0 ? true : (this.showWhichSideFirst == 1 ? false : this.randomNumberGenerator.nextInt(100) < this.showFrontSideFirstPercentWhenRandom);
        this.frontShownFirstOnCurrentCardInQuiz = bl;
        this.currentCard = this.deck.getNextCardInQuiz(bl);
        this.currentCardIndex = this.deck.getIndex(this.currentCard);
        this.updateCardIndexOnScreen(this.currentCardIndex, this.deck.size());
        try {
            this.displayCard(this.currentCard, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, "An error occurred while trying to display the current card on the screen.", "Error", 0);
        }
    }

    private void scoreCard(boolean bl) {
        if (bl) {
            this.currentCard.markRight(this.frontShownFirstOnCurrentCardInQuiz);
        } else {
            this.currentCard.markWrong(this.frontShownFirstOnCurrentCardInQuiz);
        }
        this.showNextCardInQuiz();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.indexChanged();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.indexChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.indexChanged();
    }

    private void indexChanged() {
        try {
            this.currentCardIndex = Integer.parseInt(this.currentCardIndexField.getText()) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.currentCard = this.deck.getCard(this.currentCardIndex);
        try {
            this.displayCard(this.currentCard, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, "An error occurred while trying to display the current card on the screen.", "Error", 0);
        }
        if (this.currentCard != null) {
            this.cardPropertiesScreen.setFlashcard(this.currentCard);
        }
    }

    private void saveDeck() {
        String string = this.currentFileName;
        if (string == null || string.trim().equals("")) {
            this.saveDeckAs();
        } else {
            try {
                this.deck.setStartingIndex(this.currentCardIndex);
                this.deck.save(string);
                string = this.addDeckToHistory(string);
                AggregateStrategy aggregateStrategy = this.deck.getStrategy();
                this.setTemporaryStatusBarMessage(this.getFileOperationSuccessMessage("Saved", this.deck.size(), aggregateStrategy.getNumStrategies()), 3000);
                this.deckHasChanged = false;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), "Could not save", 0);
            }
        }
    }

    private void saveDeckAs() {
        boolean bl = false;
        while (!bl) {
            bl = true;
            this.fileChooser.resetChoosableFileFilters();
            this.fileChooser.setFileFilter(this.fileFilter);
            int n = this.fileChooser.showSaveDialog(this);
            if (n == 1) continue;
            if (n == 0) {
                File file = this.fileChooser.getSelectedFile();
                String string = file.getAbsolutePath();
                FileFilter fileFilter = this.fileChooser.getFileFilter();
                if (fileFilter == this.fileFilter && !this.fileFilter.accept(file)) {
                    string = string + this.APP_FILE_EXTENSION;
                }
                if (new File(string).exists()) {
                    n = JOptionPane.showConfirmDialog(this, "The specified file (" + string + ") already exists.  Would you like to overwrite it?", "File Already Exists", 0);
                    boolean bl2 = bl = n == 0;
                }
                if (!bl) continue;
                try {
                    this.deck.setStartingIndex(this.currentCardIndex);
                    this.deck.save(string);
                    String string2 = this.currentFileName = string;
                    string2 = this.addDeckToHistory(string2);
                    if (string2 != null && !string2.trim().equals("")) {
                        this.setTitle("Quizzam 3.1 (" + string2 + ")");
                        AggregateStrategy aggregateStrategy = this.deck.getStrategy();
                        this.setTemporaryStatusBarMessage(this.getFileOperationSuccessMessage("Saved", this.deck.size(), aggregateStrategy.getNumStrategies()), 3000);
                    } else {
                        this.setTitle(TITLE);
                    }
                    this.deckHasChanged = false;
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, iOException.getMessage(), "Could not save", 0);
                }
                continue;
            }
            if (n != -1) continue;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.deckHasChanged = true;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.currentCardIndexField && !focusEvent.isTemporary()) {
            this.updateCardIndexOnScreen(this.currentCardIndex, this.deck.size());
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.endProgram();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.endProgram();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private void endProgram() {
        int n = 1;
        if (this.deckHasChanged) {
            n = JOptionPane.showConfirmDialog(this, "Would you like to save your current flashcards first?", "Quit Program", 1);
        }
        if (n != 2) {
            if (n == 0) {
                this.saveDeckAs();
            }
            Properties properties = this.preferencesManager.getProperties();
            boolean bl = properties.getProperty(PreferencesManager.PARAM_SAVE_WINDOW_SIZE_ON_EXIT).trim().toUpperCase().equals("Y");
            boolean bl2 = properties.getProperty(PreferencesManager.PARAM_SAVE_WINDOW_POSITION_ON_EXIT).trim().toUpperCase().equals("Y");
            String string = CommonFunctions.getFullPathName(PREFERENCES_FILENAME);
            try {
                if (bl && bl2) {
                    this.preferencesManager.storeWindowSizeAndPosition(string, this.getX(), this.getY(), this.getHeight(), this.getWidth());
                } else if (bl) {
                    this.preferencesManager.storeWindowSize(string, this.getHeight(), this.getWidth());
                } else if (bl2) {
                    this.preferencesManager.storeWindowPosition(string, this.getX(), this.getY());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.getClass().getName() + ": " + fileNotFoundException.getMessage());
                JOptionPane.showMessageDialog(this, "The user preferences file, \"" + string + "\", does not exist and could not be created.", "Could not save Quizzam's window settings", 0);
            }
            catch (SecurityException securityException) {
                System.err.println(securityException.getClass().getName() + ": " + securityException.getMessage());
                JOptionPane.showMessageDialog(this, "The security manager has denied read/write access to the user preferences file \"" + string + "\".", "Could not save Quizzam's window settings", 0);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getClass().getName() + ": " + iOException.getMessage());
                JOptionPane.showMessageDialog(this, "An I/0 error has occurred while reading or writing the user preferences file \"" + string + "\".", "Could not save Quizzam's window settings", 0);
            }
            System.exit(0);
        }
    }

    public boolean findNext(String string, int n) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("This method cannot accept NULL for the search string");
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("An invalid flashcard side was specified");
        }
        return this.findCard(string, n, "next");
    }

    public boolean findPrevious(String string, int n) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("This method cannot accept NULL for the search string");
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("An invalid flashcard side was specified");
        }
        return this.findCard(string, n, "previous");
    }

    private boolean findCard(String string, int n, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("This method cannot accept NULL for the search string");
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("An invalid flashcard side was specified");
        }
        if (!string2.equals("next") && !string2.equals("previous")) {
            throw new IllegalArgumentException("An invalid direction was specified");
        }
        int n2 = this.currentCardIndex;
        int n3 = this.frontShowing ? 0 : 1;
        boolean bl = false;
        int n4 = n2;
        int n5 = n3;
        do {
            if (string2.equals("next")) {
                if (n5 == 1) {
                    n5 = 0;
                    n4 = n4 >= this.deck.size() - 1 ? 0 : ++n4;
                } else {
                    n5 = 1;
                }
            } else if (n5 == 0) {
                n5 = 1;
                n4 = n4 <= 0 ? this.deck.size() - 1 : --n4;
            } else {
                n5 = 0;
            }
            if (n != 2 && n != n5) continue;
            bl = this.doesCardContain(string, n5, this.deck.getCard(n4));
        } while (!bl && (n4 != n2 || n5 != n3));
        if (bl) {
            this.currentCardIndexField.setText(String.valueOf(n4 + 1));
            if (n5 == 0) {
                this.displayCard(this.currentCard, true);
            } else {
                this.displayCard(this.currentCard, false);
            }
        }
        return bl;
    }

    private boolean doesCardContain(String string, int n, Flashcard flashcard) {
        if (flashcard == null) {
            throw new IllegalArgumentException("This method cannot accept NULL for the flashcard parameter");
        }
        if (string == null) {
            throw new IllegalArgumentException("This method cannot accept NULL for the search string");
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("An invalid flashcard side was specified");
        }
        string = Pattern.compile("<", 32).matcher(string).replaceAll("&lt;");
        string = Pattern.compile(">", 32).matcher(string).replaceAll("&gt;").toUpperCase();
        String string2 = n == 0 ? flashcard.getFront() : flashcard.getBack();
        StringBuffer stringBuffer = new StringBuffer(string2.toUpperCase());
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            char c = stringBuffer.charAt(n2);
            if (c == '<') {
                bl = true;
            } else if (c == '>') {
                bl = false;
            }
            if (!bl) {
                stringBuffer2.append(c);
            }
            ++n2;
        }
        string2 = stringBuffer2.toString();
        return string2.indexOf(string) != -1;
    }
}

