/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.ColorIcon;
import com.quizzam.application.basic.SelectExternalBrowserDialog;
import com.quizzam.application.basic.SelfPositioningDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PreferencesManager
extends SelfPositioningDialog
implements ActionListener {
    private String appName;
    private String version;
    private String release;
    private String[] fonts;
    private String[] fontSizes;
    private Properties defaultProperties;
    private Properties properties;
    private Box box;
    private JCheckBox saveWindowSizeOnExit = null;
    private JCheckBox saveWindowPositionOnExit = null;
    private JCheckBox startWithDefaultWindowSizeAndPosition = null;
    private JCheckBox useExternalInternetBrowser = null;
    private JCheckBox useCustomTextFormattingOnNewCards = null;
    private JTextField externalBrowserPath = null;
    private JButton browserPathBrowseButton = null;
    private JCheckBox applyCustomFontToNewCards;
    private JComboBox defaultFontCombo = null;
    private JComboBox defaultFontSizeCombo = null;
    private JCheckBox storeDeckHistory;
    private SelectExternalBrowserDialog selectExternalBrowserDialog = null;
    private JFileChooser fileChooser = null;
    private JLabel externalBrowserLabel = null;
    private ColorIcon colorIcon = new ColorIcon(Color.BLACK, 34, 19);
    private JButton colorButton = new JButton(this.colorIcon);
    protected static final int WIDTH = 525;
    protected static final int HEIGHT = 250;
    private Color textColor;
    private Cursor actionCursor;
    private int lastResult = RESULT_CANCEL;
    private static String DEFAULT_SAVE_WINDOW_SIZE_ON_EXIT = "N";
    private static String DEFAULT_SAVE_WINDOW_POSITION_ON_EXIT = "N";
    private static String DEFAULT_START_WITH_DEFAULT_WINDOW_SIZE_AND_POSITION = "Y";
    private static String DEFAULT_USE_EXTERNAL_INTERNET_BROWSER = "N";
    private static String DEFAULT_HAS_EXTERNAL_BROWSER_QUESTION_BEEN_ASKED = "N";
    private static String DEFAULT_EXTERNAL_BROWSER_PATH = "C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE";
    private static String DEFAULT_APPLY_DEFAULT_FONT = "N";
    private static String DEFAULT_DEFAULT_FONT = "Arial";
    private static String DEFAULT_DEFAULT_FONT_SIZE = "12";
    private static String DEFAULT_DEFAULT_FONT_COLOR = "0,0,0";
    private static String DEFAULT_STORE_DECK_HISTORY = "Y";
    private static String DEFAULT_DECK_HISTORY_1 = " ";
    private static String DEFAULT_DECK_HISTORY_2 = " ";
    private static String DEFAULT_DECK_HISTORY_3 = " ";
    private static String DEFAULT_DECK_HISTORY_4 = " ";
    public static int RESULT_APPLY_ONLY = 0;
    public static int RESULT_APPLY_AND_SAVE = 1;
    public static int RESULT_CANCEL = 2;
    public static String PARAM_SAVE_WINDOW_SIZE_ON_EXIT = "saveWindowSizeOnExit";
    public static String PARAM_SAVE_WINDOW_POSITION_ON_EXIT = "saveWindowPositionOnExit";
    public static String PARAM_START_WITH_DEFAULT_WINDOW_SIZE_AND_POSITION = "startWithDefaultWindowSizeAndPosition";
    public static String PARAM_USE_EXTERNAL_INTERNET_BROWSER = "useExternalInternetBrowser";
    public static String PARAM_HAS_EXTERNAL_BROWSER_QUESTION_BEEN_ASKED = "N";
    public static String PARAM_EXTERNAL_BROWSER_PATH = "externalBrowserPath";
    public static String PARAM_WINDOW_X = "windowX";
    public static String PARAM_WINDOW_Y = "windowY";
    public static String PARAM_WINDOW_HEIGHT = "windowHeight";
    public static String PARAM_WINDOW_WIDTH = "windowWidth";
    public static String PARAM_APPLY_DEFAULT_FONT = "applyNewCardFont";
    public static String PARAM_DEFAULT_FONT = "newCardFont";
    public static String PARAM_DEFAULT_FONT_SIZE = "newCardFontSize";
    public static String PARAM_DEFAULT_FONT_COLOR = "newCardFontColor";
    public static String PARAM_STORE_DECK_HISTORY = "storeDeckHistory";
    public static String PARAM_DECK_HISTORY_1 = "historicDeck1";
    public static String PARAM_DECK_HISTORY_2 = "historicDeck2";
    public static String PARAM_DECK_HISTORY_3 = "historicDeck3";
    public static String PARAM_DECK_HISTORY_4 = "historicDeck4";

    public PreferencesManager(Frame frame, String string, boolean bl, Color color, Cursor cursor, JFileChooser jFileChooser, String string2, String string3, String string4, String[] stringArray, String[] stringArray2) throws IllegalArgumentException {
        super(frame, string, bl);
        if (frame == null || string == null || color == null || cursor == null || jFileChooser == null || string2 == null || string3 == null || string4 == null || stringArray == null || stringArray2 == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(color, cursor, jFileChooser, string2, string3, string4, frame, stringArray, stringArray2);
    }

    public PreferencesManager(Dialog dialog, String string, boolean bl, Color color, Cursor cursor, JFileChooser jFileChooser, String string2, String string3, String string4, String[] stringArray) throws IllegalArgumentException {
        super(dialog, string, bl);
        if (dialog == null || string == null || color == null || cursor == null || jFileChooser == null || string2 == null || string3 == null || string4 == null || stringArray == null || this.fontSizes == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(color, cursor, jFileChooser, string2, string3, string4, dialog, stringArray, this.fontSizes);
    }

    private void initialize(Color color, Cursor cursor, JFileChooser jFileChooser, String string, String string2, String string3, Window window, String[] stringArray, String[] stringArray2) {
        this.textColor = color;
        this.actionCursor = cursor;
        this.fileChooser = jFileChooser;
        this.appName = string;
        this.version = string2;
        this.release = string3;
        this.fonts = stringArray;
        this.fontSizes = stringArray2;
        if (window instanceof Dialog) {
            this.selectExternalBrowserDialog = new SelectExternalBrowserDialog((Dialog)window, "Select External Browser", true, color, cursor, jFileChooser);
        } else if (window instanceof Frame) {
            this.selectExternalBrowserDialog = new SelectExternalBrowserDialog((Frame)window, "Select External Browser", true, color, cursor, jFileChooser);
        }
        this.defaultProperties = new Properties();
        this.defaultProperties.setProperty(PARAM_SAVE_WINDOW_SIZE_ON_EXIT, DEFAULT_SAVE_WINDOW_SIZE_ON_EXIT);
        this.defaultProperties.setProperty(PARAM_SAVE_WINDOW_POSITION_ON_EXIT, DEFAULT_SAVE_WINDOW_POSITION_ON_EXIT);
        this.defaultProperties.setProperty(PARAM_START_WITH_DEFAULT_WINDOW_SIZE_AND_POSITION, DEFAULT_START_WITH_DEFAULT_WINDOW_SIZE_AND_POSITION);
        this.defaultProperties.setProperty(PARAM_USE_EXTERNAL_INTERNET_BROWSER, DEFAULT_USE_EXTERNAL_INTERNET_BROWSER);
        this.defaultProperties.setProperty(PARAM_HAS_EXTERNAL_BROWSER_QUESTION_BEEN_ASKED, DEFAULT_HAS_EXTERNAL_BROWSER_QUESTION_BEEN_ASKED);
        this.defaultProperties.setProperty(PARAM_EXTERNAL_BROWSER_PATH, DEFAULT_EXTERNAL_BROWSER_PATH);
        this.defaultProperties.setProperty(PARAM_APPLY_DEFAULT_FONT, DEFAULT_APPLY_DEFAULT_FONT);
        this.defaultProperties.setProperty(PARAM_DEFAULT_FONT, DEFAULT_DEFAULT_FONT);
        this.defaultProperties.setProperty(PARAM_DEFAULT_FONT_SIZE, DEFAULT_DEFAULT_FONT_SIZE);
        this.defaultProperties.setProperty(PARAM_DEFAULT_FONT_COLOR, DEFAULT_DEFAULT_FONT_COLOR);
        this.defaultProperties.setProperty(PARAM_STORE_DECK_HISTORY, DEFAULT_STORE_DECK_HISTORY);
        this.properties = new Properties(this.defaultProperties);
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.getContentPane().add((Component)this.getContentPanel(), "North");
        this.setSize(525, 250);
        this.setResizable(false);
    }

    public int getResult() {
        return this.lastResult;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Apply");
        jButton.setActionCommand("apply");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Cancel");
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Use Default Settings");
        jButton.setActionCommand("restoreDefaults");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        return jPanel;
    }

    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    public void setToDefault() {
        String string = this.properties.getProperty(PARAM_HAS_EXTERNAL_BROWSER_QUESTION_BEEN_ASKED);
        this.properties.clear();
        this.properties.setProperty(PARAM_HAS_EXTERNAL_BROWSER_QUESTION_BEEN_ASKED, string);
        this.updateUI(this.properties);
    }

    private void updateUI(Properties properties) {
        this.saveWindowSizeOnExit.setSelected(properties.getProperty(PARAM_SAVE_WINDOW_SIZE_ON_EXIT).toUpperCase().equals("Y"));
        this.saveWindowPositionOnExit.setSelected(properties.getProperty(PARAM_SAVE_WINDOW_POSITION_ON_EXIT).toUpperCase().equals("Y"));
        this.startWithDefaultWindowSizeAndPosition.setSelected(properties.getProperty(PARAM_START_WITH_DEFAULT_WINDOW_SIZE_AND_POSITION).toUpperCase().equals("Y"));
        this.useExternalInternetBrowser.setSelected(properties.getProperty(PARAM_USE_EXTERNAL_INTERNET_BROWSER).toUpperCase().equals("Y"));
        this.externalBrowserPath.setText(properties.getProperty(PARAM_EXTERNAL_BROWSER_PATH));
        this.setEnabledExternalBrowserFields(this.useExternalInternetBrowser.isSelected());
        this.applyCustomFontToNewCards.setSelected(properties.getProperty(PARAM_APPLY_DEFAULT_FONT).toUpperCase().equals("Y"));
        this.defaultFontCombo.setSelectedItem(properties.getProperty(PARAM_DEFAULT_FONT));
        this.defaultFontSizeCombo.setSelectedItem(properties.getProperty(PARAM_DEFAULT_FONT_SIZE));
        this.setEnabledCustomFontFields(this.applyCustomFontToNewCards.isSelected());
        try {
            String string = properties.getProperty(PARAM_DEFAULT_FONT_COLOR);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            this.colorIcon.setColor(new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken())));
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.storeDeckHistory.setSelected(properties.getProperty(PARAM_STORE_DECK_HISTORY).toUpperCase().equals("Y"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        String string = actionEvent.getActionCommand();
        if (string.equals("apply")) {
            if (this.saveWindowSizeOnExit.isSelected()) {
                this.properties.setProperty(PARAM_SAVE_WINDOW_SIZE_ON_EXIT, "Y");
            } else {
                this.properties.setProperty(PARAM_SAVE_WINDOW_SIZE_ON_EXIT, "N");
            }
            if (this.saveWindowPositionOnExit.isSelected()) {
                this.properties.setProperty(PARAM_SAVE_WINDOW_POSITION_ON_EXIT, "Y");
            } else {
                this.properties.setProperty(PARAM_SAVE_WINDOW_POSITION_ON_EXIT, "N");
            }
            if (this.startWithDefaultWindowSizeAndPosition.isSelected()) {
                this.properties.setProperty(PARAM_START_WITH_DEFAULT_WINDOW_SIZE_AND_POSITION, "Y");
            } else {
                this.properties.setProperty(PARAM_START_WITH_DEFAULT_WINDOW_SIZE_AND_POSITION, "N");
            }
            if (this.useExternalInternetBrowser.isSelected()) {
                this.properties.setProperty(PARAM_USE_EXTERNAL_INTERNET_BROWSER, "Y");
            } else {
                this.properties.setProperty(PARAM_USE_EXTERNAL_INTERNET_BROWSER, "N");
            }
            this.properties.setProperty(PARAM_EXTERNAL_BROWSER_PATH, this.externalBrowserPath.getText());
            if (this.applyCustomFontToNewCards.isSelected()) {
                this.properties.setProperty(PARAM_APPLY_DEFAULT_FONT, "Y");
            } else {
                this.properties.setProperty(PARAM_APPLY_DEFAULT_FONT, "N");
            }
            String string2 = (String)this.defaultFontCombo.getSelectedItem();
            if (string2 == null) {
                string2 = "";
            }
            this.properties.setProperty(PARAM_DEFAULT_FONT, string2);
            string2 = (String)this.defaultFontSizeCombo.getSelectedItem();
            if (string2 == null) {
                string2 = "";
            }
            this.properties.setProperty(PARAM_DEFAULT_FONT_SIZE, string2);
            Color color2 = this.colorIcon.getColor();
            this.properties.setProperty(PARAM_DEFAULT_FONT_COLOR, color2.getRed() + "," + color2.getGreen() + "," + color2.getBlue() + ",");
            if (this.storeDeckHistory.isSelected()) {
                this.properties.setProperty(PARAM_STORE_DECK_HISTORY, "Y");
            } else {
                this.properties.setProperty(PARAM_STORE_DECK_HISTORY, "N");
            }
            this.lastResult = RESULT_APPLY_ONLY;
            boolean bl = true;
            int n = JOptionPane.showConfirmDialog(this, "Would you like your changes to remain in effect the next time you run QUIZZAM?", "Save Preferences to Disk?", 0);
            this.lastResult = n == 0 ? RESULT_APPLY_AND_SAVE : RESULT_APPLY_ONLY;
            this.updateUI(this.properties);
            this.dispose();
        } else if (string.equals("cancel")) {
            this.lastResult = RESULT_CANCEL;
            this.updateUI(this.properties);
            this.dispose();
        } else if (string.equals("restoreDefaults")) {
            this.updateUI(this.defaultProperties);
        } else if (string.equals("browseForExternalBrowserPath")) {
            if (0 == this.fileChooser.showDialog(this, "Select External Browser")) {
                File file = this.fileChooser.getSelectedFile();
                this.externalBrowserPath.setText(file.getPath());
            }
        } else if (string.equals("toggleExternalBrowser")) {
            if (this.useExternalInternetBrowser.isSelected()) {
                this.setEnabledExternalBrowserFields(true);
            } else {
                this.setEnabledExternalBrowserFields(false);
            }
        } else if (string.equals("toggleCustomFont")) {
            if (this.applyCustomFontToNewCards.isSelected()) {
                this.setEnabledCustomFontFields(true);
            } else {
                this.setEnabledCustomFontFields(false);
            }
        } else if (string.equals("toggleStartWithDefaultWindowSizeAndPosition")) {
            if (this.startWithDefaultWindowSizeAndPosition.isSelected()) {
                this.saveWindowSizeOnExit.setSelected(false);
                this.saveWindowPositionOnExit.setSelected(false);
            }
        } else if (string.equals("toggleSaveWindowSize")) {
            if (this.saveWindowSizeOnExit.isSelected()) {
                this.startWithDefaultWindowSizeAndPosition.setSelected(false);
            }
        } else if (string.equals("toggleSaveWindowPosition")) {
            if (this.saveWindowPositionOnExit.isSelected()) {
                this.startWithDefaultWindowSizeAndPosition.setSelected(false);
            }
        } else if (string.equals("colorButtonClicked") && (color = JColorChooser.showDialog(this.colorButton, "Select Text Color", this.colorIcon.getColor())) != null) {
            this.colorIcon.setColor(color);
        }
    }

    private void setEnabledExternalBrowserFields(boolean bl) {
        this.externalBrowserPath.setEnabled(bl);
        this.externalBrowserLabel.setEnabled(bl);
        this.browserPathBrowseButton.setEnabled(bl);
    }

    private void setEnabledCustomFontFields(boolean bl) {
        this.defaultFontCombo.setEnabled(bl);
        this.defaultFontSizeCombo.setEnabled(bl);
        this.colorButton.setEnabled(bl);
    }

    private JPanel getContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("   "), "West");
        JPanel jPanel2 = new JPanel(new GridLayout(7, 1, 0, 0));
        JPanel jPanel3 = null;
        JLabel jLabel = null;
        Object var9_5 = null;
        this.saveWindowSizeOnExit = new JCheckBox("Save window size upon exiting application", false);
        this.saveWindowSizeOnExit.addActionListener(this);
        this.saveWindowSizeOnExit.setActionCommand("toggleSaveWindowSize");
        this.saveWindowPositionOnExit = new JCheckBox("Save window position upon exiting application", false);
        this.saveWindowPositionOnExit.addActionListener(this);
        this.saveWindowPositionOnExit.setActionCommand("toggleSaveWindowPosition");
        this.startWithDefaultWindowSizeAndPosition = new JCheckBox("Use the default window size and position upon startup");
        this.startWithDefaultWindowSizeAndPosition.addActionListener(this);
        this.startWithDefaultWindowSizeAndPosition.setActionCommand("toggleStartWithDefaultWindowSizeAndPosition");
        this.storeDeckHistory = new JCheckBox("Show the 4 most recently used decks in the FILE menu.");
        this.useExternalInternetBrowser = new JCheckBox("Use an external Internet Browser:");
        this.useExternalInternetBrowser.addActionListener(this);
        this.useExternalInternetBrowser.setActionCommand("toggleExternalBrowser");
        this.externalBrowserLabel = new JLabel("                    Executable File: ");
        this.externalBrowserLabel.setEnabled(false);
        this.externalBrowserPath = new JTextField("", 26);
        this.externalBrowserPath.setEnabled(false);
        this.browserPathBrowseButton = new JButton("Browse");
        this.browserPathBrowseButton.setEnabled(false);
        this.applyCustomFontToNewCards = new JCheckBox("Apply the following font to new cards: ");
        this.applyCustomFontToNewCards.addActionListener(this);
        this.applyCustomFontToNewCards.setActionCommand("toggleCustomFont");
        this.defaultFontCombo = new JComboBox<String>(this.fonts);
        this.defaultFontSizeCombo = new JComboBox<String>(this.fontSizes);
        this.colorButton.setActionCommand("colorButtonClicked");
        this.colorButton.addActionListener(this);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 0, 0));
        JCheckBox jCheckBox = this.saveWindowSizeOnExit;
        jCheckBox.setAlignmentY(1.0f);
        jCheckBox.setForeground(this.textColor);
        jPanel3.add(this.saveWindowSizeOnExit);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 0, 0));
        jCheckBox = this.saveWindowPositionOnExit;
        jCheckBox.setAlignmentY(1.0f);
        jCheckBox.setForeground(this.textColor);
        jPanel3.add(this.saveWindowPositionOnExit);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 0, 0));
        jCheckBox = this.startWithDefaultWindowSizeAndPosition;
        jCheckBox.setAlignmentY(1.0f);
        jCheckBox.setForeground(this.textColor);
        jPanel3.add(this.startWithDefaultWindowSizeAndPosition);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 0, 0));
        jCheckBox = this.useExternalInternetBrowser;
        jCheckBox.setAlignmentY(1.0f);
        jCheckBox.setForeground(this.textColor);
        jPanel3.add(this.useExternalInternetBrowser);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 0, 0));
        jLabel = this.externalBrowserLabel;
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel3.add(jLabel);
        jPanel3.add(this.externalBrowserPath);
        JButton jButton = this.browserPathBrowseButton;
        Font font = new Font(null, 0, 10);
        jButton.setFont(font);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(this.actionCursor);
        jButton.setActionCommand("browseForExternalBrowserPath");
        jButton.addActionListener(this);
        jPanel3.add(jButton);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 0, 0));
        jCheckBox = this.applyCustomFontToNewCards;
        jCheckBox.setAlignmentY(1.0f);
        jCheckBox.setForeground(this.textColor);
        jPanel3.add(jCheckBox);
        this.defaultFontCombo.setCursor(this.actionCursor);
        this.defaultFontSizeCombo.setCursor(this.actionCursor);
        jPanel3.add(this.defaultFontCombo);
        jPanel3.add(this.defaultFontSizeCombo);
        this.colorButton.setMargin(new Insets(0, 0, 0, 0));
        this.colorButton.setCursor(this.actionCursor);
        jPanel3.add(this.colorButton);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 0, 0));
        jCheckBox = this.storeDeckHistory;
        jCheckBox.setAlignmentY(1.0f);
        jCheckBox.setForeground(this.textColor);
        jPanel3.add(jCheckBox);
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "Center");
        this.updateUI(this.properties);
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string) throws IOException, FileNotFoundException, SecurityException {
        try {
            this.properties.load(new FileInputStream(string));
            if (this.properties.getProperty(PARAM_SAVE_WINDOW_SIZE_ON_EXIT).toUpperCase().equals("Y") || this.properties.getProperty(PARAM_SAVE_WINDOW_POSITION_ON_EXIT).toUpperCase().equals("Y")) {
                this.properties.setProperty(PARAM_START_WITH_DEFAULT_WINDOW_SIZE_AND_POSITION, "N");
            }
            Object var3_2 = null;
            this.updateUI(this.properties);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.updateUI(this.properties);
            throw throwable;
        }
    }

    public void store(String string) throws IOException, SecurityException, FileNotFoundException {
        File file = new File(string);
        file.createNewFile();
        this.properties.store(new FileOutputStream(file, false), this.appName + " " + this.version + " (release " + this.release + ")");
    }

    public void storeWindowSize(String string, int n, int n2) throws IOException, SecurityException, FileNotFoundException {
        this.storeWindowSizeAndPosition(string, -1, -1, n, n2);
    }

    public void storeWindowPosition(String string, int n, int n2) throws IOException, SecurityException, FileNotFoundException {
        this.storeWindowSizeAndPosition(string, n, n2, -1, -1);
    }

    public void storeWindowSizeAndPosition(String string, int n, int n2, int n3, int n4) throws IOException, SecurityException, FileNotFoundException {
        Properties properties = new Properties(this.defaultProperties);
        try {
            properties.load(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (n >= 0) {
            properties.setProperty(PARAM_WINDOW_X, String.valueOf(n));
            this.properties.setProperty(PARAM_WINDOW_X, String.valueOf(n));
        }
        if (n2 >= 0) {
            properties.setProperty(PARAM_WINDOW_Y, String.valueOf(n2));
            this.properties.setProperty(PARAM_WINDOW_X, String.valueOf(n));
        }
        if (n3 >= 0) {
            properties.setProperty(PARAM_WINDOW_HEIGHT, String.valueOf(n3));
            this.properties.setProperty(PARAM_WINDOW_X, String.valueOf(n));
        }
        if (n4 >= 0) {
            properties.setProperty(PARAM_WINDOW_WIDTH, String.valueOf(n4));
            this.properties.setProperty(PARAM_WINDOW_X, String.valueOf(n));
        }
        File file = new File(string);
        file.createNewFile();
        properties.store(new FileOutputStream(file, false), this.appName + " " + this.version + " (release " + this.release + ")");
    }

    public void showExternalBrowserSelectionScreen() {
        this.selectExternalBrowserDialog.setBrowserPath(this.properties.getProperty(PARAM_EXTERNAL_BROWSER_PATH));
        this.selectExternalBrowserDialog.show();
        if (this.selectExternalBrowserDialog.getResult()) {
            String string = this.selectExternalBrowserDialog.getBrowserPath();
            if (string != null) {
                this.properties.setProperty(PARAM_EXTERNAL_BROWSER_PATH, string);
            }
            this.properties.setProperty(PARAM_USE_EXTERNAL_INTERNET_BROWSER, "Y");
        } else {
            this.properties.setProperty(PARAM_USE_EXTERNAL_INTERNET_BROWSER, "N");
        }
        this.updateUI(this.properties);
    }

    public void storeHasBrowserQuestionBeenAsked(String string, boolean bl) throws IOException, SecurityException, FileNotFoundException {
        Properties properties = new Properties(this.defaultProperties);
        try {
            properties.load(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        String string2 = null;
        string2 = bl ? "Y" : "N";
        properties.setProperty(PARAM_HAS_EXTERNAL_BROWSER_QUESTION_BEEN_ASKED, string2);
        this.properties.setProperty(PARAM_HAS_EXTERNAL_BROWSER_QUESTION_BEEN_ASKED, string2);
        File file = new File(string);
        file.createNewFile();
        properties.store(new FileOutputStream(file, false), this.appName + " " + this.version + " (release " + this.release + ")");
    }

    public void storeDeckHistory(String string, String string2, String string3, String string4, String string5) throws IOException, SecurityException, FileNotFoundException {
        Properties properties = new Properties(this.defaultProperties);
        try {
            properties.load(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        properties.setProperty(PARAM_DECK_HISTORY_1, string2);
        properties.setProperty(PARAM_DECK_HISTORY_2, string3);
        properties.setProperty(PARAM_DECK_HISTORY_3, string4);
        properties.setProperty(PARAM_DECK_HISTORY_4, string5);
        File file = new File(string);
        file.createNewFile();
        properties.store(new FileOutputStream(file, false), this.appName + " " + this.version + " (release " + this.release + ")");
    }
}

