/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.ColorToHexConverter;
import com.quizzam.application.basic.SelfPositioningDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class GenericInformationScreen
extends SelfPositioningDialog
implements ActionListener {
    private JTextPane introTextPane;

    public GenericInformationScreen(Frame frame, String string, String string2, boolean bl, Color color, Cursor cursor, int n, int n2) throws IllegalArgumentException {
        super(frame, string, bl);
        this.init(string2, color, cursor, n, n2, null);
    }

    public GenericInformationScreen(Frame frame, String string, String string2, boolean bl, Color color, Cursor cursor, int n, int n2, HyperlinkListener hyperlinkListener) throws IllegalArgumentException {
        super(frame, string, bl);
        this.init(string2, color, cursor, n, n2, hyperlinkListener);
    }

    private void init(String string, Color color, Cursor cursor, int n, int n2, HyperlinkListener hyperlinkListener) throws IllegalArgumentException {
        if (string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        if (n2 < 0 || n <= 0) {
            throw new IllegalArgumentException("this method cannot accept a height or width less than 1");
        }
        this.getContentPane().add((Component)new JPanel(), "West");
        this.introTextPane = this.createTextPane(color);
        this.getContentPane().add((Component)this.introTextPane, "North");
        this.introTextPane.setText(string);
        if (hyperlinkListener != null) {
            this.introTextPane.addHyperlinkListener(hyperlinkListener);
        }
        this.getContentPane().add((Component)this.introTextPane, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(n2, n);
        this.setResizable(false);
    }

    public void setDisplayedText(String string) {
        this.introTextPane.setText(string);
    }

    private JTextPane createTextPane(Color color) {
        JTextPane jTextPane = new JTextPane(new DefaultStyledDocument());
        jTextPane.setBackground(this.owner.getBackground());
        jTextPane.setEditable(false);
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.addRule("BODY{ margin: 0; font-weight:bold; color:" + ColorToHexConverter.convert(color) + "}");
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        hTMLEditorKit.setStyleSheet(styleSheet);
        jTextPane.setEditorKit(hTMLEditorKit);
        return jTextPane;
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Close");
        jButton.setActionCommand("close");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("close")) {
            this.dispose();
        }
    }
}

