/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.FindCardDialogListener;
import com.quizzam.application.basic.NonOverlappingDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FindCardDialog
extends NonOverlappingDialog
implements ActionListener {
    private JTextField searchTextField;
    protected static final int WIDTH = 350;
    protected static final int HEIGHT = 190;
    private Color textColor;
    private Cursor actionCursor;
    private JRadioButton frontSide;
    private JRadioButton backSide;
    private JRadioButton bothSides;
    private FindCardDialogListener listener;
    private Component owner;

    public FindCardDialog(Frame frame, FindCardDialogListener findCardDialogListener, String string, boolean bl, Color color, Cursor cursor) throws IllegalArgumentException {
        super(frame, string, bl);
        if (frame == null || findCardDialogListener == null || string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(frame, color, cursor, findCardDialogListener);
    }

    public FindCardDialog(Dialog dialog, FindCardDialogListener findCardDialogListener, String string, boolean bl, Color color, Cursor cursor) throws IllegalArgumentException {
        super(dialog, string, bl);
        if (dialog == null || findCardDialogListener == null || string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(dialog, color, cursor, findCardDialogListener);
    }

    private void initialize(Component component, Color color, Cursor cursor, FindCardDialogListener findCardDialogListener) {
        this.textColor = color;
        this.actionCursor = cursor;
        this.listener = findCardDialogListener;
        this.owner = component;
        this.getContentPane().add((Component)this.getContentPanel(), "North");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(350, 190);
        this.setResizable(false);
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Find Previous");
        jButton.setActionCommand("findPrevious");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Close");
        jButton.setActionCommand("close");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        JButton jButton2 = jButton;
        jButton = new JButton("   Find Next   ");
        jButton.setActionCommand("findNext");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("close")) {
            this.dispose();
        } else if (string.equals("findNext") || string.equals("findPrevious")) {
            String string2 = this.searchTextField.getText();
            if (string2 == null || string2.equals("")) {
                JOptionPane.showMessageDialog(this, "Please specify what you would like to search for", "Cannot search for nothing", 0);
            } else {
                int n = this.frontSide.isSelected() ? 0 : (this.backSide.isSelected() ? 1 : 2);
                boolean bl = string.equals("findNext") ? this.listener.findNext(string2, n) : this.listener.findPrevious(string2, n);
                if (!bl) {
                    JOptionPane.showMessageDialog(this, "Could not find the text you specified!", "Search text not found", 1);
                }
            }
        }
    }

    private JPanel getContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("               "), "West");
        JPanel jPanel2 = new JPanel(new GridLayout(5, 1, 0, 0));
        JPanel jPanel3 = null;
        JLabel jLabel = null;
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 0, 0));
        jLabel = new JLabel("Navigate to a card that contains the following text:");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel3.add(jLabel);
        jPanel2.add(jPanel3);
        this.searchTextField = new JTextField(20);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 0, 0));
        jPanel3.add(this.searchTextField);
        jPanel2.add(jPanel3);
        JRadioButton jRadioButton = new JRadioButton("on the front side", true);
        jRadioButton.setCursor(this.actionCursor);
        jRadioButton.setForeground(this.textColor);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JLabel("          "), "West");
        jPanel4.add((Component)jRadioButton, "Center");
        jPanel2.add(jPanel4);
        this.frontSide = jRadioButton;
        jRadioButton = new JRadioButton("on the back side");
        jRadioButton.setCursor(this.actionCursor);
        jRadioButton.setForeground(this.textColor);
        jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JLabel("          "), "West");
        jPanel4.add((Component)jRadioButton, "Center");
        jPanel2.add(jPanel4);
        this.backSide = jRadioButton;
        jRadioButton = new JRadioButton("on either side");
        jRadioButton.setCursor(this.actionCursor);
        jRadioButton.setForeground(this.textColor);
        jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JLabel("          "), "West");
        jPanel4.add((Component)jRadioButton, "Center");
        jPanel2.add(jPanel4);
        this.bothSides = jRadioButton;
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.frontSide);
        buttonGroup.add(this.backSide);
        buttonGroup.add(this.bothSides);
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }
}

