/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JToolBar;

public class CustomJToolBar
extends JToolBar
implements MouseListener {
    private boolean canBeVertical = true;
    private int verticalIndent = 0;
    private int horizontalIndent = 0;

    public CustomJToolBar(String string, int n) throws IllegalArgumentException {
        super(string, n);
        this.addMouseListener(this);
        this.addSeparator(new Dimension(0, 0));
    }

    public boolean canBeVertical() {
        return this.canBeVertical;
    }

    public void setCanBeVertical(boolean bl) {
        this.canBeVertical = bl;
    }

    public void setHorizontalIndent(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("the amount of the indent must be greater than or equal to zero.");
        }
        this.horizontalIndent = n;
        this.updateIndents();
    }

    public int getHorizontalIndent() {
        return this.horizontalIndent;
    }

    public void setVerticalIndent(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("the amount of the indent must be greater than or equal to zero.");
        }
        this.verticalIndent = n;
        this.updateIndents();
    }

    public int getVerticalIndent() {
        return this.verticalIndent;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = this.getOrientation();
        if (!this.canBeVertical && n == 1) {
            Container container = this.getParent();
            container.remove(this);
            this.setOrientation(0);
            container.add("North", this);
            container.validate();
        }
        this.updateIndents();
    }

    private void updateIndents() {
        JToolBar.Separator separator = (JToolBar.Separator)this.getComponent(0);
        int n = this.getOrientation();
        if (n == 0) {
            separator.setSeparatorSize(new Dimension(this.horizontalIndent, 0));
        } else if (n == 1) {
            separator.setSeparatorSize(new Dimension(0, this.verticalIndent));
        }
        this.validate();
    }
}

