/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.NonOverlappingGenericInformationScreen;
import com.quizzam.engine.Flashcard;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CardPropertiesScreen
extends NonOverlappingGenericInformationScreen {
    protected static final int WIDTH = 230;
    protected static final int HEIGHT = 270;
    private Cursor actionCursor;
    private Flashcard flashcard;

    public CardPropertiesScreen(Frame frame, String string, boolean bl, Color color, Cursor cursor) throws IllegalArgumentException {
        super(frame, string, "No information is currently available.", bl, color, cursor, 270, 230);
        if (frame == null || string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.actionCursor = cursor;
    }

    public void setFlashcard(Flashcard flashcard) throws IllegalArgumentException {
        if (flashcard == null) {
            throw new IllegalArgumentException("Cannot accept NULL a parameter");
        }
        this.flashcard = flashcard;
        this.setDisplayedText(this.getText(flashcard, flashcard.getDateAndTimeOfLastReset()));
    }

    private String getText(Flashcard flashcard, Calendar calendar) {
        DecimalFormat decimalFormat = new DecimalFormat("###.##");
        int n = flashcard.getFrontNumTimesRight();
        int n2 = flashcard.getFrontNumTimesWrong();
        int n3 = flashcard.getBackNumTimesRight();
        int n4 = flashcard.getBackNumTimesWrong();
        String string = null;
        string = n + n2 == 0 ? "" : "(" + decimalFormat.format(100.0 * ((double)n / (double)(n + n2))) + "%)";
        String string2 = null;
        string2 = n + n2 == 0 ? "" : "(" + decimalFormat.format(100.0 * ((double)n2 / (double)(n + n2))) + "%)";
        String string3 = null;
        string3 = n3 + n4 == 0 ? "" : "(" + decimalFormat.format(100.0 * ((double)n4 / (double)(n3 + n4))) + "%)";
        String string4 = null;
        string4 = n3 + n4 == 0 ? "" : "(" + decimalFormat.format(100.0 * ((double)n3 / (double)(n3 + n4))) + "%)";
        String string5 = calendar.get(9) == 0 ? "AM" : "PM";
        String string6 = calendar.get(5) + "-" + this.getMonth(calendar) + "-" + calendar.get(1);
        String string7 = this.getHour(calendar) + ":" + this.getMinute(calendar) + " " + string5;
        String string8 = "#000099";
        String string9 = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        return "Since: &nbsp; <font color=\"" + string8 + "\">" + string6 + " &nbsp;" + string7 + "</font>,<br><br>When front side is shown first,<br>" + string9 + "total right: <font color=\"" + string8 + "\">" + n + " " + string + "</font><br>" + string9 + "total wrong: <font color=\"" + string8 + "\">" + n2 + " " + string2 + "</font><br><br>When back side is shown first,<br>" + string9 + "total right: <font color=\"" + string8 + "\">" + n3 + " " + string4 + "</font><br>" + string9 + "total wrong: <font color=\"" + string8 + "\">" + n4 + " " + string3 + "</font><br><br><font size=\"2\">These statistics are NOT used to decide which card is shown next during a quiz.</font>";
    }

    private String getHour(Calendar calendar) {
        int n = calendar.get(10);
        if (n == 0) {
            return "12";
        }
        return String.valueOf(n);
    }

    private String getMinute(Calendar calendar) {
        int n = calendar.get(12);
        String string = String.valueOf(n);
        if (n < 10) {
            return "0" + string;
        }
        return string;
    }

    private String getMonth(Calendar calendar) {
        int n = calendar.get(2);
        if (n == 0) {
            return "JAN";
        }
        if (n == 1) {
            return "FEB";
        }
        if (n == 2) {
            return "MAR";
        }
        if (n == 3) {
            return "APR";
        }
        if (n == 4) {
            return "MAY";
        }
        if (n == 5) {
            return "JUN";
        }
        if (n == 6) {
            return "JUL";
        }
        if (n == 7) {
            return "AUG";
        }
        if (n == 8) {
            return "SEP";
        }
        if (n == 9) {
            return "OCT";
        }
        if (n == 10) {
            return "NOV";
        }
        if (n == 11) {
            return "DEC";
        }
        return "???";
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Reset Stats");
        jButton.setActionCommand("reset");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Close");
        jButton.setActionCommand("close");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("close")) {
            this.dispose();
        } else if (string.equals("reset")) {
            JOptionPane.showMessageDialog(this, "Resetting statistics will NOT affect the order cards are shown to you during a quiz.", "Confirm Reset", 2);
            int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to reset this card's statistics?", "Confirm Reset", 0, 3);
            if (n == 0) {
                this.flashcard.resetStats();
                this.setFlashcard(this.flashcard);
                JOptionPane.showMessageDialog(this, "Statistics have been reset for this card", "Reset Completed!", 1);
            }
        }
    }
}

