/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.AudioPlayer;
import com.quizzam.application.basic.AudioPlayerListener;
import com.quizzam.application.basic.NonOverlappingGenericInformationScreen;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AudioPlayerScreen
extends NonOverlappingGenericInformationScreen
implements AudioPlayerListener {
    protected static final int WIDTH = 370;
    protected static final int HEIGHT = 210;
    private Cursor actionCursor;
    private URL audioFileURL;
    private Thread audioPlayerThread;
    private AudioPlayer audioPlayer = new AudioPlayer(this);
    private boolean isPlaying = false;

    public AudioPlayerScreen(Frame frame, String string, boolean bl, Color color, Cursor cursor) throws IllegalArgumentException {
        super(frame, string, "No audio file is currently selected.", bl, color, cursor, 210, 370);
        if (frame == null || string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.actionCursor = cursor;
        this.setResizable(true);
    }

    public void setURL(URL uRL) throws IllegalArgumentException {
        if (uRL == null) {
            throw new IllegalArgumentException("Cannot accept NULL a parameter");
        }
        this.audioFileURL = uRL;
        this.setDisplayedText(this.getText("", uRL));
    }

    private String getText(String string, URL uRL) {
        String string2 = "#000099";
        return "NOTE: This audio player currently supports .WAV files only.<br><br>AUDIO SOURCE:<br><font color=\"" + string2 + "\">" + uRL.toString() + "</font><br><br>PLAYBACK STATUS:<BR><font color=\"" + string2 + "\">" + string + "</font>";
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Play");
        jButton.setActionCommand("play");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Stop");
        jButton.setActionCommand("stop");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Close");
        jButton.setActionCommand("close");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("close")) {
            this.stopPlaying();
            this.dispose();
        } else if (string.equals("play")) {
            this.startPlaying();
        } else if (string.equals("stop")) {
            this.stopPlaying();
        }
    }

    private void stopPlaying() {
        if (this.audioPlayerThread != null && this.isPlaying) {
            this.audioPlayerThread.stop();
            this.audioPlayerThread = null;
        }
        if (this.isPlaying) {
            this.setDisplayedText(this.getText("Stopped.", this.audioFileURL));
        }
        this.isPlaying = false;
    }

    private void startPlaying() {
        this.stopPlaying();
        this.isPlaying = true;
        this.setDisplayedText(this.getText("Retrieving the audio stream...", this.audioFileURL));
        this.audioPlayer.setAudioFileURL(this.audioFileURL);
        this.audioPlayerThread = new Thread(this.audioPlayer);
        this.audioPlayerThread.start();
    }

    public void audioPlayerError(AudioPlayer audioPlayer, IOException iOException) {
        this.stopPlaying();
        JOptionPane.showMessageDialog(this, "An I/O error has occurred: " + iOException.getMessage(), "Could not play audio file", 0);
    }

    public void audioPlayerError(AudioPlayer audioPlayer, UnsupportedAudioFileException unsupportedAudioFileException) {
        this.stopPlaying();
        JOptionPane.showMessageDialog(this, "The audio file cannot be played because it is not in a recognized format.", "Audio File is in Unrecognized Format", 0);
    }

    public void audioPlayerError(AudioPlayer audioPlayer, LineUnavailableException lineUnavailableException) {
        this.stopPlaying();
        JOptionPane.showMessageDialog(this, "The audio file cannot be played because of resource restrictions.", "An audio line could not be opened", 0);
    }

    public void audioPlayerError(AudioPlayer audioPlayer, SecurityException securityException) {
        this.stopPlaying();
        JOptionPane.showMessageDialog(this, "The audio line cannot be accessed because of security restrictions.", "Audio line could not be accessed", 0);
    }

    public void audioPlayerError(AudioPlayer audioPlayer, IllegalArgumentException illegalArgumentException) {
        this.stopPlaying();
        JOptionPane.showMessageDialog(this, "The audio file cannot be played because your system does not support the required type of audio lines.", "An audio line could not be opened", 0);
    }

    public void audioPlayerError(AudioPlayer audioPlayer, IllegalStateException illegalStateException) {
        this.stopPlaying();
        JOptionPane.showMessageDialog(this, "The audio file cannot be played because an audio line was open when it should not have been.", "An audio line could not be opened", 0);
    }

    public void audioPlayerHasRetrievedTheStream(AudioPlayer audioPlayer) {
        this.setDisplayedText(this.getText("Audio stream successfully opened.<br>Retrieving an audio line...", this.audioFileURL));
    }

    public void audioPlayerIsDone(AudioPlayer audioPlayer) {
        this.setDisplayedText(this.getText("Finished playing!", this.audioFileURL));
        this.isPlaying = false;
    }

    public void audioPlayerIsPlaying(AudioPlayer audioPlayer) {
        this.setDisplayedText(this.getText("Currently playing...", this.audioFileURL));
    }

    public void show() {
        super.show();
        this.startPlaying();
    }
}

