/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.AudioPlayerListener;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioPlayer
implements Runnable {
    private URL audioFileURL;
    private AudioPlayerListener listener;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public AudioPlayer(AudioPlayerListener audioPlayerListener) {
        if (audioPlayerListener == null) {
            throw new IllegalArgumentException("This constructor cannot accept NULL as a parameter");
        }
        this.listener = audioPlayerListener;
    }

    public void setAudioFileURL(URL uRL) {
        this.audioFileURL = uRL;
    }

    public void run() {
        if (this.audioFileURL != null) {
            try {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(this.audioFileURL);
                AudioFormat audioFormat = audioInputStream.getFormat();
                DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = AudioPlayer.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat);
                this.listener.audioPlayerHasRetrievedTheStream(this);
                SourceDataLine sourceDataLine = null;
                try {
                    sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
                    sourceDataLine.open(audioFormat);
                    sourceDataLine.start();
                    this.listener.audioPlayerIsPlaying(this);
                    byte[] byArray = new byte[256000];
                    int n = audioInputStream.read(byArray);
                    while (n != -1) {
                        sourceDataLine.write(byArray, 0, n);
                        n = audioInputStream.read(byArray);
                    }
                    sourceDataLine.drain();
                    sourceDataLine.close();
                }
                catch (LineUnavailableException lineUnavailableException) {
                    this.listener.audioPlayerError(this, lineUnavailableException);
                }
                catch (SecurityException securityException) {
                    this.listener.audioPlayerError(this, securityException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.listener.audioPlayerError(this, illegalArgumentException);
                }
                catch (IllegalStateException illegalStateException) {
                    this.listener.audioPlayerError(this, illegalStateException);
                }
                this.listener.audioPlayerIsDone(this);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                this.listener.audioPlayerError(this, unsupportedAudioFileException);
            }
            catch (IOException iOException) {
                this.listener.audioPlayerError(this, iOException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

