<%@ Control Language="c#" AutoEventWireup="false" Codebehind="List.ascx.cs" Inherits="Tp.Web.UserSpace.UsersList" TargetSchema="http://schemas.microsoft.com/intellisense/ie5" %>
<div class="title orange">Users</div>
<asp:datagrid id="dgUsers" CssClass="table" CellSpacing="0" CellPadding="6" BorderWidth="0"
	ItemStyle-CssClass="row" HeaderStyle-CssClass="tableHead" AutoGenerateColumns="False"
	DataKeyField="UserId" runat="server">
	<Columns>
		
		<asp:TemplateColumn>
			<HeaderTemplate>
				Name
			</HeaderTemplate>
			<ItemTemplate>
				<%# DataBinder.Eval(Container.DataItem, "Name") + " " +
				 DataBinder.Eval(Container.DataItem, "Surname")%> 
			</ItemTemplate>
		</asp:TemplateColumn>
		
		<asp:BoundColumn
			HeaderText="Email"
			DataField="Email" />
			
		<asp:HyperLinkColumn
			DataNavigateUrlField="UserId"
			DataNavigateUrlFormatString="javascript:OpenWizard('{0}/Edit.aspx');"
			DataTextField="UserId"
			DataTextFormatString="{0:Edit}" />
		
		<asp:ButtonColumn
			ButtonType="LinkButton"
			CommandName="Delete"
			DataTextField="UserId"
			DataTextFormatString="{0:Delete}"  />
	</Columns> 
</asp:datagrid>
