<%@ Control Language="c#" AutoEventWireup="false" Codebehind="List.ascx.cs" Inherits="Tp.Web.ProjectSpace.Planning.Releases.List" TargetSchema="http://schemas.microsoft.com/intellisense/ie5" %>
<DIV class="title green">Releases</DIV>
<br>
<asp:Panel Runat="server" ID="pnlList">
<asp:datagrid id="dgReleases" runat="server" CssClass="table" CellSpacing="0" CellPadding="4"
	BorderWidth="0" ItemStyle-CssClass="row" HeaderStyle-CssClass="tableHead"
	OnItemCreated="dgReleases_ItemCreated" AutoGenerateColumns="False" DataKeyField="ReleaseId">
	<Columns>
		
		<asp:TemplateColumn>
			<HeaderTemplate>
				Name
			</HeaderTemplate>
			<ItemTemplate>
				<asp:HyperLink Runat=server NavigateUrl='<%# Application["appPath"] + 
				"/Project/" + GetProjectId() + "/Planning/Releases/" + 
				DataBinder.Eval(Container.DataItem, "ReleaseId") + "/Iterations/List.aspx"%>'><%#DataBinder.Eval(Container.DataItem, "Name")%></asp:HyperLink>
			</ItemTemplate>
		</asp:TemplateColumn>
			
		<asp:BoundColumn DataField="Goal" HeaderText="Goal" />
		<asp:BoundColumn DataField="StartDate" DataFormatString="{0:dd-MMM-yyyy}" HeaderText="Start Date" ItemStyle-Wrap=False />
		<asp:BoundColumn DataField="FinishDate" DataFormatString="{0:dd-MMM-yyyy}" HeaderText="Finish Date" ItemStyle-Wrap=False />
		<asp:TemplateColumn ItemStyle-HorizontalAlign="Center">
			<HeaderTemplate>
				Iterations
			</HeaderTemplate>
			<ItemTemplate>
				<asp:HyperLink Runat=server NavigateUrl='<%# "~/" + DataBinder.Eval(Container.DataItem, "ReleaseId") + "/Iterations/List.aspx" %>' ID="Hyperlink1">
					<asp:Label ID="lblIterationsCount" Runat=server /></asp:Label>
				</asp:HyperLink>
			</ItemTemplate>
		</asp:TemplateColumn>
		<asp:TemplateColumn ItemStyle-HorizontalAlign="Center">
			<HeaderTemplate>
				User Stories
			</HeaderTemplate>
			<ItemTemplate>
				<b><asp:Label ID="lblDoneUserStoriesCount" Runat=server /></asp:Label></b>/
				<asp:HyperLink Runat=server NavigateUrl='<%# "~/" + DataBinder.Eval(Container.DataItem, "ReleaseId") + "/UserStories/List.aspx" %>' ID="Hyperlink2">
				<b><asp:Label ID="lblTotalUserStoriesCount" Runat=server></asp:Label></b></asp:HyperLink>
			</ItemTemplate>
		</asp:TemplateColumn>
		<asp:TemplateColumn>
			<ItemTemplate>
				<a href="javascript:OpenWizard('<%= Application["appPath"] %>/Project/<%=GetProjectId()%>/Planning/Releases/<%# DataBinder.Eval(Container.DataItem, "ReleaseId")%>/Edit.aspx')">Edit</a>
				<br>or<br>
				<asp:LinkButton Runat=server ID="lbDelete">Delete</asp:LinkButton>?
			</ItemTemplate>
		</asp:TemplateColumn>
	</Columns>
</asp:datagrid>
</asp:Panel>
<asp:Panel ID="pnlNotFound" Runat=server Visible=False>
	No Releases found. But you may <a href="javascript:OpenWizard('<%= Application["appPath"] %>/Project/<%=GetProjectId()%>/Planning/Releases/Add.aspx')"><b>Add a New Release</b></a>.
</asp:Panel>