//////////////////////////////////////////////////////////////////////////
// Copyright (C) 2000 - 2004 EleFun Multimedia							//
//////////////////////////////////////////////////////////////////////////
//																		//
// Name:		aml.h													//
// Description:	Advanced Media Library header file						//
//																		//
//////////////////////////////////////////////////////////////////////////

#pragma once

#include <windows.h>

#ifdef AML_EXPORTS
#define AML_API __declspec(dllexport)
#else
#define AML_API __declspec(dllimport)
#endif

#define AML_LIB_VERSION 100

#define AML_STATE_RUNNING 0
#define AML_STATE_STOPPED 1
#define AML_STATE_PAUSED 2

AML_API BOOL AML_Initializate(HWND _video_window);
AML_API BOOL AML_Destroy();

AML_API BOOL AML_Refresh();

AML_API BOOL AML_LoadMediaFile(int *_index, const char *_file_name, const bool &_only_audio_stream);
AML_API BOOL AML_UploadMediaFile(const int &_index);

AML_API BOOL AML_Play(const int &_index);
AML_API BOOL AML_Pause(const int &_index);
AML_API BOOL AML_Stop(const int &_index);

AML_API BOOL AML_SetStartPosition(const int &_index, const float &_start_position);
AML_API BOOL AML_SetStopPosition(const int &_index, const float &_stop_position);
AML_API BOOL AML_SetCurrentPosition(const int &_index, const float &_current_position);
AML_API BOOL AML_SetRate(const int &_index, const float &_rate);
AML_API BOOL AML_SetLoop(const int &_index, const BOOL &_is_looped);
AML_API BOOL AML_SetMute(const int &_index, const BOOL &_is_muted);
AML_API BOOL AML_SetVolume(const int &_index, const float &_volume);
AML_API BOOL AML_SetBalance(const int &_index, const float &_balance);
AML_API BOOL AML_SetVideoFullscreen(const int &_index, const BOOL &_is_fullscreen);

AML_API BOOL AML_GetState(const int &_index, int *_state);
AML_API BOOL AML_GetDuration(const int &_index, float *_duration);
AML_API BOOL AML_GetStartPosition(const int &_index, float *_start_position);
AML_API BOOL AML_GetStopPosition(const int &_index, float *_stop_position);
AML_API BOOL AML_GetCurrentPosition(const int &_index, float *_current_position);
AML_API BOOL AML_GetRate(const int &_index, float *_rate);
AML_API BOOL AML_GetLoop(const int &_index, BOOL *_is_looped);
AML_API BOOL AML_GetMute(const int &_index, BOOL *_is_muted);
AML_API BOOL AML_GetVolume(const int &_index, float *_volume);
AML_API BOOL AML_GetBalance(const int &_index, float *_balance);
AML_API BOOL AML_GetVideoFullscreen(const int &_index, BOOL *_is_fullscreen);

AML_API BOOL AML_HasMediaFileAudioStream(const int &_index, BOOL *_has_media_source_audio_stream);
AML_API BOOL AML_HasMediaFileVideoStream(const int &_index, BOOL *_has_media_source_video_stream);