<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("user",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_USER_PREFS,request); %>

<%@ include file="../global/topInclude.jsp" %>
<%@ include file="includes/prefsInclude.jsp" %>
<%!

%>



<%

boolean success=controller.getParamAsBoolean("success",true);

User user=controller.getSessionInfo().getUser();
boolean doNotifications=controller.getCurrentInstallationConfig().isDoNotifications();



%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>

<script language="JavaScript">

</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>

<form>
<font class=bodyFont>


<%
if (success)
{
	%>
	<span class=firstSentenceFont>Your account changes have been made.</span> The current configuration is below. You may now:

	<ul>
	<li><a href="../issues/index.jsp">view the issues list</a>
	<li><A href="prefs.jsp">make more changes to your account</a>
	<li><a href="../login/logout.jsp">log out</a>
	<%=HtmlUtils.doubleLB(request)%>
	</ul>
	<%
}
else
{
	%>
	<span class=firstSentenceFont>There was a problem.</span> Some or all of your data may not have been saved. The current configuration of your account is below. You may now:

	<ul>
	<li><A href="../feedback/compose.jsp">report the problem you just experienced</a>
	<li><a href="../issues/index.jsp">view the issues list</a>
	<li><A href="prefs.jsp">make more changes to your account</a>
	<li><a href="../login/logout.jsp">log out</a>

	<%=HtmlUtils.doubleLB(request)%>
	</ul>

	<%
}
%>

<%
if (doNotifications)
{
	%>
	<i>General info</i><%=HtmlUtils.doubleLB(request)%>
	<%
}
%>
<span class=boldishFont>Username:</span> <%=user.getUsername()%><BR>
<span class=boldishFont>Full Name:</span> <%=user.getFullname()%><BR>
<span class=boldishFont>Password:</span> <%=HtmlUtils.getPasswordAsterisks(user.getPassword())%><BR>
<span class=boldishFont>Remember me on this computer:</span> <%=user.isDropUserCookie()?"yes":"no"%><BR>
<%
if (doNotifications)
{
	%>
	<%=HtmlUtils.doubleLB(request)%>
	<i>Notifications and reminders</i><%=HtmlUtils.doubleLB(request)%>
	
	<span class=boldishFont>E-mail address:</span> <%=HtmlUtils.getMailtoLink(user.getEmailAddress())%><BR>
	
	<span class=boldishFont>By default, send notifications of new/changed issues to users:</span> <%
	int defaultNotificationPref=user.getDefaultNotificationPref();
	for (int i=0; i<DEFAULT_NOTIF_LABELS.length; i++)
	{
		if (DEFAULT_NOTIF_VALUES[i]==defaultNotificationPref)
		{
			%>
			<%=DEFAULT_NOTIF_LABELS[i]%>
			<%
			break;
		}
	} 
	%><BR>

	
	<span class=boldishFont>Send me pre-deadline reminder e-mails about issues:</span> <%
	long preDeadlineReminderBeforeMillis=user.getPreDeadlineReminderBeforeMillis();
	for (int i=0; i<REMINDER_MILLIS_LABELS.length; i++)
	{
		if (REMINDER_MILLIS_VALUES[i]==preDeadlineReminderBeforeMillis)
		{
			%>
			<%=REMINDER_MILLIS_LABELS[i]%>
			<%
			break;
		}
	} 
	%><BR>
	<span class=boldishFont>Send me a reminder e-mail if I miss a deadline:</span> <%=user.isSendMissedDeadlineReminder()?"yes":"no"%><BR>
	<span class=boldishFont>Attach an iCalendar file to notification e-mails:</span> <%=user.isSendICalendarFileWithNotification()?"yes":"no"%><BR>
	
	<%
}
%>



<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>

</form>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

