<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>
  
 
<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>     
 
<%@ page import="java.util.*" %>
 
<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.session.*" %>

<% PageUtils.setSkipTrialPeriodExpireCheck(true,request); %>
<% PageUtils.setSkipMaxUsersExceededCheck(true,request); %>

<% PageUtils.setRequiredLoginStatus("none",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_LOGIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%> 

<%

InstallationConfig installationConfig=controller.getCurrentInstallationConfig();
SessionInfo sessionInfo=controller.getSessionInfo();


String adminName=PageUtils.nonNull(installationConfig.getAdminName()).trim();
String adminEmail=PageUtils.nonNull(installationConfig.getAdminEmail()).trim();
boolean showAdminLink=(adminName.length()>0 && adminEmail.length()>0);

String currentLoginStatus=PageUtils.nonNull(sessionInfo.getLoginStatus()).trim().toLowerCase();

boolean currentlyLoggedIn=(currentLoginStatus.equals("user") || currentLoginStatus.equals("superuser"));
 
int errorCode=controller.getParamAsInt("errorCode",0);

String requiredUserTypeForLogin=PageUtils.nonNull(sessionInfo.getRequiredUserTypeForLogin()).trim().toLowerCase();

String username=controller.getParam("username").trim();
if (username.length()==0)
{
	// no username on the q-string, so let's see if user wants the app to "remember" him or her:
	int userIdFromCookie=controller.getUserIdFromCookie(); // will equal 0 if not found
	if (userIdFromCookie>0)
	{
		User user=Manager.selectUserById(userIdFromCookie);
		if (user!=null && user.isDropUserCookie())
		{
			username=user.getUsername();
		}
	}
}

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>


<script language="JavaScript">

// this page may load in a frame (e.g. on the "list" page), so don't allow that:

if (top.frames.length>0)
{
	top.location.replace(""+location.href)
}

function isValidForm(formObj)
{
	var els=formObj.elements

	if (trim(els["username"].value).length==0)
	{
		errorAlert("You have not entered a username.  Please enter one and try again.",els["username"])
		return false
	}
	if (trim(els["password"].value).length==0)
	{
		errorAlert("You have not entered a password.  Please enter one and try again.",els["password"])
		return false
	}
	hidePageAndShowPleaseWait()
	return true
}

</script>

<style type="text/css">
 
</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=<%=isPopup?"popupMainDiv":"mainDiv"%>>
<span class=standardTextBlockWidth>

<%
if (!currentlyLoggedIn)
{
	%>
	<form action=processLogin.jsp?isPopup=<%=(isPopup?"true":"false")%> method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm> 
	<font class=bodyFont>
	<%
	if (errorCode==0) // no error:
	{
		%>
		<span class=firstSentenceFont>Please enter your username and password</span> and press the "log in" button to log in. 
		<%
	}
	else if (errorCode==1) // invalid username or password:
	{
		%>
		<span class=firstSentenceFont>There was a problem.</span> Either you entered an unrecognized username<%=HelpManager.helpLink("username",request)%>, or the password<%=HelpManager.helpLink("password",request)%> you entered did not match the username. Please try again.
		<%	
	}
	else if (errorCode==2) // superuser needed, but user found:
	{
		%>
		<span class=firstSentenceFont>There was a problem.</span> the page you were trying to access requires administrator privileges<%=HelpManager.helpLink("administrator",request)%>, but your account does not have administrator privileges.  You may attempt to log in below again with a username that has administrator privileges.
		<%	
	}
	else if (errorCode==3) // inactive user:
	{
		%>
		<span class=firstSentenceFont>There was a problem.</span> The account "<%=username%>" has been deactivated<%=HelpManager.helpLink("deactivation",request)%> by an administrator<%=HelpManager.helpLink("administrator",request)%>.  If you believe this account should be activated, please speak to a user with administrator privileges.  Or, you may attempt to log in below again with an active username.
		<%	
	}

	%>

	If you do not have a WorkRoll account and would like one created for you, please 
	<%
	if (showAdminLink)
	{
		%>
		contact <%=HtmlUtils.getMailtoLink(adminEmail,adminName)%>, or another user with admistrator privileges.
		<%
	}
	else
	{
		%>
		ask a user with administrator privileges to create an account for you.
		<%
	}

	if (requiredUserTypeForLogin.equals("superuser") && errorCode!=2)
	{
		%>
		<b>Note that the page you are attempting to access requires administrator privileges<%=HelpManager.helpLink("administrator",request)%>.  If you are a user without administrator privileges, you will be denied access to the page.</b>
		<%
	}
	%>
	


	<%=HtmlUtils.doubleLB(request)%><BR>

	<span class=boldishFont>Username<%=HelpManager.helpLink("username",request)%></span><BR>
	<input class=inputText type=text size=16 name=username id=username value="<%=username%>"><%=HtmlUtils.doubleLB(request)%>

	<span class=boldishFont>Password<%=HelpManager.helpLink("password",request)%></span><BR>
	<input class=inputText type=password size=16 name=password id=password value=""><BR>	
	<a href="forgotPassword.jsp">Forgot your password?</a><BR><BR>

	<input  class=formButton type=submit value="log in"><%=HtmlUtils.doubleLB(request)%>


	<br></font>

	</form>
	<%
}
else
{
	// user is already logged in:
	%>              
	<form action=# onsubmit="return false">
	<font class=bodyFont>    
	<span class=firstSentenceFont>You are currently logged in as user "<%=currentUser.getUsername()%>".</span>  <%
	if (requiredUserTypeForLogin.equals("superuser") && !(currentUser.isSuperUser()))
	{
		%>
<B>		However, the page you are trying to access is available only to administrators, and the user "<%=currentUser.getUsername()%>" does not have administrator privileges. If you wish to access this page, you must log out (by clicking "log out" below) and log back in as an administrator, or have an administrator perform this task for you.
</B>		<%
	}
	else
	{
		%>
		If you wish to log out, press the "log out" button below.  (If you wish to login as another user, you must log out first.)
		<%
	}
	
	
	%><%=HtmlUtils.doubleLB(request)%><BR>
	<input  class=formButton type=button value="log out" onclick="location.href='logout.jsp?isPopup=<%=(isPopup?"true":"false")%>'"><BR>
	</font>
	<%
}  
%>

      
  </span>

</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

