<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>
<%@ page import="java.net.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.util.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.session.*" %>
<%@ page import="com.workroll.app.mail.*" %>
<%@ page import="com.workroll.app.WorkRollConstants" %>
 
<% PageUtils.setRequiredLoginStatus("none",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setRequiredRequestMethod("POST",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ISSUES_POPUP,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%


// We are now going to parse a text file that looks something like this (this sample does not include the later-added URL field, btw):
/*



-----------------------------7d325135210212
Content-Disposition: form-data; name="toUsersAreUsernames"

false
-----------------------------7d325135210212
Content-Disposition: form-data; name="openDateFormat"

2
-----------------------------7d325135210212
Content-Disposition: form-data; name="dueDateFormat"

2
-----------------------------7d325135210212
Content-Disposition: form-data; name="file1"; filename="C:\Documents and Settings\Steve Schneider\Desktop\exportForImport.jsp.txt"
Content-Type: text/plain

 ID	By	To	Status	Priority	Project	Instance	Opened	Due	Description
10	steve developer	steve developer	Closed	Very Low	All projects	All instances	2003-03-29	2003-06-01 02:00:00	top
12	steve java	steve designer	Closed	Normal	All projects	Main dev	2003-04-04	2003-04-04 17:00:00	sdsdsdg[WR-EOL]cv
13	steve developer	steve developer	Closed	Normal	All projects	All instances	2003-04-11	2003-04-11 23:59:00	cv
14	steve developer	steve developer	Closed	Normal	All projects	All instances	2003-04-11	2003-04-11 23:59:00	df
15	steve developer	steve developer	Closed	Normal	All projects	All instances	2003-04-11	2003-04-11 23:59:00	v
16	steve developer	steve developer	Closed	Normal	All projects	All instances	2003-04-11	2003-04-11 23:59:00	oij
17	steve developer	steve developer	Closed	Normal	All projects	All instances	2003-04-11	2003-04-11 23:59:00	lkj
18	steve developer	steve developer	Closed	Normal	All projects	All instances	2003-04-11	2003-04-11 23:59:00	lkj
72	steve developer	steve developer	Closed	Normal	workroll app	All instances	2003-04-30	2003-05-14 23:59:00	force to single line doesn't workl in some cases, e.g. bug 129 (mayb just need to strip BRs).
	
-----------------------------7d325135210212
Content-Disposition: form-data; name="savePrefs"

true
-----------------------------7d325135210212--
null

*/
try
{
	BufferedReader reader=request.getReader();
	boolean plaintextMarkerFound=false;
	ArrayList formDataLines=new ArrayList(2000);
	String filename="";
	String l="";
	while (l!=null)
	{
		l=reader.readLine();
		if (l!=null)
		{
			if (!plaintextMarkerFound)
			{
				if (l.indexOf("Content-Type: text/plain")>-1)
				{
					plaintextMarkerFound=true;
				}
			}
			if (filename.length()==0)
			{
				if (l.indexOf("filename=\"")>-1)
				{
					int startIdx=l.indexOf("filename=\"")+"filename=\"".length();
					int endIdx=l.indexOf("\"",startIdx+1);
					if (endIdx==-1)
					{
						endIdx=l.length();
					}
					Printer.p(""+startIdx+": "+endIdx+"");
					filename=l.substring(startIdx,endIdx);

				}
			}
			formDataLines.add(l);
		}
	}
	
	MultipartFormDataParser formParser=new MultipartFormDataParser(formDataLines);
	
	boolean containsHeaderRow=formParser.getParam("containsHeaderRow").trim().toLowerCase().equals("true");
	boolean containsIgnorableIdColumn=formParser.getParam("containsIgnorableIdColumn").trim().toLowerCase().equals("true");
	boolean byUsersAreUsernames=formParser.getParam("byUsersAreUsernames").trim().toLowerCase().equals("true");
	boolean toUsersAreUsernames=formParser.getParam("toUsersAreUsernames").trim().toLowerCase().equals("true");
	boolean removeQuotes=formParser.getParam("removeQuotes").trim().toLowerCase().equals("true");
	String tabSubstitute=formParser.getParam("tabSubstitute");
	String eolSubstitute=formParser.getParam("eolSubstitute");
	int openDateFormat=Integer.parseInt(formParser.getParam("openDateFormat"));
	int dueDateFormat=Integer.parseInt(formParser.getParam("dueDateFormat"));


	HashMap userSpecifiedProperties=new HashMap();
	userSpecifiedProperties.put("containsHeaderRow",new Boolean(containsHeaderRow));
	userSpecifiedProperties.put("containsIgnorableIdColumn",new Boolean(containsIgnorableIdColumn));
	userSpecifiedProperties.put("byUsersAreUsernames",new Boolean(byUsersAreUsernames));
	userSpecifiedProperties.put("toUsersAreUsernames",new Boolean(toUsersAreUsernames));
	userSpecifiedProperties.put("removeQuotes",new Boolean(removeQuotes));
	userSpecifiedProperties.put("tabSubstitute",""+tabSubstitute);
	userSpecifiedProperties.put("eolSubstitute",""+eolSubstitute);
	userSpecifiedProperties.put("openDateFormat",new Integer(openDateFormat));
	userSpecifiedProperties.put("dueDateFormat",new Integer(dueDateFormat));

	IssueRowParser parser=new IssueRowParser(userSpecifiedProperties, Manager.selectAllUsers(), Manager.selectAllProjects(), Manager.selectAllInstances());

	ArrayList issues=new ArrayList();

	StringBuffer errorsBuffer=new StringBuffer("");
	if (!plaintextMarkerFound)
	{
		errorsBuffer.append("<LI>The uploaded file \""+filename+"\" is not a text file; WorkRoll requires text (not binary) files of MIME type \"text/plain\" for imports. Such files are generated by default by any text editor (for example, Notepad, SimpleText, EMACS, Pico, VI, etc.), as well as by spreadsheet-application and database exports if you have specified output to be in text format. (Note that word processors such as Word, WordPerfect, and others are <I>not</I> text editors and must be asked explicitly to save files as text, rather than in their proprietary, binary format.)  If you are certain that the file you uploaded was a text file, please report your problem <a href=\"mailto:"+WorkRollConstants.COMMENTS_EMAIL_ADDRESS+"\">here</a>.<BR>");
	}
	if (plaintextMarkerFound)
	{
		String line="";

		int lineNumber=0; // used exclusively for error reporting to user

		boolean invalidLineFound=false; // indicates if the file contains any invalid lines thus far

		int expectedNumTabs=(containsIgnorableIdColumn?10:9);

		for (int i=0; i<formDataLines.size(); i++)
		{
			line=(String)formDataLines.get(i);
			// two tabs in a row will be counted as one by StringTokenizer, so need to replace blank fields with space chars (will trim them later):
			line=GeneralUtils.stringReplace(line,"\t\t","\t \t");
			StringTokenizer tzr=new StringTokenizer(line,"\t");
			int numTabs=tzr.countTokens()-1;
			if (numTabs==expectedNumTabs)
			{
				lineNumber++;
				ParsedIssueRowWrapper wrapper=parser.parse(line, lineNumber);
				if (wrapper.isLegalHeaderRow())
				{
					continue;
				}
				if (wrapper.getErrors().size()>0)
				{
					invalidLineFound=true;
					for (int j=0; j<wrapper.getErrors().size(); j++)
					{
						errorsBuffer.append("<li>"+wrapper.getErrors().get(j)+"<BR>");
						continue;
					}
				}
				// legal issue found, but if we've already found a bad line, we're not bothering to add to ArrayList:
				if (!invalidLineFound)
				{
					issues.add(wrapper.getIssue());
				}
			}
			else
			{
				if ((numTabs>0 && numTabs<expectedNumTabs) || numTabs>expectedNumTabs)
				{
					errorsBuffer.append("<LI>Error at data line "+lineNumber+": Row contains "+numTabs+", not the expected "+expectedNumTabs+", tab characters.<BR>");
				}
			}
		}
		if (issues.size()==0)
		{
			errorsBuffer.append("<LI>The uploaded file did not contain any valid rows.<BR>");
		}
	}
	if (errorsBuffer.length()==0)
	{
		session.setAttribute("issuesForImport",issues);
		session.removeAttribute("importErrors");
		%>
		<script>
		location.replace("previewImportedIssues.jsp");
		</script>
		<%
	}
	else
	{
		session.setAttribute("importErrors",errorsBuffer);
		session.removeAttribute("issuesForImport");
		%>
		<script>
		location.replace("viewImportErrors.jsp");
		</script>
		<%
	}
}
catch (Throwable e)
{
	Printer.p(""+e+e.getMessage());
}


%><%@ include file="../global/bottomInclude.jsp" %><%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%><% PageUtils.jspEnd(request); %>