<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% //PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>
<%@ page import="java.net.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.session.*" %>
<%@ page import="com.workroll.app.mail.*" %>
<%@ page import="com.workroll.app.WorkRollConstants" %>
 
<% PageUtils.setRequiredLoginStatus("none",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setRequiredRequestMethod("POST",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ISSUES_POPUP,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%
int successCode; // will= 0 for success; 1 for already closed; 2 for error
try
{
	int issueId=controller.getParamAsInt("issueId");
	boolean issueIsNonClosed=controller.getParamAsBoolean("issueIsNonClosed");


	AbstractIssue issue=Manager.selectNonClosedIssueById(issueId);
	if (issue==null)
	{
		// was already closed (could happen with multiple users):
		successCode=1;
	}
	
	else
	{
		// update the issue to the non-closed-issue table, without setting
		// its status to CLOSED because moveIssueToClosedIssues does this,
		// then move it (yes, this is clunky):
		issue.setLastModifiedDate(new Date());
		Manager.updateNonClosedIssue((NonClosedIssue)issue);
		Manager.moveIssueToClosedIssues(issueId);
		successCode=0;
	}

}
catch (Throwable t)
{
	successCode=2;
	Printer.pe("storing issue", t);
}

%>
<html><head></head>
<body onload="parent.frames[0].closeIssueSuccess(<%=successCode%>)">
</body>
</html>



<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>
