<%@ page import="java.text.*" %><%@ page import="java.net.*" %><%

// This JSP generates all lists of issues except for the main (active) one, which is JavaScripted and different.  I.e., this include generates the closed-issue list, as well as the printable version (of closed or active issues) the exportable text file, and the "basic" (non-IE/Win) active list.

// This file must be compile-time included, and expects the (parameter-like) int listType to be defined to one of the constants below, as well as an isActiveIssues boolean and also expects definitions of the arrays String[] headerNames and int[] colWidths.

%><%!
static final int LIST_TYPE_STANDARD=0;
static final int LIST_TYPE_PRINTABLE=1;
static final int LIST_TYPE_EXPORT=2;
static final int LIST_TYPE_IMPORT_PREVIEW=3;



HashMap getMapFromList(ArrayList objs)
{
	HashMap ret=new HashMap();
	for (int i=0; i<objs.size(); i++)
	{
		AbstractEntity obj=(AbstractEntity)objs.get(i);
		if (obj!=null)
		{
			ret.put(new Integer(obj.getId()),obj);
		}
	}
	return ret;
}

%><%

boolean outputToWeb=(listType==LIST_TYPE_STANDARD || listType==LIST_TYPE_PRINTABLE || listType==LIST_TYPE_IMPORT_PREVIEW);

String eolSubstitute=controller.getParam("eolChar",WorkRollConstants.EXPORT_EOL_CHARS);
String tabSubstitute=controller.getParam("tabChar",WorkRollConstants.EXPORT_TAB_CHARS);
boolean prependSortableText=controller.getParamAsBoolean("prependSortableText",false);

// In case passed chars for tab- or EOL-replacement sequences contain tab or EOL chars:
eolSubstitute=GeneralUtils.stringReplace(eolSubstitute, WorkRollConstants.LINE_SEPARATOR, " ").replace('\t',' ');
tabSubstitute=GeneralUtils.stringReplace(tabSubstitute, WorkRollConstants.LINE_SEPARATOR, " ").replace('\t',' ');


ArrayList users=Manager.selectAllUsers();
if (users==null)
{
	users=new ArrayList();
}
HashMap usersMap=getMapFromList(users);


ArrayList projects=Manager.selectAllProjects();
if (projects==null)
{
	projects=new ArrayList();
}
HashMap projectsMap=getMapFromList(projects);



ArrayList instances=Manager.selectAllInstances();
if (instances==null)
{
	instances=new ArrayList();
}
HashMap instancesMap=getMapFromList(instances);



ArrayList issues;
if (listType!=LIST_TYPE_IMPORT_PREVIEW)
{
	if (listType!=LIST_TYPE_EXPORT)
	{
		if (isActiveIssues)
		{
			issues=Manager.selectAllNonClosedIssues();
		}
		else
		{
			issues=Manager.selectAllClosedIssues();
		}
	}
	else // exporting:
	{
		if (isActiveIssues)
		{
			issues=Manager.selectAllNonClosedIssues();
			if (controller.getParam("exportType","").equals("all"))
			{
				// then in addition to active issues, we need closed as well (export view is the only one where we do both):
				issues.addAll(Manager.selectAllClosedIssues());
			}
		}
		else
		{
			issues=Manager.selectAllClosedIssues();
		}
	}
}
else
{
	issues=issuesForPreview;
}








// FILTERING:
if (filter!=null && issues!=null && staticListDoFilterIfFound)
{
	filter.filter(issues,controller.getSessionInfo().getUser());
}
if (issues==null)
{
	issues=new ArrayList();
}



// SORTING:

ListSorter sorter=null;
if (staticListSortName!=null)
{
	sorter=new ListSorter(usersMap, projectsMap, instancesMap);
	issues=sorter.getSortedList(issues, staticListSortName, staticListSortAscending);
}


%>