<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>

<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>
 
<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.session.*" %>

<% PageUtils.setSkipTrialPeriodExpireCheck(true,request); %>
<% PageUtils.setRequiredLoginStatus("none",request); %>
<% PageUtils.setPathToAppRoot("",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_LOGIN,request); %>
<% PageUtils.setSkipMaxUsersExceededCheck(true,request); %>


<%@ include file="global/topInclude.jsp" %>

<%!

%>

<%
InstallationConfig installationConfig=controller.getCurrentInstallationConfig();
SessionInfo sessionInfo=controller.getSessionInfo();


String adminName=PageUtils.nonNull(installationConfig.getAdminName()).trim();
String adminEmail=PageUtils.nonNull(installationConfig.getAdminEmail()).trim();
boolean showAdminLink=(adminName.length()>0 && adminEmail.length()>0);

String currentLoginStatus=PageUtils.nonNull(sessionInfo.getLoginStatus()).trim().toLowerCase();

boolean currentlyLoggedIn=(currentLoginStatus.equals("user") || currentLoginStatus.equals("superuser"));


String username=controller.getParam("username").trim();
if (username.length()==0)
{
	// no username on the q-string, so let's see if user wants the app to "remember" him or her:
	int userIdFromCookie=controller.getUserIdFromCookie(); // will equal 0 if not found
	if (userIdFromCookie>0)
	{
		User user=Manager.selectUserById(userIdFromCookie);
		if (user!=null && user.isDropUserCookie())
		{
			username=user.getUsername();
		}
	}
}

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
<%@ include file="global/headInclude.jsp" %>
<%@ include file="global/validationJs.jsp" %>


<script language="JavaScript">


var adminName="<%=adminName%>"
var adminEmail="<%=adminEmail%>"


function launchFeedback(isSupportRequest)
{
	var url=top.location.href
	if (url.indexOf("/help/")>-1)
	{
		url=""
	}
	openDialog("../feedback/compose.jsp?isSupportRequest="+(isSupportRequest?"true":"false")+"&currUrl="+escape(url), "workrollFeedback", 580, 340, true, false)
}



function isValidForm(formObj)
{
	var els=formObj.elements

	if (trim(els["username"].value).length==0)
	{
		errorAlert("You have not entered a username.  Please enter one and try again.",els["username"])
		return false
	}
	if (trim(els["password"].value).length==0)
	{
		errorAlert("You have not entered a password.  Please enter one and try again.",els["password"])
		return false
	}
	return true
}


function needUsernameAlert()
{
	generalAlert("If you do not have a WorkRoll account and would like one created for you, please contact <a href=\"mailto:"+adminEmail+"\">"+adminName+"</a> or another user with admistrator privileges.")
}

function gotoUrl(url)
{
	top.location.href=url
}

</script>

<style type="text/css">
body {background-repeat:repeat-x; background-image:url(images/homeBg.gif); }

#mainDiv {position:absolute; top:0px; left:0px; }
#fields {position:absolute; top:270px; left:275px; }
.inputText {font-weight:bold; margin-left:2px; color:#9e9e9e; background-color:#535353; width:150px; padding:3px; height:24px;  border: 1px solid #2e2e2e; font-size:14px; font-family:arial,helvetica; }
.formButton {xfont-weight:bold; margin-left:2px; background-color:#242424; color:#535353; border:1px solid #000000; height:24px; width:55px;  font-size:14px; font-family:arial,helvetica; }
.selectText {background-color:#858585; border: 1px solid #6A6A4F; font-size:15px; font-family:arial,helvetica; }
.bodyFont {color:#858585; font-family:arial,helvetica; font-size:12px;}
.linkFont {color:#ff9900; font-family:arial,helvetica; font-size:12px;}
</style>
</head>

<body bgcolor=#3b3b3b background=images/homeBg.gif>

<%
if (!currentlyLoggedIn)
{
	%>
		<form action=login/processLogin.jsp method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm> 
		<div id=mainDiv>
		<img src=images/homeHeader.gif width=872 height=246 border=0><BR>
	
		</div>
		
		<div id=fields>
		<table border=0 cellspacing=0 cellpadding=0>
		<tr>
		<td align=right><img src=images/homeUsername.gif height=14 width=75><br></td>
		<td><input class=inputText type=text name=username id=username value="<%=username%>"><br></td>
		<td valign=bottom><a href=# onclick="needUsernameAlert(); return false"><img src=images/homeNeedUsername.gif height=13 width=143 hspace=6 vspace=5 border=0></a><br></td>
		</tr>
		<tr><td><img src=images/spacer.gif height=3 width=2><BR></td></tr>
		<tr>
		<td align=right><img src=images/homePassword.gif height=14 width=75><br></td>
		<td><input class=inputText type=password name=password id=password value=""><br></td>
		<td valign=bottom><a href="login/forgotPassword.jsp"><img src=images/homeForgotPassword.gif height=13 width=143 hspace=6 vspace=5 border=0></a><br></td>
		</tr>
		<tr>
		<td align=right><img src=images/spacer.gif height=2 width=2><br></td>
		<td><img src=images/spacer.gif height=4 width=2><BR>
		<input type=submit class=formButton value="log in"><br></td>
		<td><img src=images/spacer.gif height=3 width=2><br></td>
		</tr>
		</table>
		</div>
		
		
		</form>
	<%
}
else
{
	%>
		<div id=mainDiv>
		<table border=0 cellspacing=0 cellpadding=0 width=872>
		<tr>
		<td align=center>
		<img src=images/homeHeader.gif width=872 height=246 border=0><BR>
		</td>
		</tr>
		<tr>
		<td align=left>
			<table border=0 cellspacing=0 cellpadding=0>
			<tr valign=top>
			<td nowrap width=300>
			</td>
			<td><span class=bodyFont>
			<img src=images/spacer.gif height=30 width=2><BR>
			<img src="images/pleaseChoose.gif" height=11 width=101 border=0><BR><BR>
			<a href="issues/index.jsp" class=linkFont>&nbsp;&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;View or manage issues</a><BR>
			<a href="userprefs/prefs.jsp" class=linkFont>&nbsp;&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;Configure your account settings</a><BR>
			<a href="admin/index.jsp" class=linkFont>&nbsp;&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;View or change application settings</a> (administrators only)<BR>
			<a href="#" onclick="launchHelp(); return false" class=linkFont>&nbsp;&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;Get help</a><BR>
			<a href="#" onclick="launchFeedback(false); return false" class=linkFont>&nbsp;&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;Send feedback</a><BR>
			<a href="#" onclick="launchFeedback(true); return false" class=linkFont>&nbsp;&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;Contact technical support</a><BR>
			<a href="login/logout.jsp" class=linkFont>&nbsp;&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;Log out</a><BR>
			<BR></span>
			</td>
			</tr>
			</table>
		</td>
		</tr>
		
		</table>
		</div>
		
		
		
	<%
}
%>



</html>

<%@ include file="global/bottomInclude.jsp" %>

<%
if (pageException!=null)
{
	%>
	<%@ include file="global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>

<% PageUtils.jspEnd(request); %>

