<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%

ArrayList allProjects=Manager.selectAllProjects();
if (allProjects==null)
{
	allProjects=new ArrayList();
}
String[] names=new String[allProjects.size()];
int[] ids=new int[allProjects.size()];


for (int i=0; i<allProjects.size(); i++)
{
	Project project=(Project)allProjects.get(i);
	names[i]=project.getName();
	ids[i]=project.getId();
}

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>


<script language="JavaScript">

var numProjects=<%=allProjects.size()%>
var doNotifications=<%=(controller.getCurrentInstallationConfig().isDoNotifications()?"true":"false")%>

function isValidForm(formObj)
{
	var els=formObj.elements
	// we have at least one Project; make sure that all Projects entered have all fields entered:
	for (var i=0; i<numProjects; i++)
	{
		var projectName=trim(els["name"+i].value)
		if (projectName.length==0)
		{
			errorAlert("You have left a name blank; all projects must have a name. Please fix and try again.",els["name"+i])
			return false
		}
	}
	if (duplicateProjectNamesInForm(formObj,numProjects))
	{
		return false
	}
	hidePageAndShowPleaseWait()
	return true
}

<% pageContext.include("js/js.jsp"); %>

</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>
                                     
<form action=processProjects.jsp method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm>
<input type=hidden name=numProjects id=numProjects value="<%=names.length%>">
<font class=bodyFont>

<span class=standardTextBlockWidth><span class=boldishFont>Edit projects here<%=HelpManager.helpLink("project",request)%></span>.If you've changed your mind and don't want to edit any projects right now, click the "cancel" button below.</span></span>
<%=HtmlUtils.doubleLB(request)%><BR>


<table border=0 cellspacing=0 cellpadding=0>
<%@ include file="projectsTableHeaderRow.jsp" %>



<%

for (int i=0; i<names.length; i++)
{
	%>
	<input type=hidden name=id<%=i%> id=id<%=i%> value="<%=ids[i]%>">
	<tr class=dataRow height=24>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	<td align=left><font class=columnDataFont>&nbsp;<input class=inputText type=text size=50 name=name<%=i%> id=name<%=i%> value="<%=names[i]%>">&nbsp;<BR></font></td>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	</tr> 
	<%=HtmlUtils.getHorizRuleTr(5, request)%>
	<%
}
  
%>

</table><BR>

<input  class=formButton type=submit value=change> <input  class=formButton type=button value=cancel onclick="location.href='menu.jsp'"><BR>

<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>

</form>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

