<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

 
<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.db.Manager" %>
<%@ page import="com.workroll.app.util.PageUtils" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.mail.Mailer" %>


<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_INSTALL,request); %>

<%@ include file="../../global/installTopInclude.jsp" %>

<%!


%>

<%
InstallationConfig installationConfig=controller.getCurrentInstallationConfig();
boolean javamailInstalled=Mailer.isJavaMailInstalled();
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../../global/headInclude.jsp" %>

<script language="JavaScript">

</script>

<style type="text/css">

</style>
</head>

<%@ include file="../../global/bodyOpen.jsp" %>

<div id=mainDiv><span class=standardTextBlockWidth>
<font class=bodyFont>
<%
if (javamailInstalled)
{






String smtpHost=null;
String smtpUsername=null;
String smtpPort=null;
String testAddr=null;
String initialNotificationPrefix=null;
String changeNotificationPrefix=null;
String reminderPrefix=null;

int successCode=Integer.parseInt(controller.getParam("successCode",""+Mailer.SUCCESS));

// if successCode==Mailer.SUCCESS then we're not returning to this page because of errors, so there are no
// paramaters on the q-string to get, so in case there is already stored mail-config info in
// the installationConfig object, set values on that basis:
if (successCode==Mailer.SUCCESS)
{
	smtpHost=(installationConfig.getSmtpHost()!=null?installationConfig.getSmtpHost():"");
	smtpUsername=(installationConfig.getSmtpUsername()!=null?installationConfig.getSmtpUsername():"");
	smtpPort=""+installationConfig.getSmtpPort();
	testAddr="";
	initialNotificationPrefix=(installationConfig.getMailSubjectPrefixInitialNotification()!=null?installationConfig.getMailSubjectPrefixInitialNotification():WorkRollConstants.DEFAULT_INITIAL_NOTIFICATION_PREFIX);
	changeNotificationPrefix=(installationConfig.getMailSubjectPrefixChangeNotification()!=null?installationConfig.getMailSubjectPrefixChangeNotification():WorkRollConstants.DEFAULT_CHANGE_NOTIFICATION_PREFIX);
	reminderPrefix=(installationConfig.getMailSubjectPrefixReminder()!=null?installationConfig.getMailSubjectPrefixReminder():WorkRollConstants.DEFAULT_REMINDER_PREFIX);
}
else // else there is stuff on the q-string and we should use that:
{
	smtpHost=controller.getParam("smtpHost");
	smtpUsername=controller.getParam("smtpUsername");
	smtpPort=controller.getParam("smtpPort");
	testAddr=controller.getParam("testAddr");
	initialNotificationPrefix=controller.getParam("initialNotificationPrefix");
	changeNotificationPrefix=controller.getParam("changeNotificationPrefix");
	reminderPrefix=controller.getParam("reminderPrefix");
	
	
}
 

	%>

	<% // Method is post because we don't want these initial config pages to be bookmarkable: %>
	<form method=post action=doJavamailTest.jsp>
	<%
	if (successCode==Mailer.SUCCESS)
	{
	%>
		<span class=firstSentenceFont>One more step, also optional.</span> WorkRoll can make use of your mail server to send notifications of new issues or changed issues, as well as reminders of approaching deadlines, to users.  Configuration is easy; if you're not sure whether your mail server is accessible to WorkRoll, give it a try by completing the form below and clicking the "test" button (to continue without configuring e-mail for now -- which is not necessary for WorkRoll to function -- click <a href="saveInstallationConfig.jsp">here</a>):<BR>
		<BR>
		<%
	}

	else // failure
	{
		%>
		<span class=firstSentenceFont>There was an unknown problem.</span>  One of the following may have occurred:
		<ul>
		<li>The e-mail address you entered (<%=testAddr%>) is not valid or was otherwise rejected by your outgoing mail server
		<li>The mail-server information you entered below is not accurate
		<li>Your outgoing mail server is offline
		<li>Your Internet or local-network connectivity has been disrupted such that your web-server machine cannot communicate with your outgoing mail server
		<li>Your outgoing mail server does not support the SMTP protocol (this is highly unlikely)
		<li>Your outgoing mail server requires authentication that is not supported by WorkRoll
		</ul>
		
		Please double-check your entries below and try again (by clicking the "test" button).  Or, if you prefer to put off e-mail configuration until later (or not to configure it at all; it is not necessary to configure notifications for this application to function), click <a href="saveInstallationConfig.jsp">here</a>.<%=HtmlUtils.doubleLB(request)%>
		<%
	}
	%>



	<span class=boldishFont>SMTP (outgoing) mail-server hostname</span> (for example, <i>mail.mydomain.com</i>):<BR>
	<input class=inputText type=text size=20 name=smtpHost id=smtpHost value="<%=smtpHost%>"><%=HtmlUtils.doubleLB(request)%>



	<span class=boldishFont>SMTP username<a href=#usernameDetails>*</a></span> (for example, <i>jsmith</i>):<BR>
	<input class=inputText type=text size=10 name=smtpUsername id=smtpUsername value="<%=smtpUsername%>"><%=HtmlUtils.doubleLB(request)%>



	<span class=boldishFont>Password for above username</span><BR>
	<input class=inputText type=password size=10 name=smtpPassword id=smtpPassword><%=HtmlUtils.doubleLB(request)%>

 

	<span class=boldishFont>Re-type password</span><BR>
	<input class=inputText type=password size=10 name=smtpPasswordRetyp id=smtpPasswordRetype><%=HtmlUtils.doubleLB(request)%>




	<span class=boldishFont>SMTP port number</span> (almost always <%=WorkRollConstants.DEFAULT_SMTP_PORT%>)<BR>
	<input class=inputText type=text size=4 name=smtpPort id=smtpPort value="<%=smtpPort%>"><%=HtmlUtils.doubleLB(request)%>
 


	<span class=boldishFont>E-mail address for JavaMail test<a href=#addrForTest>**</a></span><BR>
	<input class=inputText type=text size=60 name=testAddr id=testAddr value="<%=testAddr%>"><%=HtmlUtils.doubleLB(request)%>

<BR>
	<i>E-mail subject-line prefixes</i><BR><BR>
	You can choose to have the subject line of all notifications and reminders prefixed with text -- for example, <i><%=WorkRollConstants.DEFAULT_INITIAL_NOTIFICATION_PREFIX%></i> -- that will allow users to more easily filter and/or organize e-mails that they receive from this application.  If you do not wish to use such prefixes, simply leave the following three textboxes blank (you can always change them later):<%=HtmlUtils.doubleLB(request)%>
	<blockquote>

	<span class=boldishFont>Prefix for new-issue notifications</span><BR>
	<input class=inputText type=text size=35 name=initialNotificationPrefix id=initialNotificationPrefix value="<%=initialNotificationPrefix%>"><%=HtmlUtils.doubleLB(request)%>

	<span class=boldishFont>Prefix for changed-issue notifications</span><BR>
	<input class=inputText type=text size=35 name=changeNotificationPrefix id=changeNotificationPrefix value="<%=changeNotificationPrefix%>"><%=HtmlUtils.doubleLB(request)%>

	<span class=boldishFont>Prefix for issue reminders</span><BR>
	<input class=inputText type=text size=35 name=reminderPrefix id=reminderPrefix value="<%=reminderPrefix%>"><%=HtmlUtils.doubleLB(request)%>
	</blockquote><BR>
	
	
	
	<input  class=formButton type=submit size=4 value="test"><%=HtmlUtils.doubleLB(request)%>


	<a name=usernameDetails></a>*You may or may not want to create a user account on your mail server specifically for use by WorkRoll.  Note that when users receive mail notifications from WorkRoll, the messages will be from (for example) "John Smith via WorkRoll Message Dispatcher &lt;jsmith@mydomain.com&gt;"; additionally, in the above example, if the user replied to this message, the "reply-to" address would also be "jsmith@mydomain.com".  So you may wish to skip the hassle of setting up a new account and just use your own mail account; the choice will be transparent to users of WorkRoll.<%=HtmlUtils.doubleLB(request)%>



	<a name=addrForTest></a>**After you press "test," WorkRoll will attempt to send an e-mail message to the address you enter here; this should therefore be an e-mail address that you can check now.<%=HtmlUtils.doubleLB(request)%>

	<br>
	</form>
	<%
}
else
{
	%>
	<span class=firstSentenceFont>You don't have JavaMail installed on this server.</span> That's okay; it just means that you will not be able to take advantage of WorkRoll's e-mail notification capabilities.  If you'd like to install JavaMail, it's free, easy to install, and available <a href="http://java.sun.com/products/javamail/" target=_blank>here</a>.  If after installing JavaMail you'd like to configure WorkRoll to send e-mail notifications, simply go to the WorkRoll admin area (always accessible via the "admin" link in the top nav bar) after installing JavaMail.  (You'll probably need to re-start your application server first.)  Please click <a href="saveInstallationConfig.jsp">here</a> now to finish this installation.<%=HtmlUtils.doubleLB(request)%>

	<%
}
%>

</font></span>
</div>

<%@ include file="../../global/bodyClose.jsp" %>

</html>


<%@ include file="../../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

