<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%
InstallationConfig installationConfig=controller.getCurrentInstallationConfig();
String companyName=PageUtils.nonNull(installationConfig.getCompanyName());
String adminName=PageUtils.nonNull(installationConfig.getAdminName());
String adminEmail=PageUtils.nonNull(installationConfig.getAdminEmail());

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>

<script language="JavaScript">



function isValidForm(formObj)
{
	// don't allow submit more than once:
	if (window.formSubmitted)
	{
		return false;
	}
	var els=formObj.elements
		
	if (trim(els["adminName"].value).length==0)
	{
		errorAlert("You have not entered a primary-contact name. Please enter one and try again.",els["adminName"])
		return false
	}
	if (trim(els["adminEmail"].value).length==0)
	{
		errorAlert("You have not entered a primary-contact e-mail address. Please enter one and try again.",els["adminEmail"])
		return false
	}
	if (!isValidEmail(trim(els["adminEmail"].value)))
	{
		errorAlert("The primary-contact e-mail address you've entered (\""+trim(els["adminEmail"].value)+"\") is not valid. An example of a valid e-mail address is \"janedoe@somecompany.com\". Please enter one and try again.",els["adminEmail"])
		return false
	}

	window.formSubmitted=true
	hidePageAndShowPleaseWait()
	return true
}


 
</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>
<span class=standardTextBlockWidth>
<form action=processGeneralConfig.jsp method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm>

<font class=bodyFont>

<span class=firstSentenceFont>Please make general changes<%=HelpManager.helpLink("generalPreferences",request)%></span> to the application's configuration here, then press the "change" button. If you've changed your mind and don't want to make any changes right now, click the "cancel" button below.<%=HtmlUtils.doubleLB(request)%>

Note: you are asked for the name and e-mail address of the "primary contact" below.  The name and e-mail address of this person will be available to all WorkRoll users, who will be directed to send mail to this person regarding tasks that can only be performed by a user with administrator rights.  These fields should therefore refer to a user who has WorkRoll administrator privileges, although this is not required.<%=HtmlUtils.doubleLB(request)%><BR>

<span class=boldishFont>"Registered-to" name</span> (optional; for display in "registered-to" section of header if the application has been registered; you may enter a value here even if you have not purchased a WorkRoll license)<BR>
<input class=inputText type=text size=60 name=companyName id=companyName value="<%=companyName%>"><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>Primary contact name<%=HelpManager.helpLink("primaryContact",request)%></span><BR>
<input class=inputText type=text size=60 name=adminName id=adminName value="<%=adminName%>"><%=HtmlUtils.doubleLB(request)%>
<span class=boldishFont>Primary contact e-mail<%=HelpManager.helpLink("primaryContact",request)%></span><BR>
<input class=inputText type=text size=60 name=adminEmail id=adminEmail value="<%=adminEmail%>"><%=HtmlUtils.doubleLB(request)%>
<BR>




<BR>
<input  class=formButton type=submit value=change> <input  class=formButton type=button value=cancel onclick="location.href='menu.jsp'"><BR>

<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>

</form></span>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

