<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%! 
static final int NUM_PROJECTS_ADD_AT_ONCE=10;
%>

<% 

 
String[] names=new String[NUM_PROJECTS_ADD_AT_ONCE];

for (int i=0; i<NUM_PROJECTS_ADD_AT_ONCE; i++)
{
	names[i]="";
}

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>

<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>

<script language="JavaScript">

var NUM_PROJECTS_ADD_AT_ONCE=<%=NUM_PROJECTS_ADD_AT_ONCE%>

<% pageContext.include("includes/writeAllProjectNamesArray.jsp?jsVarName=allProjectNames"); %>

function isValidForm(formObj)
{
	if (noProjectsEntered(formObj,NUM_PROJECTS_ADD_AT_ONCE))
	{
		return false
	}
	var els=formObj.elements
	// we have at least one Project; make sure that all Projects entered have all fields entered:
	for (var i=0; i<NUM_PROJECTS_ADD_AT_ONCE; i++)
	{
		// no tests needed here; the only reqd field is "name".
	}
	// user tried to add an Project name that was already in the db:
	if (duplicateProjectNameFound(formObj,NUM_PROJECTS_ADD_AT_ONCE))
	{
		return false
	}
	// user tried to add two Projects with the same username:
	if (duplicateProjectNamesInForm(formObj,NUM_PROJECTS_ADD_AT_ONCE))
	{
		return false
	}
	hidePageAndShowPleaseWait()
	return true
}

<% pageContext.include("js/js.jsp"); %>
</script>

<style type="text/css">
 
</style> 
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>

<form action=processAddProjects.jsp method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm>
<input type=hidden name=numProjects id=numProjects value="<%=names.length%>">
<font class=bodyFont>
<span class=standardTextBlockWidth>
<span class=firstSentenceFont>Add projects here<%=HelpManager.helpLink("project",request)%>.</span> You may add up to <%=NUM_PROJECTS_ADD_AT_ONCE%> projects at a time. If you need to add fewer than that, leave the unneeded project rows blank. When you're read to add the projects, click the "add" button. If you've changed your mind and don't want to add any projects right now, click the "cancel" button below.</span><%=HtmlUtils.doubleLB(request)%><BR> 

<table border=0 cellspacing=0 cellpadding=0>
<%@ include file="projectsTableHeaderRow.jsp" %>



<% 

for (int i=0; i<NUM_PROJECTS_ADD_AT_ONCE; i++)
{
	%>
	<tr class=<%=((((double)i/2)==(double)((int)(i/2)))?"evenDataRow":"oddDataRow")%> height=24>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	<td align=left><font class=columnDataFont>&nbsp;<input class=inputText type=text size=50 name=name<%=i%> id=name<%=i%> value="<%=names[i]%>">&nbsp;<BR></font></td>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	</tr>
	<%=HtmlUtils.getHorizRuleTr(5, request)%>
	<%
}
 
%>

</table><BR>

<input  class=formButton type=submit value=add> <input  class=formButton type=button value=cancel onclick="location.href='menu.jsp'"><BR>

<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>

</form>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>





<% PageUtils.jspEnd(request); %>

