<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>

 
<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%! 
static final int NUM_INSTANCES_ADD_AT_ONCE=10;
%>

<%


String[] names=new String[NUM_INSTANCES_ADD_AT_ONCE];
String[] rootUrls=new String[NUM_INSTANCES_ADD_AT_ONCE];

for (int i=0; i<NUM_INSTANCES_ADD_AT_ONCE; i++)
{
	names[i]="";
	rootUrls[i]="http://";
}

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>

<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>

<script language="JavaScript">

var NUM_INSTANCES_ADD_AT_ONCE=<%=NUM_INSTANCES_ADD_AT_ONCE%>

<% pageContext.include("includes/writeAllInstanceNamesArray.jsp?jsVarName=allInstanceNames"); %>

function isValidForm(formObj)
{
	if (noInstancesEntered(formObj,NUM_INSTANCES_ADD_AT_ONCE))
	{
		return false
	}
	var els=formObj.elements
	// we have at least one instance; make sure that all instances entered have all fields entered:
	for (var i=0; i<NUM_INSTANCES_ADD_AT_ONCE; i++)
	{
		// no tests needed here; the only reqd field is "name".
	}
	// user tried to add an instance name that was already in the db:
	if (duplicateInstanceNameFound(formObj,NUM_INSTANCES_ADD_AT_ONCE))
	{
		return false
	}
	// user tried to add two instances with the same username:
	if (duplicateInstanceNamesInForm(formObj,NUM_INSTANCES_ADD_AT_ONCE))
	{
		return false
	}	
	hidePageAndShowPleaseWait()
	return true
}

<% pageContext.include("js/js.jsp"); %>
</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>

<form action=processAddInstances.jsp method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm>
<input type=hidden name=numInstances id=numInstances value="<%=names.length%>">
<font class=bodyFont>
<span class=standardTextBlockWidth>
<span class=firstSentenceFont>Add instances here<%=HelpManager.helpLink("instance",request)%>.</span> You may add up to <%=NUM_INSTANCES_ADD_AT_ONCE%> instances at a time. If you need to add fewer than that, leave the unneeded instance rows blank. When you're read to add the instances, make sure you've made note of the passwords you've assigned, then click the "add" button. If you've changed your mind and don't want to add any instances right now, click the "cancel" button below.</span><%=HtmlUtils.doubleLB(request)%><BR>

<table border=0 cellspacing=0 cellpadding=0>
<%@ include file="instancesTableHeaderRow.jsp" %>



<% 

for (int i=0; i<NUM_INSTANCES_ADD_AT_ONCE; i++)
{

	%>
	<tr class=<%=((((double)i/2)==(double)((int)(i/2)))?"evenDataRow":"oddDataRow")%> height=24>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	<td align=left><font class=columnDataFont>&nbsp;<input class=inputText type=text size=25 name=name<%=i%> id=name<%=i%> value="<%=names[i]%>"><BR></font></td>
	<td align=left><font class=columnDataFont>&nbsp;<input class=inputText type=text size=45 name=rootUrl<%=i%> id=rootUrl<%=i%> value="<%=rootUrls[i]%>">&nbsp;<BR></font></td>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	</tr>
	<%=HtmlUtils.getHorizRuleTr(4, request)%>
	<%
}

%>

</table><BR>

<input class=formButton type=submit value=add> <input  class=formButton type=button value=cancel onclick="location.href='menu.jsp'"><BR>

<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>

</form>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>





<% PageUtils.jspEnd(request); %>

