VERSION 5.00
Begin VB.Form frmStats 
   BorderStyle     =   5  'Sizable ToolWindow
   Caption         =   "Date Statistics"
   ClientHeight    =   3510
   ClientLeft      =   1890
   ClientTop       =   1890
   ClientWidth     =   2655
   Icon            =   "frmStats.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3510
   ScaleWidth      =   2655
   ShowInTaskbar   =   0   'False
   Begin VB.CommandButton Command2 
      Caption         =   "Months"
      Height          =   255
      Left            =   870
      TabIndex        =   2
      Top             =   150
      Width           =   765
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Close"
      Height          =   255
      Left            =   1920
      TabIndex        =   1
      Top             =   150
      Width           =   615
   End
   Begin VB.TextBox Text1 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   2865
      Left            =   90
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      TabStop         =   0   'False
      Text            =   "frmStats.frx":014A
      Top             =   570
      Width           =   2500
   End
End
Attribute VB_Name = "frmStats"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'frmStats demonstrates the DateStatistics. PriorMonths and LaterMonths
'Properties of the Universal Calendar ActiveX Control.
'Copyright(c)1999 David Breedlove All Rights Reserved

Option Explicit
Private bStats As Boolean
Public sStats As String, sMonths As String

Private Sub Command1_Click()
    Unload Me
End Sub

Private Sub Command2_Click()
    Dim d As Date, i As Integer, s As String, v As Variant
    bStats = Not bStats
    Command2.Caption = IIf(bStats, "Months", "Stats")
    Caption = IIf(bStats, "Date Statistics", "Next/Previous Months")
    RefreshText
End Sub

Public Sub RefreshText()
    Dim ds As Date, d As Date, i As Integer, s As String, v As Variant
    Dim aDayAbs
    Dim iCTYP As Integer, iFDOW As Integer, iFMOY As Integer, iLOFM As Integer, iFWIY As Integer
    Dim aTypes, aDays, aMonths, aLengths, aFWIY
    Dim sCTYP As String, sFDOW As String, sFMOY As String, sLOFM As String, sFWIY As String
    Dim sWeekDay As String, iWeekDay As Integer
    Dim sWeekdayNumberOfMonth As String, sWeekdayNumberOfQuarter As String, sWeekdayNumberOfYear As String
    
    aTypes = Array("Fiscal", "Regular")
    aDays = Array("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday")
    aMonths = Array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December")
    aLengths = Array("4-4-5", "13x4")
    aFWIY = Array("1+", "2+", "3+", "4+", "5+", "6+", "7")
    aDayAbs = Array("", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat")
    
    With frmCtl.UCalCtl1
        iCTYP = .CalendarType
        iFDOW = .FirstDayOfWeek
        iFMOY = .FirstMonthOfYear
        iLOFM = .LengthOfFiscalMonth
        iFWIY = .FirstWeekInYear
        sCTYP = aTypes(iCTYP - 1)
        sFDOW = aDays(iFDOW - 1)
        sFMOY = aMonths(iFMOY - 1)
        sLOFM = aLengths(iLOFM - 1)
        sFWIY = aFWIY(iFWIY - 1)
        iWeekDay = WeekDay(.DateSelected)
        sWeekDay = aDays(iWeekDay - 1)
        sWeekdayNumberOfMonth = sWeekDay & " #" & CStr(Int(.WeekdayNumberInMonth / 100)) & " in Month"
        If iCTYP = 2 Or iLOFM = 1 Then
            sWeekdayNumberOfQuarter = sWeekDay & " #" & CStr(Int(.WeekdayNumberInQuarter / 100)) & " in Quarter"
        Else
            sWeekdayNumberOfQuarter = sWeekDay & " #0" & " in Quarter (N/A)"
        End If
        sWeekdayNumberOfYear = sWeekDay & " #" & CStr(Int(.WeekdayNumberInYear / 100)) & " in Year"
        
        sStats = _
            "DateSelected: " & .DateSelected & vbCrLf & _
            "IsDateAHoliday: " & .IsDateAHoliday(.DateSelected) & vbCrLf & _
            "CalendarType: " & sCTYP & vbCrLf & _
            "FirstDayOfWeek: " & sFDOW & vbCrLf & _
            "FirstMonthOfYear: " & sFMOY & vbCrLf & _
            "LengthOfFiscalMonth: " & sLOFM & vbCrLf & _
            "FirstWeekInYear: " & sFWIY & vbCrLf & vbCrLf & _
            "DaysInYear: " & .DaysInYear & vbCrLf & _
            "DayOfYear: " & .DayOfYear & vbCrLf & _
            sWeekdayNumberOfMonth & vbCrLf & _
            sWeekdayNumberOfQuarter & vbCrLf & _
            sWeekdayNumberOfYear & vbCrLf & _
            "WeekNumber: " & IIf(iCTYP = 2, "N/A", .WeekNumber) & vbCrLf & _
            "WeeksInMonth: " & IIf(iCTYP = 2, "N/A", .WeeksInMonth) & vbCrLf & _
            "WeekOfMonth: " & IIf(iCTYP = 2, "N/A", .WeekOfMonth) & vbCrLf & _
            "MonthNumber: " & .MonthNumber & vbCrLf & _
            "QuarterNumber: " & IIf(iCTYP = 1 And iLOFM = 2, "N/A", .QuarterNumber) & vbCrLf & _
            "YearNumber: " & .YearNumber & vbCrLf & vbCrLf
        sStats = sStats & _
            "BeginWeek: " & .BeginWeek & vbCrLf & _
            "EndOfWeek: " & .EndOfWeek & vbCrLf & _
            "NextWeek: " & .NextWeek & vbCrLf & _
            "PreviousWeek: " & .PreviousWeek & vbCrLf & vbCrLf & _
            "BeginMonth: " & .BeginMonth & vbCrLf & _
            "EndOfMonth: " & .EndOfMonth & vbCrLf & _
            "NextMonth: " & .NextMonth & vbCrLf & _
            "PreviousMonth: " & .PreviousMonth & vbCrLf & vbCrLf & _
            "BeginQuarter: " & IIf(iCTYP = 1 Or iLOFM = 1, .BeginQuarter, "N/A") & vbCrLf & _
            "EndOfQuarter: " & IIf(iCTYP = 1 Or iLOFM = 1, .EndOfQuarter, "N/A") & vbCrLf & _
            "NextQuarter: " & IIf(iCTYP = 1 Or iLOFM = 1, .NextQuarter, "N/A") & vbCrLf & _
            "PreviousQuarter: " & IIf(iCTYP = 1 Or iLOFM = 1, .PreviousQuarter, "N/A") & vbCrLf & vbCrLf & _
            "BeginYear: " & .BeginYear & vbCrLf & _
            "EndOfYear: " & .EndOfYear & vbCrLf & _
            "NextYear: " & .NextYear & vbCrLf & _
            "PreviousYear: " & .PreviousYear
        
        ds = .DateSelected
        sMonths = "Prior Months:" & vbCrLf
        v = .PriorMonths
        For i = UBound(v) To 0 Step -1
            If v(i) = 0 Then
                'date was out of range
                sMonths = sMonths & "Out of Range" & vbCrLf
            Else
                d = DateAdd("d", v(i), ds)
                sMonths = sMonths & aDayAbs(WeekDay(d)) & " " & Format(d, "Medium Date") & vbCrLf
            End If
        Next i
        sMonths = sMonths & vbCrLf & Format(ds, "Long Date") & vbCrLf & vbCrLf
        sMonths = sMonths & "Later Months:" & vbCrLf
        v = .LaterMonths
        For i = 0 To UBound(v)
            If v(i) = 0 Then
                sMonths = sMonths & "Out of Range" & vbCrLf
            Else
                d = DateAdd("d", v(i), ds)
                sMonths = sMonths & aDayAbs(WeekDay(d)) & " " & Format(d, "Medium Date") & vbCrLf
            End If
        Next i
    End With
    Text1.Text = IIf(bStats, sStats, sMonths)
End Sub

Private Sub Form_Activate()
    RefreshText
End Sub

Private Sub Form_Load()
    bStats = True
    With gwsStats
        TOP = .TOP
        LEFT = .LEFT
        HEIGHT = .HEIGHT
    End With
End Sub

Private Sub Form_Resize()
    WIDTH = 2775
    Text1.HEIGHT = ScaleHeight - Text1.TOP
End Sub
