VERSION 5.00
Object = "{C0A58BC3-1600-4C2C-8DDB-2DD7FDE5CA63}#1.0#0"; "vbalIml200_75B4A91C.ocx"
Object = "{23F895D7-45A6-4886-931B-89D88C2857ED}#1.0#0"; "iGrid250_75B4A91C.ocx"
Begin VB.Form frmMain 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "iGrid Demonstrator Control Center"
   ClientHeight    =   7500
   ClientLeft      =   195
   ClientTop       =   435
   ClientWidth     =   9690
   Icon            =   "Main.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   MouseIcon       =   "Main.frx":0442
   ScaleHeight     =   7500
   ScaleWidth      =   9690
   Begin VB.PictureBox picBackground 
      Height          =   495
      Left            =   5580
      Picture         =   "Main.frx":074C
      ScaleHeight     =   435
      ScaleWidth      =   1155
      TabIndex        =   2
      Top             =   6960
      Visible         =   0   'False
      Width           =   1215
   End
   Begin vbalIml200_75B4A91C.vbalImageList ImgList 
      Left            =   7980
      Top             =   6840
      _ExtentX        =   953
      _ExtentY        =   953
      Size            =   2296
      Images          =   "Main.frx":1544
      Version         =   131072
      KeyCount        =   2
      Keys            =   ""
   End
   Begin VB.CheckBox chkTip 
      Caption         =   "Show Tips that Explain How Some Demos Work"
      Height          =   375
      Left            =   180
      TabIndex        =   0
      Top             =   7020
      Width           =   3735
   End
   Begin iGrid250_75B4A91C.iGrid grdDemos 
      Height          =   6795
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   9435
      _ExtentX        =   16642
      _ExtentY        =   11986
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Type tagInitCommonControlsEx
   lngSize As Long
   lngICC As Long
End Type
Private Declare Function InitCommonControlsEx Lib "comctl32.dll" _
   (iccex As tagInitCommonControlsEx) As Boolean
Private Const ICC_USEREX_CLASSES = &H200


Private Const GAP_SIZE = 7

Dim m_GroupFont As StdFont
Dim m_hGroupFont As Long
Dim m_ButtonFont As StdFont
Dim m_hButtonFont As Long

Dim m_lMouseRow As Long
Dim m_lMouseCol As Long

Private Enum EButtonState
   bsNormal
   bsHot
   bsPushed
End Enum
Dim m_eButtonState As EButtonState

Dim m_lExpandedGroupRow As Long

Public Function InitCommonControlsVB() As Boolean
   On Error Resume Next
   Dim iccex As tagInitCommonControlsEx
   ' Ensure CC available:
   With iccex
       .lngSize = LenB(iccex)
       .lngICC = ICC_USEREX_CLASSES
   End With
   InitCommonControlsEx iccex
   InitCommonControlsVB = (Err.Number = 0)
   On Error GoTo 0
End Function

Private Sub chkTip_Click()
   SaveSetting APP_ID, "Main", "ShowTips", chkTip
End Sub

Private Sub Form_Initialize()
   InitCommonControlsVB
End Sub

'===============================================================

Private Sub pAddDemoGroup(psTitle As String)
   With grdDemos
      .AddRow bGroupRow:=True
      .CellValue(.RowCount, "group") = psTitle
      .RowHeight(.RowCount) = 26
   End With
End Sub

Private Sub pAddDemo(psTitle As String, psDescr As String, pForm As Form, Optional ByVal pbVisible As Boolean = False)
   With grdDemos
      .AddRow lHeight:=GAP_SIZE, bVisible:=pbVisible
      .AddRow vTag:=pForm, bVisible:=pbVisible
      .CellValue(.RowCount, "button") = psTitle
      .CellValue(.RowCount, "descr") = psDescr
      .RowHeight(.RowCount) = 46
      .AddRow lHeight:=GAP_SIZE, bVisible:=pbVisible
   End With
End Sub

Private Sub Form_Load()
   Dim iRow As Long
   Dim fnt As StdFont
   Dim iFnt As IFont
   
   gsTipsFile = App.Path & "\iGridDemo.tips"
   chkTip = CLng(GetSetting(APP_ID, "Main", "ShowTips", "1"))
   
   m_lExpandedGroupRow = 1
   
   Set m_GroupFont = New StdFont
   With m_GroupFont
      .Name = "Tahoma"
      .Size = 10
      .Bold = True
   End With
   Set iFnt = m_GroupFont
   m_hGroupFont = iFnt.hFont
   
   Set m_ButtonFont = New StdFont
   With m_ButtonFont
      .Name = "Tahoma"
      .Size = 10
   End With
   Set iFnt = m_ButtonFont
   m_hButtonFont = iFnt.hFont
   
   With grdDemos
      .Redraw = False
      
      .Editable = False
      .Header.Visible = False
      .BorderStyle = igBorderThin
      .ForeColor = vbBlack
      .BackColor = RGB(248, 248, 248) 'vbWhite
      .DrawRowText = False
      .GridLines = igGridLinesNone
      Set .BackgroundPicture = picBackground
      
      .Font.Name = "Tahoma"
      .Font.Size = 10
      
      Set fnt = New StdFont
      fnt.Name = "Tahoma"
      fnt.Size = 10
      fnt.Bold = True
      
      .AddCol sKey:="gap1", lWidth:=GAP_SIZE
      .AddCol(sKey:="button", lWidth:=160).eType = igCellCustomDraw
      .AddCol sKey:="gap2", lWidth:=GAP_SIZE
      .AddCol(sKey:="descr").eTextFlags = igTextWordBreak
      .ColWidth("descr") = grdDemos.Width / Screen.TwipsPerPixelX - .ColWidth("button") - 2 - GAP_SIZE * 3
      .AddCol sKey:="gap3", lWidth:=GAP_SIZE
      .AddCol(sKey:="group", bRowTextCol:=True).eType = igCellCustomDraw
      
      pAddDemoGroup "Full-featured Demos"
      pAddDemo "My Customers", "This sample demonstrates basic techniques of using iGrid and its programming.", frmMyCust, True
      pAddDemo "Outlook Style Demo", "In this sample you can see how iGrid can emulate the Outlook messages list, including grouping of messages and message preview.", frmOutlookDemo, True
      pAddDemo "Property Editor", "Demonstrates how you can use cells of different types (textbox and combobox cells) in the same column.", frmPropEd, True
      
      pAddDemoGroup "iGrid 2.5 New Features"
      pAddDemo "OLE Drag-n-drop", "You can drag objects form and to other Windows applications using new OLE Drag-n-drop related features.", frmOLEDnD2iG
      pAddDemo "Playing with Scroll Bars", "iGrid 2.5 has some new properties and events you can use to work with its scroll bars. This demo allows you to playing around with them.", frmScrlBars
      pAddDemo "Custom Sorting", "Now you can define your own sort criteria, highlight odd and even rows and specify your own colors for iGrid header. Check this demo for further details.", frmCustomSort
      pAddDemo "Customizing iGrid Header", "iGrid 2.5 allows you to adjust a lot of header options. This demo demonstrates it.", frmCustomizeHdr
      
      pAddDemoGroup "Ideas for Your Apps"
      pAddDemo "Option Multiselect", "An attractive menu with the multiselection ability you can implement using iGrid.", frmOptMult
      pAddDemo "TreeView", "iGrid features can be used to implement an interface with a fully customizable treeview functionality.", frmCustomTree
      
      pAddDemoGroup "Browsing Databases and Virtual Mode"
      pAddDemo "Browsing ADO Recordsets", "Shows how you can browse an ADO recordset. You need to have MS ADO 2.5 or higher in order to use this features.", frmDB
      pAddDemo "Virtual Grid", "Demonstrates iGrid virtual mode. In this mode iGrid requests new rows whenever they need to be displayed.", frmVirtual
      pAddDemo "Remote Databases", "iGrid virtual mode can be used to browse remote databases. This demo provides you with an idea how to implement it.", frmVMFORS
      
      pAddDemoGroup "Using Particular Features"
      pAddDemo "Custom Draw Cells", "Shows how you can create cells drawn by yourself.", frmCustomDraw
      pAddDemo "Multiple Columns Sort", "iGrid allows you to sort its contents by several columns simultaneously. You can see it in this sample.", frmMultiColSort
      pAddDemo "Built-in Memory Manager", "You can greatly reduce the time of adding rows to iGrid using its memory manager. See how it works in this demo!", frmMemMng
      pAddDemo "Fun-n-Games with iGrid", "In this demo you can play with a lot of options available in iGrid.", frmFunNGames
      
      .Redraw = True
   End With
End Sub

Private Sub Form_Unload(Cancel As Integer)
   Dim v
   For Each v In Forms
      Unload v
   Next
End Sub

Private Sub grdDemos_CustomDrawCell(ByVal lRow As Long, ByVal lCol As Long, ByVal hdc As Long, ByVal lLeft As Long, ByVal lTop As Long, ByVal lRight As Long, ByVal lBottom As Long, ByVal bSelected As Boolean)
   If grdDemos.RowIsGroup(lRow) Then
      pDrawGroup lRow, hdc, lLeft, lTop, lRight, lBottom
   Else
      If Len(grdDemos.CellValue(lRow, lCol)) > 0 Then
         pDrawButton lRow, hdc, lLeft, lTop, lRight, lBottom
      End If
   End If
End Sub

Private Sub pDrawButton(ByVal lRow As Long, ByVal hdc As Long, ByVal lLeft As Long, ByVal lTop As Long, ByVal lRight As Long, ByVal lBottom As Long)
   Dim rc As RECT
   Dim hPen As Long
   Dim hOldPen As Long
   Dim hOldFont As Long
   Dim hBr As Long
   Dim eThisButtonState As EButtonState
   
   Const LIGHT_BORDER = vbWhite
   Const DARK_BORDER = &HC0C0C0
   
   rc.Left = lLeft
   rc.Top = lTop
   rc.Right = lRight
   rc.Bottom = lBottom
   
   If lRow = m_lMouseRow Then
      eThisButtonState = m_eButtonState
   End If
   
   ' ------------- highlight cell (if required) ---------------
   If (eThisButtonState = bsHot Or eThisButtonState = bsPushed) Then
      hBr = CreateSolidBrush(RGB(255, 255, 225))
      FillRect hdc, rc, hBr
      DeleteObject hBr
   End If
   
   ' ------------- drawing button border ---------------
   MoveToEx hdc, lLeft, lBottom - 1, ByVal 0
   hPen = CreatePen(PS_SOLID, 1, IIf(eThisButtonState = bsPushed, DARK_BORDER, LIGHT_BORDER))
   hOldPen = SelectObject(hdc, hPen)
   LineTo hdc, lLeft, lTop
   LineTo hdc, lRight, lTop
   SelectObject hdc, hOldPen
   DeleteObject hPen
   
   MoveToEx hdc, lRight - 1, lTop, ByVal 0
   hPen = CreatePen(PS_SOLID, 1, IIf(eThisButtonState = bsPushed, LIGHT_BORDER, DARK_BORDER))
   hOldPen = SelectObject(hdc, hPen)
   LineTo hdc, lRight - 1, lBottom - 1
   LineTo hdc, lLeft, lBottom - 1
   SelectObject hdc, hOldPen
   DeleteObject hPen
   
   ' ------------- drawing button caption ---------------
   hOldFont = SelectObject(hdc, m_hButtonFont)
   
   If eThisButtonState = bsPushed Then
      OffsetRect rc, 1, 1
   End If
   
   SetBkMode hdc, TRANSPARENT
   SetTextColor hdc, TranslateColor(RGB(0, 0, 192))
   DrawText hdc, grdDemos.CellValue(lRow, "button"), -1, rc, DT_SINGLELINE Or DT_VCENTER Or DT_CENTER
   
   SelectObject hdc, hOldFont
End Sub

Private Sub pDrawGroup(ByVal lRow As Long, ByVal hdc As Long, ByVal lLeft As Long, ByVal lTop As Long, ByVal lRight As Long, ByVal lBottom As Long)
   Dim rc As RECT
   Dim hOldFont As Long
   Dim i As Long
   Dim hBr As Long
   Dim eThisButtonState As EButtonState

   Const BORDER = 5
   Const DELTA = 15
   
   rc.Left = lLeft
   rc.Right = lRight
   
   If lRow = m_lMouseRow Then
      eThisButtonState = m_eButtonState
   End If
   
   ' ----------- drawing background -------------------
   For i = 0 To BORDER
      hBr = CreateSolidBrush(RGB(150 - (BORDER - i + 1) * DELTA, 190 - (BORDER - i + 1) * DELTA, 255 - (BORDER - i + 1) * DELTA))
      rc.Top = lTop + i
      rc.Bottom = rc.Top + 1
      FillRect hdc, rc, hBr
      rc.Top = lBottom - i - 2
      rc.Bottom = rc.Top + 1
      FillRect hdc, rc, hBr
      DeleteObject hBr
   Next
   
   rc.Top = lTop + BORDER + 1
   rc.Bottom = lBottom - (BORDER + 2)
   hBr = CreateSolidBrush(RGB(150, 190, 255))
   FillRect hdc, rc, hBr
   DeleteObject hBr

   ' ----------- drawing expanded/collapsed icon -------------------
   If lRow = m_lExpandedGroupRow Then
      ImgList.DrawImage 1, hdc, 5, 5
   Else
      ImgList.DrawImage 2, hdc, 5, 5
   End If
   
   ' ----------- drawing text -------------------
   rc.Left = lLeft + 25
   rc.Top = lTop + BORDER - 1
   rc.Right = lRight
   rc.Bottom = lBottom - BORDER
   
   hOldFont = SelectObject(hdc, m_hGroupFont)
   
   SetBkMode hdc, TRANSPARENT
   If eThisButtonState = bsHot Then
      OffsetRect rc, 1, 1
      SetTextColor hdc, RGB(144, 144, 144)
      DrawText hdc, grdDemos.CellValue(lRow, "group"), -1, rc, DT_LEFT
      OffsetRect rc, -1, -1
   End If
   SetTextColor hdc, IIf(eThisButtonState = bsHot, vbWhite, vbBlack)
   DrawText hdc, grdDemos.CellValue(lRow, "group"), -1, rc, DT_LEFT
   
   SelectObject hdc, hOldFont
End Sub

Private Sub grdDemos_MouseEnter(ByVal lRow As Long, ByVal lCol As Long)
   m_lMouseRow = lRow
   m_lMouseCol = lCol
   
   Select Case grdDemos.ColKey(lCol)
   Case "button"
      If Len(grdDemos.CellValue(lRow, lCol)) > 0 Then
         m_eButtonState = bsHot
         grdDemos.DrawCell lRow, lCol
      End If
   Case "group"
      m_eButtonState = bsHot
      MousePointer = vbCustom
      grdDemos.DrawCell lRow, lCol
   End Select
End Sub

Private Sub grdDemos_MouseLeave(ByVal lRow As Long, ByVal lCol As Long)
   If m_eButtonState = bsHot Then
      m_eButtonState = bsNormal
      grdDemos.DrawCell m_lMouseRow, m_lMouseCol
      MousePointer = vbDefault
   End If
   
   m_lMouseRow = 0
   m_lMouseCol = 0
End Sub

Private Sub grdDemos_MouseDown(ByVal Button As Integer, Shift As Integer, ByVal x As Single, ByVal y As Single, ByVal lRow As Long, ByVal lCol As Long, bDoDefault As Boolean, ByVal bUnderControl As Boolean)
   bDoDefault = False
   
   If grdDemos.ColKey(lCol) = "group" Then
      pExpandGroup lRow
   Else
      If m_eButtonState = bsHot Then
         m_eButtonState = bsPushed
         grdDemos.DrawCell m_lMouseRow, m_lMouseCol
      End If
   End If
End Sub

Private Sub pButtonClick()
   grdDemos.RowTag(m_lMouseRow).Show ' row tag stores the reference to the corresponding form
End Sub

Private Sub pExpandGroup(ByVal plExpandGroupRow As Long)
   Dim iRow As Long
   Dim bVisible As Boolean
   
   If m_lExpandedGroupRow = plExpandGroupRow Then Exit Sub
   
   PlaySound App.Path & "\expand.wav", 0&, SND_ASYNC Or SND_FILENAME
   
   m_lExpandedGroupRow = plExpandGroupRow

   With grdDemos
      .Redraw = False
      
      For iRow = 1 To .RowCount
         If .RowIsGroup(iRow) Then
            bVisible = iRow = plExpandGroupRow
         Else
            .RowVisible(iRow) = bVisible
         End If
      Next
      
      .Redraw = True
   End With
End Sub

Private Sub grdDemos_MouseUp(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Single, ByVal y As Single, ByVal lRow As Long, ByVal lCol As Long, bDoDefault As Boolean)
   If m_eButtonState = bsPushed Then
      m_eButtonState = bsHot
      grdDemos.DrawCell m_lMouseRow, m_lMouseCol
      pButtonClick
   End If
End Sub
