/*
 * Decompiled with CFR 0.152.
 */
package stec.ss;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Hashtable;
import stec.ss.ssCookie;
import stec.ss.ssException;
import stec.ss.ssSystem;

abstract class ssResponse {
    protected static final int status_ok = 200;
    protected static final int status_created = 201;
    protected static final int status_accepted = 202;
    protected static final int status_partial_information = 203;
    protected static final int status_no_content = 204;
    protected static final int status_moved_permanently = 301;
    protected static final int status_moved_temporarily = 302;
    protected static final int status_not_modified = 304;
    protected static final int status_bad_request = 400;
    protected static final int status_unauthorized = 401;
    protected static final int status_forbidden = 403;
    protected static final int status_not_found = 404;
    protected static final int status_internal_server_error = 500;
    protected static final int status_not_implemented = 501;
    protected static final int status_bad_gateway = 502;
    protected static final int status_gateway_timeout = 503;
    protected boolean headerSent = false;
    protected long content_length = 0L;
    protected Hashtable headers = null;
    protected Hashtable cookies = null;
    protected ByteArrayOutputStream bufferedOutputStream = null;
    protected boolean isBuffered = false;
    protected int status = 200;
    protected String charset = null;
    protected String content_type = "text/html";
    protected long last_modified = -1L;
    protected long expires = -1L;
    protected String content_encoding = null;
    protected boolean cache_content = false;
    protected boolean isRaw = false;
    protected OutputStream os;
    protected ssSystem system;

    protected ssResponse(ssSystem _system) {
        this.system = _system;
    }

    protected final void setStatus(int _status) {
        this.status = _status;
    }

    protected final int getStatus() {
        return this.status;
    }

    protected final long getContentLength() {
        if (this.bufferedOutputStream == null) {
            return this.content_length;
        }
        return this.content_length + (long)this.bufferedOutputStream.size();
    }

    protected final void setContentLength(long _content_length) {
        this.content_length = _content_length;
    }

    protected static final String encode(String s) {
        return URLEncoder.encode(s);
    }

    protected final Hashtable Headers() throws ssException {
        if (this.headers != null) {
            return this.headers;
        }
        if (!this.system.gListOption && this.content_length > (long)0) {
            throw new ssException(19, "Headers()");
        }
        this.headers = new Hashtable();
        return this.headers;
    }

    protected final String Headers(String name) throws ssException {
        Hashtable ht = this.Headers();
        if (ht == null) {
            return null;
        }
        Object header = ht.get(name);
        if (header == null) {
            return null;
        }
        return (String)header;
    }

    protected final String Headers(String name, String header) throws ssException {
        if (!this.system.gListOption && this.content_length > (long)0) {
            throw new ssException(19, "Headers()");
        }
        Hashtable ht = this.Headers();
        if (ht == null) {
            return null;
        }
        return ht.put(name, header);
    }

    protected final Hashtable Cookies() throws ssException {
        if (this.cookies != null) {
            return this.cookies;
        }
        if (!this.system.gListOption && this.content_length > (long)0) {
            throw new ssException(19, "Cookies()");
        }
        this.cookies = new Hashtable();
        return this.cookies;
    }

    protected final ssCookie Cookies(String name) throws ssException {
        Hashtable ht = this.Cookies();
        if (ht == null) {
            return null;
        }
        Object object = ht.get(name);
        if (object == null) {
            return null;
        }
        return (ssCookie)object;
    }

    protected final ssCookie Cookies(ssCookie cookie) throws ssException {
        if (!this.system.gListOption && this.content_length > (long)0) {
            throw new ssException(19, "Cookies()");
        }
        Hashtable ht = this.Cookies();
        if (ht == null) {
            return null;
        }
        ssCookie object = ht.put(cookie.getName(), cookie);
        if (object == null) {
            return null;
        }
        return object;
    }

    protected final ssCookie Cookies(String name, String value) throws ssException {
        if (!this.system.gListOption && this.content_length > (long)0) {
            throw new ssException(19, "Cookies()");
        }
        Hashtable ht = this.Cookies();
        if (ht == null) {
            return null;
        }
        ssCookie cookie = new ssCookie(name, value);
        ssCookie object = ht.put(name, cookie);
        if (object == null) {
            return null;
        }
        return object;
    }

    protected final boolean getIsBuffered() {
        return this.isBuffered;
    }

    protected final void setIsBuffered(boolean _isBuffered) throws IOException, ssException {
        if (_isBuffered == this.isBuffered) {
            return;
        }
        if (_isBuffered) {
            if (!this.system.gListOption && this.content_length > (long)0) {
                throw new ssException(19, "setIsBuffered()");
            }
            this.bufferedOutputStream = new ByteArrayOutputStream();
            this.content_length = 0L;
        } else {
            if (this.isBuffered) {
                this.flush();
            }
            this.bufferedOutputStream = null;
        }
        this.isBuffered = _isBuffered;
    }

    protected final void reset() throws ssException {
        if (!this.isBuffered) {
            throw new ssException(18, "reset()");
        }
        this.bufferedOutputStream.reset();
    }

    protected void flush() throws IOException, ssException {
        if (!this.isBuffered) {
            throw new ssException(18, "flush()");
        }
        if (this.bufferedOutputStream.size() > 0) {
            this.content_length += (long)this.bufferedOutputStream.size();
            if (!this.isRaw) {
                this.sendHeader();
            }
            this.bufferedOutputStream.writeTo(this.os);
            this.os.flush();
            this.bufferedOutputStream.reset();
        } else if (!this.isRaw) {
            this.sendHeader();
        }
    }

    protected void write(int iByte) throws IOException {
        if (this.isBuffered) {
            this.bufferedOutputStream.write(iByte);
        } else {
            if (!this.isRaw) {
                this.sendHeader();
            }
            this.os.write(iByte);
            this.content_length += (long)1;
        }
    }

    protected void write(byte[] buffer, int offset, int length) throws IOException {
        if (this.isBuffered) {
            this.bufferedOutputStream.write(buffer, offset, length);
        } else {
            if (!this.isRaw) {
                this.sendHeader();
            }
            this.os.write(buffer, offset, length);
            this.content_length += (long)buffer.length;
        }
    }

    protected final void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    protected final void print(String sValue) throws IOException {
        this.write(sValue.getBytes());
    }

    protected final void println(String sValue) throws IOException {
        this.print(String.valueOf(String.valueOf(sValue)).concat(String.valueOf(String.valueOf('\n'))));
    }

    protected final String bufferToString() throws ssException {
        if (!this.isBuffered) {
            throw new ssException(18, "bufferToString()");
        }
        return this.bufferedOutputStream.toString();
    }

    protected final byte[] bufferToByteArray() throws ssException {
        if (!this.isBuffered) {
            throw new ssException(18, "bufferToByteArray()");
        }
        return this.bufferedOutputStream.toByteArray();
    }

    protected final void setCharset(String _charset) {
        this.charset = _charset;
    }

    protected final String getCharset() {
        return this.charset;
    }

    protected final void setContentType(String _content_type) {
        this.content_type = _content_type;
    }

    protected final String getContentType() {
        return this.content_type;
    }

    protected final void setLastModified(long _last_modified) {
        this.last_modified = _last_modified;
    }

    protected final long getLastModified() {
        return this.last_modified;
    }

    protected final void setExpires(long _expires) {
        this.expires = _expires;
    }

    protected final long getExpires() {
        return this.expires;
    }

    protected final void setContentEncoding(String _content_encoding) {
        this.content_encoding = _content_encoding;
    }

    protected final String getContentEncoding() {
        return this.content_encoding;
    }

    protected final void setCacheContent(boolean _cache_content) {
        this.cache_content = _cache_content;
    }

    protected final boolean getCacheContent() {
        return this.cache_content;
    }

    protected final boolean getIsRaw() {
        return this.isRaw;
    }

    protected void setIsRaw(boolean _isRaw) throws ssException {
        if (!this.system.gListOption && this.content_length > (long)0) {
            throw new ssException(19, "setIsRaw()");
        }
        this.isRaw = _isRaw;
    }

    protected final void log(String msg) throws Exception {
        this.system.log(msg);
    }

    protected final String charset() {
        if (this.charset == null) {
            return null;
        }
        return "charset=".concat(String.valueOf(String.valueOf(this.charset)));
    }

    protected abstract void sendHeader();

    protected abstract void redirect(String var1) throws IOException, ssException;

    protected abstract String encodeRedirectURL(String var1);

    protected abstract String encodeURL(String var1);

    static {
        status_ok = 200;
        status_created = 201;
        status_accepted = 202;
        status_partial_information = 203;
        status_no_content = 204;
        status_moved_permanently = 301;
        status_moved_temporarily = 302;
        status_not_modified = 304;
        status_bad_request = 400;
        status_unauthorized = 401;
        status_forbidden = 403;
        status_not_found = 404;
        status_internal_server_error = 500;
        status_not_implemented = 501;
        status_bad_gateway = 502;
        status_gateway_timeout = 503;
    }
}

