/*
 * Decompiled with CFR 0.152.
 */
package stec.ss;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import stec.ss.ssBuffer;
import stec.ss.ssException;
import stec.ss.ssGenerator;
import stec.ss.ssStatementProcessor;
import stec.ss.ssSymbolTable;
import stec.ss.ssSystem;
import stec.ss.ssToken;

final class ssProgram {
    protected ssSystem system;
    private ssSymbolTable symbolTable;
    private ssBuffer source;
    private ssBuffer object;
    private int mark;

    protected ssProgram(ssSystem _system) {
        this.system = _system;
        this.symbolTable = new ssSymbolTable();
        this.source = null;
        this.system.gCurrentLineNumber = 0;
        this.object = null;
    }

    protected ssProgram(ssSystem _system, ssBuffer _source) throws ssException {
        this.system = _system;
        this.symbolTable = new ssSymbolTable();
        this.source = _source;
        this.system.gCurrentLineNumber = 1;
        this.object = ssGenerator.generate(this);
        this.source = null;
    }

    protected ssProgram(ssSystem _system, byte[] _source) throws ssException {
        this(_system, new ssBuffer(_source));
    }

    protected ssProgram(ssSystem _system, String _source) throws ssException {
        this(_system, new ssBuffer(_source));
    }

    protected ssProgram(ssSystem _system, File inputFile) throws Exception, ssException {
        this.system = _system;
        this.symbolTable = new ssSymbolTable();
        FileInputStream fileInputStream = new FileInputStream(inputFile);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        this.source = ssProgram.read(bufferedInputStream);
        bufferedInputStream.close();
        fileInputStream.close();
        this.system.gCurrentLineNumber = 1;
        this.object = ssGenerator.generate(this);
        this.source = null;
    }

    protected ssProgram(ssSystem _system, BufferedInputStream bufferedInputStream) throws ssException {
        this(_system, ssProgram.read(bufferedInputStream));
    }

    protected final ssBuffer getSource() {
        return this.source;
    }

    protected final ssBuffer getObject() {
        return this.object;
    }

    protected final ssSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    protected static final ssBuffer read(BufferedInputStream bufferedInputStream) throws ssException {
        try {
            int bytesRead;
            ssBuffer source = new ssBuffer();
            byte[] buffer = new byte[2048];
            while ((bytesRead = bufferedInputStream.read(buffer, 0, 2048)) != -1) {
                source.write(buffer, 0, bytesRead);
            }
            ssBuffer ssBuffer2 = source;
            return ssBuffer2;
        }
        catch (Exception e) {
            throw new ssException(e.toString());
        }
    }

    protected final void run() throws Exception, ssException {
        this.object.reset(0);
        this.system.gCurrentLineNumber = 1;
        ssStatementProcessor statementProcessor = new ssStatementProcessor(this.system);
        while (statementProcessor.processStatement() && !this.system.gExit) {
        }
        if (!this.system.gExit) {
            if (this.system.gProcessor != 3 && this.system.gInStatement) {
                throw new ssException(16, "end of file", "statement block");
            }
            if (this.system.gLoopHandler.inLoop()) {
                throw new ssException(16, "end of file", "loop block");
            }
            if (this.system.gLevel != 0) {
                throw new ssException(16, "end of file", "block statement");
            }
        }
    }

    protected final ssToken getNextToken() throws ssException {
        ssToken token;
        byte bToken = this.getNextByte();
        switch (bToken) {
            case 48: {
                token = new ssToken(bToken, this.getNextDataBlock());
                break;
            }
            case 49: {
                token = new ssToken(bToken, this.getNextSymbol());
                break;
            }
            case 51: {
                token = new ssToken(bToken, this.getNextString());
                break;
            }
            case 50: {
                token = new ssToken(bToken, this.getNextInteger());
                break;
            }
            case 52: {
                token = new ssToken(bToken, this.getNextDouble());
                break;
            }
            case 116: {
                token = new ssToken(bToken, this.getNextInteger());
                break;
            }
            default: {
                token = new ssToken(bToken);
            }
        }
        this.mark = this.object.getIndex();
        return token;
    }

    protected final void incrementTokenOffset() {
        this.object.reset(this.mark);
    }

    protected final ssToken peekAtNextToken() throws ssException {
        this.object.mark();
        ssToken token = this.getNextToken();
        this.mark = this.object.getIndex();
        this.object.reset();
        return token;
    }

    protected final String getNextDataBlock() throws ssException {
        try {
            String string = this.object.getString(this.getNextInteger());
            return string;
        }
        catch (EOFException e) {
            throw new ssException(12, "end of file", "Data Block");
        }
        catch (IOException e) {
            throw new ssException(e.toString());
        }
    }

    protected final String getNextSymbol() throws ssException {
        int symbol = this.getNextInteger();
        return this.symbolTable.get(symbol);
    }

    protected final String getNextString() throws ssException {
        try {
            String string = this.object.getString(this.getNextInteger());
            return string;
        }
        catch (EOFException e) {
            throw new ssException(12, "end of file", "String");
        }
        catch (IOException e) {
            throw new ssException(e.toString());
        }
    }

    protected final byte getNextByte() throws ssException {
        try {
            byte by = this.object.readByte();
            return by;
        }
        catch (EOFException e) {
            byte by = -1;
            return by;
        }
        catch (IOException e) {
            throw new ssException(e.toString());
        }
    }

    protected final int getNextInteger() throws ssException {
        try {
            int n = this.object.readInt();
            return n;
        }
        catch (EOFException e) {
            throw new ssException(12, "end of file", "Integer");
        }
        catch (IOException e) {
            throw new ssException(e.toString());
        }
    }

    protected final double getNextDouble() throws ssException {
        try {
            double d = this.object.readDouble();
            return d;
        }
        catch (EOFException e) {
            throw new ssException(12, "end of file", "Double");
        }
        catch (IOException e) {
            throw new ssException(e.toString());
        }
    }

    protected final void save(String fileName) throws Exception, ssException {
        FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(String.valueOf(fileName)).concat(String.valueOf(String.valueOf(this.system.objectExtension()))));
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        dataOutputStream.writeShort(255);
        dataOutputStream.writeInt(0x1000000);
        dataOutputStream.writeInt(this.system.gProcessor);
        dataOutputStream.writeInt(this.object.length());
        dataOutputStream.write(this.object.getBuffer(), 0, this.object.length());
        dataOutputStream.writeInt(this.symbolTable.count());
        for (int i = 0; i < this.symbolTable.count(); ++i) {
            String symbol = this.symbolTable.get(i);
            dataOutputStream.writeInt(symbol.length());
            dataOutputStream.write(symbol.getBytes(), 0, symbol.length());
        }
        dataOutputStream.close();
        fileOutputStream.close();
    }

    protected final void load(String fileName) throws Exception, ssException {
        FileInputStream fileInputStream = new FileInputStream(String.valueOf(String.valueOf(fileName)).concat(String.valueOf(String.valueOf(this.system.objectExtension()))));
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        short id = dataInputStream.readShort();
        if (id != 255) {
            throw new ssException(8, "object id", String.valueOf(id));
        }
        int version = dataInputStream.readInt();
        if (version != 0x1000000) {
            throw new ssException(8, "object version", String.valueOf(version));
        }
        int processor = dataInputStream.readInt();
        if (this.system.gProcessor == 3 ? processor != 3 : processor == 3) {
            throw new ssException(8, "processor", String.valueOf(this.system.gProcessor));
        }
        int length = dataInputStream.readInt();
        this.object = new ssBuffer(length);
        this.object.setLength(length);
        int bytesRead = dataInputStream.read(this.object.getBuffer(), 0, length);
        if (bytesRead != length) {
            throw new ssException(8, "object length != bytes read", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(length))).append(" != ").append(bytesRead))));
        }
        this.symbolTable.clear();
        ssBuffer symbol = new ssBuffer();
        int count = dataInputStream.readInt();
        for (int i = 0; i < count; ++i) {
            length = dataInputStream.readInt();
            symbol.clear();
            symbol.setLength(length);
            bytesRead = dataInputStream.read(symbol.getBuffer(), 0, length);
            if (bytesRead != length) {
                throw new ssException(8, "symbol length != bytes read", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(length))).append(" != ").append(bytesRead))));
            }
            this.symbolTable.add(symbol.toString());
        }
        dataInputStream.close();
        fileInputStream.close();
        this.system.gCurrentLineNumber = 1;
    }
}

