/*
 * @(#)wrapper.c 1.0.0
 *
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

#define PACKAGE "stec.mk."

#include "parse_params.h"

#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <process.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <signal.h>

#define KB 1024
#define BUF_SIZE (((8 * KB) + 1) * sizeof(char))

#define JAVA "java"
#define SPACE " "
#define PATHSIZE 256
#define MSVM "jview"

void error(char *msg)
{
    fprintf(stderr, "%s\n", msg);
    exit(-1);
}

char *envfilenm = NULL;

void _wrapup(void)
{
	if(envfilenm != NULL)
	{
		remove(envfilenm);
		envfilenm = NULL;
	}
}

void wrapup(int i)
{
	_wrapup();
}

int main( int argc, char *argv[], char *envp[] )
{
	char *java_exe;
	char *classpath;
    char buf[BUF_SIZE];
	char **envarg;
	int rc;
	FILE *envFH;
	int count;

	int length;
	char *p;

#ifdef _WIN32
    char **args, **ap;
	char *param;

	int usingMSVM;
	int lMSVM;
	int i;
#else
	char command[BUF_SIZE];
#endif

	signal(SIGINT, wrapup);
	signal(SIGTERM, wrapup);
	signal(SIGABRT, wrapup);
#ifdef _WIN32
	signal(SIGBREAK, wrapup);
#else
	signal(SIGHUP, wrapup);
	signal(SIGQUIT, wrapup);
#endif

	atexit(_wrapup);

	// setup java
	java_exe = (char *)getenv("JAVA_EXE");
    if(java_exe == 0)
	{
		error("JAVA_EXE is not defined.");
	}

	count = count_args(java_exe);
	if(count == 0)
	{
		error("JAVA_EXE is empty.");
	}
	
#ifdef _WIN32
	param = extract_arg(java_exe, 0);

	strip_quotes(param);

	// which java vm, microsoft/javasoft
	usingMSVM = FALSE;
	p = param;
	lMSVM = strlen(MSVM);
	length = strlen(param) - lMSVM + 1;
	for(i = 0; i < length; i++)
	{
		if(strnicmp(p, MSVM, lMSVM) == 0)
		{
			usingMSVM = TRUE;
			break;
		}

		p++;
	}

	// add 6 for parameters: cmd -classpath <classpath> -Denv=? <class> 0x00
    ap = args = (char **)malloc((argc + count + 6) * sizeof(char *));
    
	*ap++ = param;

	for(i = 1; i < count; i++)
	{
		param = extract_arg(java_exe, i);
		strip_quotes(param);
		
		*ap++ = param;
	}

	// setup args

	// setup classpath
	classpath = (char *)getenv("CLASSPATH");
    if (classpath == 0)
		error("CLASSPATH is not defined.");

	if(!usingMSVM)
	{
	    *ap++ = strdup("-classpath");
	    *ap++ = strdup(classpath);
	}
#else
	// setup java executable
	strcpy(command, java_exe);

	// setup args
    strcat(command, SPACE);

	// setup classpath
	classpath = (char *)getenv("CLASSPATH");
    if (classpath == 0)
		error("CLASSPATH is not defined.");

    sprintf(buf, "-classpath %s", classpath);
	strcat(command, buf);
#endif

	// setup env file
	envfilenm = (char *)tempnam(NULL, "~" CLASS);
	if(envfilenm == NULL)
		error("Unable to create a temp filename.");

	envFH = fopen(envfilenm, "wb");

	// setup environmental variables
	
	envarg = envp;
	while(*envarg)
	{
		fprintf(envFH, "%s\n", *envarg++);
	}

	fflush(envFH);
	fclose(envFH);

#ifdef _WIN32
	if(usingMSVM)
		sprintf(buf, "/D:env=%s", envfilenm);
	else
		sprintf(buf, "-Denv=%s", envfilenm);

	*ap++ = strdup(buf);

	// setup CLASS executable
    *ap++ = strdup(PACKAGE CLASS);

	// setup user arguements
    while(--argc > 0)
	{
		*ap++ = strdup(*++argv);
	}

    *ap = NULL;
#else
	sprintf(buf, "-Denv=%s", envfilenm);
    strcat(command, SPACE);
	strcat(command, buf);

	// setup CLASS executable
    strcat(command, SPACE);
	strcat(command, PACKAGE CLASS);

	// setup user arguements
    while (--argc > 0)
	{
	   	strcat(command, SPACE);
		strcat(command, *++argv);
	}
#endif

#ifdef _WIN32
	rc = spawnv(P_WAIT, args[0], args);
#else
	rc = system(command);
#endif

	return rc;
}
