////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
//  Copy template classes for 'Bars' collection.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_COLLECTIONS_H__C43C7C21_91E2_4F42_8346_6615EAC364EE__INCLUDED_)
#define AFX_COLLECTIONS_H__C43C7C21_91E2_4F42_8346_6615EAC364EE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <AtlCom.h>

// ************** Cute Bars Type Templates **************
// *** copy Collection Exposed types

namespace VCUE
{
    typedef CComObject<CIBar>* ContObj;
	template <>
	class GenericCopy<IBar*, ContObj>
	{
	public :
		typedef IBar*	destination_type;
		typedef ContObj	source_type;

		static void init(destination_type* p)
		{
//			GenericCopy<destination_type>::init(p);
            p = NULL;
		}
		static void destroy(destination_type* p)
		{
//			GenericCopy<destination_type>::destroy(p);
            if (p ) //&& *p
            {
                IUnknown* pUnk =(IUnknown*) p;
                pUnk->Release();
            }
		}
		static HRESULT copy(destination_type* pTo, const source_type* pFrom);
	}; // class GenericCopy<IBar*, IDispatch*>
// *********************************************************
// *** Copy Enum  Expo Types
	template <>
	class GenericCopy<VARIANT, ContObj>
	{
	public :
		typedef VARIANT	destination_type;
		typedef ContObj	source_type;

		static void init(destination_type* p)
		{
			GenericCopy<destination_type>::init(p);
		}
		static void destroy(destination_type* p)
		{
			GenericCopy<destination_type>::destroy(p);
		}
		static HRESULT copy(destination_type* pTo, const source_type* pFrom)
		{
            HRESULT hr = E_INVALIDARG;
            if (pFrom == NULL && *pFrom == NULL)
			    return hr;

            CComVariant var;
            var.vt = VT_DISPATCH;
            hr = (*pFrom)->QueryInterface(IID_IDispatch,(void**)&var.pdispVal);
		    if (FAILED(hr))
				return hr;
            
			return var.Detach(pTo);
		}

	}; // class GenericCopy<IBar*, IDispatch*>


}; // namespace VCUE

#endif // !defined(AFX_COLLECTIONS_H__C43C7C20_91E2_4F42_8346_6615EAC364EE__INCLUDED_)
