////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// PropItemDlg.cpp : implementation file
//

#include "stdafx.h"
#include "cutecontrols.h"
#include "PropItemDlg.h"
#include "Item.h"
#include "BarPropPage.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

HBITMAP  _CopyBitmap(HBITMAP hBmpSrc);
int _EditPicture(HWND Parent, HBITMAP hBmp, int cx, int cy, HBITMAP& hNewBmp);

/////////////////////////////////////////////////////////////////////////////
// CPropItemDlg dialog


CPropItemDlg::CPropItemDlg(CWnd* pParent)
	: CDialog(CPropItemDlg::IDD, pParent)
{
    m_pItemProp = NULL;
    m_bLoaded = FALSE;
	//{{AFX_DATA_INIT(CPropItemDlg)
	//}}AFX_DATA_INIT
    Create(IDD_ITEMPROP_DLG, pParent);
}

CPropItemDlg::~CPropItemDlg()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    DestroyWindow();
}


BEGIN_MESSAGE_MAP(CPropItemDlg, CDialog)
	//{{AFX_MSG_MAP(CPropItemDlg)
	ON_BN_CLICKED(IDC_BTN_HKEY_SET, OnBtnHkeySet)
	ON_BN_CLICKED(IDC_CHECK_BTN_GROUP, OnChange)
	ON_BN_CLICKED(IDC_BTN_PICTURE, OnBtnPicture)
	ON_BN_CLICKED(IDC_BTN_PICTUREDSBL, OnBtnPicturedsbl)
	ON_BN_CLICKED(IDC_BTN_PICTUREHOT, OnBtnPicturehot)
	ON_BN_CLICKED(IDC_CHECK_ENABLED, OnChange)
	ON_BN_CLICKED(IDC_CHECK_VISIBLE, OnChange)
	ON_BN_CLICKED(IDC_RADIO_BSTYLE_DEF, OnChange)
	ON_BN_CLICKED(IDC_RADIO_BSTYLE_IMGTEXT, OnChange)
	ON_BN_CLICKED(IDC_RADIO_BSTYLE_IMAGE, OnChange)
	ON_BN_CLICKED(IDC_RADIO_BSTYLE_TEXT, OnChange)
	ON_EN_CHANGE(IDC_EDIT_ID, OnChange)
	ON_EN_CHANGE(IDC_EDIT_NAME, OnChange)
	ON_EN_CHANGE(IDC_EDIT_TOOLTIP, OnChange)
	ON_BN_CLICKED(IDC_RADIO_PRESSED, OnChange)
	ON_BN_CLICKED(IDC_RADIO_UNPRESSED, OnChange)
	ON_CBN_SELCHANGE(IDC_COMBO_BSTYLE, OnChangeType)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropItemDlg message handlers

BOOL CPropItemDlg::ReadProp(IItem* pItem, ITEM_PROPERTIES* pIProp)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CComPtr<IItem> spItem = pItem;
    ASSERT(spItem);

    CComBSTR Name;
    if(FAILED(spItem->get_Name(&Name)))
        return FALSE;
    pIProp->Name = Name;

    long ID = -1;
    if(FAILED(spItem->get_ID(&ID)))
        return FALSE;
    pIProp->Id = ID;

    VARIANT_BOOL bVisible = VARIANT_TRUE;
    if(FAILED(spItem->get_Visible(&bVisible)))
        return FALSE;
    pIProp->Visible = bVisible ? TRUE: FALSE;

    // process Enabled
    VARIANT_BOOL bEnabled = VARIANT_TRUE;
    if(FAILED(spItem->get_Enabled(&bEnabled)))
        return FALSE;
    pIProp->Enabled = bEnabled ? TRUE : FALSE;

    // Show ToolTips prop
    CComBSTR bstr;
    if(FAILED(spItem->get_ToolTip(&bstr)))
        return FALSE;
    pIProp->Tooltip = bstr;

    // Set Hotkey   
    long HotKey;
    if(FAILED(spItem->get_AccelKey(&HotKey)))
        return FALSE;
    pIProp->HotKey = (UINT)HotKey;

    // Set State  
    long State;
    if(FAILED(spItem->get_State(&State)))
        return FALSE;
    pIProp->State = (UINT)State;

    // Set Button Style
    enItemStyle Style;
    if(FAILED(spItem->get_Style(&Style)))
        return FALSE;
    pIProp->Style = (int)Style;

    // Set Picture
    HBITMAP hBmp = NULL;

    CComPtr<IPictureDisp> pPic;
    if (SUCCEEDED(spItem->get_Image(&pPic)))
    {
        CComQIPtr<IPicture,&IID_IPicture> spPic(pPic);
        if (spPic)
            spPic->get_Handle((UINT*)&hBmp);
    }
    pIProp->hPic = hBmp;

    // Set Image Hot
    CComPtr<IPictureDisp> pPicHot;
    hBmp = NULL;
    if (SUCCEEDED(spItem->get_ImageHot(&pPicHot)))
    {
        CComQIPtr<IPicture,&IID_IPicture> spPic(pPicHot);
        if (spPic)
            spPic->get_Handle((UINT*)&hBmp);
    }
    pIProp->hPicHot = hBmp;

    // Set Image Disabled
    hBmp = NULL;
    CComPtr<IPictureDisp> pPicDsbl;

    if (SUCCEEDED(spItem->get_ImageDisabled(&pPicDsbl)))
    {
        CComQIPtr<IPicture,&IID_IPicture> spPic(pPicDsbl);
        if (spPic)
            spPic->get_Handle((UINT*)&hBmp);
    }
    pIProp->hPicDsbl = hBmp; // Init anyway

    return TRUE;
}

BOOL CPropItemDlg::SetProp(IItem* pItem, ITEM_PROPERTIES* pIProp)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    CComPtr<IItem> spItem = pItem;

    CComBSTR Name = pIProp->Name.AllocSysString();
    if(FAILED(spItem->put_Name(Name)))
        return FALSE;

    enItemType type = (enItemType) pIProp->Type;
    if(FAILED(spItem->put_Type(type)))
        return FALSE;

    long ID = type == ccTypeSeparator ? -1 : pIProp->Id;
    if(FAILED(spItem->put_ID(ID)))
        return FALSE;

    VARIANT_BOOL bVisible = pIProp->Visible ? VARIANT_TRUE:VARIANT_FALSE;
    if(FAILED(spItem->put_Visible(bVisible)))
        return FALSE;

    // process Enabled
    VARIANT_BOOL bEnabled = pIProp->Enabled ? VARIANT_TRUE : VARIANT_FALSE;
    if(FAILED(spItem->put_Enabled(bEnabled)))
        return FALSE;


    // Show ToolTips prop
    CComBSTR bstr = pIProp->Tooltip.AllocSysString();
    if(FAILED(spItem->put_ToolTip(bstr)))
        return FALSE;

    // Set Hotkey   
    long HotKey = (long) pIProp->HotKey;
    if(FAILED(spItem->put_AccelKey(HotKey)))
        return FALSE;

    // Set State  
    long State = (long)pIProp->State ;
    if(FAILED(spItem->put_State(State)))
        return FALSE;

    // Set Button Style
    enItemStyle Style = (enItemStyle)pIProp->Style;
    if(FAILED(spItem->put_Style(Style)))
        return FALSE;

    // Set Picture
    CPictureHolder* pPicHolder = new CPictureHolder;
    pPicHolder->CreateFromBitmap(pIProp->hPic);  
    if (FAILED(spItem->put_Image(pPicHolder->GetPictureDispatch())))
        return FALSE;

    // Set Image Hot
    {
    CPictureHolder* pPicHolder = new CPictureHolder;
    pPicHolder->CreateFromBitmap(pIProp->hPicHot);  
    if (FAILED(spItem->put_ImageHot(pPicHolder->GetPictureDispatch())))
        return FALSE;
    }

    // Set Image Disabled
    {
    CPictureHolder* pPicHolder = new CPictureHolder;
    pPicHolder->CreateFromBitmap(pIProp->hPicDsbl);  
    if (FAILED(spItem->put_ImageDisabled(pPicHolder->GetPictureDispatch())))
        return FALSE;
    }

    pIProp->bDirty = FALSE;

    return TRUE;
}

BOOL CPropItemDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
    CComboBox ComboBox;
    ComboBox.Attach(::GetDlgItem(m_hWnd, IDC_COMBO_BSTYLE));

    int i  = 0;
    ComboBox.InsertString(i,_T("ccTypeButton"));
    ComboBox.SetItemData(i,ccTypeButton); i++;

    ComboBox.InsertString(i,_T("ccTypeToggleButton"));
    ComboBox.SetItemData(i,ccTypeToggleButton); i++;

    ComboBox.InsertString(i,_T("ccTypeDropDown"));
    ComboBox.SetItemData(i,ccTypeDropDown); i++;

    ComboBox.InsertString(i,_T("ccTypeToggleDropDown"));
    ComboBox.SetItemData(i,ccTypeToggleDropDown); i++;

    ComboBox.InsertString(i,_T("ccTypeSeparator"));
    ComboBox.SetItemData(i,ccTypeSeparator); i++;

    ComboBox.Detach();
 	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPropItemDlg::OnChange() 
{
   if (m_pItemProp && m_bLoaded)
   {
        m_pItemProp->bDirty = TRUE;	
        Update(m_pItemProp);

        // Notify Propery page to turn on "Apply" button
       ::PostMessage(::GetParent(m_hWnd),WM_MODIFIED, NULL, NULL); 
   }
}

void CPropItemDlg::OnChangeType() 
{
   if (m_pItemProp && m_bLoaded)
   {
       OnChange();

    if (m_pItemProp->Type == ccTypeSeparator)
    {
        ShowSepControls(TRUE);
        return;
    }
    ShowSepControls(FALSE);
   }
}

void CPropItemDlg::OnBtnHkeySet() 
{
	OnChange(); 
}

void CPropItemDlg::OnBtnPicture() 
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    BAR_PROPRETIES*  pBarProp = m_pItemProp->pBar;
    
    int cx = pBarProp->ImageWidth;
    int cy = pBarProp->ImageHeight;

    HBITMAP hBmp = NULL;
    if (_EditPicture(m_hWnd, m_pItemProp->hPic, cx, cy,hBmp) == IDCANCEL)    
        return;
    m_pItemProp->hPic = hBmp;
    OnChange();

    // Set Picture
    CButton PicPreView;
    PicPreView.Attach(::GetDlgItem(m_hWnd, IDC_IMAGE_PREVIEW));
    PicPreView.SetBitmap(NULL);
//    if (m_pItemProp->hPic)
        PicPreView.SetBitmap(m_pItemProp->hPic);
    PicPreView.Detach();
}

void CPropItemDlg::OnBtnPicturedsbl() 
{	
    BAR_PROPRETIES*  pBarProp = m_pItemProp->pBar;
    
    int cx = pBarProp->ImageWidth;
    int cy = pBarProp->ImageHeight;

    HBITMAP hBmp = NULL;
    if (_EditPicture(m_hWnd, m_pItemProp->hPicDsbl, cx, cy,hBmp) == IDCANCEL)    
        return;
    m_pItemProp->hPicDsbl = hBmp;
    OnChange();

    // Set Image Disabled
    CButton PicPreView;
    PicPreView.Attach(::GetDlgItem(m_hWnd, IDC_IMAGE_PREVIEWDSBL));
    PicPreView.SetBitmap(NULL);
//    if (m_pItemProp->hPicDsbl)
        PicPreView.SetBitmap(m_pItemProp->hPicDsbl);
    PicPreView.Detach();
}

void CPropItemDlg::OnBtnPicturehot() 
{	
    BAR_PROPRETIES*  pBarProp = m_pItemProp->pBar;
    
    int cx = pBarProp->ImageWidth;
    int cy = pBarProp->ImageHeight;

    HBITMAP hBmp = NULL;
    if (_EditPicture(m_hWnd, m_pItemProp->hPicHot, cx, cy,hBmp) == IDCANCEL)    
        return;
    m_pItemProp->hPicHot = hBmp;
    OnChange();
    // Set Image Hot
    CButton PicPreView;
    PicPreView.Attach(::GetDlgItem(m_hWnd, IDC_IMAGE_PREVIEWHOT));
    PicPreView.SetBitmap(NULL);
//    if (m_pItemProp->hPicHot)
        PicPreView.SetBitmap(m_pItemProp->hPicHot);
    PicPreView.Detach();
}


BOOL CPropItemDlg::ShowData(ITEM_PROPERTIES *pIProp)
{
    m_pItemProp = pIProp;
    if (!pIProp) return FALSE;

    ShowButtonProp(pIProp);

    return TRUE;
}

void CPropItemDlg::ShowButtonProp(ITEM_PROPERTIES *pIProp)
{
    ASSERT(pIProp);
    m_bLoaded = FALSE;  // Prop page SetDirty update protection


    SetDlgItemText(IDC_EDIT_NAME, pIProp->Name);

    // Set ID
    SetDlgItemInt(IDC_EDIT_ID, pIProp->Id);

    CComboBox  ComboBox;
    HWND hWnd = ::GetDlgItem(m_hWnd,IDC_COMBO_BSTYLE);
    ComboBox.Attach(hWnd);
    int Select = pIProp->Type < ccTypeSeparator ? pIProp->Type : 4;
    ComboBox.SetCurSel(Select);
    ComboBox.Detach();

    if (pIProp->Type == ccTypeSeparator)
    {
        ShowSepControls(TRUE);
        m_bLoaded = TRUE;
        return;
    }
    ShowSepControls(FALSE);

    // Set Visible
    CheckDlgButton(IDC_CHECK_VISIBLE,           // Set the check box
                  pIProp->Visible ? BST_CHECKED : BST_UNCHECKED);
    // Set Enabled
    CheckDlgButton(IDC_CHECK_ENABLED,           
                  pIProp->Enabled ? BST_CHECKED : BST_UNCHECKED);

    

    // Show ToolTips prop
    SetDlgItemText(IDC_EDIT_TOOLTIP, pIProp->Tooltip);

    // Set Hotkey   
    CHotKeyCtrl hKey;
    hKey.Attach(::GetDlgItem(m_hWnd, IDC_HOTKEY_ACCEL));
    hKey.SetHotKey(HIWORD(pIProp->HotKey), LOWORD(pIProp->HotKey ));
    hKey.Detach();

    // Set State  
    long State = pIProp->State;
    BOOL bNorm = FALSE, bGroup = FALSE, bPressed = FALSE;

    if (State & ccItemUnpressed)
    {
        bNorm = TRUE;
        bPressed = FALSE;
    }
    else if (State & ccItemPressed)
    {
        bNorm = FALSE;
        bPressed = TRUE;
    }
    if (State & ccItemGroup)
        bGroup = TRUE;

    CheckDlgButton(IDC_RADIO_UNPRESSED,  //IDC_CHECK_BTN_NORM,           
                  bNorm ? BST_CHECKED : BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_PRESSED,   //IDC_CHECK_BTN_PRESS,           
                  bPressed ? BST_CHECKED : BST_UNCHECKED);
    CheckDlgButton(IDC_CHECK_BTN_GROUP,           
                  bGroup ? BST_CHECKED : BST_UNCHECKED);

    // Set Button Style
    enItemStyle Style = (enItemStyle)pIProp->Style;
    BOOL bDef = FALSE, bText = FALSE, bImage = FALSE, bImgAndText = FALSE;
    switch (Style)
    {
    case ccDefaultStyle:
        bDef = TRUE;
        break;
    case ccTextOnly:
        bText = TRUE;
        break;
    case ccImageOnly:
        bImage = TRUE;
        break;
    case ccImageAndText:
        bImgAndText = TRUE;
        break;
    }
    CheckDlgButton(IDC_RADIO_BSTYLE_DEF,           
                  bDef? BST_CHECKED : BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_BSTYLE_TEXT,           
                  bText? BST_CHECKED : BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_BSTYLE_IMAGE,           
                  bImage? BST_CHECKED : BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_BSTYLE_IMGTEXT,           
                  bImgAndText? BST_CHECKED : BST_UNCHECKED);

    // Set Picture
    CButton PicPreView;
    PicPreView.Attach(::GetDlgItem(m_hWnd, IDC_IMAGE_PREVIEW));
    PicPreView.SetBitmap(NULL);
    if (pIProp->hPic)
        PicPreView.SetBitmap(pIProp->hPic);
    PicPreView.Detach();

    // Set Image Hot
    PicPreView.Attach(::GetDlgItem(m_hWnd, IDC_IMAGE_PREVIEWHOT));
    PicPreView.SetBitmap(NULL);
    if (pIProp->hPicHot)
        PicPreView.SetBitmap(pIProp->hPicHot);
    PicPreView.Detach();

    // Set Image Disabled
    PicPreView.Attach(::GetDlgItem(m_hWnd, IDC_IMAGE_PREVIEWDSBL));
    PicPreView.SetBitmap(NULL);
    if (pIProp->hPicDsbl)
        PicPreView.SetBitmap(pIProp->hPicDsbl);
    PicPreView.Detach();

    m_bLoaded = TRUE;
}

BOOL CPropItemDlg::Update(ITEM_PROPERTIES* pIProp)
{   
   if (!pIProp || !pIProp->bDirty) return FALSE;

   int ID = GetDlgItemInt(IDC_EDIT_ID);
   pIProp->Id = ID;

   TCHAR buffer[256];
   GetDlgItemText(IDC_EDIT_NAME,buffer,sizeof(buffer));
   pIProp->Name = buffer; // CSting copy

   BOOL bChk = IsDlgButtonChecked(IDC_CHECK_VISIBLE ) == BST_CHECKED;
   pIProp->Visible = bChk;

   bChk = IsDlgButtonChecked(IDC_CHECK_ENABLED) == BST_CHECKED;
   pIProp->Enabled = bChk;

   GetDlgItemText(IDC_EDIT_TOOLTIP,buffer,sizeof(buffer));
   pIProp->Tooltip = buffer;

    CComboBox  ComboBox;
    HWND hWnd = ::GetDlgItem(m_hWnd,IDC_COMBO_BSTYLE);
    ComboBox.Attach(hWnd);
    int Select = ComboBox.GetCurSel();
    pIProp->Type = (enItemType) ComboBox.GetItemData(Select);
    ComboBox.Detach();

   // Button style
   BOOL bChkDef = IsDlgButtonChecked(IDC_RADIO_BSTYLE_DEF) == BST_CHECKED;
   BOOL bChkImgTxt = IsDlgButtonChecked(IDC_RADIO_BSTYLE_IMGTEXT) == BST_CHECKED;
   BOOL bChkImg = IsDlgButtonChecked(IDC_RADIO_BSTYLE_IMAGE) == BST_CHECKED;
   BOOL bChkTxt = IsDlgButtonChecked(IDC_RADIO_BSTYLE_TEXT) == BST_CHECKED;

    enItemStyle style = ccDefaultStyle;

    if (bChkDef)
        style =ccDefaultStyle;
    else if (bChkTxt)
        style =ccTextOnly;
    else if (bChkImg)
        style =ccImageOnly;
    else if (bChkImgTxt)
        style =ccImageAndText;

   pIProp->Style = style;

   // Hot key
   long HotKey;
   CHotKeyCtrl hKey;
   hKey.Attach(::GetDlgItem(m_hWnd, IDC_HOTKEY_ACCEL));
   WORD wVirtualKeyCode, wModifiers;
   hKey.GetHotKey(wVirtualKeyCode,wModifiers);
   HotKey = MAKELPARAM(wModifiers,wVirtualKeyCode); 
   pIProp->HotKey = HotKey;
   hKey.Detach();

    // State
    bChk = IsDlgButtonChecked(IDC_RADIO_UNPRESSED) == BST_CHECKED;
    int State;
    if (bChk) State = ccItemUnpressed;
    else      State = ccItemPressed;
    pIProp->State = State;

   // Group
/*   bChk = IsDlgButtonChecked(IDC_CHECK_BTN_GROUP) == BST_CHECKED;
   int State = 0;
   if (bChk)
        State |= ccItemGroup;

   pIProp->State | = State;
*/

   return TRUE;
}

void CPropItemDlg::ShowSepControls(BOOL bShow)
{
    BOOL cmd =  !bShow ;

    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_EDIT_ID), cmd);

    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_CHECK_VISIBLE), cmd);

    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_CHECK_ENABLED), cmd);

    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_EDIT_TOOLTIP), cmd);

    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_HOTKEY_ACCEL), cmd);
    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_BTN_HKEY_SET), cmd);

    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_EDIT_PICTURE), cmd);

    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_BTN_PICTURE), cmd);
    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_BTN_PICTUREHOT), cmd);
    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_BTN_PICTUREDSBL), cmd);

    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_CHECK_BTN_GROUP), cmd);
    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_RADIO_UNPRESSED), cmd);
    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_RADIO_PRESSED), cmd);

    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_RADIO_BSTYLE_DEF), cmd);
    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_RADIO_BSTYLE_TEXT), cmd);
    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_RADIO_BSTYLE_IMAGE), cmd);
    ::EnableWindow(::GetDlgItem(m_hWnd,IDC_RADIO_BSTYLE_IMGTEXT), cmd);
}
