// PaletteCommandFrameWnd.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "ImageEditDlg.h"
#include "PaletteCommandFrameWnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHCPaletteCommandFrameWnd

IMPLEMENT_DYNAMIC(CHCPaletteCommandFrameWnd, CFrameWnd)

CHCPaletteCommandFrameWnd::CHCPaletteCommandFrameWnd()
{
	m_pDlgEdit = NULL;
}

CHCPaletteCommandFrameWnd::~CHCPaletteCommandFrameWnd()
{
}

BEGIN_MESSAGE_MAP(CHCPaletteCommandFrameWnd, CFrameWnd)
	//{{AFX_MSG_MAP(CHCPaletteCommandFrameWnd)
	ON_COMMAND(ID_TOOL_OPEN, OnToolOpen)
	ON_COMMAND(ID_TOOL_CLEAR, OnToolClear)
	ON_COMMAND(ID_TOOL_COPY, OnToolCopy)
	ON_COMMAND(ID_TOOL_PASTE, OnToolPaste)
	ON_UPDATE_COMMAND_UI(ID_TOOL_PASTE, OnUpdateToolPaste)
	ON_COMMAND(ID_TOOL_ELLIPSE, OnToolEllipse)
	ON_COMMAND(ID_TOOL_FILL, OnToolFill)
	ON_COMMAND(ID_TOOL_LINE, OnToolLine)
	ON_COMMAND(ID_TOOL_PEN, OnToolPen)
	ON_COMMAND(ID_TOOL_PICK, OnToolPick)
	ON_COMMAND(ID_TOOL_RECT, OnToolRect)
	ON_UPDATE_COMMAND_UI(ID_TOOL_ELLIPSE, OnUpdateToolEllipse)
	ON_UPDATE_COMMAND_UI(ID_TOOL_FILL, OnUpdateToolFill)
	ON_UPDATE_COMMAND_UI(ID_TOOL_LINE, OnUpdateToolLine)
	ON_UPDATE_COMMAND_UI(ID_TOOL_PEN, OnUpdateToolPen)
	ON_UPDATE_COMMAND_UI(ID_TOOL_PICK, OnUpdateToolPick)
	ON_UPDATE_COMMAND_UI(ID_TOOL_RECT, OnUpdateToolRect)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHCPaletteCommandFrameWnd message handlers

void CHCPaletteCommandFrameWnd::OnToolClear() 
{
	m_pDlgEdit->Clear ();
}

void CHCPaletteCommandFrameWnd::OnToolCopy() 
{
	m_pDlgEdit->Copy ();
}

void CHCPaletteCommandFrameWnd::OnToolPaste() 
{
	m_pDlgEdit->Paste ();
}

void CHCPaletteCommandFrameWnd::OnToolOpen() 
{
	m_pDlgEdit->Open ();
}

void CHCPaletteCommandFrameWnd::OnUpdateToolPaste(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(::IsClipboardFormatAvailable (CF_BITMAP));
}

void CHCPaletteCommandFrameWnd::OnToolEllipse() 
{
	m_pDlgEdit->SetMode (CHCImagePaintArea::IMAGE_EDIT_MODE_ELLIPSE);
}

void CHCPaletteCommandFrameWnd::OnToolFill() 
{
	m_pDlgEdit->SetMode (CHCImagePaintArea::IMAGE_EDIT_MODE_FILL);
}

void CHCPaletteCommandFrameWnd::OnToolLine() 
{
	m_pDlgEdit->SetMode (CHCImagePaintArea::IMAGE_EDIT_MODE_LINE);
}

void CHCPaletteCommandFrameWnd::OnToolPen() 
{
	m_pDlgEdit->SetMode (CHCImagePaintArea::IMAGE_EDIT_MODE_PEN);
}

void CHCPaletteCommandFrameWnd::OnToolPick() 
{
	m_pDlgEdit->SetMode (CHCImagePaintArea::IMAGE_EDIT_MODE_COLOR);
}

void CHCPaletteCommandFrameWnd::OnToolRect() 
{
	m_pDlgEdit->SetMode (CHCImagePaintArea::IMAGE_EDIT_MODE_RECT);
}

void CHCPaletteCommandFrameWnd::OnUpdateToolEllipse(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_pDlgEdit->GetMode () ==
		CHCImagePaintArea::IMAGE_EDIT_MODE_ELLIPSE);
}

void CHCPaletteCommandFrameWnd::OnUpdateToolFill(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_pDlgEdit->GetMode () ==
		CHCImagePaintArea::IMAGE_EDIT_MODE_FILL);
}

void CHCPaletteCommandFrameWnd::OnUpdateToolLine(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_pDlgEdit->GetMode () ==
		CHCImagePaintArea::IMAGE_EDIT_MODE_LINE);
}

void CHCPaletteCommandFrameWnd::OnUpdateToolPen(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_pDlgEdit->GetMode () ==
		CHCImagePaintArea::IMAGE_EDIT_MODE_PEN);
}

void CHCPaletteCommandFrameWnd::OnUpdateToolPick(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_pDlgEdit->GetMode () ==
		CHCImagePaintArea::IMAGE_EDIT_MODE_COLOR);
}

void CHCPaletteCommandFrameWnd::OnUpdateToolRect(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_pDlgEdit->GetMode () ==
		CHCImagePaintArea::IMAGE_EDIT_MODE_RECT);
}

BOOL CHCPaletteCommandFrameWnd::Create(DWORD dwStyle, const RECT& rect, 
	CHCImageEditDlg* pDlgEdit) 
{
	m_pDlgEdit = pDlgEdit;
	ASSERT (m_pDlgEdit != NULL);

	return CFrameWnd::Create(NULL, _T(""), dwStyle, rect, pDlgEdit);
}
