////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// Edit.cpp : Implementation of CICEdit
#include "stdafx.h"
#include "CuteControls.h"
#include "CuteBar.h"
#include "Edit.h"
#include "ReturnLong.h"

/////////////////////////////////////////////////////////////////////////////
// CICEdit

BEGIN_MESSAGE_MAP(CICEdit, CEdit)
	//{{AFX_MSG_MAP(CICEdit)
	ON_CONTROL_REFLECT(EN_CHANGE, OnChange)
	ON_CONTROL_REFLECT(EN_KILLFOCUS, OnKillfocus)
	ON_CONTROL_REFLECT(EN_SETFOCUS, OnSetfocus)
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CICEdit::CICEdit()
{
    m_PasswordCh =0x00;     //Password char
    m_TextLimit =80;
    m_bReadOnly = FALSE;
    m_bBorder = FALSE;
}

CICEdit::~CICEdit()
{
}

void CICEdit::SetHolder(CIItem* pHolder)
{
    ASSERT(pHolder);
    m_pHolder = pHolder;
}

BOOL CICEdit::Create(DWORD dwStyle, const RECT &rect, CWnd *pParentWnd, UINT nID)
{
    CRect rc;
    rc= rect;
//	rc.top = CY_CONTROL_SPACE;
//	rc.bottom += CY_CONTROL_SPACE;
//    rc.left  = 0;
//    rc.right -= 2*CX_CONTROL_SPACE;
   if (m_bReadOnly)
   {
        dwStyle |= ES_READONLY;
	    dwStyle &= ~WS_TABSTOP;
   }else
   {
        dwStyle |= WS_TABSTOP;
	    dwStyle &= ~ES_READONLY;
   }

   if (m_bBorder)
        dwStyle |= WS_BORDER;
   else
	    dwStyle &= ~WS_BORDER;

   m_dwStyle = WS_CHILD|WS_VISIBLE|ES_AUTOVSCROLL|dwStyle;

   BOOL bRet = CEdit::Create(m_dwStyle, rc, pParentWnd, nID );
   if (bRet)
   {
       if (m_dwStyle& ES_READONLY)
           SetReadOnly(TRUE);
       SetLimitText(m_TextLimit);
       SetWindowText(m_String);
       SetPasswordChar(m_PasswordCh);
   }
   return bRet;
}

void CICEdit::Serialize(CArchive &ar)
{
    if (ar.IsStoring())
	{
       ar << m_dwStyle;
       ar << m_bReadOnly;
       ar << m_TextLimit;
       ar << m_String;
       ar << m_PasswordCh;
       ar << m_bBorder;
    }
    else
    {
        ar >> m_dwStyle;
        ar >> m_bReadOnly;
        ar >> m_TextLimit;        
        ar >> m_String;
        ar >> m_PasswordCh;
        ar >> m_bBorder;
    }
}

void CICEdit::SetFocus()
{
    CEdit::SetFocus();
}

void CICEdit::Update()
{
#ifdef URESOLVED
    if ( m_bDirty == FALSE)
        return;
#endif
}

STDMETHODIMP CICEdit::get_ReadOnly(VARIANT_BOOL *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    BOOL bRet = FALSE;
    if (m_hWnd)
    {
       m_bReadOnly = FALSE;
       if (GetStyle() & ES_READONLY)
        {
             bRet = TRUE;
            m_bReadOnly = TRUE;
        }
    }
    else
    {
        bRet = m_bReadOnly;
    }

    *pVal = bRet ? VARIANT_TRUE: VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP CICEdit::put_ReadOnly(VARIANT_BOOL newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    m_bReadOnly  = newVal ? TRUE : FALSE;
    if (m_hWnd)
        SetReadOnly(m_bReadOnly);

	return S_OK;
}

STDMETHODIMP CICEdit::get_MaxLength(long *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    if (m_hWnd)
        m_TextLimit = GetLimitText();

    *pVal = m_TextLimit;
	return S_OK;
}

STDMETHODIMP CICEdit::put_MaxLength(long newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    m_TextLimit = newVal;
    if (m_hWnd)
        SetLimitText(m_TextLimit);
	return S_OK;
}

STDMETHODIMP CICEdit::get_Text(BSTR *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    if (m_hWnd)
        GetWindowText(m_String);

    *pVal = m_String.AllocSysString();;
	return S_OK;
}

STDMETHODIMP CICEdit::put_Text(BSTR newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CComBSTR cbstr;
    cbstr.AppendBSTR(newVal);
    m_String = cbstr;
    if (m_hWnd)
        SetWindowText((LPCSTR) m_String);
    
	return S_OK;
}

STDMETHODIMP CICEdit::get_PasswordChar(BSTR *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    if (m_hWnd)
        m_PasswordCh = GetPasswordChar();
    CString str(m_PasswordCh);

   *pVal = str.AllocSysString();
	return S_OK;
}

STDMETHODIMP CICEdit::put_PasswordChar(BSTR newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CString str(newVal);
    m_PasswordCh = 0x00;
    if (!str.IsEmpty())
        m_PasswordCh = str[0];
    if (m_hWnd)
       SetPasswordChar(m_PasswordCh);

	return S_OK;
}

STDMETHODIMP CICEdit::get_Border(VARIANT_BOOL *pVal)
{
    *pVal = m_bBorder ? VARIANT_TRUE: VARIANT_FALSE;

	return S_OK;
}

STDMETHODIMP CICEdit::put_Border(VARIANT_BOOL newVal)
{
    m_bBorder  = newVal ? TRUE : FALSE;

	return S_OK;
}

CWnd* CICEdit::GetControl()
{
    return this;
}
/////////////////////////////////////////////////////////////////////////////
// CICEdit message handlers

void CICEdit::OnChange() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CEdit::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	 ASSERT(m_pHolder);
     ASSERT(m_pHolder->m_pMainControl);

     CComPtr<IItem> pItem;
     HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
     if (SUCCEEDED(hr))
        m_pHolder->m_pMainControl->Fire_TextChanged(pItem);				
}

void CICEdit::OnKillfocus() 
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemLostFocus(pItem);	
}

void CICEdit::OnSetfocus() 
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);
    
    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemGotFocus(pItem);		
}

void CICEdit::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
    ASSERT(m_pHolder);
    UINT nChr = nChar;
    
    CComObject<CReturnLong>* pObj;
    CComPtr<IReturnLong> pIRetlong;
    CComPtr<IReturnLong> pVal;

    CComObject<CReturnLong>::CreateInstance(&pObj);
    pObj->QueryInterface(&pIRetlong);
    pIRetlong.p->QueryInterface(IID_IDispatch,(void**)&pVal);

    pObj->m_lValue =(long)nChar;
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemKeyPress(pItem, pVal);

    nChar = (UINT)pObj->m_lValue;

    UINT nMsg = WM_CHAR; WPARAM wParam = nChar; LPARAM lParam = MAKELPARAM(nFlags,nRepCnt);
    DefWindowProc( nMsg,  wParam,  lParam);
}

void CICEdit::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemKeyDown(pItem, nChar, _ShiftState());
	
	CEdit::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CICEdit::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemKeyUp(pItem, nChar, _ShiftState());	

	CEdit::OnKeyUp(nChar, nRepCnt, nFlags);
}
