// CoreEdit.cpp : implementation file
//

#include "stdafx.h"
#include "cutecontrols.h"
#include "CoreEdit.h"
#include "Edit.h"
#include "CuteBar.h"
#include "ReturnLong.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCoreEdit
IMPLEMENT_DYNAMIC(CCoreEdit, CEdit)

CCoreEdit::CCoreEdit(CICEdit* pHolder)
{
    ASSERT(pHolder);
    m_pHolder = pHolder;
}

CCoreEdit::~CCoreEdit()
{
}


BEGIN_MESSAGE_MAP(CCoreEdit, CEdit)
	//{{AFX_MSG_MAP(CCoreEdit)
	ON_CONTROL_REFLECT(EN_CHANGE, OnChange)
	ON_CONTROL_REFLECT(EN_KILLFOCUS, OnKillfocus)
	ON_CONTROL_REFLECT(EN_SETFOCUS, OnSetfocus)
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCoreEdit message handlers

void CCoreEdit::OnChange() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CEdit::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	 ASSERT(m_pHolder);
     ASSERT(m_pHolder->m_pMainControl);

     CComPtr<IItem> pItem;
     HRESULT hr = m_pHolder->QueryInterface(IID_IDispatch,(void**)&pItem);
     if (SUCCEEDED(hr))
        m_pHolder->m_pMainControl->Fire_TextChanged(pItem);				
}

void CCoreEdit::OnKillfocus() 
{
	// TODO: Add your control notification handler code here
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->QueryInterface(IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemLostFocus(pItem);	
}
void CCoreEdit::OnSetfocus() 
{
	// TODO: Add your control notification handler code here
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);
    
    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->QueryInterface(IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemGotFocus(pItem);		
}

void CCoreEdit::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
    ASSERT(m_pHolder);
    UINT nChr = nChar;
    
    CComObject<CReturnLong>* pObj;
    CComPtr<IReturnLong> pIRetlong;
    CComPtr<IReturnLong> pVal;

    CComObject<CReturnLong>::CreateInstance(&pObj);
    pObj->QueryInterface(&pIRetlong);
    pIRetlong.p->QueryInterface(IID_IDispatch,(void**)&pVal);

    pObj->m_lValue =(long)nChar;
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->QueryInterface(IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemKeyPress(pItem, pVal);

    nChar = (UINT)pObj->m_lValue;

    UINT nMsg = WM_CHAR; WPARAM wParam = nChar; LPARAM lParam = MAKELPARAM(nFlags,nRepCnt);
    DefWindowProc( nMsg,  wParam,  lParam);
}

void CCoreEdit::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->QueryInterface(IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemKeyDown(pItem, nChar, _ShiftState());
	
	CEdit::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CCoreEdit::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->QueryInterface(IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemKeyUp(pItem, nChar, _ShiftState());	

	CEdit::OnKeyUp(nChar, nRepCnt, nFlags);
}

BOOL CCoreEdit::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CEdit::DestroyWindow();
}
