////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// BarPropPage.h : Declaration of the CBarPropPage

#ifndef __BARPROPPAGE_H_
#define __BARPROPPAGE_H_

#include "resource.h"       // main symbols
#include "NewBarDlg.h"
#include "cutebar.h"
#include "bar.h"
#include "HelpTOC.h"

#include "resource.hm"

#define CX_BITMAP	16	
#define CY_BITMAP	16
#define NUM_BITMAPS 256

#define MAX_ID_BASE 1024


//#define ENABLE_BAR_CURSORS // to enable IBar::MousePointer property handling


EXTERN_C const CLSID CLSID_BarPropPage;

#define nBAR_TYPES  1
CICuteBar* _GetMainControl();

class    CPropBarDlg;
class    CPropItemDlg;
class    CPropEditDlg;
class    CPropComboDlg;
class    CPropLabelDlg;

struct BAR_PROPRETIES
{
  CList<DWORD,DWORD> ItemOrder;
//*** Retrieved data
  BOOL          bDirty;
  CString       Name;
  UINT          Id;
  BOOL          Visible;
  enBarStyle    Style;
  enBarType     Type;
  int           ItemWidth;
  int           ItemHeight;
  int           ImageWidth;
  int           ImageHeight;
  enGripStyle   Grip;
  enDockState   DockState;
  int           DockStyle;
  BOOL          HideCtrls;
  BOOL          UseIList;

  BAR_PROPRETIES()
  {
     bDirty = FALSE;
     Id = 0;
     Visible = TRUE;
     Style = ccFlatBar;
     Type = ccStandard;
     ItemWidth = 23;
     ItemHeight = 22;
     ImageWidth = 16;
     ImageHeight = 15;
     Grip = ccGripSingle;
     DockState = ccDTop;
     DockStyle = ccDSAny;
     HideCtrls = FALSE;
     UseIList = FALSE;
     HideCtrls = TRUE;
  }

};

struct ITEM_CONTROLDATA
{
//*** Provided date
    BAR_PROPRETIES * pBar;
    enItemType Type;
    ITEM_CONTROLDATA()
    {
     pBar = NULL;
     Type = (enItemType)0 ;
    }
};

struct ITEM_PROPERTIES: public ITEM_CONTROLDATA
{
//*** Retrieved data
    BOOL    bDirty;
    CString Name;
    UINT    Id;
    BOOL    Visible;
    CString Tooltip;
    UINT    HotKey;
    BOOL    Enabled;
    UINT    State;
    int     Style;
    HBITMAP hPic;
    HBITMAP hPicHot;
    HBITMAP hPicDsbl;

    ITEM_PROPERTIES()
    {
        bDirty = FALSE;
        Id = 0;
        Visible = TRUE;
        HotKey = 0;
        Enabled = TRUE;
        State = 0;
        Style = 0;
        hPic = NULL;
        hPicHot = NULL;
        hPicDsbl = NULL;
   }
};

struct COMBO_PROPERTIES : public ITEM_PROPERTIES
{
    BOOL    bSort;
    UINT    State;
    int     Style;
    int     count;
    int    top;
    int    left;
    int    width;
    int    height;
    CStringArray   Strings; // Combo strings

    COMBO_PROPERTIES()
    {
        bSort = FALSE;
        State = 0;
        Style = 0;
        count = 0;
        top = 0;
        left = 0;
        width = 120;
        height = 20;
    }
};

struct EDIT_PROPERTIES: public ITEM_PROPERTIES
{
    CString Text;
    int     count;
    int    top;
    int    left;
    int    width;
    int    height;
    int    Alignment;
    BOOL    ReadOnly;
    BOOL    Boder;
    int     MaxLenght;
    CString PassChar;

    EDIT_PROPERTIES()
    {
        State = 0;
        Style = 0;
        count = 0;
        top = 0;
        left = 0;
        width = 120;
        height = 20;
        Alignment = 0;
        ReadOnly = FALSE;
        Boder = 0;
        MaxLenght = 120;
    }
};

struct LABEL_PROPERTIES: public ITEM_PROPERTIES
{
    CString Text;
    int     count;
    int    top;
    int    left;
    int    width;
    int    height;
    int    Alignment;
    BOOL    ReadOnly;
    BOOL    Boder;
    int     MaxLenght;
    CString PassChar;

    LABEL_PROPERTIES()
    {
        State = 0;
        Style = 0;
        count = 0;
        top = 0;
        left = 0;
        width = 80;
        height = 20;
        Alignment = 0;
        ReadOnly = FALSE;
        Boder = 0;
        MaxLenght = 120;
    }
};

/////////////////////////////////////////////////////////////////////////////
// CBarPropPage
class ATL_NO_VTABLE CBarPropPage :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CBarPropPage, &CLSID_BarPropPage>,
	public IPropertyPageImpl<CBarPropPage>,
	public CDialogImpl<CBarPropPage>
{
protected: 

    struct IMAGE_POS
    {
        int nImgToolBar;
        int nImgMenuBar;
        int nImgButton;
        int nImgToggleBtn;
        int nImgDropDn;
        int nImgLabel;
        int nImgCombo;
        int nImgEdit;
        int nImgSep;
        int nImgMenu;

    } m_posImage;

#define NUMBEROF_IMAGES  sizeof (IMAGE_POS)/sizeof(int)

    enum SELECTION_TYPE
    {
        SelNone,
        SelBar,
        SelItem
    };

	void SetItemName(HTREEITEM hItem,LPSTR Name);
	BOOL InsertBar(enBarType cType,LPCSTR sTitle);
    BOOL InsertAnyItem(POSITION BarPos, enItemType Type,LPCSTR sTitle);
	BOOL TreeInitImages();
	HTREEITEM TreeAddItem(LPCSTR lpszItem, int nLevel,int nIndex,int nData, HTREEITEM hInsertAfter = NULL , BOOL bInsTail = FALSE);
	BOOL InitTree(UINT nCount);
	void OnButtonUp(BOOL bCopy = FALSE);
	BOOL TransferItem(HTREEITEM hitemDrag, HTREEITEM hitemDrop);
    POSITION NewItemProp(BAR_PROPRETIES *pBar, enItemType Type, IItem* pItem);
	POSITION InsItemProp(BAR_PROPRETIES* pBar, POSITION InsAfter, enItemType Type, LPCSTR sTitle);

	HWND m_hTreeViewCtl;
	HIMAGELIST m_hDragImage;
    HIMAGELIST m_hIml;  // handle to image list
	HTREEITEM m_htiSelection;	// currently  selected tree item
	BOOL m_bDragging;
	HTREEITEM   m_hitemDrag;
	HTREEITEM   m_hitemDrop;
	HCURSOR		m_hSaveCursor;

    BOOL        m_ChngCursor; // true if cursor is changed
	HINSTANCE   m_ResInst;
//    CComPtr<IBar>       m_spBarActive;
//    CComPtr<IItem>      m_spItemActive;
    CPropBarDlg*    m_pBarPropDlg;
    CPropItemDlg*   m_pItemPropDlg;
    CPropEditDlg*   m_pEditPropDlg;
    CPropComboDlg*  m_pComboPropDlg;
    CPropLabelDlg*  m_plabelPropDlg;

    POSITION  m_nBarActive;
    POSITION  m_nItemActive;
    SELECTION_TYPE    m_bSelType;

    CList<BAR_PROPRETIES*,BAR_PROPRETIES*> m_pBarPropsList;
    CList<ITEM_CONTROLDATA*,ITEM_CONTROLDATA*> m_pItemPropsList;

    typedef CComPtr<IBar> Cunk;
    typedef IBar pIUnk;
//    CMap<UINT,UINT,Cunk,pIUnk> m_pObjMap;

public:
	BOOL UpdateProperties();
	BOOL DeteteAnyItem(POSITION posBar, POSITION pos, BOOL bDelTreeItem = FALSE);
	void AddItemsMenu(CPoint& ptAction);
	UINT m_nMaxID;
	CBarPropPage(); 
	~CBarPropPage(); 

	enum {IDD = IDD_BARPROPPAGE};

DECLARE_REGISTRY_RESOURCEID(IDR_BARPROPPAGE)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CBarPropPage) 
	COM_INTERFACE_ENTRY(IPropertyPage)
END_COM_MAP()

#define WM_MODIFIED WM_USER +225    // Notification message for derived objects

BEGIN_MSG_MAP(CBarPropPage)
	CHAIN_MSG_MAP(IPropertyPageImpl<CBarPropPage>)
	COMMAND_HANDLER(IDC_NEW, BN_CLICKED, OnClickedNew)
	MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
	COMMAND_HANDLER(IDC_DELETE, BN_CLICKED, OnClickedDelete)
	NOTIFY_HANDLER(IDC_TREE1, TVN_SELCHANGED, OnSelchangedTree1)
	MESSAGE_HANDLER(WM_MOUSEMOVE, OnMouseMove)
	NOTIFY_HANDLER(IDC_TREE1, TVN_BEGINDRAG, OnBegindragTree1)
	NOTIFY_HANDLER(IDC_TREE1, TVN_ENDLABELEDIT, OnEndlabeleditTree1)
	MESSAGE_HANDLER(WM_LBUTTONUP, OnLButtonUP)
	NOTIFY_HANDLER(IDC_TREE1, NM_RCLICK, OnRclickTree1)
	COMMAND_ID_HANDLER(IDM_NEW, OnNewBar)
    COMMAND_RANGE_HANDLER( IDM_INS_BTN, IDM_INS_BTNSP, OnInsertItem )
	COMMAND_ID_HANDLER(IDM_DELETE, OnDeleteItem)
	NOTIFY_HANDLER(IDC_TREE1, TVN_KEYDOWN, OnKeydownTree1)
//	COMMAND_HANDLER(IDC_CHECK_BTN_NORM, BN_CLICKED, OnClickedCheck_btn_norm)
//	COMMAND_HANDLER(IDC_CHECK_BTN_PRESS, BN_CLICKED, OnClickedCheck_btn_press)
#ifdef COMBO_PROP_READONLY
	COMMAND_HANDLER(IDC_CHECK_COMBO_RO, BN_CLICKED, OnClickedCheck_combo_ro)
#endif
	COMMAND_HANDLER(IDC_BUTTON_HFILE, BN_CLICKED, OnClickedButton_hfile)
	COMMAND_HANDLER(IDC_BUTTON_SAVE, BN_CLICKED, OnClickedButton_save)
	COMMAND_HANDLER(IDC_BUTTON_LOAD, BN_CLICKED, OnClickedButton_laod)
	MESSAGE_HANDLER(WM_HELP, OnHelpMessage)
	MESSAGE_HANDLER(WM_MODIFIED, OnModified)
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);


STDMETHOD(Activate)(HWND hWndParent, LPCRECT prc, BOOL bModal)
{
   // Call the base class implementation
   HRESULT hr = IPropertyPageImpl<CBarPropPage>::Activate(hWndParent, prc, bModal);
   if (FAILED(hr))
      return hr;
#ifdef SDS
   // Get the FullName property
   ComBSTR bstr;
   hr = pBarCollection->get_FullName(&bstr);
   if (FAILED(hr))
      return hr;
   // Set the text box so that the user can see the document name
   USES_CONVERSION;
   SetDlgItemText(IDC_NAME, W2CT(bstr));
   // Get the ReadOnly property
   VARIANT_BOOL bReadOnly = VARIANT_FALSE;
   hr = pDoc->get_ReadOnly(&bReadOnly);
   if (FAILED(hr))
      return hr;
   // Set the check box to show the document's read-only status
   CheckDlgButton(IDC_READONLY,
                  bReadOnly ? BST_CHECKED : BST_UNCHECKED);
#endif
   return hr;
}

STDMETHOD(Apply)(void)
{
	ATLTRACE(_T("CBarPropPage::Apply\n"));
	m_bDirty = FALSE;
    _GetMainControl()->SetDirty(TRUE);

    UpdateProperties();

    CComQIPtr<ICuteBar,&IID_ICuteBar> spControl(m_ppUnk[0]);
    spControl->Refresh();
	return S_OK;
}

STDMETHOD(Help)(LPCOLESTR pszHelpDir)
{
	ATLTRACE2(atlTraceControls,2,_T("IPropertyPageImpl::Help\n"));
	CComBSTR szFullFileName(pszHelpDir);
	LPOLESTR szFileName = LoadStringHelper(m_dwHelpFileID);
	szFullFileName.Append(OLESTR("\\"));
	szFullFileName.Append(szFileName);
	CoTaskMemFree(szFileName);
    OnHelp(szFullFileName);
	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////
// CPropPage
protected:
	POSITION FindItemOrderFromPos(BAR_PROPRETIES* pBarProp, POSITION pos);
	BOOL ClearLists();
	BOOL DeleteBar(POSITION nPos);
	BOOL OnDelete();
	BOOL OnNewItem();
	void SetMaxID(UINT nID);
	UINT GetMaxID();
	BOOL InitDialogs();
	void ShowItemProp(ITEM_CONTROLDATA* pItemProp);
	void ShowBarProp(BAR_PROPRETIES* pBarProp);

LRESULT OnNewBar(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
LRESULT OnDeleteItem(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
LRESULT OnInsertItem(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
LRESULT OnClickedNew(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
LRESULT OnClickedDelete(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);

	LRESULT OnHelpMessage(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
    BOOL OnHelp(CComBSTR& bstrName);
	LRESULT OnSelchangedTree1(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);
	LRESULT OnMouseMove(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnBegindragTree1(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);
	LRESULT OnEndlabeleditTree1(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);
	LRESULT OnLButtonUP(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnRclickTree1(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);
	LRESULT OnKeydownTree1(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);
	LRESULT OnClickedButton_hfile(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	LRESULT OnClickedButton_save(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	LRESULT OnClickedButton_laod(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
    LRESULT OnModified(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled){SetDirty(TRUE); return 0; }
};

#endif //__BARPROPPAGE_H_
