// BarPropPage.cpp : Implementation of CBarPropPage
#include "stdafx.h"
#include "CuteControls.h"
#include "BarPropPage.h"
#include "ImageEditDlg.h"

#include "PropBarDlg.h"
#include "PropLabelDlg.h"
#include "PropItemDlg.h"
#include "PropEditDlg.h"
#include "PropComboDlg.h"

/////////////////////////////////////////////////////////////////////////////
// CBarPropPage
CBarPropPage::CBarPropPage() 
{
	m_dwTitleID = IDS_TITLEBarPropPage;
	m_dwHelpFileID = IDS_HELPFILEBarPropPage;
	m_dwDocStringID = IDS_DOCSTRINGBarPropPage;

	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	m_ResInst = AfxGetResourceHandle();
	m_bDragging = FALSE;
	m_hDragImage = NULL;
    m_ChngCursor = FALSE;
    m_htiSelection = NULL;
    m_bSelType = SelNone;
    m_nMaxID = MAX_ID_BASE;

    m_nBarActive = 0;
    m_nItemActive = 0;

    m_pBarPropDlg = NULL;
    m_pItemPropDlg = NULL;
    m_pEditPropDlg = NULL;
    m_pComboPropDlg = NULL;
    m_plabelPropDlg = NULL;
}
CBarPropPage::~CBarPropPage()
{
    //release all properties
    ClearLists();

    if (m_pBarPropDlg ) delete m_pBarPropDlg;
    if (m_pItemPropDlg ) delete m_pItemPropDlg;
    if (m_pEditPropDlg ) delete m_pEditPropDlg;
    if (m_pComboPropDlg ) delete m_pComboPropDlg;
    if (m_plabelPropDlg ) delete m_plabelPropDlg;
}

/////////////////////////////////////////////////////////////////////////////
// CPropPage

 LRESULT CBarPropPage::OnNewBar(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	OnNewItem();
	return 0;
}

 LRESULT CBarPropPage::OnDeleteItem(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    OnDelete();
	return 0;
}
 LRESULT CBarPropPage::OnInsertItem(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
     enItemType Type = ccTypeButton;
     switch (wID)
     {
     case IDM_INS_BTN:
         Type = ccTypeButton;
         break;
     case IDM_INS_BTNTGL:
         Type = ccTypeToggleButton;
         break;
     case IDM_INS_BTNDD:
         Type = ccTypeDropDown;
         break;
     case IDM_INS_BTNDDTGL:
         Type = ccTypeToggleDropDown;
         break;
     case IDM_INS_BTNCB:
         Type = ccTypeComboBox;
         break;
     case IDM_INS_BTNED:
         Type = ccTypeEdit;
         break;
     case IDM_INS_BTNLB:
         Type = ccTypeLabel;
         break;
     case IDM_INS_BTNSP:
         Type = ccTypeSeparator;
         break;
     case IDM_INS_BTNMN:
         Type = ccTypeMenu;
         break;
     default:
         Type = ccTypeButton;
         break;
     }
    InsertAnyItem(m_nBarActive,Type,NULL);

     return 0;
}

LRESULT CBarPropPage::OnClickedNew(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	OnNewItem();
	return 0;
}

LRESULT CBarPropPage::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())
#ifdef SDS
	USES_CONVERSION;
	for (UINT i = 0; i < m_nObjects; i++)
	{
	  CComQIPtr<ICuteBar, &IID_ICuteBar> pBar(m_ppUnk[i]);

	  if FAILED(pBar->get_GetDataPointer((LPUNKNOWN*) pBars))
	  {
		CComPtr<IErrorInfo> pError;
		CComBSTR         strError;
		GetErrorInfo(0, &pError);         
		pError->GetDescription(&strError);
		MessageBox(OLE2T(strError), _T("Error"), MB_ICONEXCLAMATION);
		return E_FAIL;
	  }
	}
#endif
    bHandled = InitDialogs();

	InitTree(0);
	m_bDirty = FALSE;

	return 0;
}

LRESULT CBarPropPage::OnClickedDelete(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())
    OnDelete();
	return 0;
}

BOOL CBarPropPage::InitTree(UINT nCount)
{
	m_hTreeViewCtl = GetDlgItem(IDC_TREE1);
	m_htiSelection = NULL;

    TreeView_DeleteAllItems(m_hTreeViewCtl); // just in case 

	if (!TreeInitImages())		// Init tree images
		return FALSE;

   // Get the IBarCollection pointer
    CComPtr<IBarCollection> pBarCollection;
    ICuteBar* pCutes = (ICuteBar*)m_ppUnk[0];
   if (FAILED(pCutes->get_Bars((BarCollection**)&pBarCollection)))
      return FALSE;

    //release all properties
    ClearLists();

    // Init Tree Item for Bars and buttons
   long count = 0;
   pBarCollection->get_Count(&count);
   BOOL bFirst = TRUE;
   for (int i = 0 ; i < count; i++)
   {
        CComPtr<IBar> pIBar;
        CComVariant vBarIndex(i+1);
        if (FAILED(pBarCollection->get_Item(&vBarIndex,&pIBar)))  // Collections begins from 1 ?
            continue;
        if (pIBar)
        {
            BAR_PROPRETIES* pBarProp = new BAR_PROPRETIES;
            pBarProp->bDirty = FALSE;
            POSITION  BarPos = m_pBarPropsList.AddTail(pBarProp);
            m_pBarPropDlg->ReadProp(pIBar, pBarProp);

            // Set Name
            CComBSTR bstr;
            pIBar->get_Name(&bstr);
            long nID;
            pIBar->get_ID(&nID);
            SetMaxID(nID);
            USES_CONVERSION;
            // level =1 and  hti == NULL if root item( Bars)
   	        HTREEITEM htinew = TreeAddItem(W2CT(bstr),1,(int)BarPos,ccStandard,NULL);

            CComPtr<IItemCollection> pItemCollection;
            if (FAILED(pIBar->get_Items((ItemCollection**)&pItemCollection)))
                continue;
            long nButtons;
            pItemCollection->get_Count(&nButtons);
            for (int i = 0; i < nButtons; i++)
            {
                CComPtr<IItem> pItem;
                CComVariant var(i+1);
                if (FAILED(pItemCollection->get_Item(&var,&pItem)))
                    continue;               // Collections begin from 1 ?
                
                enItemType Type;
                if (SUCCEEDED(pItem->get_Type(&Type)) )
                {                
                    if( Type != ccTypeSeparator)
                    {
                        long nID;
                        pItem->get_ID(&nID);
                        SetMaxID(nID);
                    }

                    POSITION ItemPos = NewItemProp(pBarProp,Type,pItem);
                    if (!ItemPos) continue;
                
   	                TreeAddItem(NULL,2,(int)ItemPos, Type,htinew,TRUE); // insert tail
                    pBarProp->ItemOrder.AddTail((int)ItemPos);
                }
            }
            if (bFirst)
            {
                bFirst = FALSE;
                TreeView_SelectItem(m_hTreeViewCtl,htinew);
            }
        }
   }

    return TRUE;
}

HTREEITEM CBarPropPage::TreeAddItem(LPCSTR lpszItem, int nLevel, int nIndex, int nData, HTREEITEM hInsertAfter, BOOL bInsTail)
{
	TV_INSERTSTRUCT tvins;
    memset(&tvins,0,sizeof(tvins));

    tvins.item.mask = TVIF_TEXT | TVIF_IMAGE 
        | TVIF_SELECTEDIMAGE | TVIF_PARAM;
	// Set the text of the item. 
    tvins.item.pszText = (LPSTR) lpszItem;
    tvins.item.cchTextMax = lpszItem ? strlen(lpszItem): 0;  
	
    // Save the pointer to ControlBlock(CB) in the item's application-defined 
    // data area.
	tvins.item.lParam = (LPARAM) nIndex;
	
    // Set the parent item based on the specified level.
	if (nLevel == 1)
	{
        tvins.hParent = TVI_ROOT;
		// set image.
		tvins.item.iImage = m_posImage.nImgToolBar; 
		tvins.item.iSelectedImage = m_posImage.nImgToolBar;
        enBarType Type = (enBarType)nData;
        if(Type == ccMenuBar)
		{
			tvins.item.iImage = m_posImage.nImgMenuBar; 
			tvins.item.iSelectedImage = m_posImage.nImgMenuBar;
		}
	}
	else					//if (nLevel == 2) 
	{
        if (bInsTail)
        {
            tvins.hParent = hInsertAfter;
            tvins.hInsertAfter = TVI_LAST;
        }
        else
        {
            tvins.hParent = TreeView_GetParent(m_hTreeViewCtl, hInsertAfter);
            tvins.hInsertAfter = hInsertAfter;
        }
        enItemType Type = (enItemType)nData;
        int nImage = 0;

        switch (Type)
        {
        case ccTypeButton:
            tvins.item.pszText = _T("Button");
            nImage = m_posImage.nImgButton;
            break;
        case ccTypeToggleButton:
            tvins.item.pszText = _T("ToggleButton");
            nImage = m_posImage.nImgToggleBtn;
            break;
        case ccTypeDropDown:
            tvins.item.pszText = _T("DropDownButton");
            nImage = m_posImage.nImgDropDn;
            break;
        case ccTypeToggleDropDown:
            tvins.item.pszText = _T("ToggleDropDownButton");
            nImage = m_posImage.nImgDropDn;
            break;
        case ccTypeComboBox:
            tvins.item.pszText = _T("ComboBox");
            nImage = m_posImage.nImgCombo;
            break;
        case ccTypeEdit:
            tvins.item.pszText = _T("Edit");
            nImage = m_posImage.nImgEdit;
            break;
        case ccTypeLabel:
            tvins.item.pszText = _T("Label");
            nImage = m_posImage.nImgLabel;
            break;
        case ccTypeSeparator:
            tvins.item.pszText = _T("Separator");
            nImage = m_posImage.nImgSep;
            break;
        case ccTypeMenu:
            tvins.item.pszText = _T("Menu Item");
            nImage = m_posImage.nImgMenu;
            break;
        default:
            ASSERT(FALSE);
            break;
        }
	    tvins.item.cchTextMax = lstrlen(tvins.item.pszText);
		tvins.item.iImage = nImage; 
		tvins.item.iSelectedImage = nImage;
	}

    // Add the item to the tree view control. 
   return TreeView_InsertItem(m_hTreeViewCtl, &tvins); 
}

BOOL CBarPropPage::TreeInitImages()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    HBITMAP hbmp;     // handle to bitmap
	// Create the image list. 
    if ((m_hIml = ImageList_Create(CX_BITMAP, CY_BITMAP, 
        FALSE, NUM_BITMAPS, 0)) == NULL)
		return FALSE; 
    
    hbmp = LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_TOOLBAR)); 
    m_posImage.nImgToolBar = ImageList_Add(m_hIml, hbmp, (HBITMAP) NULL); 
    DeleteObject(hbmp); 

    hbmp = LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_MENUBAR)); 
    m_posImage.nImgMenuBar = ImageList_Add(m_hIml, hbmp, (HBITMAP) NULL); 
    DeleteObject(hbmp); 

    hbmp = LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_BMP_BUTTON)); 
    m_posImage.nImgButton = ImageList_Add(m_hIml, hbmp, (HBITMAP) NULL); 
    DeleteObject(hbmp); 
    hbmp = LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_BMP_TOGGLEBUTTON)); 
    m_posImage.nImgToggleBtn = ImageList_Add(m_hIml, hbmp, (HBITMAP) NULL); 
    DeleteObject(hbmp); 
    hbmp = LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_BMP_COMBO)); 
    m_posImage.nImgCombo = ImageList_Add(m_hIml, hbmp, (HBITMAP) NULL); 
    DeleteObject(hbmp); 
    hbmp = LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_BMP_DROPD)); 
    m_posImage.nImgDropDn = ImageList_Add(m_hIml, hbmp, (HBITMAP) NULL); 
    DeleteObject(hbmp); 
    hbmp = LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_BMP_EDIT)); 
    m_posImage.nImgEdit = ImageList_Add(m_hIml, hbmp, (HBITMAP) NULL); 
    DeleteObject(hbmp); 
    hbmp = LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_BMP_LABEL)); 
    m_posImage.nImgLabel = ImageList_Add(m_hIml, hbmp, (HBITMAP) NULL); 
    DeleteObject(hbmp); 
    hbmp = LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_BMP_SEP)); 
    m_posImage.nImgSep = ImageList_Add(m_hIml, hbmp, (HBITMAP) NULL); 
    DeleteObject(hbmp); 
    hbmp = LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_BMP_MENUITEM)); 
    m_posImage.nImgMenu = ImageList_Add(m_hIml, hbmp, (HBITMAP) NULL); 
    DeleteObject(hbmp); 

	// Fail if not all of the images were added. 
    if (ImageList_GetImageCount(m_hIml) < NUMBEROF_IMAGES)
		return FALSE; 
    // Associate the image list with the tree view control. 
    TreeView_SetImageList(m_hTreeViewCtl, m_hIml, TVSIL_NORMAL);

	return TRUE;
}

void CBarPropPage::OnButtonUp(BOOL bCopy)
{
	if (m_bDragging)
	{
		ASSERT(m_hDragImage != NULL);
		ImageList_DragLeave(m_hTreeViewCtl);
		ImageList_EndDrag();
		ImageList_Destroy(m_hDragImage);
		m_hDragImage = NULL;

        HTREEITEM htiParent = TreeView_GetParent(m_hTreeViewCtl,m_hitemDrop);
        POSITION pData = 0;
        CComPtr<IBar> pBar;
        if (htiParent)
        {
            TVITEM item;
            memset(&item,0,sizeof(item));
            item.mask = TVIF_PARAM; item.hItem = htiParent;
            TreeView_GetItem(m_hTreeViewCtl,&item);
            pData = (POSITION) item.lParam;
        }

		if (m_hitemDrag != m_hitemDrop 
			&& pData == m_nBarActive)	
			TransferItem(m_hitemDrag, m_hitemDrop);
		else
			MessageBeep(0);

		ReleaseCapture();
		m_bDragging = FALSE;
		TreeView_SelectDropTarget(m_hTreeViewCtl, NULL); 
		SetCursor(m_hSaveCursor);

	}
}

BOOL CBarPropPage::TransferItem(HTREEITEM hitemDrag, HTREEITEM hitemDrop)
{
    BOOL bRet = FALSE;
    TV_INSERTSTRUCT     tvstruct;
	TCHAR               sztBuffer[MAX_SIZE_NAME];
    TVITEM              tviDropItem;
    memset(&tviDropItem,0,sizeof(TVITEM));
    tviDropItem.hItem  = hitemDrop;
	tviDropItem.mask = TVIF_PARAM;
	TreeView_GetItem(m_hTreeViewCtl,&tviDropItem);  // get information of the dragged element

    POSITION nInsAfter = (POSITION)tviDropItem.lParam;
	
	// avoid an infinite recursion    
    HTREEITEM hInsertAfter = TVI_FIRST;
    HTREEITEM hParent = TreeView_GetParent(m_hTreeViewCtl,hitemDrag);
    if (hParent)
        hInsertAfter = hitemDrop;

    tvstruct.hParent = TreeView_GetParent(m_hTreeViewCtl,hitemDrop);
    tvstruct.hInsertAfter = hInsertAfter;
	tvstruct.item.hItem = hitemDrag;
	tvstruct.item.cchTextMax = MAX_SIZE_NAME-1;
	tvstruct.item.pszText = sztBuffer;
 	tvstruct.item.mask = TVIF_CHILDREN | TVIF_HANDLE | TVIF_IMAGE |
                         TVIF_SELECTEDIMAGE | TVIF_TEXT |TVIF_PARAM;
    // get information of the dragged element
	TreeView_GetItem(m_hTreeViewCtl,&tvstruct.item);  

    BAR_PROPRETIES* pBarProp = m_pBarPropsList.GetAt(m_nBarActive);
    ASSERT(pBarProp);

    // find drop target item name and insert after
    POSITION nItem = (POSITION) tvstruct.item.lParam;

    POSITION posDrag = FindItemOrderFromPos(pBarProp, nItem);
    POSITION posDrop = FindItemOrderFromPos(pBarProp, nInsAfter);

    pBarProp->ItemOrder.InsertAfter(posDrop,(DWORD)nItem);
    pBarProp->ItemOrder.RemoveAt(posDrag);

    TreeView_InsertItem(m_hTreeViewCtl, &tvstruct);
    TreeView_DeleteItem(m_hTreeViewCtl, m_hitemDrag);

	SetDirty(TRUE);
    bRet = TRUE;

	return bRet;
}

BOOL CBarPropPage::InsertBar(enBarType cType, LPCSTR sTitle)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	HTREEITEM hti = NULL;
    CString Title;

	if ( m_htiSelection )
		hti = TreeView_GetParent(m_hTreeViewCtl,m_htiSelection);

    int Level;
    UINT nID = GetMaxID();

    if (sTitle == NULL)
        Title.Format(_T("Bar%d"),nID);
    else
        Title = sTitle;

    if(cType == ccStandard || cType == ccMenuBar)
    {
        BAR_PROPRETIES* pBarProp = new BAR_PROPRETIES;
        pBarProp->Type = cType;
        pBarProp->Name = Title; //CString copy
        pBarProp->Id = nID; //CString copy
        pBarProp->bDirty = FALSE;

        POSITION  BarPos = m_pBarPropsList.AddTail(pBarProp);
        m_pBarPropDlg->ShowData(pBarProp);

        Level = 1;
        HTREEITEM htinew = TreeAddItem((LPCSTR)Title, Level, (int)BarPos, ccStandard, hti); // hti == NULL if root item( Bars)
        TreeView_SelectItem(m_hTreeViewCtl,htinew);						  // and == hParent in non root		
        SetDirty(TRUE);
    }

    return TRUE; 
}

BOOL CBarPropPage::InsertAnyItem(POSITION BarPos, enItemType Type, LPCSTR sTitle)
{
	int Level = 2;
	HTREEITEM htiParent = NULL;
    CString Title;

	if ( m_htiSelection )
		htiParent = TreeView_GetParent(m_hTreeViewCtl,m_htiSelection);

    int nID = GetMaxID();
    if (sTitle == NULL)
        if (Type != ccTypeSeparator)
            Title.Format(_T("Item%d"),nID);
        else
        {
            Title.Format(_T("Sep%d"),nID);
            nID = -1;
        }
    else
        Title = sTitle;

    BAR_PROPRETIES* pBarProp = m_pBarPropsList.GetAt(BarPos);
    ASSERT(pBarProp);

    POSITION orderPos = NULL;
    if (htiParent)
    {
        TVITEM  tviItem;
        tviItem.hItem  = m_htiSelection;
	    tviItem.mask = TVIF_PARAM;

        TreeView_GetItem(m_hTreeViewCtl,&tviItem); 
        POSITION pos = (POSITION)tviItem.lParam;
        orderPos = FindItemOrderFromPos(pBarProp, pos);
    }

    POSITION ItemPos = InsItemProp(pBarProp, orderPos, Type, Title);
    ITEM_PROPERTIES* pItemProp = (ITEM_PROPERTIES*)m_pItemPropsList.GetAt(ItemPos);
    pItemProp->Id = nID;

    HTREEITEM htinew = TreeAddItem((LPCSTR)Title,Level,(int)ItemPos,Type,m_htiSelection, htiParent == NULL); // hti == NULL if root item( Bars)
	TreeView_SelectItem(m_hTreeViewCtl,htinew);						  // and == hParent in non root		
	SetDirty(TRUE);
    return TRUE; 
}

void CBarPropPage::SetItemName(HTREEITEM hItem, LPSTR Name)
{
    ASSERT(m_hTreeViewCtl);

    TVITEM pitem;
    memset(&pitem,0,sizeof(TVITEM));
    pitem.hItem = hItem;
    pitem.mask = TVIF_TEXT;
    TreeView_GetItem(m_hTreeViewCtl,&pitem);
    pitem.hItem = hItem;
    pitem.pszText = Name;
    pitem.cchTextMax = strlen(Name);
    TreeView_SetItem(m_hTreeViewCtl,&pitem);                
}

void CBarPropPage::ShowBarProp(BAR_PROPRETIES* pBarProp)
{
    m_pItemPropDlg->ShowWindow(SW_HIDE);
    m_pEditPropDlg->ShowWindow(SW_HIDE);
    m_pComboPropDlg->ShowWindow(SW_HIDE);
    m_plabelPropDlg->ShowWindow(SW_HIDE);

    if (!pBarProp) return;

    m_pBarPropDlg->ShowData(pBarProp);
    m_pBarPropDlg->ShowWindow(SW_SHOW);

    return;
#ifdef ENABLE_BAR_CURSORS
    // Set bar mouse pointer type
    enMousePointer enMouse = ccDefault;
    pIBar->get_MousePointer(&enMouse);             
    CComboBox ComboBox;
    ComboBox.Attach(GetDlgItem(IDC_COMBO_BAR_CURSORS));
    int nSelect =(int)enMouse;
    ComboBox.SetCurSel(nSelect);    
    ComboBox.Detach();
#endif
}

void CBarPropPage::ShowItemProp(ITEM_CONTROLDATA* pItemProp)
{
    m_pItemPropDlg->ShowWindow(SW_HIDE);
    m_pEditPropDlg->ShowWindow(SW_HIDE);
    m_pComboPropDlg->ShowWindow(SW_HIDE);
    m_plabelPropDlg->ShowWindow(SW_HIDE);
    m_pBarPropDlg->ShowWindow(SW_HIDE);

    if (!pItemProp) return;

    enItemType Type = pItemProp->Type;
    switch (Type)
    {
    case ccTypeButton:
    case ccTypeToggleButton:
    case ccTypeDropDown:
    case ccTypeToggleDropDown:
    case ccTypeSeparator:
        m_pItemPropDlg->ShowData((ITEM_PROPERTIES*)pItemProp);
        m_pItemPropDlg->ShowWindow(SW_SHOW);
        break;
    case ccTypeComboBox:
        m_pComboPropDlg->ShowData((COMBO_PROPERTIES*)pItemProp);
        m_pComboPropDlg->ShowWindow(SW_SHOW);
        break;
    case ccTypeEdit:
        m_pEditPropDlg->ShowData((EDIT_PROPERTIES*)pItemProp);
        m_pEditPropDlg->ShowWindow(SW_SHOW);
        break;
    case ccTypeLabel:
        m_plabelPropDlg->ShowData((LABEL_PROPERTIES*)pItemProp);
        m_plabelPropDlg->ShowWindow(SW_SHOW);
        break;
    default:
        ASSERT(FALSE);
        break;
    }

    return;
}

BOOL CBarPropPage::InitDialogs()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    CWnd* Cwnd = CWnd::FromHandle(m_hWnd);
    CRect rc;
    HWND hWtree = GetDlgItem(IDC_TREE1);
    ::GetClientRect(hWtree,&rc);
    int adj_width = rc.Width() + 2*7; 

    if (!m_pBarPropDlg)
    {
        m_pBarPropDlg = new CPropBarDlg(Cwnd);
        m_pBarPropDlg->GetClientRect(&rc);
        rc.OffsetRect(CPoint(rc.left +adj_width,rc.top+7));
        m_pBarPropDlg->MoveWindow(rc);
    }

    if (!m_pItemPropDlg)
    {
        m_pItemPropDlg = new CPropItemDlg(Cwnd);
        m_pItemPropDlg->GetClientRect(&rc);
        rc.OffsetRect(CPoint(rc.left +adj_width,rc.top+7));
        m_pItemPropDlg->MoveWindow(rc);
    }

    if (!m_pEditPropDlg)
    {
        m_pEditPropDlg = new CPropEditDlg(Cwnd);
        m_pEditPropDlg->GetClientRect(&rc);
        rc.OffsetRect(CPoint(rc.left +adj_width,rc.top+7));
        m_pEditPropDlg->MoveWindow(rc);
    }

    if (!m_pComboPropDlg)
    {
        m_pComboPropDlg = new CPropComboDlg(Cwnd);
        m_pComboPropDlg->GetClientRect(&rc);
        rc.OffsetRect(CPoint(rc.left +adj_width,rc.top+7));
        m_pComboPropDlg->MoveWindow(rc);
    }

    if (!m_plabelPropDlg)
    {
        m_plabelPropDlg = new CPropLabelDlg(Cwnd);
        m_plabelPropDlg->GetClientRect(&rc);
        rc.OffsetRect(CPoint(rc.left +adj_width,rc.top+7));
        m_plabelPropDlg->MoveWindow(rc);
    }

    return TRUE;
}

UINT CBarPropPage::GetMaxID()
{
    return ++m_nMaxID;
}

void CBarPropPage::SetMaxID(UINT nID)
{
    if (nID > m_nMaxID)
    m_nMaxID = ++nID;
}

#define N_MENU_ITEMS 11
void CBarPropPage::AddItemsMenu(CPoint& ptAction)
{
		CMenu	Menu;
		Menu.CreatePopupMenu();
        CString smenu[N_MENU_ITEMS];
		smenu[0]=_T("&New");
		smenu[1]=_T("&Insert Item");
		smenu[2]=_T("&Delete");

		smenu[3]=_T("&ccTypeButton");
		smenu[4]=_T("&ccTypeToggleButton");
		smenu[5]=_T("&ccTypeDropDown");
		smenu[6]=_T("&ccTypeToggleDropDown");
		smenu[7]=_T("&ccTypeComboBox");
		smenu[8]=_T("&ccTypeEdit");
		smenu[9]=_T("&ccTypeLabel");
 		smenu[10]=_T("&ccTypeSeparator");

        CMenu MenuPopup;
        MenuPopup.CreatePopupMenu();
		MenuPopup.AppendMenu(MF_STRING,IDM_INS_BTN,(LPCSTR)smenu[3]);
		MenuPopup.AppendMenu(MF_STRING,IDM_INS_BTNTGL,(LPCSTR)smenu[4]);
		MenuPopup.AppendMenu(MF_STRING,IDM_INS_BTNDD,(LPCSTR)smenu[5]);
		MenuPopup.AppendMenu(MF_STRING,IDM_INS_BTNDDTGL,(LPCSTR)smenu[6]);
		MenuPopup.AppendMenu(MF_STRING,IDM_INS_BTNCB,(LPCSTR)smenu[7]);
		MenuPopup.AppendMenu(MF_STRING,IDM_INS_BTNED,(LPCSTR)smenu[8]);
		MenuPopup.AppendMenu(MF_STRING,IDM_INS_BTNLB,(LPCSTR)smenu[9]);
		MenuPopup.AppendMenu(MF_STRING,IDM_INS_BTNSP,(LPCSTR)smenu[10]);

		Menu.AppendMenu(MF_STRING,IDM_NEW,(LPCSTR)smenu[0]);
        Menu.AppendMenu(MF_POPUP,(UINT)MenuPopup.m_hMenu,(LPCSTR)smenu[1]);
		Menu.AppendMenu(MF_SEPARATOR);
		Menu.AppendMenu(MF_STRING,IDM_DELETE,(LPCSTR)smenu[2]);

//		ScreenToClient(&ptAction);

//		Menu.LoadMenu(IDR_MENU_POPUP);
		
		Menu.TrackPopupMenu(TPM_LEFTALIGN, ptAction.x, ptAction.y, CWnd::FromHandle(m_hWnd));

		Menu.DestroyMenu();
}

BOOL CBarPropPage::OnNewItem()
{
    BOOL bRet = FALSE;
    BOOL bAddBarsOny = m_nBarActive ? FALSE : TRUE;

    CHNewItemDlg Dlg(bAddBarsOny);
	if (Dlg.DoModal() == IDOK)
	{
        int nType = Dlg.GetType();
        if (nType < nBAR_TYPES)
        {
            CString pStr = Dlg.GetTitle();
            LPCSTR pName =  NULL;
            if (!pStr.IsEmpty())
                pName =(LPCSTR) pStr;
            enBarType cType = (enBarType)nType;
           bRet = InsertBar(cType,pName);
        }
        else
        {
            CString pStr = Dlg.GetTitle();
            LPCSTR pName =  NULL;
            if (!pStr.IsEmpty())
                pName =(LPCSTR) pStr;
            enItemType cType = (enItemType)(nType - nBAR_TYPES);
           bRet = InsertAnyItem(m_nBarActive,cType,pName);
        }
    }
    return bRet;
}

BOOL CBarPropPage::OnDelete()
{
    BOOL bRet = FALSE;

    switch (m_bSelType)
    {
    case SelBar:
           bRet = DeleteBar(m_nBarActive);
        break;
    case SelItem:
            bRet = DeteteAnyItem(m_nBarActive,m_nItemActive, TRUE);
        break;
     }
    return bRet;
}

BOOL CBarPropPage::DeleteBar(POSITION nPos)
{
    ASSERT(m_htiSelection);
    BOOL bRet = FALSE;

    BAR_PROPRETIES* pBarProp = m_pBarPropsList.GetAt(nPos);
    ASSERT(pBarProp);

    for (int j = 0; j < pBarProp->ItemOrder.GetCount(); j++)
    {
        POSITION pos1 =(POSITION) pBarProp->ItemOrder.GetAt(pBarProp->ItemOrder.FindIndex(j));
        DeteteAnyItem(nPos, pos1, FALSE);
    }

	bRet = TRUE;
    delete pBarProp;
    m_pBarPropsList.RemoveAt(nPos);
	m_nItemActive = 0;

	if (m_pBarPropsList.GetCount() == 0 )
	{
		m_nBarActive = 0;
		m_pItemPropDlg->ShowWindow(SW_HIDE);
		m_pEditPropDlg->ShowWindow(SW_HIDE);
		m_pComboPropDlg->ShowWindow(SW_HIDE);
		m_plabelPropDlg->ShowWindow(SW_HIDE);
		m_pBarPropDlg->ShowWindow(SW_HIDE);
	}
	else
	{
		POSITION pos = m_pBarPropsList.GetHeadPosition();
        m_nBarActive = nPos;
	}
    TreeView_DeleteItem(m_hTreeViewCtl,m_htiSelection);
    SetDirty(TRUE);

   return bRet;
}

BOOL CBarPropPage::DeteteAnyItem(POSITION posBar, POSITION posItem, BOOL bDelTreeItem)
{
    BOOL bRet = FALSE;

    ITEM_CONTROLDATA* pItemCD = m_pItemPropsList.GetAt(posItem);
    ASSERT(pItemCD);

    // remove from Bar's Item Order list
    BAR_PROPRETIES* pBarProp = m_pBarPropsList.GetAt(posBar);
    ASSERT(pBarProp);

    POSITION posDelete = FindItemOrderFromPos( pBarProp, posItem);
    ASSERT(posDelete);
    pBarProp->ItemOrder.RemoveAt(posDelete);

    // remove from tree
    if (bDelTreeItem)
    {
        ASSERT(m_htiSelection);
        TreeView_DeleteItem(m_hTreeViewCtl,m_htiSelection);
    }
    
    // remove object itself
    delete pItemCD;
    m_pItemPropsList.RemoveAt(posItem);
    SetDirty(TRUE);
	bRet = TRUE;

    return bRet;
}


LRESULT CBarPropPage::OnHelpMessage(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())
	LRESULT lRes = 0;
	HRESULT hr = S_FALSE;
	CComBSTR szFullFileName(AfxGetApp()->m_pszHelpFilePath);
//		LPOLESTR szFileName = LoadStringHelper(m_dwHelpFileID);
//		szFullFileName.Append(OLESTR("\\"));
//		szFullFileName.Append(szFileName);
//		CoTaskMemFree(szFileName);
    lRes = OnHelp(szFullFileName);

	if (lRes == FALSE)
		bHandled = FALSE;
	return lRes;
}
BOOL CBarPropPage::OnHelp(CComBSTR& bstrName)
{
	USES_CONVERSION; 
    HWND hWndFocus = ::GetFocus();
    UINT id = ::GetWindowContextHelpId(hWndFocus);
    switch (id)
    {
    case HIDC_EDIT_NAME:
    case HIDC_EDIT_ID:
    case HIDC_CHECK_VISIBLE:
        bstrName.Append(DEFAULT_TOPIC);
        break;
//Bar's id
    case HIDC_RADIO_BAR_STYLE_FLAT:                  
    case HIDC_RADIO_BAR_STYLE_3D:

    case HIDC_RADIO_DCK_RIGHT:
    case HIDC_RADIO_DCK_TOP:
    case HIDC_RADIO_DCK_BOTTOM:
    case HIDC_RADIO_DCK_LEFT:
    case HIDC_RADIO_DCK_ANY:
    case HIDC_RADIO_DCK_LOCKED:

    case HIDC_SPIN1:
    case HIDC_SPIN2:
    case HIDC_SPIN3:
    case HIDC_SPIN4:

    case HIDC_EDIT_BHEIGHT:
    case HIDC_EDIT_BWIDTH:
    case HIDC_EDIT_IHEIGHT:
    case HIDC_EDIT_IWIDTH:

    case HIDC_RADIO_GRIPSINGLE:
    case HIDC_RADIO_GRIPNONE:

    case HIDC_RADIO_DCKS_FLOAT:
    case HIDC_RADIO_DCKS_TOP:
    case HIDC_RADIO_DCKS_BOTTOM:
    case HIDC_RADIO_DCKS_LEFT:
    case HIDC_RADIO_DCKS_RIGHT:

    case HIDC_CHECK_BAR_USEILIST:
    case HIDC_CHECK_BAR_HIDECONTROLS:
            bstrName.Append(BAR_TOPIC_PROP);
            break;
// Item's id
    case HIDC_CHECK_ENABLED:
    case HIDC_EDIT_TOOLTIP:
    case HIDC_HOTKEY_ACCEL:
    case HIDC_BTN_HKEY_SET:
    case HIDC_BTN_PICTURE:
    case HIDC_IMAGE_PREVIEW:
    case HIDC_BTN_PICTUREHOT:
    case HIDC_IMAGE_PREVIEWHOT:
    case HIDC_BTN_PICTUREDSBL:
    case HIDC_IMAGE_PREVIEWDSBL:
    case HIDC_CHECK_BTN_GROUP:
    case HIDC_RADIO_UNPRESSED:
    case HIDC_RADIO_PRESSED:
    case HIDC_RADIO_BSTYLE_DEF:
    case HIDC_RADIO_BSTYLE_TEXT:
    case HIDC_RADIO_BSTYLE_IMAGE:
    case HIDC_RADIO_BSTYLE_IMGTEXT:
            bstrName.Append(ITEM_TOPIC_PROP);
        break;
// Combo's id

    case HIDC_CHECK_COMBO_SORT:
    case HIDC_LIST_COMBO_LIST:

    case HIDC_BUTTON_COMBO_ADD:
    case HIDC_BUTTON_COMBO_INS:
    case HIDC_BUTTON_COMBO_DEL:

    case HIDC_EDIT_COMBO_TEXT:
    case HIDC_EDIT_WIDTH:

    case HIDC_EDIT_HEIGHT:
    case HIDC_EDIT_LEFT:

    case HIDC_EDIT_TOP:
    case HIDC_RADIO_COMBO_STYLE_STD:
    case HIDC_RADIO_COMBO_STYLE_LIST:
            bstrName.Append(COMBO_TOPIC_PROP);
        break;
// Edit's id
    case HIDC_EDIT_ED_PSWD:
    case HIDC_EDIT_ED_TEXT:
    case HIDC_CHECK_EDIT_RO:
    case HIDC_CHECK_EDIT_BORDER:
        bstrName.Append(EDIT_TOPIC_PROP);
        break;

// General
    case HIDC_BUTTON_HFILE:
    case HIDC_BUTTON_LOAD:
    case HIDC_BUTTON_SAVE:
    case HIDC_DELETE:
    case HIDC_NEW:
    default:
        bstrName.Append(DEFAULT_TOPIC);
        break;
    }

    HWND hWnd = HtmlHelp(m_hWnd, OLE2CT(bstrName), HH_DISPLAY_TOPIC, 0); 

    return hWnd ? TRUE : FALSE;
}


LRESULT CBarPropPage::OnSelchangedTree1(int idCtrl, LPNMHDR pnmh, BOOL& bHandled)
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pnmh;

	m_htiSelection = pNMTreeView->itemNew.hItem;
	POSITION pData =(POSITION)pNMTreeView->itemNew.lParam;
	HTREEITEM hti = TreeView_GetParent(m_hTreeViewCtl,m_htiSelection);

	m_bSelType = SelNone;

	if( hti == NULL )  
    {
        m_nBarActive =(POSITION)pData;
        m_bSelType = SelBar;

        BAR_PROPRETIES* pBarProp = m_pBarPropsList.GetAt(m_nBarActive);
        if (pBarProp)
            ShowBarProp(pBarProp);

        ATLTRACE("OnSelchangedTree: SelBar \n");
    }else if (hti != NULL)
    {
        TVITEM tvi;
        memset(&tvi,0,sizeof(tvi));
        tvi.hItem = hti;
        tvi.mask = TVIF_PARAM;
        TreeView_GetItem(m_hTreeViewCtl,&tvi);
        POSITION nPos =(POSITION)tvi.lParam; 
        if (nPos && nPos != m_nBarActive)
            m_nBarActive = nPos;

        m_nItemActive = pData;
        m_bSelType = SelItem;

        ITEM_CONTROLDATA* pItemProp = m_pItemPropsList.GetAt(m_nItemActive);
        if(pItemProp)
            ShowItemProp(pItemProp);
        ATLTRACE("OnSelchangedTree: SelItem \n");
    }

	return 0;
}

LRESULT CBarPropPage::OnMouseMove(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	TVHITTESTINFO tvht;  // hit test information 
	HTREEITEM htiTarget;  // handle to target item 
	int xCur = LOWORD(lParam);  // horizontal position of cursor 
	int yCur = HIWORD(lParam);  // vertical position of cursor 
	POINT	point;
	point.x=xCur; point.y=yCur;
	DWORD fwKeys = wParam;        

	if (m_bDragging)
	{
		ASSERT(m_hDragImage != NULL);
		ImageList_DragMove(xCur, yCur); 
		tvht.pt.x = xCur;
		tvht.pt.y = yCur; 
		if ((htiTarget = TreeView_HitTest(m_hTreeViewCtl, &tvht)) != NULL) 
		{
            HTREEITEM htiParent = TreeView_GetParent(m_hTreeViewCtl,htiTarget);
            POSITION pData = 0;
            if (htiParent)
            {
                TVITEM item;
                memset(&item,0,sizeof(item));
                item.mask = TVIF_PARAM; item.hItem = htiParent;
                TreeView_GetItem(m_hTreeViewCtl,&item);
                pData = (POSITION)item.lParam;
            }
			if (m_hitemDrag == htiTarget || pData != m_nBarActive)
			{
				SetCursor(LoadCursor(m_ResInst,MAKEINTRESOURCE(IDC_NODROP)));
			}
            else
				SetCursor(LoadCursor(m_ResInst,MAKEINTRESOURCE(IDC_POINTER)));

			TreeView_Expand(m_hTreeViewCtl, htiTarget, TVE_EXPAND);
			ImageList_DragLeave(m_hTreeViewCtl);
			TreeView_SelectDropTarget(m_hTreeViewCtl, htiTarget); 
			m_hitemDrop = htiTarget;
			ImageList_DragEnter(m_hTreeViewCtl, xCur,yCur);
		}
	}
return 0;
}

LRESULT CBarPropPage::OnBegindragTree1(int idCtrl, LPNMHDR pnmh, BOOL& bHandled)
{
	CPoint      ptAction;
	TVHITTESTINFO tvht;  // hit test information 
	LPNMTREEVIEW  lpnmtv = (LPNMTREEVIEW)pnmh;
	
	if (TreeView_GetParent(m_hTreeViewCtl,lpnmtv->itemNew.hItem) == NULL)
		return 0;		// Don't drag root items

	GetCursorPos(&ptAction);
	ScreenToClient(&ptAction);
	ASSERT(!m_bDragging);
	m_bDragging = TRUE;
	m_hSaveCursor = GetCursor(); // save cursor
	tvht.pt.x = ptAction.x;
	tvht.pt.y = ptAction.y; 
	m_hitemDrag = lpnmtv->itemNew.hItem;//TreeView_HitTest(m_hTreeViewCtl, &tvht);// HitTest(ptAction, &nFlags);
	m_hitemDrop = NULL;


	ASSERT(m_hDragImage == NULL);
	m_hDragImage = TreeView_CreateDragImage(m_hTreeViewCtl, lpnmtv->itemNew.hItem); 
				//CreateDragImage(m_hitemDrag);  // get the image list for dragging
	ImageList_DragShowNolock(TRUE);
	ImageList_SetDragCursorImage(m_hDragImage,0, 0, 0);
	ImageList_BeginDrag(m_hDragImage, 0, 0,0);
	ImageList_DragMove(ptAction.x,ptAction.y);
	ImageList_DragEnter(m_hTreeViewCtl, ptAction.x,ptAction.y);
	SetCapture();

	return 0;
}


LRESULT CBarPropPage::OnEndlabeleditTree1(int idCtrl, LPNMHDR pnmh, BOOL& bHandled)
{
	TV_DISPINFO     *ptvinfo;

	ptvinfo = (TV_DISPINFO *)pnmh;
	if (ptvinfo->item.pszText != NULL)
	{
		ptvinfo->item.mask = TVIF_TEXT;
		TreeView_SetItem(m_hTreeViewCtl,&ptvinfo->item);
//			SetItemName(ptvinfo->item.pszText); //suppose to change Edit and IBar->Name 
	}
	bHandled = TRUE;
	return 0;
}

LRESULT CBarPropPage::OnLButtonUP(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	DWORD fwKeys = wParam;
	BOOL bCopy = FALSE;

	if ( (fwKeys & (MK_CONTROL | MK_SHIFT )) )      // key flags 
		bCopy = TRUE;

	OnButtonUp(bCopy);
	return 0;
}

LRESULT CBarPropPage::OnRclickTree1(int idCtrl, LPNMHDR pnmh, BOOL& bHandled)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	CPoint  ptAction;
 	GetCursorPos(&ptAction);
    AddItemsMenu(ptAction);
	return 0;
}

LRESULT CBarPropPage::OnKeydownTree1(int idCtrl, LPNMHDR pnmh, BOOL& bHandled)
{
   LPNMTVKEYDOWN ptvkd = (LPNMTVKEYDOWN) pnmh; 
   WORD fwKeys = ptvkd->wVKey;

	if ( (fwKeys == VK_CONTROL || fwKeys == VK_SHIFT ) && m_ChngCursor == FALSE && m_bDragging) 
    {
    		SetCursor(LoadCursor(m_ResInst,MAKEINTRESOURCE(IDC_POINTER_COPY)));
            m_ChngCursor = TRUE;
    }
    else if ((fwKeys == VK_CONTROL || fwKeys == VK_SHIFT ) && m_ChngCursor == TRUE )
    {
        SetCursor(m_hSaveCursor);
        m_ChngCursor = FALSE;
    }
	return 0;
}

LRESULT CBarPropPage::OnClickedButton_hfile(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
     AFX_MANAGE_STATE(AfxGetStaticModuleState())

     static char BASED_CODE lpszFilter[] = "VB Module File (*.BAS)|*.BAS||";
     TCHAR lpszExt[] = _T("bas");
    CFileDialog FileDlg(FALSE, lpszExt, 
                        NULL,
                        OFN_HIDEREADONLY |OFN_OVERWRITEPROMPT,
                        lpszFilter,
                        NULL );
    int ret = FileDlg.DoModal();
    if ( ret != IDOK)
        return 0;

    CString strFile;
    _GetMainControl()->GenHFile(hVB, strFile);
    CFile File;
    CFileException fileException;

    if ( !File.Open( FileDlg.m_ofn.lpstrFile, CFile::modeCreate |   
              CFile::modeWrite, &fileException ))
    {
        CString msg;
        msg.Format("Can't open file %s, error = %u\n",
                    FileDlg.m_ofn.lpstrFile,fileException.m_cause);
        MessageBox(msg,_T("Error"), MB_ICONERROR | MB_OK);
    }else
    {
        try
        {
            File.Write( strFile, strFile.GetLength());
        }
	    catch (...)
        {
        CString msg;
        msg.Format("Can't write to file %s, error = %u\n",
                    FileDlg.m_ofn.lpstrFile,fileException.m_cause);
        MessageBox(msg,_T("Error"), MB_ICONERROR | MB_OK);
        }        
    }

    File.Close();

    return 0;
}

LRESULT CBarPropPage::OnClickedButton_save(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
     AFX_MANAGE_STATE(AfxGetStaticModuleState())
     USES_CONVERSION;
     static char BASED_CODE lpszccFilter[] = "Cute Controls File (*.ccb)|*.ccb||";
     TCHAR lpszExt[] = _T("ccb");
     CFileDialog FileDlg(FALSE, lpszExt, 
                        NULL,
                        OFN_HIDEREADONLY |OFN_OVERWRITEPROMPT,
                        lpszccFilter,
                        NULL );
     int ret = FileDlg.DoModal();
     if ( ret != IDOK)
        return 0;

    LPSTORAGE lpStorage;
    SCODE sc = ::StgCreateDocfile(T2COLE(FileDlg.m_ofn.lpstrFile),
	    STGM_READWRITE|STGM_TRANSACTED|STGM_SHARE_DENY_WRITE|STGM_CREATE,
	    0, &lpStorage);
    if (sc != S_OK)
    {
	    AfxMessageBox(IDS_FILE_ERORR, MB_OK|MB_ICONSTOP);
        return 0;
    }

    CComPtr<IStream> spStream;
    static LPCOLESTR vszContents = OLESTR("Contents");
    HRESULT hr = lpStorage->CreateStream(vszContents,
	    STGM_READWRITE | STGM_SHARE_EXCLUSIVE | STGM_CREATE,
	    0, 0, &spStream);
    if (FAILED(hr))
    {
	    AfxMessageBox(IDS_FILE_ERORR, MB_OK|MB_ICONSTOP);
        return 0;
    }

    CComPtr<IPersistStreamInit> pObject;	
    hr = _GetMainControl()->ControlQueryInterface(IID_IPersistStreamInit, (void**)&pObject);
     if (FAILED(hr))
    {
	    AfxMessageBox(IDP_INTERLAL_ERROR, MB_OK|MB_ICONSTOP);
        return 0;
    }

    pObject->Save(spStream, TRUE);

    lpStorage->Commit(STGC_OVERWRITE);
    return 0;
}

LRESULT CBarPropPage::OnClickedButton_laod(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
     AFX_MANAGE_STATE(AfxGetStaticModuleState())
     USES_CONVERSION;
     static char BASED_CODE lpszccFilter[] = "Cute Controls File (*.ccb)|*.ccb||";
     TCHAR lpszExt[] = _T("ccb");
    CFileDialog FileDlg(TRUE, lpszExt, 
                        NULL,
                        OFN_HIDEREADONLY |OFN_OVERWRITEPROMPT,
                        lpszccFilter,
                        NULL );
    int ret = FileDlg.DoModal();
    if ( ret != IDOK)
        return 0;

    LPSTORAGE lpStorage;
    SCODE sc = ::StgOpenStorage(T2COLE(FileDlg.m_ofn.lpstrFile),
	    NULL, STGM_READ|STGM_TRANSACTED ,
	    0, 0, &lpStorage);
    if (sc != S_OK)
    {
	    AfxMessageBox(IDS_INVALID_FILEDATA, MB_OK|MB_ICONSTOP);
        return 0;
    }

    CComPtr<IStream> spStream;
    static LPCOLESTR vszContents = OLESTR("Contents");
    HRESULT hr = lpStorage->OpenStream(vszContents, NULL,
	    STGM_READ | STGM_SHARE_EXCLUSIVE ,
	    0, &spStream);
     if (FAILED(hr))
    {
	    AfxMessageBox(IDS_INVALID_FILEDATA, MB_OK|MB_ICONSTOP);
        return 0;
    }

    CComPtr<IPersistStreamInit> pObject;
    CICuteBar* pControl =_GetMainControl();
    hr = pControl->ControlQueryInterface(IID_IPersistStreamInit, (void**)&pObject);
     if (FAILED(hr))
    {
	    AfxMessageBox(IDP_INTERLAL_ERROR, MB_OK|MB_ICONSTOP);
        return 0;
    }
     // Clean up all objects
    pControl->FinalRelease();
    pControl->FinalConstruct();

    pObject->Load(spStream);

    pControl->Refresh();    // refresh Control Bars on frame
    BOOL bHnd;
    OnInitDialog(0,0,0,bHnd);   // Reinit Property Page 
    return 0;
}

BOOL CBarPropPage::ClearLists()
{
    POSITION pos = m_pBarPropsList.GetHeadPosition();
    for (int i=0;i < m_pBarPropsList.GetCount();i++)
    {
       BAR_PROPRETIES* pBarProp = m_pBarPropsList.GetNext(pos);
       delete pBarProp;
    }
    m_pBarPropsList.RemoveAll();

    pos = m_pItemPropsList.GetHeadPosition();
    for (i=0;i < m_pItemPropsList.GetCount();i++)
    {
       ITEM_CONTROLDATA* pProp = m_pItemPropsList.GetNext(pos);
       delete pProp;
    }
    m_pItemPropsList.RemoveAll();

    return TRUE;
}

POSITION CBarPropPage::NewItemProp(BAR_PROPRETIES *pBar, enItemType Type, IItem* pItem)
{
    POSITION iRet = 0;

    switch (Type)
    {
    case ccTypeButton:
    case ccTypeToggleButton:
    case ccTypeDropDown:
    case ccTypeToggleDropDown:
    case ccTypeSeparator:
        {
        ITEM_PROPERTIES * pIProp = new ITEM_PROPERTIES;
        pIProp->pBar= pBar;
        pIProp->Type = Type;
        pIProp->bDirty = FALSE;

        iRet = m_pItemPropsList.AddTail(pIProp);
        m_pItemPropDlg->ReadProp(pItem, pIProp);
        }
        break;
    case ccTypeComboBox:
        {
        COMBO_PROPERTIES * pIProp = new COMBO_PROPERTIES;
        pIProp->pBar= pBar;
        pIProp->Type = Type;
        pIProp->bDirty = FALSE;

        iRet = m_pItemPropsList.AddTail(pIProp);
        m_pComboPropDlg->ReadProp(pItem, pIProp);
        }
        break;
    case ccTypeEdit:
        {
        EDIT_PROPERTIES * pIProp = new EDIT_PROPERTIES;
        pIProp->pBar= pBar;
        pIProp->Type = Type;
        pIProp->bDirty = FALSE;

        iRet = m_pItemPropsList.AddTail(pIProp);
        m_pEditPropDlg->ReadProp(pItem, pIProp);
        }
        break;
    case ccTypeLabel:
        {
        LABEL_PROPERTIES * pIProp = new LABEL_PROPERTIES;
        pIProp->pBar= pBar;
        pIProp->Type = Type;
        pIProp->bDirty = FALSE;

        iRet = m_pItemPropsList.AddTail(pIProp);
        m_plabelPropDlg->ReadProp(pItem, pIProp);
        }
        break;
    default:
        ASSERT(FALSE);
        break;
    }

    return iRet;
}

POSITION CBarPropPage::InsItemProp(BAR_PROPRETIES *pBar, POSITION InsAfter, enItemType Type, LPCSTR sTitle)
{
    POSITION iRet = 0;

    switch (Type)
    {
    case ccTypeButton:
    case ccTypeToggleButton:
    case ccTypeDropDown:
    case ccTypeToggleDropDown:
    case ccTypeSeparator:
        {
        ITEM_PROPERTIES * pIProp = new ITEM_PROPERTIES;
        pIProp->pBar= pBar;
        pIProp->Type = Type;
        pIProp->bDirty = FALSE;
        if (sTitle) pIProp->Name = sTitle; // CString copy

        iRet = m_pItemPropsList.AddTail(pIProp);

        if (InsAfter)
            pBar->ItemOrder.InsertAfter(InsAfter,(DWORD)iRet);
        else
            pBar->ItemOrder.AddTail((DWORD)iRet);

        m_pItemPropDlg->ShowData(pIProp);
        }
        break;
    case ccTypeComboBox:
        {
        COMBO_PROPERTIES * pIProp = new COMBO_PROPERTIES;
        pIProp->pBar= pBar;
        pIProp->Type = Type;
        pIProp->bDirty = FALSE;
        if (sTitle) pIProp->Name = sTitle; // CString copy

        iRet = m_pItemPropsList.AddTail(pIProp);

        if (InsAfter)
            pBar->ItemOrder.InsertAfter(InsAfter,(DWORD)iRet);
        else
            pBar->ItemOrder.AddTail((DWORD)iRet);

        m_pComboPropDlg->ShowData(pIProp);
        }
        break;
    case ccTypeEdit:
        {
        EDIT_PROPERTIES * pIProp = new EDIT_PROPERTIES;
        pIProp->pBar= pBar;
        pIProp->Type = Type;
        pIProp->bDirty = FALSE;
        if (sTitle) pIProp->Name = sTitle; // CString copy

        iRet = m_pItemPropsList.AddTail(pIProp);

        if (InsAfter)
            pBar->ItemOrder.InsertAfter(InsAfter,(DWORD)iRet);
        else
            pBar->ItemOrder.AddTail((DWORD)iRet);

        m_pEditPropDlg->ShowData(pIProp);
        }
        break;
    case ccTypeLabel:
        {
        LABEL_PROPERTIES * pIProp = new LABEL_PROPERTIES;
        pIProp->pBar= pBar;
        pIProp->Type = Type;
        pIProp->bDirty = FALSE;
        if (sTitle) pIProp->Name = sTitle; // CString copy

        iRet = m_pItemPropsList.AddTail(pIProp);

        if (InsAfter)
            pBar->ItemOrder.InsertAfter(InsAfter,(DWORD)iRet);
        else
            pBar->ItemOrder.AddTail((DWORD)iRet);

        m_plabelPropDlg->ShowData(pIProp);
        }
        break;
    default:
        ASSERT(FALSE);
        break;
    }

    return iRet;
}

BOOL CBarPropPage::UpdateProperties()
{
	USES_CONVERSION;

    CComQIPtr<IBarCollection, &IID_IBarCollection> pBarCol(m_ppUnk[0]);
    if (!pBarCol) return FALSE;

    //*** Remove all toolbars and items;
    pBarCol->Clear();

    //*** Populate control with Bars and Items
    POSITION pos = m_pBarPropsList.GetHeadPosition();
    for (int i = 0; i < m_pBarPropsList.GetCount(); i++)
    {
      BAR_PROPRETIES* pBarProp =  m_pBarPropsList.GetNext(pos);
      if (m_pBarPropDlg)    // && pBarProp->bDirty
      {
            CComVariant varName(pBarProp->Name);   //T2BSTR
            CComVariant varType(pBarProp->Type);
            CComPtr<IBar> pIBar;
            if (FAILED(pBarCol->Add(pBarProp->Id, &varName, &varType, &pIBar)))
            {
	            CComPtr<IErrorInfo> pError;
	            CComBSTR         strError;
	            GetErrorInfo(0, &pError);         
	            pError->GetDescription(&strError);
	            MessageBox(OLE2T(strError), _T("Error"), MB_ICONEXCLAMATION);
	            return FALSE;
            }
            m_pBarPropDlg->SetProp(pIBar, pBarProp);

            // Add Items to the Bar 
                CComQIPtr<IItemCollection, &IID_IItemCollection> pItemCol(pIBar);
                if (pItemCol == NULL)
                    return FALSE;

            for (int j = 0; j < pBarProp->ItemOrder.GetCount(); j++)
            {
                POSITION pos1 =(POSITION) pBarProp->ItemOrder.GetAt(pBarProp->ItemOrder.FindIndex(j));
                ITEM_CONTROLDATA* pItemProp = m_pItemPropsList.GetAt(pos1);
//                if (pItemProp->pBar != pBarProp) continue;  // !pItemProp->bDirty

                // ---  Add button
                enItemType Type = pItemProp->Type;

                CComPtr<IItem> pItem;
                if (FAILED(pItemCol->Add(((ITEM_PROPERTIES*)pItemProp)->Id, Type, &pItem)))
                    return FALSE;
                
                switch (Type)
                {
                case ccTypeButton:
                case ccTypeToggleButton:
                case ccTypeDropDown:
                case ccTypeToggleDropDown:
                case ccTypeSeparator:
                    m_pItemPropDlg->SetProp(pItem, (ITEM_PROPERTIES*)pItemProp);
                    break;
                case ccTypeComboBox:
                    m_pComboPropDlg->SetProp(pItem, (COMBO_PROPERTIES*)pItemProp);
                    break;
                case ccTypeEdit:
                    m_pEditPropDlg->SetProp(pItem, (EDIT_PROPERTIES*)pItemProp);
                    break;
                case ccTypeLabel:
                    m_plabelPropDlg->SetProp(pItem, (LABEL_PROPERTIES*)pItemProp);
                    break;
                default:
                    ASSERT(FALSE);
                    break;
                }
            }
      }
    }
    return TRUE;
}

POSITION CBarPropPage::FindItemOrderFromPos(BAR_PROPRETIES* pBarProp, POSITION pos)
{
    ASSERT(pBarProp);
    POSITION pos1;
    POSITION pos2;

    for (pos1 = pBarProp->ItemOrder.GetHeadPosition(); (pos2 = pos1) != NULL;)
    {
        POSITION itempos = (POSITION)pBarProp->ItemOrder.GetNext(pos1);
        if (itempos == pos )
            return pos2;
    }

    ASSERT(FALSE);
    return NULL;
}
