////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
#if !defined(AFX_BARBUTTON_H__66D23A5A_9AAB_11D3_B68A_000000000000__INCLUDED_)
#define AFX_BARBUTTON_H__66D23A5A_9AAB_11D3_B68A_000000000000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// BarButton.h : header file
//
#include "CuteControls.h"

interface IItem;
class CICuteBar;
/////////////////////////////////////////////////////////////////////////////
// CBCBarButton command target

class CBCBarButton : public CObject
{
	DECLARE_SERIAL(CBCBarButton)
public:
	CBCBarButton();
	virtual ~CBCBarButton();

// Attributes
    CICuteBar* m_pMainControl;
    int m_nImage;   // current image index
    IPictureDisp*   m_spImage;
	IPictureDisp*    m_spImageHot;
	IPictureDisp*    m_spImageDsbl;
    CStatic         m_Label;

    BOOL m_bEnabled;
    BOOL m_bVisible;
    UINT m_ID;
    UINT m_AccelKey;
    CString m_strName;
    CString m_strToolTip;
    CString m_strDesc;
    enItemType m_ItemType;
    enItemStyle   m_ItemStyle;
    UINT m_ItemState;
    UINT m_ControlWidth;
    UINT m_ControlHeight;
    UINT m_ControlTop;
    UINT m_ControlLeft;
    BOOL    m_bDirty;
    enAlignment m_Algn;

// Operations
public:
	void SetMainControl(CICuteBar* pControl);
	void SetAlign(enAlignment Algn);
	enAlignment GetAlign();
	virtual void Update();
    BOOL SetImageDsbl(IPictureDisp *pPicture);
    BOOL SetImageHot(IPictureDisp *pPicture);
	BOOL SetImage(IPictureDisp* pPicture);
	enItemState GetButtonState();
	void virtual Serialize(CArchive &ar);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBCBarButton)
	//}}AFX_VIRTUAL

// Implementation
protected:
	BOOL LoadImage(CArchive &ar, IPictureDisp** pPicDisp);
	BOOL SaveImage(CArchive &ar, IPictureDisp* pPicDisp);

};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_BARBUTTON_H__66D23A5A_9AAB_11D3_B68A_000000000000__INCLUDED_)
