////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// Bar.h : Declaration of the CIBar

#ifndef __BAR_H_
#define __BAR_H_

#include "resource.h"       // main symbols
#include "CToolBar.h"
#include "ItemCollection.h"
class CuteBar;

/////////////////////////////////////////////////////////////////////////////
// CIBar
class ATL_NO_VTABLE CIBar : public CBCToolBarBase,
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CIBar, &CLSID_Bar>,
	public ISupportErrorInfo,
   	public IPersistStreamInitImpl<CIBar>,
    public IPersistStorageImpl<CIBar>,
	public IProvideClassInfo2Impl<&CLSID_CuteBar, &IID_IBar, &LIBID_CuteControlsLib>,
	public IDispatchImpl<IBar, &IID_IBar, &LIBID_CuteControlsLib>
{
public:
	CIBar();
    virtual ~CIBar();

DECLARE_REGISTRY_RESOURCEID(IDR_BAR)     // noncreatable object

DECLARE_NOT_AGGREGATABLE(CIBar)

DECLARE_PROTECT_FINAL_CONSTRUCT()


BEGIN_COM_MAP(CIBar)
	COM_INTERFACE_ENTRY(IBar)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersistStream, IPersistStreamInit)
	COM_INTERFACE_ENTRY_AGGREGATE(IID_IItemCollection,m_spItemCollection.p)
END_COM_MAP()

BEGIN_PROP_MAP(CIBar)
//	PROP_ENTRY("TOOLBAR Style", 1, CLSID_NULL)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
//	 PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// IBar
public:
	STDMETHOD(get_Style)(/*[out, retval]*/ enBarStyle *pVal);
	STDMETHOD(put_Style)(/*[in]*/ enBarStyle newVal);

    unsigned  m_bRequiresSave:1;
    //--- Aggeregated Objects
    CComPtr<IUnknown> m_spItemCollection;
    CComAggObject<CIItemCollection>* m_pItemCol;
protected:
    int m_HotID;
    enBarType m_enType;
	enBarStyle m_enStyle;
    enGripStyle m_enGripStyle;
    enMousePointer m_enMousePointer;
	UINT m_ID;

//CIBar 
public:
	BOOL UpdateBar();
    // Interface Inplemetation
	STDMETHOD(get_UseImageList)(/*[out, retval]*/ VARIANT_BOOL *pVal);
	STDMETHOD(put_UseImageList)(/*[in]*/ VARIANT_BOOL newVal);
	STDMETHOD(get_HideControls)(/*[out, retval]*/ VARIANT_BOOL *pVal);
	STDMETHOD(put_HideControls)(/*[in]*/ VARIANT_BOOL newVal);
	STDMETHOD(get_MousePointer)(/*[out, retval]*/ enMousePointer *pVal);
	STDMETHOD(put_MousePointer)(/*[in]*/ enMousePointer newVal);
	STDMETHOD(get_Items)(/*[out, retval]*/ ItemCollection* *pVal);
	STDMETHOD(get_GripStyle)(/*[out, retval]*/ enGripStyle *pVal);
	STDMETHOD(put_GripStyle)(/*[in]*/ enGripStyle newVal);
	STDMETHOD(get_Type)(/*[out, retval]*/ enBarType *pVal);
	STDMETHOD(get_ItemState)(/*[in]*/ long ID, /*[out, retval]*/ enItemState *pVal);
	STDMETHOD(put_ItemState)(/*[in]*/ long ID, /*[in]*/ enItemState newVal);
	STDMETHOD(get_ItemWidth)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_ItemWidth)(/*[in]*/ short newVal);
	STDMETHOD(get_ItemHeight)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_ItemHeight)(/*[in]*/ short newVal);
	STDMETHOD(get_ImageWidth)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_ImageWidth)(/*[in]*/ short newVal);
	STDMETHOD(get_ImageHeight)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_ImageHeight)(/*[in]*/ short newVal);
	STDMETHOD(get_DockState)(/*[out, retval]*/ enDockState *pVal);
	STDMETHOD(put_DockState)(/*[in]*/ enDockState newVal);
	STDMETHOD(get_Visible)(/*[out, retval]*/ VARIANT_BOOL  *pVal);
	STDMETHOD(put_Visible)(/*[in]*/ VARIANT_BOOL  newVal);
	STDMETHOD(Refresh)();
	STDMETHOD(get_DockingStyle)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_DockingStyle)(/*[in]*/ long newVal);
	STDMETHOD(get_Name)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Name)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_ID)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_ID)(/*[in]*/ long NewVal);
    //====================
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBCToolBarBase)
	virtual void OnUpdateCmdUI(CFrameWnd* pTarget, BOOL bDisableIfNoHndler);
	//}}AFX_VIRTUAL

    // Persitence Scheme
	virtual void Serialize (CArchive& ar);

	virtual void Update();
	BOOL UpdateImage(UINT nID);
	void GenHeader(HFILETYPE Type, CString &Buffer);

    // =======================
	virtual void FinalRelease();
	virtual HRESULT FinalConstruct();
    virtual BOOL TranslateMessage(MSG *pMsg);
	virtual BOOL OnButtonCommand(WPARAM wParam, LPARAM lParam);
    virtual CIItem* FindItemByID(UINT ID);
	void OnItemClick(int ID);
	void SetMainControl(CICuteBar* pControl);
    BOOL ConstructToolBar();

HRESULT IPersistStreamInit_Load(LPSTREAM pStm, ATL_PROPMAP_ENTRY* pMap);
HRESULT IPersistStreamInit_Save(LPSTREAM pStm, BOOL fClearDirty, ATL_PROPMAP_ENTRY* pMap);

protected:
    BOOL DestructToolBar();
    BOOL AddControls();
    virtual void EraseSep(CDC* pDC);
    virtual void ControlsToButtons(TBBUTTON* pData);
    virtual void PutButtons(TBBUTTON* pData);
    virtual int ShrinkControls(TBBUTTON* pData, DWORD dwMode, int nCount);

	//{{AFX_MSG(CIBar)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnSettingChange(UINT uFlags, LPCTSTR lpszSection);
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);

	afx_msg void OnToolBarBtnClick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnToolBarBtnDblClick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnToolBarBtnDropDown(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnToolBarOnKeyDown(NMHDR* pNMHDR, LRESULT* pRes);
	afx_msg void OnHotItemChange(NMHDR* pNMHDR, LRESULT* pRes);
	afx_msg LRESULT OnIdleUpdateCmdUI(WPARAM wParam, LPARAM lParam);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif //__BAR_H_
