/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.galileo.client.jsp.html.table;

import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.components.table.TableImpl;
import com.softaspects.framework.galileo.renderers.html.table.RendererUtils;
import com.softaspects.galileo.client.jsp.html.base.ColorFactory;
import com.softaspects.galileo.client.jsp.html.base.ComponentBaseHolderImpl;
import com.softaspects.galileo.client.jsp.html.base.ComponentHolderImpl;
import com.softaspects.galileo.client.jsp.html.base.TagFactory;
import com.softaspects.galileo.client.jsp.html.table.TableSupported;
import javax.servlet.jsp.JspException;

public class TableTag
extends ComponentHolderImpl
implements TableSupported {
    private int fPageSize = -1;
    private int fShowHeader = -1;
    private int fColumnSelectionAllowed = -1;
    private int fColumnSelectionType = -1;
    private String fHeaderHintText = null;
    private String fHeaderHeight = null;
    private int fAltStep = -1;

    public TableTag() {
        this.setTableComponent();
    }

    protected void setTableComponent() {
        this.setComponent(new TableImpl());
    }

    public Table getTableComponent() {
        return (Table)this.getComponent();
    }

    public void setCaption(String aCaption) {
        ComponentBaseHolderImpl.validateValue(aCaption, "Table caption");
        this.getTableComponent().setCaption(aCaption);
    }

    public String getCaption() {
        return this.getTableComponent().getCaption();
    }

    public void setCaptionAlign(String aCaptionAlign) {
        ComponentBaseHolderImpl.validateValue(aCaptionAlign, "Caption align mode");
        int code = RendererUtils.getCaptionAlignCode(aCaptionAlign);
        if (code < 1 || code > 4) {
            TableTag.generateIllegalArgumentException("Caption align mode");
        }
        this.getTableComponent().setCaptionAlign(code);
    }

    public String getCaptionAlign() {
        return RendererUtils.getCaptionAlignValue(this.getTableComponent().getCaptionAlign());
    }

    public void setBorder(String aBorder) {
        ComponentBaseHolderImpl.validateValue(aBorder, "Border");
        try {
            int border = Integer.parseInt(aBorder);
            ComponentBaseHolderImpl.validateValue(border, "Border");
            this.getTableComponent().setBorder(border);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public String getBorder() {
        return String.valueOf(this.getTableComponent().getBorder());
    }

    public void setBorderColor(String aBorderColor) {
        ComponentBaseHolderImpl.validateValue(aBorderColor, "Border color");
        int color = ColorFactory.convertColorFromHtmlToInt(aBorderColor);
        if (color == 0) {
            TableTag.generateIllegalArgumentException("Border color");
        }
        this.getTableComponent().setBorderColor(color);
    }

    public String getBorderColor() {
        return ColorFactory.convertColorFromIntToHtml(this.getTableComponent().getBorderColor());
    }

    public void setCellPadding(String aCellPadding) {
        ComponentBaseHolderImpl.validateValue(aCellPadding, "CellPadding");
        try {
            int cellPadding = Integer.parseInt(aCellPadding);
            ComponentBaseHolderImpl.validateValue(cellPadding, "CellPadding");
            this.getTableComponent().setCellPadding(cellPadding);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public String getCellPadding() {
        return String.valueOf(this.getTableComponent().getCellPadding());
    }

    public void setCellSpacing(String aCellSpacing) {
        ComponentBaseHolderImpl.validateValue(aCellSpacing, "CellSpacing");
        try {
            int cellSpacing = Integer.parseInt(aCellSpacing);
            ComponentBaseHolderImpl.validateValue(cellSpacing, "CellSpacing");
            this.getTableComponent().setCellSpacing(cellSpacing);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public String getCellSpacing() {
        return String.valueOf(this.getTableComponent().getCellSpacing());
    }

    public void setRowHeight(String aRowHeight) {
        ComponentBaseHolderImpl.validateValue(aRowHeight, "RowHeight");
        this.getTableComponent().setRowHeight(aRowHeight);
    }

    public String getRowHeight() {
        return this.getTableComponent().getRowHeight();
    }

    public void setHorizontalBorderStyle(String aBorderStyle) {
        ComponentBaseHolderImpl.validateValue(aBorderStyle, "Horizontal border style");
        this.getTableComponent().setHorizontalBorderStyle(aBorderStyle);
    }

    public String getHorizontalBorderStyle() {
        return this.getTableComponent().getHorizontalBorderStyle();
    }

    public void setVerticalBorderStyle(String aBorderStyle) {
        ComponentBaseHolderImpl.validateValue(aBorderStyle, "Vertical border style");
        this.getTableComponent().setVerticalBorderStyle(aBorderStyle);
    }

    public String getVerticalBorderStyle() {
        return this.getTableComponent().getVerticalBorderStyle();
    }

    public void setFrame(String aFrame) {
        ComponentBaseHolderImpl.validateValue(aFrame, "Table frame");
        int frame = RendererUtils.getFrameCode(aFrame);
        if (frame < 1 || frame > 8) {
            TableTag.generateIllegalArgumentException("Frame");
        }
        this.getTableComponent().setFrame(frame);
    }

    public String getFrame() {
        return RendererUtils.getFramesValue(this.getTableComponent().getFrame());
    }

    public void setRules(String aRules) {
        ComponentBaseHolderImpl.validateValue(aRules, "Table rules");
        int rules = RendererUtils.getRulesCode(aRules);
        if (rules < 1 || rules > 5) {
            TableTag.generateIllegalArgumentException("Rules");
        }
        this.getTableComponent().setRules(rules);
    }

    public String getRules() {
        return RendererUtils.getRulesValue(this.getTableComponent().getRules());
    }

    public void setBackground(String aBackground) {
        ComponentBaseHolderImpl.validateValue(aBackground, "Background");
        this.getTableComponent().setBackGround(aBackground);
    }

    public String getBackground() {
        return this.getTableComponent().getBackGround();
    }

    public void setShowHeader(String aShowHeader) {
        ComponentBaseHolderImpl.validateValue(aShowHeader, "Show heeader");
        this.fShowHeader = TagFactory.getBooleanCode(aShowHeader);
    }

    public String getShowHeader() {
        return TagFactory.getBooleanValue(this.fShowHeader);
    }

    public void setHeaderHintText(String aHeaderHintText) {
        ComponentBaseHolderImpl.validateValue(aHeaderHintText, "Header hint text");
        this.fHeaderHintText = aHeaderHintText;
    }

    public String getHeaderHintText() {
        return this.fHeaderHintText;
    }

    public void setHeaderHeight(String aHeaderHeight) {
        ComponentBaseHolderImpl.validateValue(aHeaderHeight, "Header height");
        this.fHeaderHeight = aHeaderHeight;
    }

    public String getHeaderHeight() {
        return this.fHeaderHeight;
    }

    public void setSimpleViewMode(String aSimpleViewMode) {
        ComponentBaseHolderImpl.validateValue(aSimpleViewMode, "Simple view mode");
        boolean value = new Boolean(aSimpleViewMode);
        this.getTableComponent().setSimpleViewMode(value);
    }

    public String getSimpleViewMode() {
        return String.valueOf(this.getTableComponent().isSimpleViewMode());
    }

    public void setRowSelectionAllowed(String aRowSelectionAllowed) {
        ComponentBaseHolderImpl.validateValue(aRowSelectionAllowed, "Row selection allowed");
        boolean value = new Boolean(aRowSelectionAllowed);
        this.getTableComponent().setRowSelectionAllowed(value);
    }

    public String getRowSelectionAllowed() {
        return String.valueOf(this.getTableComponent().isRowSelectionAllowed());
    }

    public void setRowSelectionType(String aType) {
        ComponentBaseHolderImpl.validateValue(aType, "Rows selection type");
        int code = TagFactory.getSelectionCode(aType);
        if (code < 1 || code > 3) {
            TableTag.generateIllegalArgumentException("Rows selection type");
        }
        this.getTableComponent().setRowSelectionType(code);
    }

    public String getRowSelectionType() {
        return TagFactory.getSelectionValue(this.getTableComponent().getRowSelectionType());
    }

    public void setColumnSelectionAllowed(String aColumnSelectionAllowed) {
        ComponentBaseHolderImpl.validateValue(aColumnSelectionAllowed, "Column selection allowed");
        this.fColumnSelectionAllowed = TagFactory.getBooleanCode(aColumnSelectionAllowed);
    }

    public String getColumnSelectionAllowed() {
        return TagFactory.getBooleanValue(this.fColumnSelectionAllowed);
    }

    public void setColumnSelectionType(String aType) {
        ComponentBaseHolderImpl.validateValue(aType, "Columns selection type");
        int code = TagFactory.getSelectionCode(aType);
        if (code < 1 || code > 3) {
            TableTag.generateIllegalArgumentException("Columns selection type");
        }
        this.fColumnSelectionType = code;
    }

    public String getColumnSelectionType() {
        return TagFactory.getSelectionValue(this.fColumnSelectionType);
    }

    public void setAutoColumnCreationMode(String aAutoColumnCreationMode) {
        ComponentBaseHolderImpl.validateValue(aAutoColumnCreationMode, "Column creation mode");
        boolean value = new Boolean(aAutoColumnCreationMode);
        this.getTableComponent().setAutoColumnCreationMode(value);
    }

    public String getAutoColumnCreationMode() {
        return String.valueOf(this.getTableComponent().isAutoColumnCreationMode());
    }

    public void setTarget(String aTarget) {
        ComponentBaseHolderImpl.validateValue(aTarget, "Table component target window");
        this.getTableComponent().setTarget(aTarget);
    }

    public String getTarget() {
        return this.getTableComponent().getTarget();
    }

    public void setEditorMode(String aEditorMode) {
        ComponentBaseHolderImpl.validateValue(aEditorMode, "Table editor mode");
        this.getTableComponent().setEditorMode(RendererUtils.getEditCode(aEditorMode));
    }

    public String getEditorMode() {
        return RendererUtils.getEditValue(this.getTableComponent().getEditorMode());
    }

    public void setPageSize(String aPageSize) {
        ComponentBaseHolderImpl.validateValue(aPageSize, "PageSize");
        try {
            int pageSize = Integer.parseInt(aPageSize);
            ComponentBaseHolderImpl.validateValue(pageSize, "PageSize");
            this.fPageSize = pageSize;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public String getPageSize() {
        return String.valueOf(this.fPageSize);
    }

    public void setCellAltStep(String aAltStep) {
        ComponentBaseHolderImpl.validateValue(aAltStep, "AltStep");
        try {
            this.fAltStep = Integer.parseInt(aAltStep);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public String getCellAltStep() {
        return String.valueOf(this.fAltStep);
    }

    public int doEndTag() throws JspException {
        Table table = this.getTableComponent();
        if (this.fPageSize != -1) {
            table.setCursorPageSize(this.fPageSize);
        }
        if (this.fHeaderHintText != null) {
            table.setHeaderHintText(this.fHeaderHintText);
        }
        if (this.fHeaderHeight != null) {
            table.setHeaderHeight(this.fHeaderHeight);
        }
        if (this.fColumnSelectionType != -1) {
            table.setColumnSelectionType(this.fColumnSelectionType);
        }
        if (this.fColumnSelectionAllowed != -1) {
            table.setColumnSelectionAllowed(TagFactory.getBoolean(this.fColumnSelectionAllowed));
        }
        if (this.fShowHeader != -1) {
            table.setShowHeader(TagFactory.getBoolean(this.fShowHeader));
        }
        if (this.fAltStep != -1) {
            table.getInterfaceManager().setCellAltStep(this.fAltStep);
        }
        return super.doEndTag();
    }

    public void release() {
        super.release();
        this.fPageSize = -1;
        this.fShowHeader = -1;
        this.fColumnSelectionAllowed = -1;
        this.fColumnSelectionType = -1;
        this.fAltStep = -1;
        this.fHeaderHintText = null;
        this.fHeaderHeight = null;
    }

    protected static void generateIllegalArgumentException(String aName) {
        throw new IllegalArgumentException("Table: " + aName + " value not supported.");
    }
}

