/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.form.custom;

import com.softaspects.framework.galileo.components.base.ComponentImpl;
import com.softaspects.framework.galileo.renderers.html.form.custom.HiddenFormRenderer;
import com.softaspects.framework.galileo.support.components.form.custom.HiddenForm;
import com.softaspects.framework.galileo.support.util.HashedArrayList;
import com.softaspects.framework.galileo.support.util.HashedListStrategy;
import java.util.AbstractList;
import java.util.Iterator;

public class HiddenFormImpl
extends ComponentImpl
implements HiddenForm {
    private String fAction = null;
    private int fMethod = 1;
    private boolean fCurrentURLAction = false;
    private HashedArrayList fFieldsList = new HashedArrayList(new HashedListStrategy(){

        public Object getKeyForObject(Object anObject) {
            return ((FormField)anObject).getField();
        }
    });

    public HiddenFormImpl() {
        this.setRenderer(new HiddenFormRenderer());
    }

    public String getComponentTypeName() {
        return "HIDDEN_FORM";
    }

    public void setMethod(int aMethod) {
        if (aMethod < 1 || aMethod > 2) {
            throw new IllegalArgumentException("Hidden Form: Invalid form method.");
        }
        this.fMethod = aMethod;
    }

    public int getMethod() {
        return this.fMethod;
    }

    public void setAction(String aAction) {
        this.fAction = aAction;
    }

    public String getAction() {
        return this.fAction;
    }

    public void addField(String aField, String aValue) {
        FormField formField = new FormField(aField, aValue);
        if (this.isFieldPresent(aField)) {
            throw new IllegalArgumentException("Hidden Form: Field duplication '" + String.valueOf(aField) + "' .");
        }
        this.fFieldsList.add(formField);
    }

    public void addField(String aField) {
        this.addField(aField, null);
    }

    public boolean isFieldPresent(String aField) {
        return aField == null ? false : this.fFieldsList.contains(new FormField(aField));
    }

    public void setValue(String aField, String aValue) {
        FormField formField = (FormField)this.fFieldsList.get(aField);
        if (formField == null) {
            throw new IllegalArgumentException("Hidden Form: Field not found '" + String.valueOf(aField) + "' .");
        }
        formField.setValue(aValue);
    }

    public String getValue(String aField) {
        FormField formField;
        if (aField != null && (formField = (FormField)this.fFieldsList.get(aField)) != null) {
            return formField.getValue();
        }
        return null;
    }

    public int getCountFields() {
        return this.fFieldsList.size();
    }

    public Iterator getFields() {
        return new FieldsIterator(((AbstractList)this.fFieldsList).iterator());
    }

    public void useCurrentURLAction(boolean aCurrentURLAction) {
        this.fCurrentURLAction = aCurrentURLAction;
    }

    public boolean isUseCurrentURLAction() {
        return this.fCurrentURLAction;
    }

    protected static class FormField {
        private String fField;
        private String fValue;

        public FormField(String aField, String aValue) {
            if (aField == null || aField.length() == 0) {
                throw new IllegalArgumentException("Hidden Form: Field can't be null.");
            }
            this.fField = aField;
            this.setValue(aValue);
        }

        public FormField(String aField) {
            this(aField, null);
        }

        public String getField() {
            return this.fField;
        }

        public String getValue() {
            return this.fValue;
        }

        public void setValue(String aValue) {
            this.fValue = aValue;
        }

        public boolean equals(Object aObject) {
            if (aObject == this) {
                return true;
            }
            if (aObject != null && aObject instanceof FormField) {
                return this.getField().equals(((FormField)aObject).getField());
            }
            return false;
        }

        public int hashCode() {
            return this.getField().hashCode();
        }
    }

    protected static class FieldsIterator
    implements Iterator {
        private Iterator fFormFieldIterator;

        public FieldsIterator(Iterator aFormFieldIterator) {
            this.fFormFieldIterator = aFormFieldIterator;
        }

        public Object next() {
            return ((FormField)this.fFormFieldIterator.next()).getField();
        }

        public boolean hasNext() {
            return this.fFormFieldIterator.hasNext();
        }

        public void remove() {
            this.fFormFieldIterator.remove();
        }
    }
}

