/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.container.layout;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.renderers.html.container.layout.GridLayoutRenderer;
import com.softaspects.framework.galileo.support.components.container.Container;
import com.softaspects.framework.galileo.support.components.container.layout.DirectionSupportedLayoutManager;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManagerImpl;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManagerPolicy;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;

public class FlowLayoutManager
extends DirectionSupportedLayoutManager {
    private ArrayList fComponentsList = new ArrayList();

    public FlowLayoutManager() {
        this.setRenderer(new GridLayoutRenderer());
        this.setDirection(this.fDirection);
    }

    public int getCountRows(Container aContainer) {
        this.doLayout(aContainer);
        int columns = this.getColumns();
        int rows = this.getRows();
        int count = aContainer.getComponentsCount();
        if (rows == -1) {
            if (columns == -1) {
                throw new IllegalStateException("LayoutManager: need assign a count of COLUMNS or ROWS.");
            }
            int remainder = count % columns == 0 ? 0 : 1;
            rows = count / columns + remainder;
        } else if (columns != -1 && rows * columns < count && LayoutManagerPolicy.generateExceptionIfCapacityOfConstainerLessCountOfComponents()) {
            throw new IllegalStateException("LayoutManager: The capacity of container less than count of components.");
        }
        return rows;
    }

    public int getCountColumns(Container aContainer) {
        this.doLayout(aContainer);
        int columns = this.getColumns();
        int rows = this.getRows();
        int count = aContainer.getComponentsCount();
        if (columns == -1) {
            if (rows == -1) {
                throw new IllegalStateException("LayoutManager: needo assign a count of COLUMNS or ROWS.");
            }
            int remainder = count % rows == 0 ? 0 : 1;
            columns = count / rows + remainder;
        } else if (rows != -1 && rows * columns < count && LayoutManagerPolicy.generateExceptionIfCapacityOfConstainerLessCountOfComponents()) {
            throw new IllegalStateException("LayoutManager: The capacity of container less than count of components.");
        }
        return columns;
    }

    public void addLayoutComponent(Component aComponent) {
        if (aComponent != null) {
            this.fComponentsList.add(aComponent);
        }
    }

    public void removeLayoutComponent(Component aComponent) {
        ((AbstractCollection)this.fComponentsList).remove(aComponent);
    }

    public void removeAllLayoutComponents() {
        this.fComponentsList.clear();
    }

    public void doLayout(Container aContainer) {
        LayoutManagerImpl.validateContainer(aContainer);
        Object[] containerComponents = aContainer.getComponentsArray();
        if (!Arrays.equals(this.fComponentsList.toArray(), containerComponents)) {
            this.removeAllLayoutComponents();
            int i = 0;
            while (i < containerComponents.length) {
                this.addLayoutComponent((Component)containerComponents[i]);
                ++i;
            }
            aContainer.getComponentsList().clear();
            aContainer.getComponentsList().addAll(this.fComponentsList);
        }
    }
}

