/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.clientagent;

import com.softaspects.framework.galileo.support.components.clientagent.ClientAgentConstants;
import com.softaspects.framework.galileo.support.components.clientagent.ClientAgentExtraInfo;
import com.softaspects.framework.galileo.support.components.clientagent.ClientAgentExtraInfoImpl;
import com.softaspects.framework.galileo.support.components.clientagent.ClientAgentInfo;
import com.softaspects.framework.galileo.support.components.clientagent.ClientAgentInfoImpl;
import com.softaspects.framework.galileo.support.util.StringUtils;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class ClientAgentInfoGenerator
implements ClientAgentConstants {
    protected ClientAgentInfo getUserAgentInfo(HttpServletRequest aRequest, boolean aExtraInfo) {
        ClientAgentInfoImpl userAgentInfo = aExtraInfo ? new ClientAgentExtraInfoImpl() : new ClientAgentInfoImpl();
        userAgentInfo.setServerTime(System.currentTimeMillis());
        this.parseUserAgent(aRequest, userAgentInfo);
        userAgentInfo.setHTTPVersion(this.getHTTPVersion(aRequest));
        userAgentInfo.setRemoteHost(aRequest.getRemoteHost());
        userAgentInfo.setRemoteAddr(aRequest.getRemoteAddr());
        userAgentInfo.setRemoteUser(aRequest.getRemoteUser());
        userAgentInfo.setAcceptedEncoding(this.parse(aRequest, "Accept-Encoding"));
        userAgentInfo.setAcceptedMimeTypes(this.parse(aRequest, "Accept"));
        userAgentInfo.setAcceptedLanguages(this.parse(aRequest, "Accept-Language"));
        userAgentInfo.setAcceptedCharsets(this.parse(aRequest, "Accept-Charset"));
        return userAgentInfo;
    }

    public ClientAgentInfo getUserAgentInfo(HttpServletRequest aRequest) {
        return this.getUserAgentInfo(aRequest, false);
    }

    public ClientAgentExtraInfo getUserAgentExtraInfo(HttpServletRequest aRequest) {
        ClientAgentExtraInfoImpl userAgentExtraInfo = (ClientAgentExtraInfoImpl)this.getUserAgentInfo(aRequest, true);
        userAgentExtraInfo.setIntProperty("SCREEN_WIDTH", aRequest.getParameter("SCREEN_W"));
        userAgentExtraInfo.setIntProperty("SCREEN_HEIGHT", aRequest.getParameter("SCREEN_H"));
        userAgentExtraInfo.setIntProperty("SCREEN_AVAILABLE_HEIGHT", aRequest.getParameter("SCREEN_AH"));
        userAgentExtraInfo.setIntProperty("SCREEN_AVAILABLE_WIDTH", aRequest.getParameter("SCREEN_AW"));
        userAgentExtraInfo.setIntProperty("COLOR_DEPTH", aRequest.getParameter("COLOR_DEPTH"));
        userAgentExtraInfo.setIntProperty("PIXEL_DEPTH", aRequest.getParameter("PIXEL_DEPTH"));
        userAgentExtraInfo.setIntProperty("BUFFER_DEPTH", aRequest.getParameter("BUFFER_DEPTH"));
        userAgentExtraInfo.setIntProperty("WINDOW_HEIGHT", aRequest.getParameter("WINDOW_H"));
        userAgentExtraInfo.setIntProperty("WINDOW_WIDTH", aRequest.getParameter("WINDOW_W"));
        userAgentExtraInfo.setIntProperty("WINDOW_OUTER_HEIGHT", aRequest.getParameter("WINDOW_OH"));
        userAgentExtraInfo.setIntProperty("WINDOW_OUTER_WIDTH", aRequest.getParameter("WINDOW_OW"));
        userAgentExtraInfo.setIntProperty("WINDOW_FRAME_RATE", aRequest.getParameter("WINDOW_FR"));
        userAgentExtraInfo.setIntProperty("WINDOW_FRAME_RATE", aRequest.getParameter("WINDOW_FR"));
        userAgentExtraInfo.setStringProperty("WINDOW_BUFFER", aRequest.getParameter("WINDOW_BF"));
        userAgentExtraInfo.setBooleanProperty("FONT_SMOOTH", aRequest.getParameter("FONT_SMOOTH"));
        userAgentExtraInfo.setStringProperty("SYSTEM_LANGUAGE", aRequest.getParameter("S_LANG"));
        userAgentExtraInfo.setStringProperty("USER_LANGUAGE", aRequest.getParameter("U_LANG"));
        userAgentExtraInfo.setStringProperty("BROWSER_LANGUAGE", aRequest.getParameter("B_LANG"));
        userAgentExtraInfo.setStringProperty("CLIENT_TIME", aRequest.getParameter("DATE_TIME"));
        userAgentExtraInfo.setStringProperty("CLIENT_LOCAL_TIME", aRequest.getParameter("LOCAL_TIME"));
        userAgentExtraInfo.setStringProperty("CLIENT_GMT_TIME", aRequest.getParameter("GMT_TIME"));
        userAgentExtraInfo.setFloatProperty("JSCRIPT_VERSION", aRequest.getParameter("JS_VER"));
        userAgentExtraInfo.setStringProperty("NAVIGATOR_VER", aRequest.getParameter("N_VER"));
        userAgentExtraInfo.setFloatProperty("NAVIGATOR_MIN_VER", aRequest.getParameter("N_MINVER"));
        userAgentExtraInfo.setFloatProperty("NAVIGATOR_MAY_VER", aRequest.getParameter("N_MAYVER"));
        userAgentExtraInfo.setStringProperty("NAVIGATOR_CODE", aRequest.getParameter("N_CODE"));
        userAgentExtraInfo.setStringProperty("NAVIGATOR_NAME", aRequest.getParameter("N_NAME"));
        userAgentExtraInfo.setStringProperty("NAVIGATOR_ONLINE", aRequest.getParameter("N_ONLINE"));
        userAgentExtraInfo.setStringProperty("NAVIGATOR_CPU", aRequest.getParameter("N_CPU"));
        userAgentExtraInfo.setStringProperty("NAVIGATOR_DIRECTX", aRequest.getParameter("N_DIRECTX"));
        userAgentExtraInfo.setStringProperty("NAVIGATOR_PLUGINS", aRequest.getParameter("N_PLUGINS"));
        userAgentExtraInfo.setStringProperty("NAVIGATOR_SECURITY", aRequest.getParameter("N_SECUR"));
        userAgentExtraInfo.setStringProperty("NAVIGATOR_PLATFORM", aRequest.getParameter("N_PLATF"));
        userAgentExtraInfo.setBooleanProperty("JAVA_ENABLED", aRequest.getParameter("JAVA_E"));
        userAgentExtraInfo.setBooleanProperty("COOKIES", aRequest.getParameter("COOKIES"));
        userAgentExtraInfo.setBooleanProperty("COOKIES_SESSION", aRequest.getParameter("COOKIES_S"));
        userAgentExtraInfo.setStringProperty("AOL ART Image Format Support", aRequest.getParameter("COMPONENT_A"));
        userAgentExtraInfo.setStringProperty("Address Book", aRequest.getParameter("COMPONENT_AB"));
        userAgentExtraInfo.setStringProperty("Arabic Text Display Support", aRequest.getParameter("COMPONENT_AR"));
        userAgentExtraInfo.setStringProperty("Chinese Text Display Support", aRequest.getParameter("COMPONENT_CH"));
        userAgentExtraInfo.setStringProperty("Pan-European Text Display Support", aRequest.getParameter("COMPONENT_PE"));
        userAgentExtraInfo.setStringProperty("Thai Text Display Support", aRequest.getParameter("COMPONENT_TH"));
        userAgentExtraInfo.setStringProperty("Korean Text Display Support", aRequest.getParameter("COMPONENT_KR"));
        userAgentExtraInfo.setStringProperty("Japanese Text Display Support", aRequest.getParameter("COMPONENT_JP"));
        userAgentExtraInfo.setStringProperty("Hebrew Text Display Support", aRequest.getParameter("COMPONENT_HE"));
        userAgentExtraInfo.setStringProperty("Vietnamese Text Display Support", aRequest.getParameter("COMPONENT_VT"));
        userAgentExtraInfo.setStringProperty("Language Auto-Selection", aRequest.getParameter("COMPONENT_AL"));
        userAgentExtraInfo.setStringProperty("DirectAnimation", aRequest.getParameter("COMPONENT_AN"));
        userAgentExtraInfo.setStringProperty("Macromedia Flash", aRequest.getParameter("COMPONENT_FL"));
        userAgentExtraInfo.setStringProperty("VRML 2.0 Viewer", aRequest.getParameter("COMPONENT_VR"));
        userAgentExtraInfo.setStringProperty("Dynamic HTML Data Binding", aRequest.getParameter("COMPONENT_BI"));
        userAgentExtraInfo.setStringProperty("Internet Connection Wizard", aRequest.getParameter("COMPONENT_WZ"));
        userAgentExtraInfo.setStringProperty("Internet Explorer Browsing Enhancements", aRequest.getParameter("COMPONENT_ED"));
        userAgentExtraInfo.setStringProperty("Wallet", aRequest.getParameter("COMPONENT_WA"));
        userAgentExtraInfo.setStringProperty("VECTOR Graphics Rendering (VML)", aRequest.getParameter("COMPONENT_VM"));
        userAgentExtraInfo.setStringProperty("Internet Explorer Help", aRequest.getParameter("COMPONENT_HP"));
        userAgentExtraInfo.setStringProperty("Offline Browsing Pack", aRequest.getParameter("COMPONENT_BR"));
        userAgentExtraInfo.setStringProperty("Web Folders", aRequest.getParameter("COMPONENT_WF"));
        userAgentExtraInfo.setStringProperty("Visual Basic Scripting Support", aRequest.getParameter("COMPONENT_BS"));
        userAgentExtraInfo.setStringProperty("Windows Media Player", aRequest.getParameter("COMPONENT_MP"));
        userAgentExtraInfo.setStringProperty("Microsoft virtual machine", aRequest.getParameter("COMPONENT_VM"));
        userAgentExtraInfo.setStringProperty("Uniscribe", aRequest.getParameter("COMPONENT_UN"));
        userAgentExtraInfo.setStringProperty("Macromedia Shockwave Director", aRequest.getParameter("COMPONENT_SH"));
        return userAgentExtraInfo;
    }

    protected void parseUserAgent(HttpServletRequest aRequest, ClientAgentInfoImpl aUserAgentInfo) {
        String userAgent = aRequest.getHeader("User-Agent");
        if (userAgent.indexOf("MSIE") >= 0) {
            aUserAgentInfo.setBrowserName("MSIE");
            float browserVersion = this.getBrowserVersion(userAgent, "MSIE", ';');
            aUserAgentInfo.setBrowserVersion(browserVersion);
            if ((double)browserVersion >= 4.0) {
                aUserAgentInfo.setAcceptJavaScript(true);
                aUserAgentInfo.setAcceptUploading(true);
                aUserAgentInfo.setAcceptCSS(true);
            }
        } else if (userAgent.indexOf("Opera") >= 0) {
            aUserAgentInfo.setBrowserName("Opera");
            float browserVersion = this.getBrowserVersion(userAgent, "Opera", ' ');
            aUserAgentInfo.setBrowserVersion(browserVersion);
            if ((double)browserVersion >= 3.0) {
                aUserAgentInfo.setAcceptJavaScript(true);
                aUserAgentInfo.setAcceptUploading(true);
                aUserAgentInfo.setAcceptCSS(true);
            }
        } else if (userAgent.indexOf("ICE Browser") >= 0) {
            aUserAgentInfo.setBrowserName("ICE Browser");
            float browserVersion = this.getBrowserVersion(userAgent, "ICE Browser", ' ');
            aUserAgentInfo.setBrowserVersion(browserVersion);
            if ((double)browserVersion >= 5.0) {
                aUserAgentInfo.setAcceptJavaScript(true);
                aUserAgentInfo.setAcceptUploading(true);
                aUserAgentInfo.setAcceptCSS(true);
            }
        } else if (userAgent.indexOf("Netscape6") >= 0) {
            aUserAgentInfo.setBrowserName("Netscape6");
            float browserVersion = this.getBrowserVersion(userAgent, "Netscape6", ' ');
            aUserAgentInfo.setBrowserVersion(browserVersion);
            aUserAgentInfo.setAcceptJavaScript(true);
            aUserAgentInfo.setAcceptUploading(true);
            aUserAgentInfo.setAcceptCSS(true);
        } else {
            int startIndex = userAgent.indexOf(47);
            String browserName = userAgent.substring(0, startIndex);
            aUserAgentInfo.setBrowserName(browserName);
            float browserVersion = this.getBrowserVersion(userAgent, browserName, ' ');
            aUserAgentInfo.setBrowserVersion(browserVersion);
            if ("Mozilla".equals(browserName)) {
                if ((double)browserVersion >= 3.0) {
                    aUserAgentInfo.setAcceptJavaScript(true);
                    aUserAgentInfo.setAcceptUploading(true);
                }
                if ((double)browserVersion >= 4.0) {
                    aUserAgentInfo.setAcceptCSS(true);
                }
            }
        }
        if (userAgent.indexOf("Win") >= 0) {
            aUserAgentInfo.setPlatformName("Windows");
        } else if (userAgent.indexOf("Mac") >= 0) {
            aUserAgentInfo.setPlatformName("Macintosh");
        } else if (userAgent.indexOf("X11") >= 0) {
            aUserAgentInfo.setPlatformName("Unix");
        }
    }

    protected float getBrowserVersion(String aUserAgent, String aBrowserName, char aEndChar) {
        int startIndex = aUserAgent.indexOf(aBrowserName) + 1 + aBrowserName.length();
        int endIndex = aUserAgent.indexOf(aEndChar, startIndex);
        String part = endIndex < 0 ? aUserAgent.substring(startIndex) : aUserAgent.substring(startIndex, endIndex);
        float result = 1.0f;
        try {
            result = Float.parseFloat(part);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    protected float getHTTPVersion(HttpServletRequest aRequest) {
        String protocol = aRequest.getProtocol();
        int startIndex = protocol.indexOf(47) + 1;
        String part = protocol.substring(startIndex);
        float result = 1.0f;
        try {
            result = Float.parseFloat(part);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    protected String[] parse(HttpServletRequest aRequest, String aHeaderName) {
        Enumeration enumeration = aRequest.getHeaders(aHeaderName);
        if (enumeration == null) {
            return null;
        }
        StringBuffer sBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String value = (String)enumeration.nextElement();
            if (value != null) {
                sBuffer.append(value);
            }
            if (!enumeration.hasMoreElements()) continue;
            sBuffer.append(',');
        }
        return StringUtils.parseString(sBuffer.toString(), ',');
    }
}

